/* drivers/input/touchscreen/gt1x_firmware.h
 *
 * 2010 - 2014 Goodix Technology.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be a reference
 * to you, when you are integrating the GOODiX's CTP IC into your system,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * Version: 1.2   
 * Release Date:  2015/03/10
 */

#ifndef _GT1X_FIRMWARE_H_
#define _GT1X_FIRMWARE_H_

unsigned char gt1x_default_FW[] = 
{
};

#if GTP_HOTKNOT
unsigned char gt1x_patch_jump_fw[] = {
    0xa8,0x3f,0x06,0xec,0xd9,0x50,0xf5,0xbf,0xb9,0xc2,0xec,0x5c,0x94,0x2c,0xd0,0xc0,
    0x56,0x1b,0x01,0xaa,0xea,0x04,0xe0,0xa8,0x36,0x37,0xd4,0xbf,0x33,0xfe,0xea,0x9e,
    0x7b,0xf0,0x20,0x46,0x80,0x73,0x6b,0x4e,0x3f,0x27,0x51,0x1e,0x3d,0x80,0x05,0x01,
    0x2d,0xee,0x85,0x0f,0xa9,0x87,0x11,0x29,0x24,0xef,0x2c,0x47,0xc0,0x75,0x24,0xac,
    0x41,0xb6,0x31,0x8c,0x3f,0xa3,0x95,0x98,0x50,0xe2,0x51,0x2d,0x9a,0xcb,0x14,0x6e,
    0xb7,0x17,0xc1,0x85,0x2e,0x04,0x5d,0xa9,0xc5,0x0d,0x8a,0x46,0x59,0x69,0x13,0x55,
    0xfb,0xbf,0x92,0xcb,0xc2,0xc0,0x63,0xdc,0x0a,0x94,0xfd,0x09,0x76,0x5c,0xd2,0xc6,
    0xf2,0x21,0x03,0x81,0x7f,0xa9,0xe9,0xae,0x5d,0x04,0xff,0x98,0x5a,0x70,0xc3,0xd7,
    0x09,0x0c,0xd1,0x7b,0xc4,0x88,0x81,0x2a,0xe1,0x36,0x78,0xbc,0x93,0x53,0xbf,0x04,
    0x30,0x9f,0xa5,0x01,0xa2,0x98,0x80,0x58,0xe0,0x30,0xb0,0x86,0xbe,0x7c,0x70,0x7b,
    0x39,0x8e,0x24,0x15,0xbb,0xf6,0x7d,0xab,0x06,0xc1,0xba,0xd7,0x28,0x5d,0x58,0xec,
    0x8f,0xef,0x09,0x2b,0xb4,0xff,0xdd,0xe6,0x42,0x79,0xae,0x4b,0x21,0x4d,0xd1,0xa4,
    0x62,0x88,0x0b,0x17,0x8d,0xc5,0x35,0x25,0xbc,0x47,0x2d,0x10,0x52,0x79,0x0a,0x4c,
    0x0b,0x2e,0x7d,0xd2,0x5b,0xde,0x8b,0xe5,0x17,0x2d,0xe8,0xf8,0xf5,0x90,0xd9,0x65,
    0xcf,0x3f,0xf6,0xf1,0xe7,0x10,0x49,0x6f,0xf3,0x22,0xb1,0x11,0x51,0x60,0xda,0x2c,
    0xe7,0x26,0xb8,0xbc,0x70,0xf7,0xd9,0xf1,0x31,0x5f,0x37,0xd9,0x1b,0x1f,0x98,0x80,
    0xeb,0xf2,0xa0,0x60,0x7b,0x06,0xb8,0x1c,0x15,0x54,0xe3,0x54,0x8e,0x24,0x21,0x7b,
    0x4c,0xb0,0x20,0x15,0xec,0x97,0xf0,0x73,0x1c,0xb8,0x06,0x5e,0x5c,0xfe,0xc0,0x77,
    0x01,0x85,0xe0,0x02,0x45,0xcf,0x01,0xcb,0x93,0x49,0x96,0x99,0x43,0x27,0x78,0x7e,
    0x6d,0xd7,0xcc,0x9e,0xa4,0xe7,0x33,0x17,0x44,0x09,0x04,0xac,0xb9,0xe7,0x52,0x75,
    0x51,0xfd,0xc9,0x50,0x1d,0xfa,0x22,0x63,0xc2,0x46,0x09,0x64,0xab,0x06,0xf0,0x3c,
    0xe8,0xab,0x80,0xd5,0x7e,0x66,0xf6,0x28,0xc7,0x3c,0xc3,0x1f,0xa4,0x76,0x72,0x10,
    0x7b,0xe9,0xd4,0xb9,0x9c,0xf4,0xc6,0xa4,0xf1,0xd9,0xf4,0x24,0xc7,0x97,0x51,0x13,
    0xf7,0x59,0x80,0x50,0xa2,0x25,0xed,0x4f,0x88,0x27,0x4d,0x66,0xdf,0x17,0x71,0x7f,
    0xdd,0x89,0xa6,0x11,0xa8,0x6e,0xba,0x1c,0x17,0xde,0x5b,0x10,0xb2,0xef,0x7e,0x64,
    0xd9,0x38,0xc0,0x29,0xee,0x9f,0xfc,0x36,0xe4,0x3c,0xf0,0x7d,0x5e,0xf6,0x98,0x7f,
    0x74,0xae,0x57,0x90,0x2b,0x09,0x29,0x27,0xb8,0x5f,0xf8,0xa7,0xae,0x2f,0x70,0xd6,
    0x45,0x04,0x5e,0x96,0xef,0x9e,0x38,0x79,0xb3,0x51,0x97,0x9d,0xbb,0xeb,0x5a,0x7d,
    0xc4,0xca,0xd6,0x07,0xb1,0xc3,0xae,0x37,0xea,0xd5,0xaa,0x36,0x42,0x8e,0x3b,0x6c,
    0xb4,0x50,0xca,0xde,0x4a,0x2a,0x6f,0x14,0x25,0x5b,0x74,0x04,0xa6,0x7e,0x7e,0x06,
    0xcb,0x39,0xea,0xdf,0x14,0x7e,0xdf,0x26,0x3b,0xe9,0x13,0x5f,0xaf,0x8f,0xb9,0x91,
    0xb5,0xd8,0x30,0x04,0x99,0x08,0x01,0xfb,0xf2,0x47,0xd1,0x07,0x85,0xfc,0x58,0x79,
    0xd8,0x0a,0xdb,0x0f,0xe1,0xe6,0xcf,0x60,0x31,0xd6,0x4c,0x5d,0xb1,0x50,0x35,0x92,
    0x9c,0xf8,0x46,0x61,0x12,0xf8,0x05,0x6c,0x01,0x52,0x4f,0x40,0x05,0xa4,0x47,0xbc,
    0x01,0x2a,0x65,0xe4,0x81,0xc9,0xa7,0x31,0x69,0x17,0x3d,0x43,0x4b,0x06,0x27,0x8c,
    0x3b,0x0b,0x14,0xef,0x54,0x93,0x0c,0x87,0x40,0x53,0x83,0x42,0xa3,0x35,0x17,0xe7,
    0x82,0xb9,0xf3,0x96,0x2b,0x4b,0x89,0xa9,0x42,0x86,0xc7,0x23,0x88,0x04,0x15,0x9b,
    0x7f,0xa1,0x83,0x28,0x6a,0x66,0x44,0xe9,0xaf,0x85,0x96,0x46,0x80,0x51,0xf6,0x6f,
    0x83,0xb9,0x6f,0xb7,0x31,0xeb,0x82,0x9e,0x0e,0xe4,0xa2,0x05,0x89,0x05,0x95,0x59,
    0x78,0xeb,0x6c,0xe3,0x05,0x6d,0xb2,0x81,0x4f,0x00,0x6c,0xec,0x0e,0x95,0x76,0x6d,
    0xf6,0x58,0x4f,0x78,0x8d,0x61,0xc5,0x34,0x72,0xca,0x56,0xd3,0xba,0x62,0x6f,0x7b,
    0x22,0x0a,0xee,0x43,0xfb,0x65,0x4c,0xa2,0xe0,0x98,0xcd,0xcb,0xc5,0xba,0xc4,0xcd,
    0x29,0x2b,0x1d,0xee,0x1a,0x55,0x9a,0x46,0xe0,0xdf,0xcc,0xda,0x09,0xd5,0xcc,0x27,
    0x0b,0x1a,0xc8,0x44,0x32,0xf7,0x94,0x66,0x62,0x87,0xaa,0xcb,0x7b,0x68,0xef,0x56,
    0x5a,0xb1,0x3d,0x24,0x84,0x3c,0x25,0x41,0x1b,0xcb,0x04,0x4c,0x1d,0x8c,0xdc,0xe4,
    0x47,0x77,0xae,0x12,0x84,0x02,0xa7,0x34,0x98,0x6b,0xd9,0x2d,0x82,0x59,0xfe,0x67,
    0xd9,0x7b,0x0f,0xcc,0xca,0xfa,0xe7,0x1a,0xdd,0x4e,0x43,0xdc,0x33,0x0d,0x9d,0x31,
    0x54,0x23,0x74,0x22,0x21,0xad,0x2a,0x06,0xbb,0x79,0x6a,0xb2,0x06,0x9d,0x7e,0x65,
    0xc0,0xa5,0x05,0xb0,0x8d,0xec,0x32,0x8c,0x75,0xd4,0x05,0xd4,0x90,0xe1,0x72,0xec,
    0x3a,0xf0,0x04,0x84,0x17,0x74,0x71,0x7c,0x5d,0xf2,0x61,0xf9,0x7c,0xfd,0x6f,0x2c,
    0xa6,0xdc,0xe7,0x9e,0x28,0x03,0x2d,0x80,0x4c,0xdd,0x85,0xd6,0x8c,0x23,0x6d,0x8a,
    0x25,0x39,0x44,0xf5,0xec,0x77,0xbd,0x73,0xf2,0xcc,0x85,0x4c,0xc5,0xa3,0x10,0xe1,
    0xb7,0xb4,0xd1,0x84,0xc8,0x5f,0xe0,0x99,0x7f,0x2a,0xbb,0xda,0xf8,0x88,0xd7,0x7e,
    0x69,0x91,0x69,0xb9,0x81,0xc8,0xf5,0xc3,0x73,0x57,0xaf,0x7d,0xc1,0x94,0x34,0x2a,
    0xdf,0x3c,0x82,0xba,0x9c,0x4d,0xbc,0x8f,0xca,0xcd,0x59,0xbe,0x8a,0x05,0x74,0xde,
    0x2b,0xd0,0xfb,0x97,0x2e,0xc0,0x0e,0x6b,0x00,0xf7,0x98,0xdd,0x85,0x95,0xb4,0x48,
    0x92,0x64,0xcd,0xfe,0xff,0xdb,0xd9,0x31,0xc9,0xd4,0x0e,0x27,0xee,0xaf,0x38,0xe3,
    0x9a,0xd0,0xe4,0xdd,0x95,0x77,0x3c,0x54,0xc1,0xc4,0x07,0xc8,0xff,0xea,0x5e,0x64,
    0x93,0x61,0x4d,0xfc,0xa5,0x07,0xf9,0xb1,0xcc,0xd4,0x84,0xeb,0x39,0xd9,0x9d,0x7a,
    0x06,0xd5,0x64,0xff,0x54,0x96,0x50,0xa0,0xc4,0x3f,0x74,0x23,0x85,0x57,0xbc,0x34,
    0x4a,0xce,0xa6,0x4d,0xa8,0xe6,0xe1,0x28,0x25,0x75,0xde,0xf6,0x8e,0x6c,0x7b,0xbc,
    0x7a,0x99,0x43,0xb1,0x54,0x9a,0x0e,0x95,0x19,0x52,0x84,0x4a,0x9e,0xba,0x3b,0xf0,
    0x67,0x88,0xce,0xb2,0xd3,0xc4,0xe6,0x49,0xc3,0xab,0x32,0x98,0xcf,0x3f,0x05,0xf1,
    0xaa,0x98,0xd3,0xb6,0x8a,0xe6,0xe3,0xb8,0x8d,0x35,0xc7,0xdd,0xb5,0x04,0x5c,0xf9,
    0x88,0x0c,0xa1,0x8a,0xb8,0xff,0xf9,0x23,0xd4,0x80,0xe1,0x30,0xe8,0x27,0x9e,0x21,
    0x8b,0x72,0x42,0xbe,0xe5,0x65,0x73,0xbe,0x52,0xcb,0xe2,0x4c,0xa2,0xc7,0x77,0xce,
    0x7e,0xe3,0x02,0x4a,0x9f,0xa4,0x96,0x3e,0x71,0x65,0x98,0x4f,0x32,0x85,0x0c,0x41,
    0x71,0x93,0x84,0x23,0xb6,0x6d,0x12,0x67,0x13,0x30,0x62,0x02,0x4d,0x72,0x38,0x00,
    0x28,0x47,0xa1,0x46,0x38,0xac,0xc2,0x69,0x09,0x7a,0xe5,0x5f,0x10,0x33,0x9a,0xe9,
    0x60,0x56,0xa2,0xfa,0x80,0x58,0x15,0x19,0x77,0x16,0xcd,0x9a,0xf6,0x73,0x9a,0x6a,
    0x68,0xb3,0x03,0x62,0x3e,0x02,0x50,0x27,0x72,0x07,0x3d,0x40,0x0d,0x17,0x5c,0x03,
    0x77,0xe0,0xea,0xc4,0xec,0x27,0x30,0x6a,0x99,0x3a,0x5b,0x9a,0xf7,0x72,0x42,0xcb,
    0x3a,0xd8,0xff,0x07,0xea,0x0b,0xbb,0x2e,0x28,0xaa,0xc0,0x44,0xf0,0xac,0xb1,0x2b,
    0x6a,0x5c,0x41,0x04,0x8e,0x98,0x80,0x39,0x7a,0x3b,0xc0,0x44,0x92,0x38,0xd0,0xa0,
    0x3b,0x59,0x8c,0x05,0xa7,0x4e,0x39,0xab,0x6b,0x0e,0x6b,0x26,0x89,0x2f,0x1a,0x6e,
    0x41,0xe7,0x2a,0x06,0xa3,0x1a,0x18,0x6f,0x79,0xb9,0x4b,0x6f,0x5b,0x76,0x9e,0x66,
    0x82,0x02,0x91,0xa5,0xc0,0xaa,0x9a,0x91,0x2a,0x0e,0x0a,0x03,0x72,0x26,0xf9,0x09,
    0x22,0x5e,0x88,0x69,0x7b,0xbe,0xb7,0x22,0x05,0x58,0x38,0x4d,0xf4,0x7b,0xca,0xc1,
    0x96,0xb7,0x77,0xd7,0xa3,0x47,0xba,0xa5,0xeb,0xdb,0xea,0x33,0xfd,0x6a,0x13,0x61,
    0x33,0x2a,0xa5,0x8e,0xf1,0xb5,0xdd,0xe0,0x84,0xb9,0xbc,0x3b,0x7b,0x37,0xff,0xf8,
    0xc2,0xe2,0xdf,0x9c,0xbc,0x7f,0xd9,0x73,0x6a,0x01,0xe2,0x74,0x8a,0x10,0x19,0x93,
    0x5c,0xf2,0x3d,0x17,0xe1,0xe5,0x53,0xae,0x24,0x4b,0x01,0x11,0xf1,0x47,0x4b,0xd8,
    0xc1,0x04,0xe3,0x72,0x9b,0x20,0xb6,0x2e,0x3d,0xc3,0x13,0x37,0xeb,0x0d,0xf6,0x6e,
    0x85,0x90,0x00,0x99,0xb2,0xed,0x32,0x77,0xe0,0xc3,0x93,0x0c,0xcf,0x4a,0x86,0x73,
    0x6d,0x2a,0xa3,0x70,0xfe,0x83,0xe8,0x8b,0x6e,0x50,0xf2,0xfb,0xdc,0xf5,0x81,0xa9,
    0x72,0x65,0x4a,0x96,0x9c,0xa3,0x79,0x72,0x55,0xcc,0x88,0x11,0xa4,0x9f,0x92,0xa9,
    0x6d,0xc7,0x03,0xe9,0xff,0x5f,0x41,0xeb,0xf1,0x83,0x19,0xdd,0xb2,0x1b,0xae,0xd8,
    0x8d,0x9b,0x38,0xbe,0xa3,0xa7,0x3e,0xc1,0x67,0x41,0x69,0xf8,0xa2,0xd1,0x0a,0x68,
    0x79,0x6a,0x89,0x90,0xee,0x8b,0x9b,0x3e,0xa9,0x85,0x83,0x1c,0x29,0xdd,0x1e,0x3a,
    0xca,0x1d,0x27,0x93,0x0a,0x18,0xa0,0x29,0x26,0x4b,0x4f,0xe4,0xe0,0x10,0x90,0x4a,
    0x03,0x6b,0x55,0x96,0xa3,0xce,0x19,0xbb,0xac,0x05,0x03,0x3e,0xbe,0xf2,0x91,0x69,
    0x0b,0x39,0x08,0x6b,0xa7,0x9a,0x38,0x7f,0x0d,0xbc,0x12,0xd6,0x81,0x0c,0x06,0x86,
    0x93,0x36,0xd7,0xc5,0x39,0xbe,0xec,0xe3,0xf2,0x8a,0x9d,0xe1,0xa8,0x0e,0x8f,0xf8,
    0x36,0x28,0x6b,0xbc,0xf4,0x47,0xc0,0xb0,0xc9,0x0b,0xef,0xd0,0xe9,0x1e,0x10,0x72,
    0x2f,0xcf,0x29,0x7a,0x07,0x9a,0x64,0x52,0xcc,0x17,0x89,0x1f,0xc7,0x2b,0xa8,0xa1,
    0x9b,0x2a,0x85,0x92,0xac,0x27,0x3b,0x5f,0x0d,0xf3,0x00,0x3b,0xde,0x82,0x87,0x80,
    0x2a,0x06,0xa7,0x86,0x98,0xfd,0xfd,0x83,0x18,0x40,0x25,0xc4,0xce,0x96,0x52,0xfc,
    0xd3,0xf0,0xa4,0x09,0xc5,0x67,0x77,0x3e,0x0c,0x35,0xe4,0x5e,0x86,0x93,0x35,0xa1,
    0xa9,0x0a,0x25,0x08,0xbf,0xa3,0x92,0xbe,0x53,0x21,0xc5,0x82,0xcb,0x45,0x3f,0x41,
    0xa9,0xf1,0x07,0xcb,0x96,0x6f,0x16,0xe7,0x8d,0x51,0x3e,0x32,0x79,0x7d,0x66,0xee,
    0xe0,0xc6,0x97,0x9b,0x80,0x4c,0x36,0xa9,0xb0,0x20,0xcc,0x10,0xf0,0x6b,0xa0,0xe4,
    0x50,0xad,0xee,0x46,0x5c,0x34,0xf5,0xf0,0x55,0x17,0x41,0x99,0xda,0x89,0xaf,0xea,
    0x49,0x44,0x07,0xc2,0xfb,0x69,0xb7,0x06,0xe3,0x7c,0xaa,0x84,0xe4,0x18,0x0e,0xe9,
    0x77,0xe6,0x81,0x9b,0x68,0xd3,0x42,0x7b,0xaf,0x01,0xf4,0x53,0x69,0x05,0x06,0xf8,
    0x25,0x68,0x4f,0x57,0xca,0x09,0xbf,0xae,0xf2,0x61,0x4a,0xc5,0xcc,0x9a,0xb5,0x8b,
    0x52,0xe7,0x6c,0xcb,0x2a,0x9a,0x84,0xb9,0x3e,0xc1,0xac,0x5a,0xc3,0x5c,0xb6,0x0a,
    0x5b,0x69,0xcd,0xca,0x87,0x4c,0x3d,0x2b,0x4d,0x8b,0x35,0x4b,0xa1,0x2a,0xda,0xf6,
    0x80,0x0d,0x0f,0xc3,0x83,0x18,0x1c,0xef,0xfb,0x70,0x91,0xc6,0x85,0x8f,0xb4,0x48,
    0x0f,0x3b,0x38,0x53,0x3d,0x42,0x18,0x70,0x8a,0x82,0x9e,0x81,0xac,0x8c,0x4e,0x11,
    0x02,0x5d,0xac,0x20,0x42,0x8d,0xee,0xae,0x32,0x43,0xea,0x12,0x01,0x04,0x71,0x72,
    0xdc,0x37,0x0d,0xca,0x41,0x4d,0x27,0xef,0x8c,0x2c,0x0c,0xcc,0x64,0x90,0x2b,0x8d,
    0xbf,0x6b,0x83,0xcd,0x55,0x56,0x39,0x01,0x69,0x5f,0x24,0x8b,0x40,0xe4,0x2e,0xf9,
    0x44,0xc6,0x6c,0x9d,0x9c,0x7d,0xdd,0xd3,0x67,0x26,0xfd,0x20,0xaa,0x13,0x72,0xec,
    0x26,0x93,0x86,0x97,0xc1,0xe7,0x57,0x2e,0x6c,0xc3,0x4f,0x78,0x69,0x32,0xec,0x3b,
    0x6f,0x78,0x07,0x9f,0xbb,0x27,0xb2,0xae,0x0d,0x50,0xca,0x7f,0x1a,0xd6,0xc6,0x5d,
    0xa5,0x07,0x04,0x6c,0x92,0xef,0x36,0xf7,0xed,0xc2,0xcb,0x7c,0x95,0xb0,0x74,0xb7,
    0x32,0x66,0xcd,0xd7,0x24,0x91,0xe8,0xb7,0xcf,0x00,0xc3,0x54,0xcb,0x43,0x8d,0xfc,
    0x4d,0xf2,0x86,0x1c,0x0b,0x29,0xd6,0x63,0x51,0x97,0x61,0xa9,0x92,0x14,0xd0,0xb4,
    0x51,0xd8,0x82,0x90,0x8b,0xd2,0x3b,0x3b,0x8d,0xe1,0x73,0x94,0x73,0x6d,0xf5,0x36,
    0x23,0xb3,0xa3,0xba,0x16,0xf3,0x07,0xf3,0x2c,0x0a,0xe5,0x2c,0x51,0x7d,0x0c,0x07,
    0x76,0xe8,0x30,0x9e,0xce,0x89,0x9f,0xbe,0x64,0x28,0xe4,0xd4,0x8e,0x51,0x95,0x7b,
    0x51,0x78,0x8c,0x11,0xac,0x7c,0xbf,0x9d,0xa9,0x3e,0xf4,0x9b,0xd3,0xcf,0x4b,0x26,
    0xaf,0x82,0x0d,0x10,0x83,0xcc,0x1d,0x3b,0x0f,0x51,0x40,0xd7,0xa9,0x1e,0xfa,0xe6,
    0x2b,0x79,0x50,0xf7,0x87,0xfd,0xdf,0xbb,0x17,0xbc,0x6c,0x9f,0x00,0xc3,0x7e,0xbf,
    0xb0,0xed,0x8f,0x15,0xc0,0xc9,0x9d,0xb2,0xe6,0x16,0xfe,0x9e,0x98,0x0c,0xcb,0xbd,
    0xb8,0x5e,0xb6,0xeb,0x40,0xcd,0x39,0x51,0xc1,0x1c,0xed,0xc9,0xf8,0x1c,0xfd,0xf5,
    0x29,0xab,0xaa,0xb3,0x43,0x0d,0x3a,0xfc,0xdc,0x4d,0xdd,0x6a,0x97,0xaf,0xe3,0x75,
    0x55,0x33,0xe9,0x50,0xc9,0x5b,0x72,0x1b,0xaf,0x19,0x0e,0xcd,0x76,0x8d,0x5c,0xbe,
    0xc0,0x5b,0x37,0x06,0xfe,0x02,0xf9,0x23,0x36,0xc2,0xc2,0x43,0x00,0xcc,0x55,0xad,
    0x0a,0xf2,0x83,0x62,0xf7,0x96,0x99,0x2d,0x78,0x90,0xd9,0x4e,0x08,0xc4,0x52,0x90,
    0x51,0x14,0x21,0x8a,0x52,0xf6,0x1c,0x63,0xb0,0xc3,0x6c,0x4d,0x6a,0x2d,0x35,0x9d,
    0xd9,0x73,0xc2,0xdc,0xb1,0xa5,0x91,0xbc,0x79,0x91,0x45,0x4c,0xe7,0x33,0x30,0xe0,
    0x7b,0x30,0x82,0x82,0xb8,0xc6,0x82,0x24,0x06,0x5c,0xb1,0xb1,0x43,0x66,0xc7,0x26,
    0x6c,0x12,0xa2,0x5a,0x7c,0xb6,0xbf,0x2a,0xf5,0x57,0xbf,0x74,0x8b,0x70,0xce,0x00,
    0x61,0x81,0xfe,0x00,0xfb,0xa7,0x3e,0x29,0x44,0x5f,0xf2,0x04,0x7c,0x7f,0xd4,0x5a,
    0xfd,0x33,0x3c,0xa6,0x96,0x45,0x6c,0xfc,0xea,0x59,0xc5,0xeb,0x82,0xf7,0xa8,0x7d,
    0x7a,0x8a,0x0d,0xf1,0x3d,0x35,0xf3,0x6c,0xa6,0xca,0xca,0x4b,0x37,0xdf,0xd4,0x29,
    0x82,0x64,0xaa,0x0f,0x1a,0xf4,0x54,0xe4,0x90,0xda,0xcb,0x4a,0x98,0xde,0x7d,0x2b,
    0x59,0x08,0x2b,0x0c,0x38,0xb5,0x73,0x4e,0x37,0xcb,0x4a,0x49,0xf3,0x2e,0x59,0x67,
    0x83,0x61,0x68,0x04,0x74,0x2d,0x58,0x84,0x93,0x5b,0x8a,0x94,0xb6,0xd4,0x5b,0x4f,
    0x7a,0xb7,0x69,0x06,0xe3,0xc8,0xcf,0x6b,0x70,0xec,0xdf,0x4b,0x65,0x45,0xae,0x7d,
    0x6f,0xf4,0x0d,0x31,0xb2,0x7b,0x78,0x78,0x22,0x49,0x37,0xe2,0x7d,0x85,0x23,0x98,
    0xd6,0xba,0x0e,0x85,0xa3,0x47,0xda,0xd3,0x93,0x33,0x3f,0xc5,0x13,0x37,0x2f,0xf5,
    0x9f,0x68,0x2a,0x86,0xb3,0x7a,0x38,0xd4,0xcc,0x89,0x34,0xec,0xce,0x43,0xeb,0x2d,
    0x9f,0x7f,0xdf,0xef,0xfb,0xf7,0x04,0x93,0x14,0xa0,0xe2,0x33,0xe6,0xa4,0xef,0x32,
    0xcc,0xc7,0x54,0xee,0x3f,0xbc,0x15,0x37,0x1c,0xb0,0x61,0x51,0xb0,0xd6,0x8e,0xf0,
    0xfa,0x03,0x8e,0x01,0x16,0x7f,0x4c,0x03,0x04,0x25,0x2d,0x8b,0xb8,0x4c,0x72,0x56,
    0xf2,0x6e,0x5e,0x15,0xa9,0xc2,0x12,0xbe,0x9d,0xef,0x64,0xd2,0x8a,0x46,0x75,0xfe,
    0x57,0xcf,0x5a,0xb9,0x65,0xfc,0xae,0x85,0x41,0xde,0x52,0x15,0xb6,0xe6,0x71,0x47,
    0x72,0xe8,0x41,0xea,0x5f,0xd4,0x58,0xc4,0xd2,0x12,0xcf,0xd5,0x7c,0x87,0x51,0xa6,
    0x52,0xf1,0x01,0xe9,0x05,0x8a,0x1e,0x9d,0x35,0xe2,0xe3,0xdd,0xeb,0x44,0x8e,0xd9,
    0xb6,0xae,0xdb,0xa8,0x8d,0xa6,0xcb,0xb6,0x25,0xd6,0x80,0xae,0xa3,0xf2,0x72,0x13,
    0xd2,0xc8,0x2e,0xf4,0xdf,0xd8,0xdf,0x28,0x5e,0x5b,0xec,0x85,0xc4,0xb3,0x93,0x1c,
    0xf1,0x1a,0x07,0x91,0x98,0x39,0xd2,0x7d,0x26,0x88,0x6a,0xf6,0x3e,0xce,0x1b,0x4d,
    0x9c,0x76,0x57,0xe5,0x7d,0xa9,0x51,0x19,0x45,0xa2,0x03,0x3e,0xaf,0x9d,0xf9,0xd5,
    0xcf,0xce,0xdc,0xe4,0xb1,0x3d,0xd3,0x78,0xbf,0xcb,0x8b,0x6f,0x5f,0xf6,0xd7,0xfb,
    0xfd,0x70,0xd9,0xe9,0xbe,0x33,0xd3,0xad,0x2e,0xcf,0x09,0xd7,0xfe,0xea,0xdb,0x83,
    0xe3,0xff,0x2d,0x41,0xf0,0xe1,0xe5,0xe0,0x26,0x8a,0xc7,0x52,0xa5,0xdb,0xda,0xdc,
    0x52,0xf7,0x9a,0x5c,0x95,0x32,0x4d,0x52,0x2f,0xce,0x89,0x7e,0xb7,0xee,0x7b,0x73,
    0x3f,0x5d,0x7a,0xc2,0xd5,0xdf,0x08,0x92,0xeb,0xe9,0x48,0x59,0x0b,0x0e,0x7f,0xd2,
    0x40,0xa2,0x26,0x00,0x00,0x74,0x76,0x84,0x48,0xa0,0x6a,0xa0,0x9c,0x44,0xab,0xa2,
    0x10,0x42,0x0d,0x8e,0xf2,0x54,0x69,0x0e,0x32,0x3a,0xe6,0xc7,0xc6,0x30,0xb4,0x62,
    0x59,0x81,0xa6,0x8a,0xdf,0x00,0x35,0x7d,0xf1,0x7d,0x2c,0xcf,0x98,0x4c,0xb4,0xea,
    0xf6,0xfd,0x83,0x5f,0x09,0x65,0xf7,0x87,0x69,0x73,0x64,0x49,0x98,0xb3,0x4c,0x80,
    0xa5,0xbd,0x65,0x8a,0x3a,0xba,0x12,0xe6,0xe3,0x91,0x32,0xc0,0xdb,0xf9,0x72,0x30,
    0x4d,0xea,0x01,0xb9,0x1e,0xa6,0x1f,0xaa,0xed,0x4d,0x7f,0x10,0x28,0x6d,0x79,0x68,
    0x76,0xb0,0x02,0x0d,0x4a,0xeb,0x14,0xae,0xdf,0x59,0xf2,0x73,0xa1,0x78,0xfc,0x72,
    0xbd,0x43,0x24,0x8c,0xd3,0xbf,0xd1,0x68,0x68,0x77,0x5a,0xa2,0x99,0x74,0x56,0xe8,
    0x80,0x88,0x2e,0xc4,0xdc,0x09,0x38,0x07,0xed,0xc8,0xce,0x80,0xb0,0xcc,0x7f,0x88,
    0x23,0x0a,0xae,0x8f,0x8e,0x5d,0xbc,0xe8,0x5a,0x9f,0x2d,0x8b,0x9e,0x7c,0xfc,0x6e,
    0x19,0xe9,0x0e,0x82,0x07,0x70,0x3f,0xac,0xfc,0xaf,0x19,0x6f,0x73,0x64,0x1e,0xec,
    0xff,0xab,0x8b,0x67,0x95,0x32,0xf5,0x5a,0x95,0x47,0xcd,0xcb,0xbf,0x5d,0x71,0xe6,
    0x48,0xce,0x97,0x0a,0x22,0x10,0xcb,0xee,0x2d,0x2a,0x3d,0xf8,0x46,0x8c,0xdc,0xc8,
    0x7b,0x45,0x37,0x19,0x49,0x76,0xc3,0x9c,0xba,0x20,0x91,0x76,0xc2,0x81,0xd2,0x6b,
    0x43,0xf4,0xaa,0x5a,0x49,0x3a,0x1e,0xb1,0xc4,0x42,0x3a,0xdf,0xdb,0x0d,0x29,0x8b,
    0xfa,0x40,0xb3,0xdb,0xc8,0x73,0x47,0xde,0x73,0x83,0x5f,0x3a,0xbb,0x01,0xbe,0xeb,
    0xdb,0x7d,0xdb,0x96,0xda,0x81,0x10,0xc5,0x4a,0xa5,0xc5,0x91,0xcc,0x46,0x78,0xb2,
    0xb7,0x6d,0xda,0x6e,0xe4,0x6e,0xa9,0x4a,0x04,0x82,0x76,0x7e,0x94,0xd4,0x56,0x71,
    0xf1,0xdb,0xa2,0x7e,0x33,0xa9,0xd0,0x09,0x4d,0x21,0x6c,0x9e,0x98,0x35,0x76,0xd6,
    0xd2,0x11,0x8b,0x99,0x3d,0x6b,0x25,0xf2,0x9d,0xc1,0x87,0xd5,0x09,0xd5,0x94,0xf1,
    0x5a,0xfb,0x46,0x99,0x77,0xb6,0xb6,0xa2,0x78,0x99,0xc7,0x5e,0x24,0x5e,0x9d,0x90,
    0x3e,0x2d,0xcc,0x44,0xcf,0xe9,0x0f,0x60,0x72,0x90,0x26,0x95,0x94,0xf0,0xf4,0x91,
    0x1b,0xfe,0x4f,0x07,0xad,0x5e,0xb0,0xca,0x0a,0x01,0x64,0xd2,0xcd,0x19,0x0b,0x2f,
    0xc1,0xa0,0xdb,0x11,0xfc,0x53,0x76,0xb1,0x05,0xb5,0xed,0x99,0x85,0x75,0x7f,0xdb,
    0xe6,0xdd,0x59,0x67,0x19,0xb7,0xd7,0xfc,0x48,0xad,0xcd,0x99,0xee,0x7c,0x7a,0xc4,
    0x7e,0x8c,0xcc,0x96,0x3e,0xec,0xbf,0x9d,0xc1,0xc8,0x07,0x9a,0x86,0x44,0xd1,0xf4,
    0xd8,0x74,0x53,0x9c,0x9d,0x33,0x57,0xde,0x09,0x0e,0x8c,0xfa,0xea,0x2d,0x74,0xf6,
    0x9b,0x79,0x2f,0x98,0x87,0x7d,0x11,0xb4,0xc4,0xc8,0xc7,0x2a,0xc0,0xf8,0x3f,0xff,
    0x26,0xb9,0x5a,0x15,0x26,0x85,0x4c,0xfe,0xc1,0x6e,0xbb,0x76,0xce,0xfe,0xdd,0xf7,
    0x7d,0xa9,0x13,0x3c,0xf8,0xe3,0xd4,0x4c,0xbe,0xa4,0x31,0xdb,0xc6,0xee,0xdc,0xf9,
    0x47,0x59,0x2e,0x96,0x4a,0xe8,0xdd,0xbc,0xa8,0xeb,0x99,0x5e,0x80,0x6d,0x76,0xf2,
    0xf8,0x20,0x46,0xce,0xd5,0x6e,0xcb,0x10,0x77,0x5c,0x8c,0xff,0x89,0xdb,0x7d,0xb7,
    0xcc,0x62,0x43,0xdf,0xff,0x43,0xd2,0x22,0xd0,0x7e,0x44,0xbb,0xe8,0x46,0x13,0x1f,
    0x70,0x72,0x42,0x7e,0xa8,0xd4,0x6d,0x63,0x78,0x70,0x6f,0xca,0x58,0x6a,0x83,0x6c,
    0x79,0x63,0xc3,0xbd,0xba,0x75,0x10,0xa4,0x38,0xa5,0x15,0x86,0xe9,0xa7,0xd5,0x08,
    0x71,0x73,0xc2,0xec,0xa4,0x95,0x30,0x82,0x1d,0xd3,0x43,0x4b,0xd3,0xda,0x72,0x6e,
    0x45,0xdd,0xdb,0xf9,0x3f,0xbb,0xed,0xdb,0x5a,0x61,0xe1,0x4a,0x2f,0x9b,0xad,0x9b,
    0x73,0x80,0x0f,0x89,0x37,0xab,0xec,0xda,0xee,0x12,0xb4,0x43,0x27,0x8b,0xac,0x9a,
    0x6e,0x1b,0x77,0x9a,0x3e,0xba,0x6d,0xd9,0x39,0x45,0x40,0x4e,0x2e,0x9a,0x2d,0x99,
    0x9d,0xf4,0xc0,0x0b,0x36,0xaa,0x6c,0xd8,0x51,0x46,0x62,0x2b,0x26,0x8a,0x2c,0x98,
    0x7a,0x8a,0x0d,0x42,0xd6,0xff,0x9c,0xa5,0xa6,0x5a,0xeb,0xb3,0xd8,0xdb,0xfb,0x6e,
    0x32,0xc8,0xf2,0x06,0xb2,0xe7,0x9b,0x0d,0x7a,0x78,0xe5,0xc2,0xf9,0x5e,0x1a,0x16,
    0x3b,0xd9,0x7f,0x05,0xd5,0xad,0x73,0x4e,0xc4,0xad,0x1d,0x67,0x1b,0xe9,0xde,0xb6,
    0x33,0xc9,0x36,0x04,0xa3,0x7f,0x2e,0x4e,0x1f,0xdb,0xed,0xdf,0xe3,0x5f,0x9a,0x84,
    0xbd,0xca,0x0f,0xe7,0x3d,0xb3,0xe5,0xd3,0xb1,0x2f,0x94,0x44,0x2d,0x93,0xa5,0x93,
    0x32,0x23,0x89,0x45,0x35,0xa3,0xe4,0xd2,0xf6,0xb8,0xe8,0x0c,0x25,0x83,0xa4,0x92,
    0x7b,0x99,0xf4,0xf6,0x3c,0xb2,0x65,0xd1,0xd7,0xae,0x4a,0x6e,0x2c,0x92,0x25,0x91,
    0xd7,0xbb,0xaf,0x09,0x34,0xa2,0x64,0xd0,0x63,0xa9,0x3c,0x40,0x24,0x82,0x24,0x90,
    0x05,0x62,0xa2,0x13,0xfc,0xa3,0xd1,0x3f,0xac,0x12,0x62,0x3d,0xce,0xde,0xd3,0x76,
    0x04,0xb5,0x80,0x9b,0x27,0x5e,0xb4,0xc4,0x45,0xae,0xc4,0xee,0xe4,0x93,0x12,0x2c,
    0x82,0xf3,0x03,0x14,0x45,0x47,0xb0,0x70,0x2f,0x49,0x34,0x1d,0x36,0xfb,0x93,0xae,
    0xf3,0x73,0x85,0xee,0x4d,0xce,0x0b,0x71,0x0b,0x10,0x0a,0x17,0xe5,0x37,0x25,0xbd,
    0x4c,0x76,0x83,0x9e,0x3b,0x3b,0xcd,0xcb,0xfb,0xc4,0xe0,0x57,0x2b,0x1b,0x8d,0x8b,
    0xcb,0x80,0x22,0x1a,0x33,0x2b,0xcc,0xca,0x24,0x92,0x20,0x8a,0x23,0x0b,0x8c,0x8a,
    0xbe,0x23,0x03,0x9c,0x3a,0x3a,0x4d,0xc9,0xa1,0x83,0xa3,0x76,0x2a,0x1a,0x0d,0x89,
    0x2d,0x91,0x41,0xca,0x32,0x2a,0x4c,0xc8,0x25,0xd5,0x61,0x5f,0x22,0x0a,0x0c,0x88,
    0x44,0xe8,0x2a,0x98,0x2a,0x1b,0x3e,0x44,0x2c,0x19,0x4a,0xf7,0xcc,0xf2,0xdb,0x1d,
    0xda,0xea,0x8a,0x1f,0xee,0xd8,0x0f,0xb4,0x60,0xbe,0x88,0xda,0x3d,0x7c,0x1a,0xa5,
    0x5f,0xc1,0x2a,0x12,0x7c,0x09,0x75,0xb5,0xb3,0xcb,0x88,0x50,0xcd,0xc2,0x5b,0x7c,
    0x07,0xbe,0x0a,0xe0,0xf7,0xba,0xf9,0x34,0xbe,0x4a,0x65,0x56,0xe7,0x9a,0x9a,0x82,
    0x3e,0xef,0xd7,0x13,0x39,0x33,0xc5,0xc3,0xa2,0x8a,0x95,0xd1,0x29,0x13,0x85,0x83,
    0x76,0x26,0xa9,0x39,0x31,0x23,0xc4,0xc2,0x64,0x03,0x98,0xa6,0x21,0x03,0x84,0x82,
    0xd7,0x4b,0x22,0x69,0x38,0x32,0x45,0xc1,0x2f,0x96,0x49,0x1f,0x28,0x12,0x05,0x81,
    0xbe,0xbb,0x50,0xa2,0x30,0x22,0x44,0xc0,0x5b,0x7d,0x3a,0xa7,0x20,0x02,0x04,0x80,
    0x18,0xd2,0xeb,0x8f,0x98,0x3b,0xff,0xe4,0x60,0x39,0x6e,0x4d,0xc8,0xa4,0x51,0xd9,
    0x62,0xe9,0xa6,0x8c,0x97,0xf4,0x97,0x85,0x9b,0x54,0xbe,0x30,0x72,0xb2,0x80,0x77,
    0x41,0x43,0x8a,0x8f,0x1a,0xab,0x7f,0xc6,0x68,0x3d,0x63,0xd9,0x8b,0xc5,0x56,0xaa,
    0x63,0xfc,0x26,0x85,0x85,0x75,0xd5,0xac,0xf9,0x78,0xe2,0xce,0x0d,0xb3,0x00,0x75,
    0x68,0xe5,0xe7,0x8b,0x1f,0xb9,0xe9,0x5b,0x48,0xb2,0xbd,0xcb,0x0f,0x99,0xa9,0x1b,
    0x62,0x53,0xa4,0x88,0x17,0xa9,0xe8,0x5a,0x00,0x10,0x06,0x85,0x07,0x89,0xa8,0x1a,
    0x01,0x03,0x20,0x8b,0x1e,0xb8,0x69,0x59,0xe1,0x01,0x87,0xe6,0x0e,0x98,0x29,0x19,
    0x23,0x4e,0xc6,0x82,0x16,0xa8,0x68,0x58,0x01,0x11,0x86,0x47,0x06,0x88,0x28,0x18,
    0x72,0x17,0x6f,0xa8,0xfa,0x59,0x9e,0x8c,0x49,0xda,0x4f,0x79,0x06,0xaa,0x91,0x31,
    0xdd,0x16,0xfe,0x8f,0x8a,0xa1,0x39,0xaf,0x9b,0xc9,0xc1,0x54,0x2a,0xbc,0x89,0xa3,
    0x5b,0x79,0x73,0x7a,0x8b,0x6d,0xdc,0xa5,0x4d,0x2d,0x2d,0x49,0xb3,0x2f,0xdc,0xea,
    0x23,0x3e,0x2c,0x03,0x0b,0x8c,0xfe,0xa5,0x43,0x5d,0x8d,0x84,0xe1,0x61,0x7e,0x8e,
    0x1a,0xc8,0x0f,0x8b,0x1d,0xb1,0xe1,0x53,0x0a,0x4e,0xaf,0x53,0x0d,0x91,0xa1,0x13,
    0x12,0x7e,0x8d,0x85,0x15,0xa1,0xe0,0x52,0x42,0x42,0xbc,0x70,0x05,0x81,0xa0,0x12,
    0xd8,0xa9,0x22,0x73,0x1c,0xb0,0x61,0x51,0x34,0xef,0x57,0xc5,0x0c,0x90,0x21,0x11,
    0x9d,0x29,0x2c,0x89,0x14,0xa0,0x60,0x50,0x23,0x8d,0x12,0x52,0x04,0x80,0x20,0x10,
    0xa7,0x80,0x02,0x96,0x64,0xd8,0xd9,0x1b,0x4f,0x26,0xfd,0xdb,0xcc,0x82,0xdf,0xf7,
    0x4c,0xd6,0x18,0x11,0xcc,0xd6,0x92,0x3a,0xc4,0xd4,0x87,0xd3,0x04,0xfb,0xdf,0x54,
    0xad,0x42,0x45,0x9d,0xd4,0x9e,0x31,0xa7,0x0e,0x41,0x41,0x52,0x7b,0x59,0x1b,0x4f,
    0x55,0x11,0xa0,0x1a,0xa9,0x75,0x19,0xbc,0xd0,0x97,0x35,0xd0,0xb6,0x8b,0x35,0xb6,
    0x9b,0x40,0xa2,0xa9,0x1b,0x39,0xc9,0x4b,0xe4,0x60,0x67,0xb9,0x0b,0x19,0x89,0x0b,
    0xd3,0x30,0x58,0xb5,0x13,0x29,0xc8,0x4a,0x55,0xf2,0x43,0x94,0x03,0x09,0x88,0x0a,
    0xde,0x21,0x55,0xf3,0x1a,0x38,0x49,0x49,0xca,0x01,0xc2,0x96,0x0a,0x18,0x09,0x09,
    0xed,0x89,0xfa,0x9b,0x12,0x28,0x48,0x48,0xed,0x0c,0x18,0x28,0x02,0x08,0x08,0x08,
    0x1c,0x68,0xae,0xd0,0x0e,0xb0,0xbb,0xcd,0x11,0x0b,0x8d,0xde,0x61,0x4c,0x2f,0x5a,
    0x32,0x78,0xf0,0x24,0x84,0xba,0xbf,0xb1,0x46,0x38,0xe5,0xd5,0x34,0xf2,0x9c,0x54,
    0xec,0x69,0x2e,0xd2,0x4f,0xb5,0xba,0xe6,0x13,0xe9,0x4f,0xbf,0xe6,0xc8,0x8a,0xc2,
    0x80,0xc5,0x5c,0x47,0x6b,0xfd,0xfe,0x04,0x07,0x41,0x41,0xd6,0xac,0x09,0x7c,0x65,
    0x0e,0x3b,0xad,0x8e,0x19,0x31,0xc1,0x43,0x89,0x15,0x91,0x23,0x09,0x11,0x81,0x03,
    0x66,0x7d,0xce,0x92,0x11,0x21,0xc0,0x42,0x81,0x05,0x90,0x22,0x01,0x01,0x80,0x02,
    0xa7,0x95,0x7b,0x98,0x18,0x30,0x41,0x41,0x88,0x14,0x11,0x21,0x08,0x10,0x01,0x01,
    0x0f,0x9a,0x23,0x92,0x10,0x20,0x40,0x40,0x80,0x04,0x10,0x20,0x00,0x00,0x54,0x3c,    
};

unsigned char hotknot_transfer_fw[] = {
    
}; 

unsigned char hotknot_auth_fw[] = {
    0xa8,0x3f,0x06,0xee,0xd9,0x50,0xf5,0xbf,0xb9,0xc2,0xec,0x5c,0x94,0x2c,0xd0,0xc0,
    0x56,0x1b,0x01,0xaa,0xea,0x04,0xe0,0xa8,0x36,0x37,0xd4,0xbf,0x33,0xfe,0xea,0x9e,
    0x7b,0xf0,0x20,0x46,0x80,0x73,0x6b,0x4e,0x3f,0x27,0x51,0x1e,0x3d,0x80,0x05,0x01,
    0x2d,0xee,0x85,0x0d,0xa9,0x87,0x11,0x29,0x24,0xef,0x2c,0x47,0xc0,0x75,0x24,0xac,
    0x41,0xb6,0x31,0x8c,0x3f,0xa3,0x95,0x98,0x50,0xe2,0x51,0x2d,0x9a,0xcb,0x14,0x6e,
    0xb7,0x17,0xc1,0x85,0x2e,0x04,0x5d,0xa9,0xc5,0x0d,0x8a,0x46,0x59,0x69,0x13,0x55,
    0xfb,0xbf,0x92,0xcb,0xc2,0xc0,0x63,0xdc,0x0a,0x94,0xfd,0x09,0x76,0x5c,0xd2,0xc6,
    0xf2,0x21,0x03,0x81,0x7f,0xa9,0xe9,0xae,0x5d,0x04,0xff,0x98,0x5a,0x70,0xc3,0xd7,
    0x09,0x0c,0xd3,0x53,0xc4,0x88,0x83,0x2a,0xe1,0x36,0x78,0xbc,0x93,0x53,0xbf,0x04,
    0x30,0x9f,0xa5,0x01,0xa2,0x98,0x82,0x58,0xe0,0x30,0xb0,0x86,0xbe,0x7c,0x70,0x7b,
    0x39,0x8e,0x24,0x15,0xbb,0xf6,0x7d,0xab,0x06,0xc1,0xba,0xd7,0x28,0x5d,0x58,0xec,
    0x8f,0xef,0x09,0x2b,0xb4,0xff,0xdd,0xe6,0x42,0x79,0xae,0x4b,0x21,0x4d,0xd1,0xa4,
    0x62,0x88,0x0b,0x17,0x8d,0xc5,0x35,0x25,0xbc,0x47,0x2d,0x10,0x52,0x79,0x0a,0x4c,
    0x0b,0x2e,0x7d,0xd2,0x5b,0xde,0x8b,0xe5,0x17,0x2d,0xe8,0xf8,0xb5,0xd1,0xd9,0x65,
    0xcf,0x3f,0xf6,0xf1,0xe7,0x10,0x49,0x6f,0xf3,0x22,0xb1,0x11,0x51,0x60,0xda,0x2c,
    0xe7,0x26,0xb8,0xbc,0x70,0xf7,0xd9,0xf1,0x31,0x5f,0x37,0xd9,0x1b,0x1f,0x98,0x80,
    0xeb,0xf2,0xa0,0x60,0x7b,0x06,0xb8,0x1c,0x15,0x54,0xe3,0x54,0x8e,0x24,0x21,0x7b,
    0x4c,0xb0,0x20,0x15,0xec,0x97,0xf0,0x73,0x1c,0xb8,0x06,0x5e,0x5c,0x7e,0xc0,0x77,
    0x01,0x85,0xe0,0x02,0x45,0x4f,0x01,0xcb,0x93,0x49,0x96,0x99,0x43,0x27,0x78,0x7e,
    0x6d,0x57,0xcc,0x9e,0xe4,0xe7,0x33,0x17,0x44,0x09,0x04,0xac,0xb9,0xe7,0x52,0x75,
    0x51,0xfd,0xc9,0x50,0x1d,0xfa,0x22,0x63,0xc2,0x46,0x09,0x64,0xab,0x06,0xf0,0x3c,
    0xe8,0xab,0x80,0xd5,0x7e,0x66,0xf6,0x28,0xc7,0x3c,0xc3,0x1f,0xa4,0x76,0x72,0x10,
    0x7b,0xe9,0xd4,0xb9,0x9c,0xf4,0xc6,0xa4,0xf1,0xd9,0xf4,0x24,0xc7,0x97,0x51,0x13,
    0xf7,0x59,0x80,0x50,0xa2,0x25,0xed,0x4f,0x88,0x27,0x4d,0x66,0xdf,0x17,0x71,0x7f,
    0xdd,0x89,0xa6,0x11,0xa8,0x6e,0xba,0x1c,0x17,0xde,0x5b,0x10,0xb2,0xef,0x7e,0x66,
    0xd9,0x38,0xc0,0x29,0xee,0x9f,0xfc,0x36,0xe4,0x3c,0xf2,0x7d,0x5e,0x76,0x98,0x7f,
    0x74,0xae,0x57,0x90,0x2b,0x09,0x2b,0x27,0xb8,0x5f,0xf8,0xa7,0xae,0x2f,0x70,0xd6,
    0x45,0x04,0x5e,0x96,0xef,0x9e,0x38,0x79,0xb3,0x51,0x97,0x9d,0xbb,0xeb,0x5a,0x7d,
    0xc4,0xca,0xd6,0x07,0xb1,0xc3,0xae,0x37,0xea,0xd5,0xaa,0x36,0x42,0x8e,0x3b,0x6c,
    0xb4,0x50,0xca,0xde,0x4a,0x2a,0x6f,0x14,0x25,0x5b,0x74,0x04,0xa6,0x7e,0x7e,0x06,
    0xcb,0x39,0xea,0xdf,0x14,0x7e,0xdf,0x26,0x3b,0xe9,0x13,0x5f,0xaf,0x8f,0xb9,0x91,
    0xb5,0xd8,0x30,0x04,0x99,0x08,0x01,0xfb,0xf2,0x47,0xd1,0x07,0x85,0xfc,0x58,0x79,
    0xd8,0x0a,0xdb,0x0f,0xe1,0xe6,0xcf,0x60,0x31,0xd6,0x4c,0x5d,0xb1,0x50,0x35,0x92,
    0x9c,0xf8,0x46,0x61,0x12,0xf8,0x05,0x6c,0x01,0x52,0x4f,0x40,0x05,0xa4,0x47,0xbc,
    0x01,0x2a,0x65,0xe4,0x81,0xc9,0xa7,0x31,0x69,0x17,0x3d,0x43,0x4b,0x06,0x27,0x8c,
    0x3b,0x0b,0x14,0xef,0x54,0x93,0x0e,0x87,0x40,0x53,0x83,0x42,0xa3,0x35,0x17,0xe7,
    0x82,0xb9,0xf3,0x96,0x2b,0x4b,0x89,0xa9,0x42,0x86,0xc7,0x23,0x88,0x04,0x15,0x9b,
    0x7f,0xa1,0x83,0x28,0x6a,0x66,0x44,0xe9,0xaf,0x85,0x96,0x46,0x80,0x51,0xf6,0x6f,
    0x83,0xb9,0x6f,0xb7,0x31,0xeb,0x82,0x9e,0x0e,0xe4,0xa2,0x05,0x89,0x05,0x95,0x59,
    0x78,0xeb,0x6c,0xe3,0x05,0x6d,0xb2,0x81,0x4f,0x00,0x6c,0xec,0x0e,0x95,0x76,0x6d,
    0xf6,0x58,0x4f,0x78,0x8d,0x61,0xc5,0x34,0x72,0xca,0x56,0xd3,0xba,0x62,0x6f,0x7b,
    0x22,0x0a,0xee,0x43,0xfb,0x65,0x4c,0xa2,0xe0,0x98,0xcd,0xcb,0xc5,0xba,0xc6,0xcd,
    0x29,0x2b,0x1d,0xee,0x1a,0x55,0x9a,0x44,0xe0,0xdf,0xcc,0xda,0x09,0xd5,0xcc,0x27,
    0x0b,0x1a,0xc8,0x44,0x32,0xf7,0x94,0x66,0x62,0x87,0xaa,0xcb,0x7b,0xe8,0xef,0x56,
    0x5a,0xb1,0x3d,0x24,0x84,0x3c,0x25,0x41,0x1b,0xcb,0x04,0x4c,0x1d,0x8c,0xdc,0xe4,
    0x07,0x77,0xae,0x12,0x84,0x02,0xa7,0x34,0x98,0x6b,0xd9,0x2d,0x82,0x59,0xfe,0x67,
    0xd9,0x7b,0x0f,0xcc,0xca,0xfa,0xe7,0x1a,0xdd,0x4e,0x43,0xdc,0x33,0x0d,0x9d,0x31,
    0x54,0x23,0x74,0x22,0x21,0xad,0x2a,0x06,0xbb,0x79,0x6a,0xb2,0x06,0x9d,0x7e,0x65,
    0xc0,0xa5,0x05,0xb0,0xcd,0xec,0x32,0x8e,0x75,0xd4,0x05,0xd4,0x90,0xe1,0x72,0xee,
    0x3a,0xf0,0x04,0x84,0x17,0x74,0x71,0x7c,0x5d,0xf2,0x61,0xf9,0x7c,0x7d,0x6f,0x2c,
    0xa6,0xdc,0xe7,0x9e,0x28,0x03,0x2f,0x80,0x4c,0xdd,0x85,0xd6,0x8c,0x23,0x6f,0x8a,
    0x25,0x39,0x44,0xf5,0xec,0x77,0xbd,0x73,0xf2,0xcc,0x85,0x4c,0xc5,0xa3,0x10,0xe1,
    0xb7,0xb4,0xd1,0x84,0xc8,0x5f,0xe0,0x99,0x7f,0x2a,0xbb,0xda,0xf8,0x88,0xd7,0x7e,
    0x69,0x91,0x69,0xb9,0x81,0xc8,0xf5,0xc3,0x73,0x57,0xaf,0x7d,0xc1,0x94,0x34,0x2a,
    0xdf,0x3c,0x82,0xba,0x9c,0x4d,0xbc,0x8f,0xca,0xcd,0x59,0xbe,0x8a,0x05,0x74,0xde,
    0x2b,0xd0,0xfb,0x97,0x2e,0xc0,0x0e,0x6b,0x00,0xf7,0x98,0xdd,0x85,0x95,0xb4,0x48,
    0x92,0x64,0xcd,0xfe,0xff,0xdb,0xd9,0x31,0xc9,0xd4,0x0e,0x27,0xee,0xaf,0x38,0xe3,
    0x9a,0xd0,0xe4,0xdd,0x95,0x77,0x3c,0x54,0xc1,0xc4,0x07,0xc8,0xff,0xea,0x5e,0x64,
    0x93,0x61,0x4d,0xfc,0xa5,0x07,0xf9,0xb1,0xcc,0xd4,0x84,0xeb,0x39,0xd9,0x9d,0x7a,
    0x06,0xd5,0x64,0xff,0x54,0x96,0x50,0xa0,0xc4,0x3f,0x76,0x23,0x85,0x57,0xbc,0x34,
    0x4a,0xce,0xa6,0x4d,0xa8,0xe6,0xe1,0x28,0x25,0x75,0xde,0xf6,0x8e,0x6c,0x7b,0xbc,
    0x7a,0x99,0x43,0xb1,0x54,0x9a,0x0e,0x95,0x19,0x52,0x84,0x4a,0x9e,0xba,0x3b,0xf0,
    0x67,0x88,0xce,0xb2,0xd3,0xc4,0xe6,0x49,0xc3,0xab,0x32,0x98,0xcf,0x3f,0x05,0xf1,
    0xaa,0x98,0xd3,0xb6,0x8a,0xe6,0xe3,0xb8,0x8d,0x35,0xc7,0xdd,0xb5,0x04,0x5c,0xf9,
    0x88,0x0c,0xa1,0x8a,0xb8,0xff,0xf9,0x23,0xd4,0x80,0xe1,0x30,0xe8,0x27,0x9e,0x21,
    0x8b,0x72,0x42,0xbe,0xe5,0x65,0x73,0xbe,0x52,0xcb,0xe2,0x4c,0xa2,0xc7,0x77,0xce,
    0x7e,0xe3,0x02,0x4a,0x9f,0xa4,0x96,0x3c,0x71,0x65,0x98,0x4f,0x32,0x85,0x0c,0x41,
    0x71,0x93,0x84,0x23,0xb6,0x6d,0x12,0x67,0x13,0x30,0x62,0x02,0x4d,0x72,0x38,0x00,
    0x28,0x47,0xa1,0x46,0x38,0xac,0xc2,0x69,0x09,0x7a,0xe5,0x5f,0x10,0xb3,0x9a,0xe9,
    0x60,0x56,0xa2,0xfa,0x80,0x58,0x15,0x1b,0x37,0xa6,0xcd,0x9a,0xf6,0x73,0x9a,0x6a,
    0x28,0xb3,0x03,0x62,0x3e,0x02,0x50,0x27,0x72,0x07,0x3d,0x40,0x0d,0x17,0x5c,0x03,
    0x77,0xe0,0xea,0xc4,0xec,0x27,0x30,0x6a,0x99,0xba,0x5b,0x9a,0xf7,0x72,0x42,0xcb,
    0x3a,0xd8,0xff,0x07,0xea,0x0b,0xbb,0x2e,0x28,0xaa,0xc0,0x44,0xf0,0xac,0xb1,0x2b,
    0x6a,0x5c,0x41,0x04,0x8e,0x98,0x82,0x39,0x7a,0x3b,0xc0,0x44,0x92,0x38,0xd0,0xa0,
    0x3b,0x59,0x8c,0x05,0xa7,0x4e,0x39,0xab,0x6b,0x0e,0x6b,0x26,0x89,0x2f,0x1a,0x6e,
    0x41,0xe7,0x2a,0x06,0xa3,0x1a,0x18,0x6f,0x79,0xb9,0x4b,0x6f,0x5b,0xf6,0x9e,0x66,
    0x82,0x82,0x91,0xa5,0xc0,0xaa,0x9a,0x91,0x2a,0x0e,0x0a,0x03,0x72,0x26,0xf9,0x09,
    0x22,0x5e,0x88,0x69,0x7b,0xbe,0xb7,0x22,0x05,0x58,0x38,0x4d,0xf4,0x7b,0xca,0xc1,
    0x96,0xb7,0x77,0xd7,0xa3,0x47,0xba,0xa5,0xeb,0xdb,0xea,0x33,0xfd,0x6a,0x13,0x61,
    0x33,0x2a,0xa5,0x8e,0xf1,0xb5,0xdd,0xe0,0x84,0xb9,0xbc,0x3b,0x7b,0x37,0xff,0xf8,
    0xc2,0xe2,0xdf,0x9c,0xbc,0x7f,0xd9,0x73,0x6a,0x01,0xe2,0x74,0x8a,0x10,0x19,0x93,
    0x5c,0xf2,0x3d,0x17,0xe1,0xe5,0x53,0xae,0x24,0x4b,0x01,0x11,0xf1,0x47,0x4b,0xd8,
    0xc1,0x04,0xe3,0x72,0x9b,0x20,0xb6,0x2c,0x3d,0xc3,0x13,0x37,0xeb,0x0d,0xf6,0x6c,
    0x85,0x90,0x00,0x99,0xb2,0xed,0x32,0x77,0xe0,0xc3,0x93,0x0c,0xcf,0x4a,0x86,0x73,
    0x2d,0x2a,0xa3,0x70,0xfe,0x83,0xe8,0x8b,0x6e,0x50,0xf2,0xfb,0xdc,0xf5,0x81,0xa9,
    0x72,0x65,0x4a,0x96,0x9c,0xa3,0x79,0x72,0x55,0xcc,0x88,0x11,0xa4,0x9f,0x92,0xa9,
    0x6d,0xc7,0x03,0xe9,0xff,0x5f,0x41,0xeb,0xf1,0x83,0x19,0xdd,0xb2,0x1b,0xae,0xd8,
    0x8d,0x1b,0x38,0xbe,0xa3,0xa7,0x3e,0xc1,0x67,0x41,0x69,0xf8,0xa2,0xd1,0x0a,0x68,
    0x79,0x6a,0x89,0x90,0xee,0x8b,0x9b,0x3e,0xa9,0x85,0x83,0x1c,0x29,0xdd,0x1e,0x3a,
    0xca,0x1d,0x27,0x93,0x0a,0x18,0xa2,0x29,0x26,0x4b,0x4f,0xe4,0xe0,0x10,0x90,0x4a,
    0x03,0x6b,0x55,0x96,0xa3,0xce,0x19,0xbb,0xac,0x05,0x03,0x3e,0xfe,0xf2,0x91,0x69,
    0x0b,0x39,0x08,0x6b,0xa7,0x9a,0x38,0x7f,0x0d,0xbc,0x12,0xd6,0x81,0x0c,0x06,0x86,
    0x93,0x36,0xd7,0xc5,0x39,0xbe,0xec,0xe3,0xf2,0x8a,0x9d,0xe1,0xa8,0x0e,0x8f,0xf8,
    0x36,0x28,0x6b,0xbc,0xf4,0x47,0xc0,0xb0,0xc9,0x0b,0xef,0xd0,0xe9,0x1e,0x10,0x72,
    0x2f,0xcf,0x29,0x7a,0x07,0x1a,0x64,0x52,0xcc,0x17,0x89,0x1f,0xc7,0x2b,0xa8,0xa1,
    0x9b,0x2a,0x85,0x92,0xac,0x27,0x3b,0x5f,0x0d,0xf3,0x00,0x3b,0xde,0x82,0x87,0x80,
    0x2a,0x06,0xa7,0x86,0x98,0xfd,0xfd,0x83,0x18,0x40,0x25,0xc4,0xce,0x96,0x52,0xfe,
    0xd3,0xf0,0xa4,0x09,0xc5,0x67,0x77,0x3e,0x0c,0x35,0xe4,0x5e,0x86,0x93,0x35,0xa1,
    0xa9,0x0a,0x25,0x08,0xbf,0xa3,0x92,0xbc,0x53,0x21,0xc5,0x82,0xcb,0x45,0x3f,0x41,
    0xa9,0xf1,0x07,0xcb,0x96,0x6f,0x16,0xe7,0x8d,0x51,0x3e,0x32,0x79,0xfd,0x66,0xee,
    0xe0,0xc6,0x95,0x9b,0x80,0x4c,0x36,0xa9,0xb0,0xa0,0xcc,0x10,0xf0,0x6b,0xa0,0xe4,
    0x50,0xad,0xee,0x46,0x5c,0x34,0xf5,0xf0,0x15,0x17,0x41,0x9b,0xda,0x89,0xaf,0xea,
    0x49,0x44,0x07,0xc2,0xfb,0x69,0xb7,0x06,0xe3,0x7c,0xaa,0x84,0xe4,0x18,0x0e,0xe9,
    0x77,0xe6,0x81,0x99,0x68,0xd3,0x40,0xeb,0xaf,0x01,0xf4,0x53,0x69,0x05,0x06,0xf8,
    0x25,0x68,0x4f,0x57,0xca,0x09,0xbf,0xae,0xf2,0xe1,0x4a,0xc5,0xcc,0x9a,0xb5,0x8b,
    0x52,0xe7,0x6c,0xcb,0x2a,0x9a,0x86,0xb9,0x3e,0xc1,0xac,0x5a,0xc3,0x5c,0xb6,0x0a,
    0x5b,0x69,0xcd,0xca,0x87,0x4c,0x3d,0x2b,0x4d,0x8b,0x35,0x4b,0xa1,0x2a,0xda,0xf4,
    0xc0,0xf7,0x0f,0xc3,0x83,0x18,0x1c,0xef,0xfb,0xf0,0x91,0xc6,0x85,0x8f,0xb4,0x48,
    0x0f,0x3b,0x38,0x53,0x3d,0x42,0x18,0x72,0x8a,0x82,0x9e,0x81,0xac,0x8c,0x4e,0x11,
    0x02,0x5d,0xac,0x20,0x42,0x8d,0xee,0xae,0x32,0x43,0xea,0x12,0x01,0x04,0x71,0x72,
    0xdc,0x37,0x0d,0xca,0x3a,0x4d,0x27,0xef,0x8c,0x2c,0x0c,0xcc,0x64,0x90,0x2b,0x8d,
    0xbf,0x6b,0x83,0xcd,0x55,0x56,0x39,0x01,0x69,0x5f,0x24,0x8b,0x40,0xe4,0x2e,0xf9,
    0x44,0xc6,0x6c,0x9d,0x9c,0x7d,0xdd,0xd3,0x67,0x26,0xff,0x20,0xaa,0x13,0x72,0xee,
    0x26,0x93,0x86,0x97,0xc1,0xe7,0x57,0x2e,0x6c,0xc3,0x4f,0x78,0x69,0x32,0xee,0x3b,
    0x6f,0x78,0x07,0x9f,0xbb,0x27,0xb2,0xac,0x0d,0x50,0xca,0x7f,0x1a,0xd6,0xc6,0x5d,
    0xa5,0x07,0x04,0x6c,0x92,0xef,0x36,0xf7,0xed,0xc2,0xcb,0x7c,0x95,0xb0,0x74,0xb7,
    0x32,0x66,0xcd,0xd7,0x24,0x11,0xe8,0xb7,0xcf,0x00,0xc3,0x54,0xcb,0x43,0x8d,0xfc,
    0x4d,0xf2,0x86,0x1c,0x0b,0x29,0xd6,0x63,0x11,0x97,0x61,0xab,0x92,0x14,0xd0,0xb4,
    0x51,0xd8,0x82,0x90,0x8b,0xd2,0x3b,0x3b,0x8d,0xe1,0x73,0x94,0x73,0x6d,0xf5,0x36,
    0x23,0xb3,0xa3,0xba,0x16,0xf3,0x07,0xf3,0x2c,0x0a,0xe5,0x2c,0x51,0x7d,0x0c,0x07,
    0x76,0xe8,0x30,0x9e,0xce,0x89,0x9f,0xbe,0x64,0x28,0xe4,0xd4,0x8e,0x51,0x95,0x7b,
    0x51,0x78,0x8c,0x11,0xac,0x7c,0xbf,0x9d,0xa9,0x3e,0xf6,0x9b,0xd3,0xcf,0x4b,0x26,
    0xaf,0x82,0x0d,0x10,0x83,0xcc,0x1d,0x3b,0x0f,0x51,0x40,0xd7,0xa9,0x1e,0xfa,0xe4,
    0x2b,0x79,0x50,0xf7,0x87,0xfd,0xdf,0xbb,0x17,0xbc,0x6c,0x9f,0x00,0xc3,0x7e,0xbf,
    0xb0,0xed,0x8f,0x15,0xc0,0xc9,0x9d,0xb2,0xe6,0x16,0xfe,0x9e,0x98,0x0c,0xcb,0xbd,
    0xb8,0x5e,0xb4,0xeb,0x00,0xcd,0x39,0x53,0xc1,0x1c,0xed,0xc9,0xf8,0x1c,0xfd,0xf5,
    0x29,0xab,0xaa,0xb3,0x43,0x0d,0x3a,0xfc,0x9c,0xdd,0xdd,0x6a,0x97,0xaf,0xe3,0x75,
    0x55,0x33,0xe9,0x50,0xc9,0x5b,0x70,0x1b,0xaf,0x19,0x0e,0xcd,0x76,0x8d,0x5c,0xbe,
    0xc0,0xdb,0x3e,0x06,0xfe,0x02,0xf9,0x23,0x36,0xc2,0xc2,0x43,0x00,0xcc,0x55,0xad,
    0x0a,0xf2,0x83,0x62,0xf7,0x96,0x99,0x2d,0x78,0x90,0xd9,0x4e,0x08,0xc4,0x52,0x90,
    0x51,0x14,0x21,0x8a,0x52,0xf6,0x1c,0x63,0xb0,0xc3,0x6c,0x4d,0x6a,0x2d,0x35,0x9d,
    0xd9,0x73,0xc2,0xdc,0xb1,0xa5,0x91,0xbc,0x79,0x91,0x45,0x4c,0xe7,0x33,0x30,0xe0,
    0x7b,0x30,0x82,0x82,0xb8,0xc6,0x82,0x24,0x06,0x5c,0xb1,0xb1,0x43,0x66,0xc7,0x26,
    0x6c,0x12,0xa2,0x5a,0x7c,0xb6,0xbf,0x2a,0xb5,0x57,0xbf,0x74,0x8b,0x70,0xcc,0x00,
    0x61,0x81,0xfe,0x00,0xfb,0xa7,0x3e,0x29,0x44,0x5f,0xf2,0x04,0x3c,0x7f,0xd4,0x58,
    0xfd,0x33,0x3c,0xa6,0x96,0x45,0x6c,0xfc,0xea,0x59,0xc5,0xe9,0x82,0xf7,0xa8,0x7d,
    0x7a,0x8a,0x0d,0xf1,0x3d,0x35,0xf3,0x6c,0xa6,0xca,0xca,0x4b,0x37,0xdf,0xd4,0x29,
    0x82,0x64,0xaa,0x0f,0x1a,0xf4,0x54,0xe4,0x90,0xda,0xcb,0x4a,0x98,0xde,0x7d,0x2b,
    0x59,0x08,0x2b,0x0c,0x38,0xb5,0x73,0x4e,0x37,0xcb,0x4a,0x49,0xf3,0x2e,0x59,0x67,
    0x83,0x61,0x68,0x04,0x74,0x2d,0x58,0x84,0x93,0x5b,0x8a,0x94,0xf6,0xd4,0x5b,0x4f,
    0x7a,0xb7,0x69,0x06,0xe3,0xc8,0xcd,0xe9,0x70,0xec,0xdd,0x4b,0x65,0x45,0xae,0x7d,
    0x6f,0xf4,0x0d,0x33,0xb2,0x7b,0x78,0x78,0x22,0x49,0x37,0xe2,0x7d,0x85,0x23,0x98,
    0xd6,0xba,0x0e,0x85,0xa3,0x47,0xda,0xd3,0x93,0xb3,0x3f,0xc5,0x13,0xb7,0x2f,0xf5,
    0x9f,0x68,0x2a,0x86,0xb3,0x7a,0x38,0xd4,0xcc,0x89,0x34,0xec,0xce,0x43,0xeb,0x2d,
    0x9f,0x7f,0xdf,0xef,0xfb,0xf7,0x04,0x93,0x14,0xa0,0xe2,0x33,0xe6,0xa4,0xef,0x32,
    0xcc,0x47,0x54,0xee,0x3f,0xbc,0x15,0x37,0x1c,0xb0,0x61,0x51,0xb0,0xd6,0x8e,0xf0,
    0xfa,0x03,0x8e,0x01,0x16,0x7f,0x4c,0x03,0x04,0x25,0x2f,0x8b,0xf8,0x4c,0x72,0x56,
    0xf2,0x6e,0x5e,0x15,0xa9,0xc2,0x12,0xbe,0x9d,0x6f,0x07,0xd2,0x8a,0x46,0x75,0xfe,
    0x57,0xcf,0x5a,0xb9,0x65,0xfc,0xae,0x85,0x41,0xde,0x52,0x15,0xb6,0xe6,0x71,0x47,
    0x72,0xe8,0x41,0xea,0x5f,0xd4,0x58,0xc4,0xd2,0x12,0xcf,0xd5,0x7c,0x87,0x51,0xa6,
    0x52,0xf1,0x01,0xe9,0x05,0x0a,0x1e,0x9d,0x35,0xe2,0xe3,0xdd,0xeb,0x44,0x8e,0xd9,
    0xb6,0xae,0xdb,0xa8,0x8d,0xa6,0xcb,0xb6,0x25,0xd6,0x80,0x7f,0xa3,0xf2,0x72,0x13,
    0xd2,0xc8,0x2e,0xf6,0xdf,0xd8,0xdf,0x28,0x5e,0x5b,0xec,0x85,0xc4,0xb3,0x93,0x1c,
    0xf1,0x1a,0x07,0x91,0x98,0x39,0xd2,0x7d,0x26,0x88,0x6a,0xf6,0x3e,0xce,0x1b,0x4d,
    0x9c,0x76,0x57,0xe5,0x7d,0xa9,0x51,0x19,0x45,0xa2,0x03,0x3e,0xaf,0x9d,0xf9,0xd5,
    0xcf,0x4e,0xdc,0xe4,0xb1,0x3d,0xd3,0x78,0xbf,0xcb,0x8b,0x6f,0x5f,0x76,0xd7,0xfb,
    0xfd,0x70,0xd9,0xe9,0xbe,0x33,0xd3,0xad,0x2e,0xcf,0x09,0xf6,0xfe,0xea,0xdb,0x83,
    0xa3,0xff,0x2d,0x43,0xf0,0xe1,0xe5,0xe0,0x26,0x8a,0xc7,0x52,0xa5,0xdb,0xda,0xdc,
    0x52,0xf7,0x9a,0x5c,0x95,0x32,0x4d,0x52,0x2f,0xce,0x89,0x7e,0xb7,0xee,0x7b,0x73,
    0x3f,0x5d,0x78,0xc2,0xd5,0xdf,0x08,0x92,0xeb,0xe9,0x48,0x59,0x0b,0x0e,0x7f,0xd2,
    0x40,0xa2,0x26,0x00,0x00,0x74,0x76,0x84,0x48,0xa0,0x6a,0xa0,0x9c,0x44,0xab,0xa2,
    0x10,0x42,0x0d,0x8e,0xf2,0x54,0x69,0x0e,0x32,0x3a,0xe6,0xc7,0xc6,0x30,0xb4,0x62,
    0x59,0x81,0xa6,0x8a,0xdf,0x00,0x35,0x7d,0xf1,0xfd,0x5e,0xcf,0xd8,0x4c,0xb4,0xea,
    0xf6,0xfd,0x83,0x5d,0x09,0x65,0xf7,0x87,0x69,0x73,0x64,0x49,0x98,0xb3,0x4e,0x80,
    0xa5,0xbd,0x65,0x8a,0x3a,0xba,0x12,0xe6,0xe3,0x91,0x32,0xc0,0x9b,0xf9,0x72,0x30,
    0x4d,0xea,0x01,0xbb,0x1e,0xa6,0x1f,0xaa,0xed,0x4d,0x7f,0x10,0x28,0x6d,0x79,0x68,
    0x76,0xb0,0x02,0x0d,0x0a,0x7b,0x14,0xae,0xdf,0x59,0xf2,0x73,0xa1,0x78,0xfc,0x72,
    0xbd,0x43,0x24,0x8c,0xd3,0xbf,0xd1,0x68,0x68,0x77,0x58,0xa2,0x99,0x74,0x56,0xe8,
    0xfb,0x88,0x2e,0xc4,0xdc,0x09,0x38,0x07,0xed,0xc8,0xce,0x80,0xb0,0xcc,0x7f,0x88,
    0x23,0x0a,0xae,0x8f,0x8e,0x5d,0xbc,0xe8,0x5a,0x9f,0x2d,0x8b,0x9e,0x7c,0xfc,0x6e,
    0x19,0xe9,0x0e,0x82,0x07,0x70,0x3f,0xac,0xfc,0xaf,0x1b,0xfc,0x73,0xe4,0x1e,0xec,
    0xff,0xab,0x8b,0x65,0x95,0x32,0xf5,0x5a,0xd5,0x47,0xcd,0xcb,0xbf,0x5d,0x71,0xe6,
    0x48,0xce,0x95,0x0a,0x22,0x90,0x9b,0xee,0x2d,0x2a,0x3d,0xf8,0x46,0x8c,0xdc,0xc8,
    0x7b,0x45,0x37,0x19,0x49,0x76,0xc3,0x9c,0xba,0xa0,0x91,0x76,0xc2,0x81,0xd2,0x6b,
    0x43,0xf4,0xaa,0x5a,0x09,0x3a,0x1e,0xb1,0xc4,0x42,0x3a,0xdf,0xdb,0x0d,0x29,0x8b,
    0xfa,0x40,0xb3,0xdb,0xc8,0x73,0x47,0xde,0x73,0x83,0x5f,0x3a,0xbb,0x01,0xbe,0xeb,
    0xdb,0x7d,0xdb,0x96,0xda,0x81,0x10,0xc5,0x4a,0xa5,0xc5,0x91,0xcc,0x46,0x78,0xb2,
    0xb7,0x6d,0xda,0x6e,0xe4,0x6e,0xa9,0x4a,0x04,0x82,0x76,0x7e,0x94,0xd4,0x56,0x71,
    0xf1,0xdb,0xa2,0x7c,0x33,0xa9,0xd0,0x09,0x4d,0x21,0x6c,0x9e,0xd8,0x35,0x76,0xd6,
    0xd2,0x11,0x8b,0x99,0x3d,0x6b,0x25,0xf2,0x9d,0xc1,0x87,0xd5,0x09,0xd5,0x94,0xf1,
    0x5a,0xfb,0x46,0x99,0x77,0xb6,0xb6,0xa2,0x78,0x99,0xc7,0x5e,0x24,0x5e,0x9d,0x90,
    0x3e,0x2d,0xcc,0x44,0xcf,0xe9,0x0f,0x60,0x72,0x90,0x26,0x95,0x94,0xf0,0xf4,0x91,
    0x1b,0xfe,0x4f,0x07,0xad,0x5e,0xb0,0xc8,0x0a,0x01,0x64,0xd2,0xcd,0x19,0x0b,0x2f,
    0xc1,0xa0,0xdb,0x11,0xfc,0x53,0x74,0xb1,0x05,0xb5,0xed,0x99,0x85,0x75,0x7f,0xdb,
    0xe6,0x5d,0x59,0x67,0x19,0xb7,0xd7,0xfc,0x48,0xad,0xcd,0x99,0xee,0x7c,0x7a,0xc6,
    0x7e,0x8c,0xcc,0x96,0x3e,0xec,0xbf,0x9d,0xc1,0xc8,0x07,0x9a,0x86,0x44,0xd1,0xf4,
    0xd8,0x74,0x53,0x9c,0x9d,0x33,0x57,0xde,0x09,0x0e,0x8c,0xfa,0xea,0x2d,0x74,0xf6,
    0x9b,0x79,0x2f,0x98,0x87,0x7d,0x11,0xb4,0xc4,0xc8,0xc7,0x2a,0xc0,0xf8,0x3f,0xff,
    0x26,0xb9,0x5a,0x15,0x26,0x05,0x4c,0xfe,0xc1,0x6e,0xb9,0xe4,0xce,0xfe,0xdd,0xf7,
    0x7d,0xa9,0x13,0x3c,0xf8,0xe3,0xd4,0x4c,0xbe,0x24,0x61,0xdb,0xc6,0xee,0xdc,0xf9,
    0x47,0x59,0x2e,0x96,0x0a,0xe8,0xdd,0xbc,0xa8,0xeb,0x99,0x5e,0x80,0x6d,0x76,0xf2,
    0xf8,0x20,0x46,0xce,0xd5,0x6e,0xcb,0x10,0x77,0x5c,0x8c,0xff,0x89,0xdb,0x7d,0xb7,
    0xcc,0x62,0x43,0xdf,0xff,0x43,0xd2,0x22,0xd0,0xfb,0xa7,0xbb,0xff,0x1f,0x56,0x0e,
    0x70,0x72,0x42,0x7e,0xa8,0xd4,0x6d,0x63,0x78,0x70,0x6f,0xca,0x58,0xe3,0xb2,0x67,
    0x79,0x63,0xc3,0xbd,0xba,0x75,0x10,0xa4,0x38,0xa5,0x17,0x19,0x77,0xa1,0x4f,0xbd,
    0x71,0x73,0xc2,0xec,0xe4,0x95,0x30,0x82,0x1d,0xd3,0x43,0x4b,0x11,0x99,0x30,0x6c,
    0x94,0xe5,0x41,0x08,0x3f,0xbb,0xed,0xdb,0x58,0x57,0xe3,0x28,0x2f,0x9b,0xad,0x9b,
    0x70,0x80,0x7d,0xfd,0x37,0xab,0xec,0xda,0xdc,0xb7,0xc3,0x65,0x27,0x8b,0xac,0x9a,
    0xbe,0xc3,0x87,0xed,0x3e,0xba,0x6d,0xd9,0xb2,0x26,0x1c,0x4e,0x2e,0x9a,0x2d,0x99,
    0x31,0x2a,0x01,0x4f,0x36,0xaa,0x6c,0xd8,0xf5,0xb1,0x60,0x06,0x26,0x8a,0x2c,0x98,
    0x7a,0x8a,0x0d,0x42,0xd6,0xff,0x9c,0xa5,0xa6,0x5a,0xeb,0xb3,0x26,0x3c,0xfb,0x2a,
    0x32,0xc8,0xf2,0x06,0xb2,0xe7,0x9b,0x0d,0x7a,0x78,0xe5,0xc2,0x9d,0x7a,0xe9,0x6f,
    0x3b,0xd9,0x7f,0x05,0xd5,0xad,0x73,0x4e,0xc4,0xad,0x1f,0xe4,0x78,0xe2,0xb3,0x7d,
    0x33,0xc9,0x36,0x04,0xa3,0x7f,0x2e,0x4e,0x1f,0xdb,0xed,0xdf,0x93,0xdb,0xba,0x4b,
    0xde,0xaa,0x2e,0x0a,0x3d,0xb3,0xe5,0xd3,0x6a,0xb8,0xbd,0x43,0x2d,0x93,0xa5,0x93,
    0x2a,0x18,0xad,0x00,0x35,0xa3,0xe4,0xd2,0xca,0x1a,0x0a,0x6d,0x25,0x83,0xa4,0x92,
    0x4b,0xee,0x6b,0x01,0x3c,0xb2,0x65,0xd1,0x6b,0xb9,0x31,0x41,0x2c,0x92,0x25,0x91,
    0x41,0x58,0x28,0x02,0x34,0xa2,0x64,0xd0,0x23,0x1b,0x8a,0x0f,0x24,0x82,0x24,0x90,
    0x05,0x62,0xa2,0x13,0xfb,0x66,0x91,0xba,0xac,0x12,0x62,0x3d,0xec,0x26,0xa4,0xbe,
    0x04,0xb5,0x80,0x9b,0x40,0x10,0xe6,0x37,0x45,0xae,0xc4,0xee,0xc6,0x6b,0xd2,0x77,
    0x82,0xf3,0x03,0x14,0x78,0x67,0x32,0x7a,0x2f,0x49,0x34,0x1d,0xcf,0x7b,0x53,0x17,
    0xf3,0x73,0x85,0xee,0xb5,0x45,0x0e,0x3c,0x0b,0x10,0x0a,0x17,0x3e,0x75,0x92,0xad,
    0x24,0x80,0xc0,0xc9,0x3b,0x3b,0xcd,0xcb,0x2c,0xc4,0xe0,0x5c,0x2b,0x1b,0x8d,0x8b,
    0xdc,0x52,0xab,0x62,0x33,0x2b,0xcc,0xca,0x24,0x8f,0xc0,0x14,0x23,0x0b,0x8c,0x8a,
    0x3d,0xe6,0x5f,0x19,0x3a,0x3a,0x4d,0xc9,0xa1,0x83,0x1d,0xdb,0x2a,0x1a,0x0d,0x89,
    0x75,0x2f,0x21,0x33,0x32,0x2a,0x4c,0xc8,0x67,0x0a,0x10,0xac,0x22,0x0a,0x0c,0x88,
    0x44,0xe8,0x2a,0x98,0xbe,0x5c,0xd7,0x37,0x2c,0x19,0x4a,0xf7,0xee,0x8b,0x1b,0x11,
    0xda,0xea,0x8a,0x1f,0x65,0x1e,0x98,0xb3,0x60,0xbe,0x88,0xda,0x50,0x42,0x96,0xc4,
    0x5f,0xc1,0x2a,0x12,0xe7,0xc9,0xbf,0x78,0xb3,0xcb,0x88,0x50,0xef,0x89,0x53,0x7d,
    0x07,0xbe,0x0a,0xe0,0x72,0x7f,0x18,0xb1,0xbe,0x4a,0x65,0x56,0x27,0xf0,0x53,0xde,
    0xb7,0xaa,0xd1,0xa1,0x39,0x33,0xc5,0xc3,0x52,0x6c,0xb9,0xa4,0x29,0x13,0x85,0x83,
    0xf5,0x3a,0xd8,0x78,0x31,0x23,0xc4,0xc2,0xe1,0x1a,0x4f,0x1d,0x21,0x03,0x84,0x82,
    0xb8,0x4b,0x2e,0xf3,0x38,0x32,0x45,0xc1,0xc7,0x6b,0xeb,0x33,0x28,0x12,0x05,0x81,
    0xf0,0x3b,0xd4,0x3f,0x30,0x22,0x44,0xc0,0x36,0xf9,0xcf,0x1e,0x20,0x02,0x04,0x80,
    0x18,0xd2,0xeb,0x8f,0x98,0x3b,0xff,0xe4,0x60,0x39,0x6e,0x4d,0xc8,0x01,0xf7,0xac,
    0x62,0xe9,0xa6,0x8c,0x97,0xf4,0x97,0x85,0x9b,0x54,0xbe,0x30,0x8b,0xb2,0xc2,0x6d,
    0x41,0x43,0x8a,0x8f,0x1a,0xab,0x7f,0xc6,0x68,0x3d,0x63,0xd9,0x02,0xe1,0x68,0xac,
    0x63,0xfc,0x26,0x85,0x85,0x75,0xd5,0xac,0xf9,0xf8,0xe2,0xce,0x29,0xb5,0x01,0xa9,
    0x2a,0x5f,0x47,0x81,0x1f,0xb9,0xe9,0x5b,0x08,0x00,0x07,0x44,0x0f,0x99,0xa9,0x1b,
    0xd3,0xb0,0xab,0x78,0x17,0xa9,0xe8,0x5a,0x3f,0xf6,0xdc,0xce,0x07,0x89,0xa8,0x1a,
    0x19,0xc1,0x87,0x81,0x1e,0xb8,0x69,0x59,0x09,0x47,0x27,0x59,0x0e,0x98,0x29,0x19,
    0x11,0x77,0x05,0x8f,0x16,0xa8,0x68,0x58,0x41,0x4b,0x34,0x7a,0x06,0x88,0x28,0x18,
    0x72,0x17,0x6f,0xa8,0xfa,0x59,0x9e,0x8c,0x49,0xda,0x4f,0x79,0xe8,0xf0,0xff,0x8d,
    0xdd,0x16,0xfe,0x8f,0x8a,0xa1,0x39,0xaf,0x9b,0xc9,0xc1,0x54,0x19,0x60,0x3e,0x37,
    0x5b,0x79,0x73,0x7a,0x8b,0x6d,0xdc,0xa5,0x4d,0x2d,0x2d,0x49,0xe9,0x4d,0x7f,0xec,
    0x23,0x3e,0x2c,0x03,0xa3,0x9a,0x3c,0x21,0x43,0x5d,0x8d,0x84,0xc3,0x18,0xbe,0x35,
    0x94,0x38,0xad,0x8a,0x1d,0xb1,0xe1,0x53,0x2a,0x9c,0x93,0x51,0x0d,0x91,0xa1,0x13,
    0x91,0xb8,0xae,0x07,0x15,0xa1,0xe0,0x52,0x8e,0x18,0x0e,0xed,0x05,0x81,0xa0,0x12,
    0x6b,0xfd,0x2f,0x04,0x1c,0xb0,0x61,0x51,0xdc,0x4f,0x4c,0xcd,0x0c,0x90,0x21,0x11,
    0xec,0x0b,0x8e,0x80,0x14,0xa0,0x60,0x50,0x03,0x19,0x8c,0x10,0x04,0x80,0x20,0x10,
    0xa7,0x80,0x02,0x96,0x5a,0x64,0xb6,0xf8,0x4f,0x26,0xff,0xdb,0xbf,0x9a,0xb4,0xb5,
    0x4c,0xd6,0x18,0x11,0x24,0x42,0x33,0x6f,0xc4,0xd4,0x87,0xd3,0xed,0xd1,0x03,0xc9,
    0xad,0x42,0x45,0x9d,0xb8,0xf5,0x17,0xb4,0x0e,0x41,0x41,0x52,0x62,0x45,0xa7,0x50,
    0x55,0x11,0xa0,0x1a,0xcd,0xb0,0xb3,0x6d,0xd0,0x97,0x35,0xd0,0x37,0xfb,0x14,0x5e,
    0xe4,0x18,0x7b,0x98,0x1b,0x39,0xc9,0x4b,0xe4,0x1d,0x99,0x2b,0x0b,0x19,0x89,0x0b,
    0xac,0x0c,0xa2,0x93,0x13,0x29,0xc8,0x4a,0x83,0x0d,0x98,0x2a,0x03,0x09,0x88,0x0a,
    0x0d,0x32,0x25,0x84,0x1a,0x38,0x49,0x49,0x8a,0x1c,0x19,0x29,0x0a,0x18,0x09,0x09,
    0x65,0x74,0x46,0x98,0x12,0x28,0x48,0x48,0x82,0x0c,0x18,0x28,0x02,0x08,0x08,0x08,
    0x1c,0x68,0xae,0xd0,0xc6,0xa9,0x3a,0x56,0x11,0x0b,0x8d,0xde,0xa5,0x18,0xfd,0x66,
    0x32,0x78,0xf0,0x24,0xae,0xba,0x3b,0x67,0x46,0x38,0xe5,0xd5,0x91,0xe4,0x88,0x65,
    0xec,0x69,0x2e,0xd2,0x3c,0x8f,0xbc,0xba,0x13,0xe9,0x4f,0xbf,0xb2,0x32,0x25,0x07,
    0x80,0xc5,0x5c,0x47,0x84,0xd9,0x41,0xf9,0x07,0x41,0x41,0xd6,0x84,0x6f,0xf1,0x77,
    0x06,0x8b,0xa2,0x91,0x19,0x31,0xc1,0x43,0x89,0x15,0x91,0x23,0x09,0x11,0x81,0x03,
    0x06,0xfe,0xad,0x95,0x11,0x21,0xc0,0x42,0x81,0x05,0x90,0x22,0x01,0x01,0x80,0x02,
    0x6d,0xca,0x0d,0x90,0x18,0x30,0x41,0x41,0x88,0x14,0x11,0x21,0x08,0x10,0x01,0x01,
    0xd9,0xb9,0x58,0x99,0x10,0x20,0x40,0x40,0x80,0x04,0x10,0x20,0x00,0x00,0x4e,0x0e,
};
#endif // GTP_HOTKNOT

#endif // _GT1X_FIRMWARE_H_
