/* Copyright (c) 2010-2011, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */
#include <linux/gpio/gpio_def.h>

static struct gpiomux_setting gsbi12 = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting msm_audio_agc_suspend_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_OUT_LOW,
};

static struct gpiomux_setting msm_audio_agc_active_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_OUT_LOW,
};


static struct gpiomux_setting msm_headset_det_active_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting msm_headset_det_suspend_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};
#if defined (CONFIG_3_5_HEADSET_NON_OTHC)
static struct gpiomux_setting msm_headset_hook_active_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting msm_headset_hook_suspend_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_IN,
};
#endif
static struct gpiomux_setting bt_active_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};

static struct gpiomux_setting capkey_active_1_cfg = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_10MA,
	.pull = GPIOMUX_PULL_UP,
};

/*Qisda, Gavin.Gao, 20110621, camera suspend GPIO config {*/
static struct gpiomux_setting cam_suspend_1_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
    .dir = GPIOMUX_OUT_LOW,
};
/*Qisda, Gavin.Gao, 20110621, camera suspend GPIO config }*/
#ifdef CONFIG_MACH_EVT2
/*Code for EVT2*/
#elif defined (CONFIG_MACH_EVT1)
static struct gpiomux_setting nfc_en_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.dir = GPIOMUX_OUT_LOW,
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting nfc_debug_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.dir = GPIOMUX_OUT_LOW,
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting nfc_irq_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.dir = GPIOMUX_IN,
	.pull = GPIOMUX_PULL_DOWN,
};

#endif
static struct gpiomux_setting lcdc_pclk_active_cfg = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_4MA,
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting lcdc_pclk_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};

static struct gpiomux_setting lcdc_reset_active_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_OUT_LOW,
};

static struct gpiomux_setting lcdc_reset_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_OUT_LOW,
};

static struct gpiomux_setting lcdc_spi_clk_active_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_OUT_LOW,
};

static struct gpiomux_setting lcdc_spi_clk_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};


static struct gpiomux_setting lcdc_spi_csi_active_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_OUT_HIGH,
};

static struct gpiomux_setting lcdc_spi_csi_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};


static struct gpiomux_setting lcdc_spi_sdi_active_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_OUT_LOW,
};

static struct gpiomux_setting lcdc_spi_sdi_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};


static struct gpiomux_setting lcdc_spi_sdo_active_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting lcdc_spi_sdo_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};

/*ORANGE_CR#XXXXX,John Ruan,20110624,
 *configure msm8260's gpio_30,gpio_67,used by charge IC and gaugeIC.{*/
static struct gpiomux_setting charge_active_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting charge_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting gauge_active_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting gauge_suspend_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};
/*ORANGE_CR#XXXXX,John Ruan,20110624,
 *configure msm8260's gpio_30,gpio_67,used by charge IC and gaugeIC.}*/
 
/*Qisda, Snail.Qian, 20110628, modify suspend GPIO config {*/
static struct gpiomux_setting mi2s_suspend_in_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
	.dir = GPIOMUX_IN,
};


static struct gpiomux_setting mi2s_suspend_out_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_NONE,
	.dir = GPIOMUX_OUT_LOW,
};
/*Qisda, Snail.Qian, 20110628, modify suspend GPIO config }*/

#ifdef CONFIG_KEYBOARD_MSM8x60_VOL_KEY
static struct gpiomux_setting vol_key_active_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};

static struct gpiomux_setting vol_key_suspend_config = {
	.func = GPIOMUX_FUNC_GPIO,
	.pull = GPIOMUX_PULL_UP,
	.dir = GPIOMUX_IN,
};
#endif

/****************************** Platform Common Configs ******************************/
static struct msm_gpiomux_config msm8x60_common_configs_orange[] __initdata = {
	{
		.gpio      = P_PS_HOLD,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ps_hold,
		},
	},
};

static struct msm_gpiomux_config msm8x60_aux_pcm_configs_orange[] __initdata = {
	{
		.gpio = BT_PCM_DOUT,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
	{
		.gpio = BT_PCM_DIN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
	{
		.gpio = BT_PCM_SYNC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
	{
		.gpio = BT_PCM_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_sdc_configs_orange[] __initdata = {
	/* SDCC1 data[0] */
	{
		.gpio = SDC1_DATA0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[1] */
	{
		.gpio = SDC1_DATA1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[2] */
	{
		.gpio = SDC1_DATA2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[3] */
	{
		.gpio = SDC1_DATA3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[4] */
	{
		.gpio = SDC1_DATA4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[5] */
	{
		.gpio = SDC1_DATA5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[6] */
	{
		.gpio = SDC1_DATA6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[7] */
	{
		.gpio = SDC1_DATA7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 CLK */
	{
		.gpio = SDC1_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_clk_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 CMD */
	{
		.gpio = SDC1_CMD,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_snd_configs_orange[] __initdata = {
	{
		.gpio = CDC_TX_MCLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_snddev_active_config,
			[GPIOMUX_SUSPENDED] = &msm_snddev_suspend_config,
		},
	},
	{
		.gpio = CDC_RX_MCLK1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_snddev_active_config,
			[GPIOMUX_SUSPENDED] = &msm_snddev_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_lcdc_configs_orange[] __initdata = {
	/* lcdc_pclk */
	{
		.gpio = LCDC_PCLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_pclk_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_pclk_suspend_cfg,
		},
	},
	/* lcdc_hsync */
	{
		.gpio = LCDC_HSYNC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_vsync */
	{
		.gpio = LCDC_VSYNC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_den */
	{
		.gpio = LCDC_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red7 */
	{
		.gpio = LCDC_RED_7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red6 */
	{
		.gpio = LCDC_RED_6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red5 */
	{
		.gpio = LCDC_RED_5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red4 */
	{
		.gpio = LCDC_RED_4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red3 */
	{
		.gpio = LCDC_RED_3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red2 */
	{
		.gpio = LCDC_RED_2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red1 */
	{
		.gpio = LCDC_RED_1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red0 */
	{
		.gpio = LCDC_RED_0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn7 */
	{
		.gpio = LCDC_GRN_7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn6 */
	{
		.gpio = LCDC_GRN_6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn5 */
	{
		.gpio = LCDC_GRN_5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn4 */
	{
		.gpio = LCDC_GRN_4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn3 */
	{
		.gpio = LCDC_GRN_3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn2 */
	{
		.gpio = LCDC_GRN_2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn1 */
	{
		.gpio = LCDC_GRN_1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn0 */
	{
		.gpio = LCDC_GRN_0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu7 */
	{
		.gpio = LCDC_BLUE_7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu6 */
	{
		.gpio = LCDC_BLUE_6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu5 */
	{
		.gpio = LCDC_BLUE_5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu4 */
	{
		.gpio = LCDC_BLUE_4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu3 */
	{
		.gpio = LCDC_BLUE_3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu2 */
	{
		.gpio = LCDC_BLUE_2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu1 */
	{
		.gpio = LCDC_BLUE_1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu0 */
	{
		.gpio = LCDC_BLUE_0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	{
		.gpio      = LCDC_SPI_SDO,
		.settings = {
			[GPIOMUX_ACTIVE] = &lcdc_spi_sdo_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_spi_sdo_suspend_cfg,
		},
	},
	{
		.gpio      = LCDC_SPI_SDI,
		.settings = {
			[GPIOMUX_ACTIVE] = &lcdc_spi_sdi_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_spi_sdi_suspend_cfg,
		},
	},
	{
		.gpio      = LCDC_SPI_CSI,
		.settings = {
			[GPIOMUX_ACTIVE] = &lcdc_spi_csi_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_spi_csi_suspend_cfg,
		},
	},
	{
		.gpio      = LCDC_SPI_CLK,
		.settings = {
			[GPIOMUX_ACTIVE] = &lcdc_spi_clk_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_spi_clk_suspend_cfg,
		},
	},
	{
		.gpio      = LCD_RESET_N,
		.settings = {
			[GPIOMUX_ACTIVE] = &lcdc_reset_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_reset_suspend_cfg,
		},
	},
};

/* Because PMIC drivers do not use gpio-management routines and PMIC
 * gpios must never sleep, a "good enough" config is obtained by placing
 * the active config in the 'suspended' slot and leaving the active
 * config invalid: the suspended config will be installed at boot
 * and never replaced.
 */

static struct msm_gpiomux_config msm8x60_pmic_configs_orange[] __initdata = {
	{
		.gpio = PM8058_GPIO_INT,
		.settings = {
			[GPIOMUX_SUSPENDED] = &pmic_suspended_cfg,
		},
	},
	{
		.gpio = PM8901_GPIO_INT,
		.settings = {
			[GPIOMUX_SUSPENDED] = &pmic_suspended_cfg,
		},
	},
};

 /* Snail Qian 2011/06/28, gpio for mi2s {*/
static struct msm_gpiomux_config msm8x60_mi2s_configs_orange[] __initdata = {
	/* MI2S WS */
	{
		.gpio = FM_I2S_WS,
		.settings = {
			[GPIOMUX_ACTIVE]    = &mi2s_active_cfg,
			[GPIOMUX_SUSPENDED] = &mi2s_suspend_out_cfg,
		},
	},
	/* MI2S SCLK */
	{
		.gpio = FM_I2S_SCK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &mi2s_active_cfg,
			[GPIOMUX_SUSPENDED] = &mi2s_suspend_out_cfg,
		},
	},
	/* MI2S IN */
	{
		.gpio = FM_I2S_DO,
		.settings = {
			[GPIOMUX_ACTIVE]    = &mi2s_active_cfg,
			[GPIOMUX_SUSPENDED] = &mi2s_suspend_in_cfg,
		},
	},
	/* MI2S OUT */
	{
		.gpio = FM_I2S_DI,
		.settings = {
			[GPIOMUX_ACTIVE]    = &mi2s_active_cfg,
			[GPIOMUX_SUSPENDED] = &mi2s_suspend_out_cfg,
		},
	},
};
/* Snail Qian 2011/06/28, gpio for mi2s }*/

/****************************** EVT2 ******************************/
#if defined(CONFIG_MACH_EVT2)
static struct msm_gpiomux_config msm8x60_gsbi_configs_orange[] __initdata = {
	{
		.gpio      = TOUCH_I2C_DATA,
		.settings = {
			[GPIOMUX_ACTIVE]    = &capkey_active_1_cfg,
			[GPIOMUX_SUSPENDED] = &gsbi3,
		},
	},
	{
		.gpio      = TOUCH_I2C_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &capkey_active_1_cfg,
			[GPIOMUX_SUSPENDED] = &gsbi3,
		},
	},
	{
		.gpio      = CAMIF_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi4,
		},
	},
	{
		.gpio      = CAMIF_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi4,
		},
	},
	{
		.gpio      = FM_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi7,
		},
	},
	{
		.gpio      = FM_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi7,
		},
	},
	{
		.gpio      = CORE_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi8,
		},
	},
	{
		.gpio      = CORE_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi8,
		},
	},
	{
		.gpio      = SENSOR_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi12,
		},
	},
	{
		.gpio      = SENSOR_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi12,
		},
	},
};

static struct msm_gpiomux_config msm8x60_uart_configs_orange[] __initdata = {
	{ /* UARTDM_TX */
		.gpio      = BT_TX,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_RX */
		.gpio      = BT_RX,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_CTS */
		.gpio      = BT_CTS,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_RFR */
		.gpio      = BT_RFR,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{
		.gpio      = UART_RX,
		.settings = {
			[GPIOMUX_SUSPENDED] = &console_uart,
		},
	},
	{
		.gpio      = UART_TX,
		.settings = {
			[GPIOMUX_SUSPENDED] = &console_uart,
		},
	},
};

static struct msm_gpiomux_config msm8x60_audio_configs_orange[] __initdata = {
	{
		.gpio = AUDIO_AMP_AGC1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_audio_agc_active_config,
			[GPIOMUX_SUSPENDED] = &msm_audio_agc_suspend_config,
		},
	},
	{
		.gpio = AUDIO_AMP_AGC2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_audio_agc_active_config,
			[GPIOMUX_SUSPENDED] = &msm_audio_agc_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_headset_configs_orange[] __initdata = {
	{
		.gpio = HEADSET_DET_N,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_headset_det_active_config,
			[GPIOMUX_SUSPENDED] = &msm_headset_det_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_hdmi_configs_orange[] __initdata = {
	{
		.gpio = HDMI_CEC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_1_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
	{
		.gpio = HDMI_DDC_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
	{
		.gpio = HDMI_DDC_DATA,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
	{
		.gpio = HDMI_HPD,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
};

static struct msm_gpiomux_config msm8x60_cam_configs_orange[] __initdata = {
/*Qisda, Gavin.Gao, 20110621, camera suspend GPIO config {*/
	{
		.gpio = CLK_CAMIF_MCLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_5_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_1_cfg,
		},
	},
	{
		.gpio = MP_CAM_RESET_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &cam_suspend_1_cfg,
		},
	},
	{
		.gpio = MP_CAM_PWDN_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &cam_suspend_1_cfg,
		},
	},
	{
		.gpio = VGA_CAM_RESET_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &cam_suspend_1_cfg,
		},
	},
	{
		.gpio = VGA_CAM_PWDN,
		.settings = {
			[GPIOMUX_SUSPENDED] = &cam_suspend_1_cfg,
		},
	},
	{
		.gpio = CAMIF_I2C_DATA,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
	{
		.gpio = CAMIF_I2C_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
/*Qisda, Gavin.Gao, 20110621, camera suspend GPIO config }*/
};

static struct msm_gpiomux_config msm8x60_bt_configs_orange[] __initdata = {
	/* BT_EN */
	{
		.gpio = BT_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_RST_N */
	{
		.gpio = BT_RST_N,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_WAKEUP */
	{
		.gpio = BT_WAKEUP,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_INT */
	{
		.gpio = BT_INT,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
};

/* GORAB1A_CR #xxxxx, Jey Zhou, 20110622, optimize wifi gpio config. {*/
static struct msm_gpiomux_config msm8x60_wifi_configs_orange[] __initdata = {
	{
		.gpio = WLAN_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wifi_en_active_cfg,
			[GPIOMUX_SUSPENDED] = &wifi_en_suspend_cfg,
		},
	},
	{
		.gpio = WLAN_IRQ,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wifi_irq_active_cfg,
			[GPIOMUX_SUSPENDED] = &wifi_irq_suspend_cfg,
		},
	},
};
/* GORAB1A_CR #xxxxx, Jey Zhou, 20110622, optimize wifi gpio config. }*/

/*ORANGE_CR#XXXXX,John Ruan,20110624,
 *configure msm8260's gpio_30,gpio_67,used by charge IC and gaugeIC.{*/
static struct msm_gpiomux_config msm8x60_charge_configs_orange[] __initdata = {
	{
		.gpio = BATT_LOW,
		.settings = {
			[GPIOMUX_ACTIVE]    = &gauge_active_cfg,
			[GPIOMUX_SUSPENDED] = &gauge_suspend_cfg,
		},
	},
	{
		.gpio = CHG_STAT,
		.settings = {
			[GPIOMUX_ACTIVE]    = &charge_active_cfg,
			[GPIOMUX_SUSPENDED] = &charge_suspend_cfg,
		},
	},

};
/*ORANGE_CR#XXXXX,John Ruan,20110624,
 *configure msm8260's gpio_30,gpio_67,used by charge IC and gaugeIC.}*/

#ifdef CONFIG_KEYBOARD_MSM8x60_VOL_KEY
static struct msm_gpiomux_config msm8x60_vol_key_configs_orange[] __initdata = {
	/* Vol_up */
	{
		.gpio = KEY_VOLUME_UP,
		.settings = {
			[GPIOMUX_ACTIVE]    = &vol_key_active_config,
			[GPIOMUX_SUSPENDED] = &vol_key_suspend_config,
		},
	},
	/* Vol_down */
	{
		.gpio = KEY_VOLUME_DOWN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &vol_key_active_config,
			[GPIOMUX_SUSPENDED] = &vol_key_suspend_config,
		},
	}
};
#endif

/****************************** EVT1 ******************************/
#elif defined(CONFIG_MACH_EVT1)
static struct msm_gpiomux_config msm8x60_gsbi_configs_orange[] __initdata = {
	{
		.gpio      = TOUCH_I2C_DATA,
		.settings = {
			[GPIOMUX_ACTIVE]    = &capkey_active_1_cfg,
			[GPIOMUX_SUSPENDED] = &gsbi3,
		},
	},
	{
		.gpio      = TOUCH_I2C_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &capkey_active_1_cfg,
			[GPIOMUX_SUSPENDED] = &gsbi3,
		},
	},
	{
		.gpio      = CAMIF_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi4,
		},
	},
	{
		.gpio      = CAMIF_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi4,
		},
	},
	{
		.gpio      = FM_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi7,
		},
	},
	{
		.gpio      = FM_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi7,
		},
	},
	{
		.gpio      = CORE_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi8,
		},
	},
	{
		.gpio      = CORE_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi8,
		},
	},
	{
		.gpio      = SENSOR_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi12,
		},
	},
	{
		.gpio      = SENSOR_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi12,
		},
	},
};

static struct msm_gpiomux_config msm8x60_uart_configs_orange[] __initdata = {
	{ /* UARTDM_TX */
		.gpio      = BT_TX,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_RX */
		.gpio      = BT_RX,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_CTS */
		.gpio      = BT_CTS,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_RFR */
		.gpio      = BT_RFR,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{
		.gpio      = UART_RX,
		.settings = {
			[GPIOMUX_SUSPENDED] = &console_uart,
		},
	},
	{
		.gpio      = UART_TX,
		.settings = {
			[GPIOMUX_SUSPENDED] = &console_uart,
		},
	},
};

static struct msm_gpiomux_config msm8x60_audio_configs_orange[] __initdata = {
	{
		.gpio = AUDIO_AMP_AGC1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_audio_agc1_active_config,
			[GPIOMUX_SUSPENDED] = &msm_audio_agc1_suspend_config,
		},
	},
	{
		.gpio = AUDIO_AMP_AGC2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_audio_agc2_active_config,
			[GPIOMUX_SUSPENDED] = &msm_audio_agc2_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_headset_configs_orange[] __initdata = {
	{
		.gpio = HEADSET_DET_N,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_headset_det_active_config,
			[GPIOMUX_SUSPENDED] = &msm_headset_det_suspend_config,
		},
	},
	{
		.gpio = HS_BUTT,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_headset_hook_active_config,
			[GPIOMUX_SUSPENDED] = &msm_headset_hook_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_hdmi_configs_orange[] __initdata = {
	{
		.gpio = HDMI_CEC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_1_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
	{
		.gpio = HDMI_DDC_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
	{
		.gpio = HDMI_DDC_DATA,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
	{
		.gpio = HDMI_HPD,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
};

static struct msm_gpiomux_config msm8x60_cam_configs_orange[] __initdata = {
/*Qisda, Gavin.Gao, 20110621, camera suspend GPIO config {*/
	{
		.gpio = FL_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_1_cfg,
		},
	},
	{
		.gpio = CLK_CAMIF_MCLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_5_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_1_cfg,
		},
	},
	{
		.gpio = MP_CAM_RESET_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &cam_suspend_1_cfg,
		},
	},
	{
		.gpio = MP_CAM_PWDN_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &cam_suspend_1_cfg,
		},
	},
	{
		.gpio = VGA_CAM_RESET_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &cam_suspend_1_cfg,
		},
	},
	{
		.gpio = VGA_CAM_PWDN,
		.settings = {
			[GPIOMUX_SUSPENDED] = &cam_suspend_1_cfg,
		},
	},
	{
		.gpio = CAMIF_I2C_DATA,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
	{
		.gpio = CAMIF_I2C_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
/*Qisda, Gavin.Gao, 20110621, camera suspend GPIO config }*/
};

static struct msm_gpiomux_config msm8x60_bt_configs_orange[] __initdata = {
	/* BT_EN */
	{
		.gpio = BT_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_RST_N */
	{
		.gpio = BT_RST_N,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_WAKEUP */
	{
		.gpio = BT_WAKEUP,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_INT */
	{
		.gpio = BT_INT,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
};

static struct msm_gpiomux_config msm8x60_nfc_configs_orange[] __initdata = {
	/* NFC_EN */
	{
		.gpio = NFC_INTLDO_EN,
		.settings = {

			[GPIOMUX_SUSPENDED] = &nfc_en_suspend_cfg,
		},
	},
	/* NFC_IRQ */
	{
		.gpio = NFC_IRQ,
		.settings = {
			[GPIOMUX_SUSPENDED]    = &nfc_irq_suspend_cfg,
		},
	},
	/* NFC_DEBUG */
	{
		.gpio = NFC_DEBUG,
		.settings = {
			[GPIOMUX_SUSPENDED]    = &nfc_debug_suspend_cfg,
		},
	},


};

/* GORAB1A_CR #xxxxx, Jey Zhou, 20110622, optimize wifi gpio config. {*/
static struct msm_gpiomux_config msm8x60_wifi_configs_orange[] __initdata = {
	{
		.gpio = WLAN_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wifi_en_active_cfg,
			[GPIOMUX_SUSPENDED] = &wifi_en_suspend_cfg,
		},
	},
	{
		.gpio = WLAN_IRQ,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wifi_irq_active_cfg,
			[GPIOMUX_SUSPENDED] = &wifi_irq_suspend_cfg,
		},
	},
};
/* GORAB1A_CR #xxxxx, Jey Zhou, 20110622, optimize wifi gpio config. }*/

/*ORANGE_CR#XXXXX,John Ruan,20110624,
 *configure msm8260's gpio_30,gpio_67,used by charge IC and gaugeIC.{*/
static struct msm_gpiomux_config msm8x60_charge_configs_orange[] __initdata = {
	{
		.gpio = BATT_LOW,
		.settings = {
			[GPIOMUX_ACTIVE]    = &gauge_active_cfg,
			[GPIOMUX_SUSPENDED] = &gauge_suspend_cfg,
		},
	},
	{
		.gpio = CHG_STAT,
		.settings = {
			[GPIOMUX_ACTIVE]    = &charge_active_cfg,
			[GPIOMUX_SUSPENDED] = &charge_suspend_cfg,
		},
	},

};
/*ORANGE_CR#XXXXX,John Ruan,20110624,
 *configure msm8260's gpio_30,gpio_67,used by charge IC and gaugeIC.}*/
#endif

struct msm_gpiomux_configs
msm8x60_qis_common_gpiomux_cfgs[] __initdata = {
	{msm8x60_gsbi_configs_orange, ARRAY_SIZE(msm8x60_gsbi_configs_orange)},
	{msm8x60_uart_configs_orange, ARRAY_SIZE(msm8x60_uart_configs_orange)},
	{msm8x60_aux_pcm_configs_orange, ARRAY_SIZE(msm8x60_aux_pcm_configs_orange)},
	{msm8x60_sdc_configs_orange, ARRAY_SIZE(msm8x60_sdc_configs_orange)},
	{msm8x60_snd_configs_orange, ARRAY_SIZE(msm8x60_snd_configs_orange)},
	{msm8x60_audio_configs_orange, ARRAY_SIZE(msm8x60_audio_configs_orange)},
	{msm8x60_headset_configs_orange, ARRAY_SIZE(msm8x60_headset_configs_orange)},
	{msm8x60_lcdc_configs_orange, ARRAY_SIZE(msm8x60_lcdc_configs_orange)},
	{msm8x60_hdmi_configs_orange, ARRAY_SIZE(msm8x60_hdmi_configs_orange)},
	{msm8x60_common_configs_orange, ARRAY_SIZE(msm8x60_common_configs_orange)},
	{msm8x60_pmic_configs_orange, ARRAY_SIZE(msm8x60_pmic_configs_orange)},
	{msm8x60_cam_configs_orange, ARRAY_SIZE(msm8x60_cam_configs_orange)},
	{msm8x60_bt_configs_orange, ARRAY_SIZE(msm8x60_bt_configs_orange)},
#ifdef CONFIG_NFC_NXP_PN544
#ifdef CONFIG_MACH_EVT2
/*Code for EVT2*/
#elif defined (CONFIG_MACH_EVT1)
	{msm8x60_nfc_configs_orange, ARRAY_SIZE(msm8x60_nfc_configs_orange)},
#endif
#endif
	{msm8x60_wifi_configs_orange, ARRAY_SIZE(msm8x60_wifi_configs_orange)},
	{msm8x60_charge_configs_orange, ARRAY_SIZE(msm8x60_charge_configs_orange)},
	/* Snail Qian 2011/06/28, gpio for mi2s {*/
	{msm8x60_mi2s_configs_orange, ARRAY_SIZE(msm8x60_mi2s_configs_orange)},
	/* Snail Qian 2011/06/28, gpio for mi2s }*/
#ifdef CONFIG_KEYBOARD_MSM8x60_VOL_KEY
	{msm8x60_vol_key_configs_orange, ARRAY_SIZE(msm8x60_vol_key_configs_orange)},
#endif
	{NULL, 0},
};
