/* Copyright (c) 2010-2011, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */
#include <linux/gpio/gpio_def.h>

#if defined(CONFIG_MACH_EVB2)
static struct gpiomux_setting lcdc_active_cfg_lp101wx1 = {
	.func = GPIOMUX_FUNC_1,
	.drv = GPIOMUX_DRV_2MA,	
	.pull = GPIOMUX_PULL_NONE,
};

static struct gpiomux_setting ebi2_cs0 = {
	.func = GPIOMUX_FUNC_2,
	.drv = GPIOMUX_DRV_8MA,
	.pull = GPIOMUX_PULL_UP,
};

static struct gpiomux_setting bt_active_cfg = {
	.func = GPIOMUX_FUNC_GPIO,
	.drv = GPIOMUX_DRV_2MA,
	.pull = GPIOMUX_PULL_DOWN,
};
#endif

/****************************** EVB2 ******************************/
#if defined(CONFIG_MACH_EVB2)
static struct msm_gpiomux_config msm8x60_gsbi_configs_song[] __initdata = {
	{
		.gpio      = TOUCH_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi3,
		},
	},
	{
		.gpio      = TOUCH_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi3,
		},
	},
	{
		.gpio      = CAMIF_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi4,
		},
	},
	{
		.gpio      = CAMIF_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi4,
		},
	},
	{
		.gpio      = FM_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi7,
		},
	},
	{
		.gpio      = FM_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi7,
		},
	},
	{
		.gpio      = CORE_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi8,
		},
	},
	{
		.gpio      = CORE_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi8,
		},
	},
};

static struct msm_gpiomux_config msm8x60_common_configs_song[] __initdata = {
	{
		.gpio      = P_PS_HOLD,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ps_hold,
		},
	},
};

static struct msm_gpiomux_config msm8x60_ebi2_configs_song[] __initdata = {
	{
		.gpio      = EBI2_A6,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A5,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A4,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A3,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A2,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A1,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A0,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_CS0_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_cs0,
		},
	},
	{
		.gpio      = EBI2_D15,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D14,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D13,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D12,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D11,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D10,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D9,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D8,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D7,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D6,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D5,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D4,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D3,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D2,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D1,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D0,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_OE_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_oe,
		},
	},
	{
		.gpio      = EBI2_WE_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_we,
		},
	},
};

static struct msm_gpiomux_config msm8x60_uart_configs_song[] __initdata = {
	{ /* UARTDM_TX */
		.gpio      = BT_TX,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_RX */
		.gpio      = BT_RX,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_CTS */
		.gpio      = BT_CTS,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_RFR */
		.gpio      = BT_RFR,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{
		.gpio      = UART_RX,
		.settings = {
			[GPIOMUX_SUSPENDED] = &console_uart,
		},
	},
	{
		.gpio      = UART_TX,
		.settings = {
			[GPIOMUX_SUSPENDED] = &console_uart,
		},
	},
};

static struct msm_gpiomux_config msm8x60_ts_configs_song[] __initdata = {
};

static struct msm_gpiomux_config msm8x60_aux_pcm_configs_song[] __initdata = {
	{
		.gpio = BT_PCM_DOUT,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
	{
		.gpio = BT_PCM_DIN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
	{
		.gpio = BT_PCM_SYNC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
	{
		.gpio = BT_PCM_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_sdc_configs_song[] __initdata = {
	/* SDCC1 data[0] */
	{
		.gpio = SDC1_DATA0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[1] */
	{
		.gpio = SDC1_DATA1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[2] */
	{
		.gpio = SDC1_DATA2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[3] */
	{
		.gpio = SDC1_DATA3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[4] */
	{
		.gpio = SDC1_DATA4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[5] */
	{
		.gpio = SDC1_DATA5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[6] */
	{
		.gpio = SDC1_DATA6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[7] */
	{
		.gpio = SDC1_DATA7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 CLK */
	{
		.gpio = SDC1_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_clk_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 CMD */
	{
		.gpio = SDC1_CMD,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_snd_configs_song[] __initdata = {
	{
		.gpio = CDC_TX_MCLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_snddev_active_config,
			[GPIOMUX_SUSPENDED] = &msm_snddev_suspend_config,
		},
	},
	{
		.gpio = CDC_RX_MCLK1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_snddev_active_config,
			[GPIOMUX_SUSPENDED] = &msm_snddev_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_audio_configs_song[] __initdata = {
};

static struct msm_gpiomux_config msm8x60_mi2s_configs_song[] __initdata = {
	/* MI2S WS */
	{
		.gpio = FM_I2S_WS,
		.settings = {
			[GPIOMUX_ACTIVE]    = &mi2s_active_cfg,
			[GPIOMUX_SUSPENDED] = &mi2s_suspend_cfg,
		},
	},
	/* MI2S SCLK */
	{
		.gpio = FM_I2S_SCK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &mi2s_active_cfg,
			[GPIOMUX_SUSPENDED] = &mi2s_suspend_cfg,
		},
	},
	/* MI2S SD3 */
	{
		.gpio = FM_I2S_DO,
		.settings = {
			[GPIOMUX_ACTIVE]    = &mi2s_active_cfg,
			[GPIOMUX_SUSPENDED] = &mi2s_suspend_cfg,
		},
	},
};

static struct msm_gpiomux_config msm8x60_lcdc_configs_song[] __initdata = {
	/* lcdc_pclk */
	{
		.gpio = LCDC_PCLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_hsync */
	{
		.gpio = LCDC_HSYNC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_vsync */
	{
		.gpio = LCDC_VSYNC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_den */
	{
		.gpio = LCDC_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red7 */
	{
		.gpio = LCDC_RED_7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red6 */
	{
		.gpio = LCDC_RED_6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red5 */
	{
		.gpio = LCDC_RED_5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red4 */
	{
		.gpio = LCDC_RED_4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red3 */
	{
		.gpio = LCDC_RED_3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red2 */
	{
		.gpio = LCDC_RED_2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red1 */
	{
		.gpio = LCDC_RED_1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red0 */
	{
		.gpio = LCDC_RED_0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn7 */
	{
		.gpio = LCDC_GRN_7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn6 */
	{
		.gpio = LCDC_GRN_6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn5 */
	{
		.gpio = LCDC_GRN_5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn4 */
	{
		.gpio = LCDC_GRN_4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn3 */
	{
		.gpio = LCDC_GRN_3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn2 */
	{
		.gpio = LCDC_GRN_2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn1 */
	{
		.gpio = LCDC_GRN_1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn0 */
	{
		.gpio = LCDC_GRN_0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu7 */
	{
		.gpio = LCDC_BLUE_7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu6 */
	{
		.gpio = LCDC_BLUE_6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu5 */
	{
		.gpio = LCDC_BLUE_5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu4 */
	{
		.gpio = LCDC_BLUE_4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu3 */
	{
		.gpio = LCDC_BLUE_3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu2 */
	{
		.gpio = LCDC_BLUE_2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu1 */
	{
		.gpio = LCDC_BLUE_1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu0 */
	{
		.gpio = LCDC_BLUE_0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg_lp101wx1,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
};

static struct msm_gpiomux_config msm8x60_hdmi_configs_song[] __initdata = {
	{
		.gpio = HDMI_CEC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_1_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
	{
		.gpio = HDMI_DDC_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
	{
		.gpio = HDMI_DDC_DATA,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
	{
		.gpio = HDMI_HPD,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
};

/* Because PMIC drivers do not use gpio-management routines and PMIC
 * gpios must never sleep, a "good enough" config is obtained by placing
 * the active config in the 'suspended' slot and leaving the active
 * config invalid: the suspended config will be installed at boot
 * and never replaced.
 */

static struct msm_gpiomux_config msm8x60_pmic_configs_song[] __initdata = {
	{
		.gpio = PM8058_GPIO_INT,
		.settings = {
			[GPIOMUX_SUSPENDED] = &pmic_suspended_cfg,
		},
	},
	{
		.gpio = PM8901_GPIO_INT,
		.settings = {
			[GPIOMUX_SUSPENDED] = &pmic_suspended_cfg,
		},
	},
};

static struct msm_gpiomux_config msm8x60_cam_configs_song[] __initdata = {
	{
		.gpio = FL_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
	{
		.gpio = CLK_CAMIF_MCLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_5_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
	{
		.gpio = CAMIF_I2C_DATA,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
	{
		.gpio = CAMIF_I2C_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
};

static struct msm_gpiomux_config msm8x60_bt_configs_song[] __initdata = {
	/* BT_EN */
	{
		.gpio = BT_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_RST_N */
	{
		.gpio = BT_RST_N,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_WAKEUP */
	{
		.gpio = BT_WAKEUP,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_INT */
	{
		.gpio = BT_INT,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
};

/* GORAB1A_CR #xxxxx, Jey Zhou, 20110622, optimize wifi gpio config. {*/
static struct msm_gpiomux_config msm8x60_wifi_configs_song[] __initdata = {
	{
		.gpio = WLAN_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wifi_en_active_cfg,
			[GPIOMUX_SUSPENDED] = &wifi_en_suspend_cfg,
		},
	},
	{
		.gpio = WLAN_IRQ,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wifi_irq_active_cfg,
			[GPIOMUX_SUSPENDED] = &wifi_irq_suspend_cfg,
		},
	},
};
/* GORAB1A_CR #xxxxx, Jey Zhou, 20110622, optimize wifi gpio config. }*/

/****************************** EVB1 ******************************/
#elif defined(CONFIG_MACH_EVB1)
static struct msm_gpiomux_config msm8x60_gsbi_configs_song[] __initdata = {
	{
		.gpio      = LCDC_SPI_SDO,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi1,
		},
	},
	{
		.gpio      = LCDC_SPI_SDI,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi1,
		},
	},
	{
		.gpio      = LCDC_SPI_CS,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi1,
		},
	},
	{
		.gpio      = LCDC_SPI_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi1,
		},
	},
	{
		.gpio      = CAMIF_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi4,
		},
	},
	{
		.gpio      = CAMIF_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi4,
		},
	},
	{
		.gpio      = FM_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi7,
		},
	},
	{
		.gpio      = FM_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi7,
		},
	},
	{
		.gpio      = CORE_I2C_DATA,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi8,
		},
	},
	{
		.gpio      = CORE_I2C_CLK,
		.settings = {
			[GPIOMUX_SUSPENDED] = &gsbi8,
		},
	},
};

static struct msm_gpiomux_config msm8x60_common_configs_song[] __initdata = {
	{
		.gpio      = P_PS_HOLD,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ps_hold,
		},
	},
};

static struct msm_gpiomux_config msm8x60_ebi2_configs_song[] __initdata = {
	{
		.gpio      = EBI2_A6,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A5,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A4,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A3,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A2,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A1,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_A0,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_CS0_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_cs0,
		},
	},
	{
		.gpio      = EBI2_D15,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D14,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D13,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D12,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D11,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D10,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D9,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D8,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D7,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D6,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D5,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D4,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D3,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D2,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D1,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_D0,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_a_d,
		},
	},
	{
		.gpio      = EBI2_OE_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_oe,
		},
	},
	{
		.gpio      = EBI2_WE_N,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ebi2_we,
		},
	},
};

static struct msm_gpiomux_config msm8x60_uart_configs_song[] __initdata = {
	{ /* UARTDM_TX */
		.gpio      = BT_TX,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_RX */
		.gpio      = BT_RX,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_CTS */
		.gpio      = BT_CTS,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{ /* UARTDM_RFR */
		.gpio      = BT_RFR,
		.settings = {
			[GPIOMUX_ACTIVE]    = &uart1dm_active,
			[GPIOMUX_SUSPENDED] = &uart1dm_suspended,
		},
	},
	{
		.gpio      = UART_RX,
		.settings = {
			[GPIOMUX_SUSPENDED] = &console_uart,
		},
	},
	{
		.gpio      = UART_TX,
		.settings = {
			[GPIOMUX_SUSPENDED] = &console_uart,
		},
	},
};

static struct msm_gpiomux_config msm8x60_ts_configs_song[] __initdata = {
	{
		.gpio = TP_INT,
		.settings = {
			[GPIOMUX_SUSPENDED] = &ts_suspended,
		},
	},
};

static struct msm_gpiomux_config msm8x60_aux_pcm_configs_song[] __initdata = {
	{
		.gpio = BT_PCM_DOUT,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
	{
		.gpio = BT_PCM_DIN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
	{
		.gpio = BT_PCM_SYNC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
	{
		.gpio = BT_PCM_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &aux_pcm_active_config,
			[GPIOMUX_SUSPENDED] = &aux_pcm_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_sdc_configs_song[] __initdata = {
	/* SDCC1 data[0] */
	{
		.gpio = SDC1_DATA0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[1] */
	{
		.gpio = SDC1_DATA1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[2] */
	{
		.gpio = SDC1_DATA2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[3] */
	{
		.gpio = SDC1_DATA3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[4] */
	{
		.gpio = SDC1_DATA4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[5] */
	{
		.gpio = SDC1_DATA5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[6] */
	{
		.gpio = SDC1_DATA6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 data[7] */
	{
		.gpio = SDC1_DATA7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_4_7_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 CLK */
	{
		.gpio = SDC1_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_clk_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
	/* SDCC1 CMD */
	{
		.gpio = SDC1_CMD,
		.settings = {
			[GPIOMUX_ACTIVE]    = &sdcc1_dat_0_3_cmd_actv_cfg,
			[GPIOMUX_SUSPENDED] = &sdcc1_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_snd_configs_song[] __initdata = {
	{
		.gpio = CDC_TX_MCLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_snddev_active_config,
			[GPIOMUX_SUSPENDED] = &msm_snddev_suspend_config,
		},
	},
	{
		.gpio = CDC_RX_MCLK1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &msm_snddev_active_config,
			[GPIOMUX_SUSPENDED] = &msm_snddev_suspend_config,
		},
	},
};

static struct msm_gpiomux_config msm8x60_audio_configs_song[] __initdata = {
};

static struct msm_gpiomux_config msm8x60_mi2s_configs_song[] __initdata = {
	/* MI2S WS */
	{
		.gpio = FM_I2S_WS,
		.settings = {
			[GPIOMUX_ACTIVE]    = &mi2s_active_cfg,
			[GPIOMUX_SUSPENDED] = &mi2s_suspend_cfg,
		},
	},
	/* MI2S SCLK */
	{
		.gpio = FM_I2S_SCK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &mi2s_active_cfg,
			[GPIOMUX_SUSPENDED] = &mi2s_suspend_cfg,
		},
	},
	/* MI2S SD3 */
	{
		.gpio = FM_I2S_DO,
		.settings = {
			[GPIOMUX_ACTIVE]    = &mi2s_active_cfg,
			[GPIOMUX_SUSPENDED] = &mi2s_suspend_cfg,
		},
	},
};

static struct msm_gpiomux_config msm8x60_lcdc_configs_song[] __initdata = {
	/* lcdc_pclk */
	{
		.gpio = LCDC_PCLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_hsync */
	{
		.gpio = LCDC_HSYNC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_vsync */
	{
		.gpio = LCDC_VSYNC,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_den */
	{
		.gpio = LCDC_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red7 */
	{
		.gpio = LCDC_RED_7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red6 */
	{
		.gpio = LCDC_RED_6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red5 */
	{
		.gpio = LCDC_RED_5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red4 */
	{
		.gpio = LCDC_RED_4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red3 */
	{
		.gpio = LCDC_RED_3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red2 */
	{
		.gpio = LCDC_RED_2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red1 */
	{
		.gpio = LCDC_RED_1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_red0 */
	{
		.gpio = LCDC_RED_0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn7 */
	{
		.gpio = LCDC_GRN_7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn6 */
	{
		.gpio = LCDC_GRN_6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn5 */
	{
		.gpio = LCDC_GRN_5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn4 */
	{
		.gpio = LCDC_GRN_4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn3 */
	{
		.gpio = LCDC_GRN_3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn2 */
	{
		.gpio = LCDC_GRN_2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn1 */
	{
		.gpio = LCDC_GRN_1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_grn0 */
	{
		.gpio = LCDC_GRN_0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu7 */
	{
		.gpio = LCDC_BLUE_7,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu6 */
	{
		.gpio = LCDC_BLUE_6,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu5 */
	{
		.gpio = LCDC_BLUE_5,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu4 */
	{
		.gpio = LCDC_BLUE_4,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu3 */
	{
		.gpio = LCDC_BLUE_3,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu2 */
	{
		.gpio = LCDC_BLUE_2,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu1 */
	{
		.gpio = LCDC_BLUE_1,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
	/* lcdc_blu0 */
	{
		.gpio = LCDC_BLUE_0,
		.settings = {
			[GPIOMUX_ACTIVE]    = &lcdc_active_cfg,
			[GPIOMUX_SUSPENDED] = &lcdc_suspend_cfg,
		},
	},
};

static struct msm_gpiomux_config msm8x60_hdmi_configs_song[] __initdata = {
	{
		.gpio = HDMI_DDC_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
	{
		.gpio = HDMI_DDC_DATA,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
	{
		.gpio = HDMI_HPD,
		.settings = {
			[GPIOMUX_ACTIVE]    = &hdmi_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &hdmi_suspend_cfg,
		},
	},
};

/* Because PMIC drivers do not use gpio-management routines and PMIC
 * gpios must never sleep, a "good enough" config is obtained by placing
 * the active config in the 'suspended' slot and leaving the active
 * config invalid: the suspended config will be installed at boot
 * and never replaced.
 */

static struct msm_gpiomux_config msm8x60_pmic_configs_song[] __initdata = {
	{
		.gpio = PM8058_GPIO_INT,
		.settings = {
			[GPIOMUX_SUSPENDED] = &pmic_suspended_cfg,
		},
	},
	{
		.gpio = PM8901_GPIO_INT,
		.settings = {
			[GPIOMUX_SUSPENDED] = &pmic_suspended_cfg,
		},
	},
};

static struct msm_gpiomux_config msm8x60_cam_configs_song[] __initdata = {
	{
		.gpio = FL_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
	{
		.gpio = CLK_CAMIF_MCLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_1_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
	{
		.gpio = CAMIF_I2C_DATA,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
	{
		.gpio = CAMIF_I2C_CLK,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_3_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
	{
		.gpio = MP_CAM_PWDN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &cam_active_2_cfg,
			[GPIOMUX_SUSPENDED] = &cam_suspend_cfg,
		},
	},
};

static struct msm_gpiomux_config msm8x60_bt_configs_song[] __initdata = {
	/* BT_EN */
	{
		.gpio = BT_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_RST_N */
	{
		.gpio = BT_RST_N,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_WAKEUP */
	{
		.gpio = BT_WAKEUP,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
	/* BT_INT */
	{
		.gpio = BT_INT,
		.settings = {
			[GPIOMUX_ACTIVE]    = &bt_active_cfg,
		},
	},
};

/* GORAB1A_CR #xxxxx, Jey Zhou, 20110622, optimize wifi gpio config. {*/
static struct msm_gpiomux_config msm8x60_wifi_configs_song[] __initdata = {
	{
		.gpio = WLAN_EN,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wifi_en_active_cfg,
			[GPIOMUX_SUSPENDED] = &wifi_en_suspend_cfg,
		},
	},
	{
		.gpio = WLAN_IRQ,
		.settings = {
			[GPIOMUX_ACTIVE]    = &wifi_irq_active_cfg,
			[GPIOMUX_SUSPENDED] = &wifi_irq_suspend_cfg,
		},
	},
};
/* GORAB1A_CR #xxxxx, Jey Zhou, 20110622, optimize wifi gpio config. }*/
#endif

struct msm_gpiomux_configs
msm8x60_qis_common_gpiomux_cfgs[] __initdata = {
	{msm8x60_gsbi_configs_song, ARRAY_SIZE(msm8x60_gsbi_configs_song)},
	{msm8x60_ebi2_configs_song, ARRAY_SIZE(msm8x60_ebi2_configs_song)},
	{msm8x60_uart_configs_song, ARRAY_SIZE(msm8x60_uart_configs_song)},
	{msm8x60_ts_configs_song, ARRAY_SIZE(msm8x60_ts_configs_song)},
	{msm8x60_aux_pcm_configs_song, ARRAY_SIZE(msm8x60_aux_pcm_configs_song)},
	{msm8x60_sdc_configs_song, ARRAY_SIZE(msm8x60_sdc_configs_song)},
	{msm8x60_snd_configs_song, ARRAY_SIZE(msm8x60_snd_configs_song)},
	{msm8x60_audio_configs_song, ARRAY_SIZE(msm8x60_audio_configs_song)},
	{msm8x60_mi2s_configs_song, ARRAY_SIZE(msm8x60_mi2s_configs_song)},
	{msm8x60_lcdc_configs_song, ARRAY_SIZE(msm8x60_lcdc_configs_song)},
	{msm8x60_hdmi_configs_song, ARRAY_SIZE(msm8x60_hdmi_configs_song)},
	{msm8x60_common_configs_song, ARRAY_SIZE(msm8x60_common_configs_song)},
	{msm8x60_pmic_configs_song, ARRAY_SIZE(msm8x60_pmic_configs_song)},
	{msm8x60_cam_configs_song, ARRAY_SIZE(msm8x60_cam_configs_song)},
	{msm8x60_bt_configs_song, ARRAY_SIZE(msm8x60_bt_configs_song)},
	{msm8x60_wifi_configs_song, ARRAY_SIZE(msm8x60_wifi_configs_song)},
	{NULL, 0},
};

