// 20100614
// Emily Jiang created

#ifndef _ATA2538_CAPKEY_H_
#define _ATA2538_CAPKEY_H_

#define CAPKEY_DRIVER_NAME "ATA2538_capkey"
#define ADD_PA0_ALPHA       	0x00
#define ADDR_REG_CHECK      	0x28
#define ADDR_COLD_RESET     	0xFE
#define ADDR_WARM_RESET     	0xFF
#define PA_TOUCH_BYTE       	0x68
#define Enter_SLEEP         	0xFD
#define WAKEUP_SLEEP        	0xFC
#define INIT_ALPHA_VALUE    	0x12
#define ADDR_GPIO_CONFIGURATION 0x1D
#define PA0_STRENGTH            0x50
#define PA1_STRENGTH            0x51
#define PA2_STRENGTH            0x52
#define PA3_STRENGTH            0x53
#define PA4_STRENGTH            0x54
#define PA5_STRENGTH            0x55
#define PA6_STRENGTH            0x56
#define PA7_STRENGTH            0x57
#define PA0_IMPEDANCE           0x58
#define PA1_IMPEDANCE           0x59
#define PA2_IMPEDANCE           0x5A
#define PA3_IMPEDANCE           0x5B
#define PA4_IMPEDANCE           0x5C
#define PA5_IMPEDANCE           0x5D
#define PA6_IMPEDANCE           0x5E
#define PA7_IMPEDANCE           0x5F
#define PA0_REFERENCE_IMPEDANCE 0x60
#define PA1_REFERENCE_IMPEDANCE 0x61
#define PA2_REFERENCE_IMPEDANCE 0x62
#define PA3_REFERENCE_IMPEDANCE 0x63
#define PA4_REFERENCE_IMPEDANCE 0x64
#define PA5_REFERENCE_IMPEDANCE 0x65
#define PA6_REFERENCE_IMPEDANCE 0x66
#define PA7_REFERENCE_IMPEDANCE 0x67
#define ALPHA_SIZE          8
#define TOTAL_REG_SIZE      61
#define ECHOSTR_SIZE            20
#define EMLIST_SIZE         9
//engineer mode
struct capkey_emlist_t {
    uint8_t   value[EMLIST_SIZE];
};

struct capkey_alpha_t {
	uint8_t   PA3_value;
	uint8_t   PA4_value;
	uint8_t   PA5_value;
	uint8_t   reference_delay;
};
/*Qisda, alan.p.xu, 2012.2.9, calibration capkey{*/
struct capkey_config {
  uint8_t value[TOTAL_REG_SIZE];
};
/*Qisda, alan.p.xu, 2012.2.9, calibration capkey}*/

#define MAX_OBJ_ELEMENT_SIZE                     30
#define ATMEL_REPORT_POINTS     		 		 2

/*
struct id_info_t                      
{                                 
	uint8_t  family_id; //start address
	uint8_t  variant_id;       
	uint8_t  version;
	uint8_t  build;
	uint8_t  matrix_x_size;
	uint8_t  matrix_y_size;
	uint8_t  num_obj_element;	
};
*/

struct ata2538_capkey_platform_data_t {
    unsigned int gpioirq;
    unsigned int gpiorst;
/*Orange EVT2 CR XXXX Jack W Lu 2011-09-03 Add for L1B vote, Power Consumption issue {*/
    int (*pm8901_l1b_init)(int on);
    int (*pm8901_l1b_vote_set)(int on);
/*Orange EVT2 CR XXXX Jack W Lu 2011-09-03 Add for L1B vote, Power Consumption issue }*/
};

//engineer mode ioctl cmd
#define __ATACAPKEYDRVIO 0xAA
#define ATA_CAPKEY_IOCTL_GET_SENSOR_VALUE _IOR(__ATACAPKEYDRVIO, 1, struct capkey_emlist_t )
#define ATA_CAPKEY_IOCTL_SET_ALPHA _IOW(__ATACAPKEYDRVIO, 2, struct capkey_alpha_t )
#define ATA_CAPKEY_IOCTL_GET_ALPHA _IOR(__ATACAPKEYDRVIO, 3, struct capkey_alpha_t )
/*Qisda, alan.p.xu, 2012.2.9, calibration capkey{*/
#define ATA_CAPKEY_IOCTL_CONFIG _IOW(__ATACAPKEYDRVIO, 4, struct capkey_config)
#define ATA_CAPKEY_IOCTL_GET_CONFIG _IOR(__ATACAPKEYDRVIO, 5, struct capkey_config)
#define ATA_CAPKEY_IOCTL_CALIBRATION_SENSOR_VALUE _IOW(__ATACAPKEYDRVIO, 6, int)
/*Qisda, alan.p.xu, 2012.2.9, calibration capkey}*/


//for EVT2-1
/*
static uint8_t init_data_alpha_evt2_1[] = {
	0x12, // PA0_ALPHA0 addr:0x00 
	0x12, // PA0_ALPHA1 addr:0x01
	0x12, // PA0_ALPHA2 addr:0x02
	0x6, // PA0_ALPHA3 addr:0x03
	0x4, // PA0_ALPHA4 addr:0x04
	0x7, // PA0_ALPHA5 addr:0x05
	0x12, // PA0_ALPHA6 addr:0x06
	0x12  // PA0_ALPHA7 addr:0x07
};

static uint8_t init_data_burst_evt2_1[] = {
	0x7f, //00 ADDR_REFERENCE_DELAY addr: 0x08
	0x04, //01 ADDR_BETA addr: 0x09
	0x27, //02 ADDR_AIC_WAIT addr: 0x0A
	0x64, //03 ADDR_STRENGTH_THRESHOLD0 addr: 0x0B
	0x64, //04 ADDR_STRENGTH_THRESHOLD1 addr: 0x0C
	0x64, //05 ADDR_STRENGTH_THRESHOLD2 addr: 0x0D
	0x64, //06 ADDR_STRENGTH_THRESHOLD3 addr: 0x0E
	0x64, //07 ADDR_STRENGTH_THRESHOLD4 addr: 0x0F
	0x64, //08 ADDR_STRENGTH_THRESHOLD5 addr: 0x10
	0x64, //09 ADDR_STRENGTH_THRESHOLD6 addr: 0x11
	0x64, //10 ADDR_STRENGTH_THRESHOLD7 addr: 0x12
	0x04, //11 ADDR_FEATURE_SELECTOR addr: 0x13
	0xff, //12 ADDR_INTEGRATION_TIME addr: 0x14
	0x1c, //13 ADDR_IDLE_Time addr: 0x15
	0x20, //14 ADDR_CONTROL_1 addr: 0x16
	0x80, //15 ADDR_CONTROL_2 addr: 0x17
	0x00, //16 ADDR_PA_DATA addr: 0x18
	0x00, //17 ADDR_GPIO_DATA addr: 0x19
	0x00, //18 ADDR_PA_DIR addr: 0x1A
	0x00, //19 ADDR_GPIO_DIR addr: 0x1B
	0xc7, //20 ADDR_PA_CONFIGURATION addr: 0x1C
	0x00, //21 ADDR_GPIO_CONFIGURATION addr: 0x1D
	0x80, //0x30, //22 ADDR_CAL_INTERVAL addr: 0x1E
	0x7e, //0xFE, //23 ADDR_INT_MASK addr: 0x1F
	0x00, //24 ADDR_INT_CLEAR addr: 0x20
	0x00, //25 ADDR_PA_EINT_EN addr: 0x21
	0x00, //26 ADDR_GPIO_EINT_EN addr: 0x22
	0x00, //27 ADDR_FILTER_PERIOD addr: 0x23
	0x01, //28 ADDR_FILTER_THRESHOLD addr: 0x24
	0x00, //29 ADDR_CONTROL_3 addr: 0x25
	0x7e, //30 ADDR_EDGE_EN addr: 0x26
	0x0a, //31 ADDR_BOUNCE_PERIOD addr: 0x27	
	0xff, //0xFF //31 ADDR_BOUNCE_PERIOD addr: 0x28	
	0x00, //33 ADDR_R_SEL_0_3 addr: 0x29
	0x00, //34 ADDR_R_SEL_4_7 addr: 0x2A
	0x03, //35 ADDR_R_SEL_REF addr: 0x2B
	0x00, //36 ADDR_BETA_DISABLE addr: 0x2C
	0x00, //37 ADDR_DIM_PERIOD_1_0 addr: 0x2D
	0x00, //38 ADDR_DIM_PERIOD_3_2 addr: 0x2E
	0x00, //39 ADDR_DIM_PERIOD_5_4 addr: 0x2F
	0x00, //40 ADDR_DIM_PERIOD_7_6 addr: 0x30
	0x00, //41 ADDR_DIM_0_CONTORL addr: 0x31
	0x00, //42 ADDR_DIM_1_CONTORL addr: 0x32
	0x00, //43 ADDR_DIM_2_CONTORL addr: 0x33
	0x00, //44 ADDR_DIM_3_CONTORL addr: 0x34
	0x00, //45 ADDR_DIM_4_CONTORL addr: 0x35
	0x00, //46 ADDR_DIM_5_CONTORL addr: 0x36
	0x00, //47 ADDR_DIM_6_CONTORL addr: 0x37
	0x00, //48 ADDR_DIM_7_CONTORL addr: 0x38
	0x00, //49 ADDR_DIM_MODE_3_2_1_0 addr: 0x39
	0x00, //50 ADDR_DIM_MODE_7_6_5_4 addr: 0x3A
	0x00, //51 ADDR_DIM_START addr: 0x3B
	0x00 //52 ADDR_DIMMING_EN addr: 0x3C
};
*/

//for EVT2-2
/*
static uint8_t init_data_alpha_evt2_2[] = {
	0x12, // PA0_ALPHA0 addr:0x00 
	0x12, // PA0_ALPHA1 addr:0x01
	0x12, // PA0_ALPHA2 addr:0x02
	0x6, // PA0_ALPHA3 addr:0x03
	0x8, // PA0_ALPHA4 addr:0x04
	0x8, // PA0_ALPHA5 addr:0x05
	0x12, // PA0_ALPHA6 addr:0x06
	0x12  // PA0_ALPHA7 addr:0x07
};

static uint8_t init_data_burst_evt2_2[] = {
	0x18, //00 ADDR_REFERENCE_DELAY addr: 0x08
	0x04, //01 ADDR_BETA addr: 0x09
	0x27, //02 ADDR_AIC_WAIT addr: 0x0A
	0x64, //03 ADDR_STRENGTH_THRESHOLD0 addr: 0x0B
	0x64, //04 ADDR_STRENGTH_THRESHOLD1 addr: 0x0C
	0x64, //05 ADDR_STRENGTH_THRESHOLD2 addr: 0x0D
	0x64, //06 ADDR_STRENGTH_THRESHOLD3 addr: 0x0E
	0x64, //07 ADDR_STRENGTH_THRESHOLD4 addr: 0x0F
	0x64, //08 ADDR_STRENGTH_THRESHOLD5 addr: 0x10
	0x64, //09 ADDR_STRENGTH_THRESHOLD6 addr: 0x11
	0x64, //10 ADDR_STRENGTH_THRESHOLD7 addr: 0x12
	0x04, //11 ADDR_FEATURE_SELECTOR addr: 0x13
	0xff, //12 ADDR_INTEGRATION_TIME addr: 0x14
	0x1c, //13 ADDR_IDLE_Time addr: 0x15
	0x20, //14 ADDR_CONTROL_1 addr: 0x16
	0x80, //15 ADDR_CONTROL_2 addr: 0x17
	0x00, //16 ADDR_PA_DATA addr: 0x18
	0x00, //17 ADDR_GPIO_DATA addr: 0x19
	0x00, //18 ADDR_PA_DIR addr: 0x1A
	0x00, //19 ADDR_GPIO_DIR addr: 0x1B
	0xc7, //20 ADDR_PA_CONFIGURATION addr: 0x1C
	0x00, //21 ADDR_GPIO_CONFIGURATION addr: 0x1D
	0x80, //0x30, //22 ADDR_CAL_INTERVAL addr: 0x1E
	0x7e, //0xFE, //23 ADDR_INT_MASK addr: 0x1F
	0x00, //24 ADDR_INT_CLEAR addr: 0x20
	0x00, //25 ADDR_PA_EINT_EN addr: 0x21
	0x00, //26 ADDR_GPIO_EINT_EN addr: 0x22
	0x00, //27 ADDR_FILTER_PERIOD addr: 0x23
	0x01, //28 ADDR_FILTER_THRESHOLD addr: 0x24
	0x00, //29 ADDR_CONTROL_3 addr: 0x25
	0x7e, //30 ADDR_EDGE_EN addr: 0x26
	0x0a, //31 ADDR_BOUNCE_PERIOD addr: 0x27	
	0xff, //0xFF //31 ADDR_BOUNCE_PERIOD addr: 0x28	
	0xaa, //33 ADDR_R_SEL_0_3 addr: 0x29
	0xa7, //34 ADDR_R_SEL_4_7 addr: 0x2A
	0x02, //35 ADDR_R_SEL_REF addr: 0x2B
	0x00, //36 ADDR_BETA_DISABLE addr: 0x2C
	0x00, //37 ADDR_DIM_PERIOD_1_0 addr: 0x2D
	0x00, //38 ADDR_DIM_PERIOD_3_2 addr: 0x2E
	0x00, //39 ADDR_DIM_PERIOD_5_4 addr: 0x2F
	0x00, //40 ADDR_DIM_PERIOD_7_6 addr: 0x30
	0x00, //41 ADDR_DIM_0_CONTORL addr: 0x31
	0x00, //42 ADDR_DIM_1_CONTORL addr: 0x32
	0x00, //43 ADDR_DIM_2_CONTORL addr: 0x33
	0x00, //44 ADDR_DIM_3_CONTORL addr: 0x34
	0x00, //45 ADDR_DIM_4_CONTORL addr: 0x35
	0x00, //46 ADDR_DIM_5_CONTORL addr: 0x36
	0x00, //47 ADDR_DIM_6_CONTORL addr: 0x37
	0x00, //48 ADDR_DIM_7_CONTORL addr: 0x38
	0x00, //49 ADDR_DIM_MODE_3_2_1_0 addr: 0x39
	0x00, //50 ADDR_DIM_MODE_7_6_5_4 addr: 0x3A
	0x00, //51 ADDR_DIM_START addr: 0x3B
	0x00 //52 ADDR_DIMMING_EN addr: 0x3C
};
*/

// use big PAD FPC for EVT3
/*
static uint8_t init_data_alpha_evt3[] = {
	0x12, // PA0_ALPHA0 addr:0x00 
	0x12, // PA0_ALPHA1 addr:0x01
	0x12, // PA0_ALPHA2 addr:0x02
	0xa, // PA0_ALPHA3 addr:0x03
	0xa, // PA0_ALPHA4 addr:0x04,9 for evt3-1,a for evt 3-2
	0x9, // PA0_ALPHA5 addr:0x05,8 for evt3-1,9 for evt3-2
	0x12, // PA0_ALPHA6 addr:0x06
	0x12  // PA0_ALPHA7 addr:0x07
};

static uint8_t init_data_burst_evt3[] = {
	0x70, //00 ADDR_REFERENCE_DELAY addr: 0x08,0x20 for evt3-1,4A for evt3-2,70 for test
	0x04, //01 ADDR_BETA addr: 0x09
	0x27, //02 ADDR_AIC_WAIT addr: 0x0A
	0x64, //03 ADDR_STRENGTH_THRESHOLD0 addr: 0x0B
	0x64, //04 ADDR_STRENGTH_THRESHOLD1 addr: 0x0C
	0x64, //05 ADDR_STRENGTH_THRESHOLD2 addr: 0x0D
	0x64, //06 ADDR_STRENGTH_THRESHOLD3 addr: 0x0E
	0x64, //07 ADDR_STRENGTH_THRESHOLD4 addr: 0x0F
	0x64, //08 ADDR_STRENGTH_THRESHOLD5 addr: 0x10
	0x64, //09 ADDR_STRENGTH_THRESHOLD6 addr: 0x11
	0x64, //10 ADDR_STRENGTH_THRESHOLD7 addr: 0x12
	0x04, //11 ADDR_FEATURE_SELECTOR addr: 0x13
	0xff, //12 ADDR_INTEGRATION_TIME addr: 0x14
	0x1c, //13 ADDR_IDLE_Time addr: 0x15
	0x00, //14 ADDR_CONTROL_1 addr: 0x16
	0x80, //15 ADDR_CONTROL_2 addr: 0x17
	0x00, //16 ADDR_PA_DATA addr: 0x18
	0x00, //17 ADDR_GPIO_DATA addr: 0x19
	0x00, //18 ADDR_PA_DIR addr: 0x1A
	0x00, //19 ADDR_GPIO_DIR addr: 0x1B
	0xc7, //20 ADDR_PA_CONFIGURATION addr: 0x1C
	0x00, //21 ADDR_GPIO_CONFIGURATION addr: 0x1D
	0x80, //0x30, //22 ADDR_CAL_INTERVAL addr: 0x1E
	0x7e, //0xFE, //23 ADDR_INT_MASK addr: 0x1F
	0x00, //24 ADDR_INT_CLEAR addr: 0x20
	0x00, //25 ADDR_PA_EINT_EN addr: 0x21
	0x00, //26 ADDR_GPIO_EINT_EN addr: 0x22
	0x00, //27 ADDR_FILTER_PERIOD addr: 0x23
	0x01, //28 ADDR_FILTER_THRESHOLD addr: 0x24
	0x00, //29 ADDR_CONTROL_3 addr: 0x25
	0x7e, //30 ADDR_EDGE_EN addr: 0x26
	0x0a, //31 ADDR_BOUNCE_PERIOD addr: 0x27	
	0xff, //0xFF //31 ADDR_BOUNCE_PERIOD addr: 0x28	
	0x00, //33 ADDR_R_SEL_0_3 addr: 0x29
	0x03, //34 ADDR_R_SEL_4_7 addr: 0x2A,0 for evt3-1,3 for evt3-2
	0x00, //35 ADDR_R_SEL_REF addr: 0x2B
	0x00, //36 ADDR_BETA_DISABLE addr: 0x2C
	0x00, //37 ADDR_DIM_PERIOD_1_0 addr: 0x2D
	0x00, //38 ADDR_DIM_PERIOD_3_2 addr: 0x2E
	0x00, //39 ADDR_DIM_PERIOD_5_4 addr: 0x2F
	0x00, //40 ADDR_DIM_PERIOD_7_6 addr: 0x30
	0x00, //41 ADDR_DIM_0_CONTORL addr: 0x31
	0x00, //42 ADDR_DIM_1_CONTORL addr: 0x32
	0x00, //43 ADDR_DIM_2_CONTORL addr: 0x33
	0x00, //44 ADDR_DIM_3_CONTORL addr: 0x34
	0x00, //45 ADDR_DIM_4_CONTORL addr: 0x35
	0x00, //46 ADDR_DIM_5_CONTORL addr: 0x36
	0x00, //47 ADDR_DIM_6_CONTORL addr: 0x37
	0x00, //48 ADDR_DIM_7_CONTORL addr: 0x38
	0x00, //49 ADDR_DIM_MODE_3_2_1_0 addr: 0x39
	0x00, //50 ADDR_DIM_MODE_7_6_5_4 addr: 0x3A
	0x00, //51 ADDR_DIM_START addr: 0x3B
	0x00 //52 ADDR_DIMMING_EN addr: 0x3C
};
*/
#endif	//_ATA2538_CAPKEY_H_