// 20081204
// Menghan Cheng created

#ifndef _AUO_TOUCH_H_
#define _AUO_TOUCH_H_

#define AUO_TS_DRIVER_NAME "auo_touchscreen"


#ifdef CONFIG_AUO_5INCH_TOUCHSCREEN
#define USE_AUO_5INCH       1
#define TOUCH_FB_PORTRAIT   1
#define CONFIG_PANEL        1
#define PERIODICAL_INT_MODE 0
#define TOUCH_INDI_INT_MODE 0
#define COORD_COMP_INT_MODE 1
#define USE_PIXCIR
#else   //!CONFIG_AUO_5INCH_TOUCHSCREEN
#define USE_AUO_5INCH       0
#define CONFIG_PANEL        1
#define PERIODICAL_INT_MODE 0
#define TOUCH_INDI_INT_MODE 1
#define COORD_COMP_INT_MODE 0 // Must be set zero. 4.3" panel doesn't support this.
#endif  //CONFIG_AUO_5INCH_TOUCHSCREEN



//#define PERFORMANCE_TEST    0
#define AUO_REPORT_POINTS     2
#define AUO_INT_ENABLE        0x08
#define AUO_INT_POL_HIGH      0x04
#define AUO_INT_POL_LOW       0x00
#define AUO_INT_MODE_MASK     0x03
#define AUO_INT_SETTING_MASK  0x0F
#define AUO_POWER_MODE_MASK   0x03

// ================================================================
#if USE_AUO_5INCH
// ********************  AUO 5" panel - START *********************
// EVT1(pixcir)
// AUO 5" coordinate:        Android coordinate (landscape):
//  ------------------- Y     ------------------- X
// |(  0,800) ... (  0,  0)  |(  0,  0) ... (  0,800)
// |   ...           ...     |   ...           ...
// |(480,800) ... (480,  0)  |(480,  0) ... (480,800)
// X                         Y
//
// EVT0-1, EVT0(cypress)
// AUO 5" coordinate:        Android coordinate (landscape):
//  ------------------- Y     ------------------- X
// |(  0,  0) ... (  0,800)  |(  0,  0) ... (  0,800)
// |   ...           ...     |   ...           ...
// |(480,  0) ... (480,800)  |(480,  0) ... (480,800)
// X                         Y
#if defined(TOUCH_FB_PORTRAIT)
	#define AUO_X_MAX	     480
	#define AUO_Y_MAX	     800
#else
	#define AUO_X_MAX	     800
	#define AUO_Y_MAX	     480
#endif
#ifdef USE_PIXCIR
#define AUO_X1_LSB           0x00
#define AUO_X_SENSITIVITY    0x70  // Difference: 0x6F in datasheet; 0x70 in android
#define AUO_Y_SENSITIVITY    0x6F  // Difference: 0x70 in datasheet; 0x6F in android
#define AUO_INT_SETTING      0x71
#define AUO_INT_WIDTH        0x72
#define AUO_POWER_MODE       0x73
#define AUO_EEPROM_CALIB_X   0x42
#define AUO_EEPROM_CALIB_X_LEN 62
//#define AUO_EEPROM_CALIB_Y   0xAD //austin set
#define AUO_EEPROM_CALIB_Y   0xCD
//#define AUO_EEPROM_CALIB_Y_LEN 36 //austin set
#define AUO_EEPROM_CALIB_Y_LEN 62
#define AUO_RAW_DATA_Y       0x4F
#define AUO_RAW_DATA_Y_LEN   0x0B
#define AUO_RAW_DATA_X       0x2B
#define AUO_RAW_DATA_X_LEN   0x12
#define AUO_TOUCH_AREA_X     0x1E
#define AUO_TOUCH_AREA_Y     0x1F
#define AUO_TOUCH_STRENGTH_ENA 0x0D
#define AUO_TOUCH_STRENGTH_X 0x0E
#else
#define AUO_X1_LSB           0x40
#define AUO_X_SENSITIVITY    0x65  // Difference: 0x64 in datasheet; 0x65 in android
#define AUO_Y_SENSITIVITY    0x64  // Difference: 0x65 in datasheet; 0x64 in android
#define AUO_INT_SETTING      0x66
#define AUO_INT_WIDTH        0x67
#define AUO_POWER_MODE       0x69
#endif

#define AUO_PERIODICAL_ENA   (0x00 | AUO_INT_POL_HIGH | AUO_INT_ENABLE)
#define AUO_COMP_COORD_ENA   (0x01 | AUO_INT_POL_HIGH | AUO_INT_ENABLE)
#define AUO_TOUCH_IND_ENA    (0x02 | AUO_INT_POL_HIGH | AUO_INT_ENABLE)
#define AUO_ACTIVE_MODE      0x00
#define AUO_SLEEP_MODE       0x01
#define AUO_DEEP_SLEEP_MODE  0x02

#if PERIODICAL_INT_MODE
#define AUO_INT_SETTING_VAL  AUO_PERIODICAL_ENA
#endif
#if COORD_COMP_INT_MODE
#define AUO_INT_SETTING_VAL  AUO_COMP_COORD_ENA
#endif
#if TOUCH_INDI_INT_MODE
#define AUO_INT_SETTING_VAL  AUO_TOUCH_IND_ENA
#endif
// ********************  AUO 5" panel - END     *********************
#else //!USE_AUO_5INCH
// ********************  AUO 4.3" panel - START *********************
#define AUO_X_MAX	     480
#define AUO_Y_MAX	     272
#define AUO_X1_LSB           0x40
#define AUO_X_SENSITIVITY    0x67
#define AUO_Y_SENSITIVITY    0x68
#define AUO_INT_SETTING      0x6E
#define AUO_INT_WIDTH        0x6F
#define AUO_POWER_MODE       0x70

#define AUO_PERIODICAL_ENA   (0x00 | AUO_INT_POL_HIGH | AUO_INT_ENABLE)
#define AUO_TOUCH_IND_ENA    (0x01 | AUO_INT_POL_HIGH | AUO_INT_ENABLE)
#if PERIODICAL_INT_MODE
#define AUO_INT_SETTING_VAL  AUO_PERIODICAL_ENA
#endif
#if TOUCH_INDI_INT_MODE
#define AUO_INT_SETTING_VAL  AUO_TOUCH_IND_ENA
#endif
// ********************  AUO 4.3" panel - END   *******************
#endif //~USE_AUO_5INCH
// ================================================================


#define TS_PENUP_TIMEOUT_MS 10

enum auo_touch_state {
    AUO_RELEASE = 0,
    AUO_PRESS,
};

enum auo_mt_state {
    AUO_NOT_TOUCH_STATE = 0,
    AUO_ONE_TOUCH_STATE,
    AUO_TWO_TOUCH_STATE,
    AUO_MAX_TOUCH_STATE
};

enum auo_touch_power_mode {
    AUO_UNKNOW_POWER_MODE = 0,
    AUO_ACTIVE_POWER_MODE,
    AUO_SLEEP_POWER_MODE,
    AUO_DEEP_SLEEP_POWER_MODE,
    AUO_REAL_SLEEP_POWER_MODE,
    AUO_MAX_POWER_MODE,
};

enum auo_touch_strength_mode {
    AUO_KEEP_READ = 0,
    AUO_ENABLE_READ,
    AUO_DISABLE_READ,
};

struct auo_touchscreen_platform_data {
    unsigned int x_max;
    unsigned int y_max;
    unsigned int gpioirq;
    unsigned int gpiorst;
/*Orange EVT2 CR XXXX Jack W Lu 2011-09-03 Add for L1B vote, Power Consumption issue {*/
    int (*pm8901_l1b_init)(int on);
    int (*pm8901_l1b_vote_set)(int on);
/*Orange EVT2 CR XXXX Jack W Lu 2011-09-03 Add for L1B vote, Power Consumption issue }*/
};

struct auo_reg_map_t {
    unsigned char x1_lsb;
    unsigned char x_sensitivity;
    unsigned char y_sensitivity;
    unsigned char int_setting;
    unsigned char int_width;
    unsigned char power_mode;
};

struct auo_point_t {
    uint   x;
    uint   y;
};

struct auo_point_info_t {
    struct auo_point_t   coord;
    enum auo_touch_state state;
};

struct auo_mt_t {
    struct auo_point_info_t points[AUO_REPORT_POINTS];
    enum auo_mt_state       state;
};

#if USE_AUO_5INCH
struct auo_sensitivity_t {
    uint   value;
};

struct auo_interrupt_t {
    uint   int_setting;
    uint   int_width;
};

struct auo_power_mode_t {
    enum auo_touch_power_mode   mode;
};

struct auo_power_switch_t {
    uint   on;
};

struct auo_eeprom_calib_t {
    char *raw_buf_x;
    char *raw_buf_y;
    uint raw_len_x;
    uint raw_len_y;
};

struct auo_raw_data_t {
    int  *raw_buf_x;
    int  *raw_buf_y;
    uint raw_len_x;
    uint raw_len_y;
    enum auo_touch_strength_mode mode;
};

struct auo_touch_area_t {
    uint area_x;
    uint area_y;
};

struct auo_touch_strength_t {
    int strength_x;
    int strength_y;
    enum auo_touch_strength_mode mode;
};
struct auo_id_info_t
{     
       uint8_t   family_id; 
	uint8_t   varlant_id;   
	uint8_t   version;     
};
struct auo_debug_info
{     
       uint8_t   gpio_status; 
	uint8_t   status_register;   
  
};
/*Qisda,Alan P Xu,2011.08.04,add touch ftd{*/
struct auo_calibration_info{
    
};
struct auo_download_firware_info{
unsigned char *touch_hex_data; 
unsigned int size_kernel;
unsigned int Version;
};
struct auo_Irqvalue{
  uint8_t irq_value;
  uint8_t int_setting;
  uint8_t int_width;
};
struct Raw_Inter_data{
  char *Rawdata;
  char *Interdata;
}; 
/*Qisda,Alan P Xu,2011.08.04,add touch ftd}*/
#define AUO_TOUCH_IOCTL_MAGIC 0xA5
#define AUO_TOUCH_IOCTL_GET_X_SENSITIVITY \
	_IOR(AUO_TOUCH_IOCTL_MAGIC, 1, struct auo_sensitivity_t )
#define AUO_TOUCH_IOCTL_GET_Y_SENSITIVITY \
	_IOR(AUO_TOUCH_IOCTL_MAGIC, 2, struct auo_sensitivity_t )
#define AUO_TOUCH_IOCTL_SET_X_SENSITIVITY \
	_IOW(AUO_TOUCH_IOCTL_MAGIC, 3, struct auo_sensitivity_t )
#define AUO_TOUCH_IOCTL_SET_Y_SENSITIVITY \
	_IOW(AUO_TOUCH_IOCTL_MAGIC, 4, struct auo_sensitivity_t )
#define AUO_TOUCH_IOCTL_SET_INT_SETTING \
	_IOW(AUO_TOUCH_IOCTL_MAGIC, 5, struct auo_interrupt_t )
#define AUO_TOUCH_IOCTL_GET_INT_SETTING \
	_IOR(AUO_TOUCH_IOCTL_MAGIC, 6, struct auo_interrupt_t )
#define AUO_TOUCH_IOCTL_SET_INT_WIDTH \
	_IOW(AUO_TOUCH_IOCTL_MAGIC, 7, struct auo_interrupt_t )
#define AUO_TOUCH_IOCTL_GET_INT_WIDTH \
	_IOR(AUO_TOUCH_IOCTL_MAGIC, 8, struct auo_interrupt_t )
#define AUO_TOUCH_IOCTL_SET_POWER_MODE \
        _IOW(AUO_TOUCH_IOCTL_MAGIC, 9, struct auo_power_mode_t )
#define AUO_TOUCH_IOCTL_GET_POWER_MODE \
        _IOR(AUO_TOUCH_IOCTL_MAGIC, 10, struct auo_power_mode_t )
#define AUO_TOUCH_IOCTL_POWER_SWITCH \
        _IOW(AUO_TOUCH_IOCTL_MAGIC, 11, struct auo_power_switch_t )
#define AUO_TOUCH_IOCTL_GET_EEPROM_CALIB \
        _IOR(AUO_TOUCH_IOCTL_MAGIC, 12, struct auo_eeprom_calib_t )
#define AUO_TOUCH_IOCTL_START_CALIB \
        _IOW(AUO_TOUCH_IOCTL_MAGIC, 13, unsigned short )
#define AUO_TOUCH_IOCTL_GET_RAW_DATA \
        _IOR(AUO_TOUCH_IOCTL_MAGIC, 14, struct auo_raw_data_t )
#define AUO_TOUCH_IOCTL_RESET_PANEL \
        _IOW(AUO_TOUCH_IOCTL_MAGIC, 15, unsigned short )
#define AUO_TOUCH_IOCTL_GET_TOUCH_AREA \
        _IOR(AUO_TOUCH_IOCTL_MAGIC, 16, struct auo_touch_area_t )
#define AUO_TOUCH_IOCTL_GET_TOUCH_STRENGTH \
        _IOR(AUO_TOUCH_IOCTL_MAGIC, 17, struct auo_touch_strength_t )
#define AUO_TOUCH_IOCTL_GET_INFO \
        _IOR(AUO_TOUCH_IOCTL_MAGIC, 18, struct auo_id_info_t )
#define AUO_TOUCH_IOCTL_FOR_DEBUG \
        _IOR(AUO_TOUCH_IOCTL_MAGIC, 19, struct auo_debug_info )
/*Qisda,Alan P Xu,2011.08.04,add touch ftd{*/
#define AUO_TOUCH_CALIBRATION \
        _IOR(AUO_TOUCH_IOCTL_MAGIC, 20, struct auo_calibration_info)
#define AUO_TOUCH_DOWNLOAD_FIRWARE \
        _IOR(AUO_TOUCH_IOCTL_MAGIC, 21, struct auo_download_firware_info)
/*Qisda,Alan P Xu,2011.08.04,add touch ftd}*/

/*Qisda, Alan P Xu, 2011.09.04, add touch performance test{*/
#define AUO_TOUCH_POWER_SWITCH \
        _IOW(AUO_TOUCH_IOCTL_MAGIC, 23, struct auo_power_switch_t)
#define AUO_TOUCH_SET_POWER_MODE \
        _IOW(AUO_TOUCH_IOCTL_MAGIC, 24, struct auo_power_switch_t)
/*Qisda, Alan P Xu, 2011.09.04, add touch performance test}*/
        
/*Qisda, Alan P Xu, 2011.09.18, get touch debug info{*/
#define AUO_TOUCH_GET_RAW_DATA _IOR(AUO_TOUCH_IOCTL_MAGIC, 25, struct Raw_Inter_data)
#define AUO_TOUCH_GET_POINT _IOR(AUO_TOUCH_IOCTL_MAGIC, 26, struct auo_point_t)
#define AUO_GET_IRQ_VALUE _IOR(AUO_TOUCH_IOCTL_MAGIC, 27, int)
#define AUO_TOUCH_RESET_PANEL _IOW(AUO_TOUCH_IOCTL_MAGIC, 28, unsigned short )
#define AUO_GET_POWER_MODE _IOW(AUO_TOUCH_IOCTL_MAGIC, 29, unsigned short )
/*Qisda, Alan P Xu, 2011.09.18, get touch debug info}*/
#endif //USE_AUO_5INCH

#endif
