//============================================================================//
//
//  Battery/Charger/Gauge driver for Opus project
//
//  Author:   Jack W Lu (Qisda Corp. SuZhou)
//
//============================================================================//
//============================================================================//
//  Date:     2010.11.01
//
//  HW base:  EVB
//  SW base:  1050
//
//============================================================================//

#ifndef	__QSD_BATTERY_H__
#define	__QSD_BATTERY_H__

#include <linux/kernel.h>
#include <linux/power_supply.h>
#include <linux/mutex.h>
#include <linux/clocksource.h>
#include <linux/wakelock.h>
#include <linux//gpio/gpio_def.h>

#ifdef CONFIG_HAS_EARLYSUSPEND
  #include <linux/earlysuspend.h>
#endif

//============================================================================//
//  my macro
//============================================================================//
#define MYBIT(b)        (1<<b)
#define TST_BIT(x,b)    ((x & (1<<b)) ? 1 : 0)
#define CLR_BIT(x,b)    (x &= (~(1<<b)))
#define SET_BIT(x,b)    (x |= (1<<b))

//============================================================================//
//  flag (used in qsd_bat_update_usb_status())
//============================================================================//
//USB status
#define USB_STATUS_USB_NONE                 MYBIT(0)
#define USB_STATUS_USB_IN                   MYBIT(1)
#define USB_STATUS_USB_WALL_IN              MYBIT(2)
#define USB_STATUS_USB_0                    MYBIT(3)
#define USB_STATUS_USB_100                  MYBIT(4)
#define USB_STATUS_USB_500                  MYBIT(5)
#define USB_STATUS_USB_1500                 MYBIT(6)  //in Autsin, max charger current is 1A

//AC status
#define AC_STATUS_AC_NONE                   MYBIT(16)
#define AC_STATUS_AC_IN                     MYBIT(17)

//event
#define CHG_EVENT_GAGIC_BATT_GOOD           MYBIT(24)
#define CHG_EVENT_GAGIC_BATT_LOW            MYBIT(25)
#define CHG_EVENT_CHGIC_INTR                MYBIT(26)

void qsd_bat_update_usb_status(int flag);


#if defined(CONFIG_GAUGE_QSD) || defined(CONFIG_CHARGE_QSD)
#define QSD_CHARGING_FLOW_SUPPORT
#endif

#ifdef CONFIG_BATTERY_QSD
#define QSD_OFF_CHARGING_SUPPORT
#endif

enum qsd_off_chg_status{
  QSD_OFF_CHG_BAT_GOOD = 0,
  QSD_OFF_CHG_BAT_HOT = 1<<0,
  QSD_OFF_CHG_BAT_COLD = 1<<1,
  QSD_OFF_CHG_TIMEOUT = 1<<2,
  QSD_OFF_CHG_BAT_LOW = 1<<3,
  QSD_OFF_CHG_BAT_OV = 1<<4,//OVER_VOLTAGE
  QSD_OFF_CHG_NO_BAT = 1<<5,
  QSD_OFF_CHG_CHARGER_ERROR = 1<<6,
  QSD_OFF_CHG_MAX_NUM = 8,
};

//============================================================================//
//  gpio pin define
//============================================================================//
#define BAT_GPIO_BAT_LOW                       BATT_LOW
#define BAT_GPIO_CHG_INT                        DC_CHG_INT
#define BAT_GPIO_DC_IN_EN                      DC_IN_EN
#define BAT_GPIO_CHG_LOAD_SW_N_EN     CHG_LOAD_SW_N_EN


//============================================================================//
//  declaration
//============================================================================//
#if 0//(defined(CONFIG_MACH_EVT0) | defined(CONFIG_MACH_EVT0_1))

//============================================================================//
//  EVT0, EVT0-1
//============================================================================//
struct qsd_bat_data
{
  //power supply class
  struct power_supply psy_ac;
  struct power_supply psy_usb;
  struct power_supply psy_bat;

  //mutex
  struct mutex work_lock;

  //if the jiff is bigger than this, the property will be invalid
  //we must get new gag and chg info
  unsigned long jiff_property_valid_time;
  //cycle_t       jiff_property_valid_time;

  //the interval of valid property
  unsigned long jiff_property_valid_interval;
  //cycle_t       jiff_property_valid_interval;

  //the interval of update gauge & charge info
  unsigned long jiff_polling_interval;

  //for power_supply class
  int bat_status;
  int bat_health;
  int bat_present;
  int bat_capacity;
  int bat_vol;
  int bat_temp;
  int bat_technology;

  //gauge info
  short gag_ai;         //current (ma)
  short gag_flag;       //gag flags

  //flag of init
  char  inited;         //bit0: i2c inited, bit1: bat inited
  char  work_flag;      //if work_flag set, it means work queue already called

  //bat_fet state
  char  bat_fet_stat;   //bat_fet state

  //charge info
  char  chg_en_stat;    //stat of chg en gpio
  //char  chg_cmd;        //chg cmd reg (0x31)
  //char  chg_stat[3];    //chg stat reg (0x35~0x37)

  //for online status
  char  ac_online;
  char  usb_online;
  char  charger_changed;
  int   usb_current;    //max current provided by usb host

  //for i2c access error
  char  gagic_err;
  char  chgic_err;
};

#else

//============================================================================//
//  EVT1, EVT2, ...
//============================================================================//
//battery temperature state
enum {BAT_TEMP_NORMAL=0, BAT_TEMP_HOT, BAT_TEMP_COLD};
//battery charging voltage state
enum {BAT_CHG_VOLT_4200=0, BAT_CHG_VOLT_4100};

struct qsd_bat_data
{
  //power supply class
  struct power_supply psy_ac;
  struct power_supply psy_usb;
  struct power_supply psy_bat;

  //early suspend
  #ifdef CONFIG_HAS_EARLYSUSPEND
  	struct early_suspend drv_early_suspend;
  #endif

  //wake lock
  struct wake_lock wlock;

  //mutex
  //struct mutex work_lock;

  //if the jiff is bigger than this, the property will be invalid
  //we must get new gag and chg info
  unsigned long jiff_property_valid_time;
  //cycle_t       jiff_property_valid_time;

  //the interval of valid property
  unsigned long jiff_property_valid_interval;
  //cycle_t       jiff_property_valid_interval;

  //the interval of update gauge & charge info
  unsigned long jiff_polling_interval;

  //for charging timeout in suspend
  unsigned long jiff_charging_timeout;

  //update ac_online_tmp when debounce time reach
  unsigned long jiff_ac_online_debounce_time;
  unsigned long jiff_bat_low_count_wait_time;

  //gpio and irq
  int gpio_bat_low;
  int gpio_chg_int;
  int irq_bat_low;
  int irq_chg_int;

  //for power_supply class
  int bat_status;
  int bat_health;
  int bat_present;
  int bat_capacity;
  int bat_vol;
  int bat_temp;
  int bat_technology;
  
  int amss_batt_low;
  int bat_low_count;
  int low_bat_power_off;
  //for bat_health abnormal debounce
  //if err_count < 3, report good, otherwise, report real err to AP
  int bat_health_err_count;

  //bat temp state, bat chg state
  int bat_temp_state;
  int bat_chg_volt_state;

  //gauge info
  short gag_ctrl;       //control status
  short gag_flag;       //gag flags
  short gag_rm;         //gag rm
  short gag_fcc;        //gag fcc
  short gag_ai;         //current (ma)

  //charge info
  struct {
		 unsigned int enable:1;       //enable
		 unsigned int overtemp:1;     //internal overtemp
		 unsigned int bat_temp_high:1;//battery temp high
		 unsigned int bat_temp_low:1; //battery temp low
		 unsigned int trick_chg:1;    //trick charging
		 unsigned int pre_chg:1;      //pre charging
		 unsigned int fast_chg:1;     //fast charging
		 unsigned int taper_chg:1;    //taper charging
		 unsigned int wdt_timeout:1;  //WDT timeout
		 unsigned int input_ovlo:1;   //input OVLO
		 unsigned int input_uvlo:1;   //input UVLO
  } chg_stat; //charger status

  //flag of init
  char  inited;         //bit0: i2c inited, bit1: bat inited
  char suspend_flag;
  char  early_suspend_flag; //early suspend flag: 1: early_suspend, 0: normal
  char  wake_flag;      //wake lock flag:     1: lock,    0: no lock

  //online status
  char  ac_online;
  char  ac_online_tmp;  //ac online debounce, report tmp to AP
  char  usb_online;
  char  flight_mode;
  char  charger_changed;
  int   usb_current;    //max current provided by usb host
  int   read_again;     //gauge ic need some time to enter stable state
                        //after charger in/out, we need to read again to get correct state

  //i2c access error
  char  gagic_err;
  char  chgic_err;
};

#endif

struct qsd_bat_eng_data
{
  int cap;  //capacity
  int volt; //voltage
  int curr; //current
  int temp; //temperature
  struct {
		 unsigned int enable:1;       //enable
		 unsigned int overtemp:1;     //internal overtemp
		 unsigned int bat_temp_high:1;//battery temp high
		 unsigned int bat_temp_low:1; //battery temp low
		 unsigned int trick_chg:1;    //trick charging
		 unsigned int pre_chg:1;      //pre charging
		 unsigned int fast_chg:1;     //fast charging
		 unsigned int taper_chg:1;    //taper charging
		 unsigned int wdt_timeout:1;  //WDT timeout
		 unsigned int input_ovlo:1;   //input OVLO
		 unsigned int input_uvlo:1;   //input UVLO
  } chg_stat; //charger status

  int rm;   //remaining capacity
  int fcc;  //full charge capacity
  int flags;//gauge flags (0x????)
  struct {
    unsigned int snooze: 1;       //snooze state
    unsigned int ocv_gd: 1;       //Good OCV taken
    unsigned int vok:1;
    unsigned int qen:1;
    unsigned int wait_id: 1;      //Waiting to identify inserted battery
    unsigned int bat_det: 1;      //battery detected
    unsigned int soc1: 1;         //state-of-charge threshold 1 reached
    unsigned int socf: 1;         //state-of-charge threshold final reached

    unsigned int ac: 1;           //ac online
    unsigned int usb: 1;          //usb online
    unsigned int usb_ma: 3;       //0:0, 1:100: 2:500, 3:1000(USB Wall charger), other: no define
  } gag_stat;
};

#endif



