/*
 * Copyright (C) 2007 Google, Inc.
 * Copyright (c) 2008-2010, Code Aurora Forum. All rights reserved.
 * Author: Brian Swetland <swetland@google.com>
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *
 * The MSM peripherals are spread all over across 768MB of physical
 * space, which makes just having a simple IO_ADDRESS macro to slide
 * them into the right virtual location rough.  Instead, we will
 * provide a master phys->virt mapping for peripherals here.
 *
 */

#ifndef __ASM_ARCH_MSM_RESATRT_FLAG_H
#define __ASM_ARCH_MSM_RESATRT_FLAG_H

/*****************Leo Qin: reboot flags*****************/
/* Keep sync in 
  modem_proc/core/boot/secboot3/common/boot_sd_ramdump.h 
  & \kernel\arch\arm\mach-msm\include\mach\restart_flag.h 
  & lk/app/aboot/aboot.c */

/*Inform appsbl*/
#define FASTBOOT_MODE               0x77665500
#define NONE_MODE                   0x77665501
#define RECOVERY_MODE               0x77665502
#define ERASE_MODEM_ST              0x77665504

#define REBOOT_ALARM_MODE           0x77665510
#define REBOOT_PWRKEY_MODE          0x77665511
#define REBOOT_CHARGE_MODE          0x77665512
#define REBOOT_FT_TEST_MODE         0x77665513
#define REBOOT_MODESEL_MODE         0x77665514
#define REBOOT_MODESEL_MODE1        0x77665515

/*Inform SBLx*/
#define REBOOT_RAMDUMP_MODE         0xffffff00
#define REBOOT_EMERGENCY_DLOAD_MODE 0x7766aa00
#define REBOOT_MODEM_RAMDUMPS_MODE  0x7766aa01
#define REBOOT_KERNEL_RAMDUMPS_MODE 0x7766aa02
#define REBOOT_RAMDUMPS_MODE_PRE    0x7766aa07
#define REBOOT_RAMDUMPS_MODE        0x7766aa08
#define REBOOT_RAMDUMPS_MODE_2      0x7766aa09
#define REBOOT_RAMDUMPED_MODE       0x7766aa0A
#define REBOOT_DLOAD_MODE           0x7766aa0B

/*Error handler*/
#define FASTBOOT_DBG_MASK           0xffffff00
#define FASTBOOT_DBG_MODE           0x7766dd00
#define FASTBOOT_DBGED_MODE         0x7766ee00
/****************reboot flags*************************/
#endif
