/*  drivers/input/keyboard/ata2538_capkey.c
*  20110415 Star Cheng, add New ATA2538_capkey.c for Cap Key in Orange project 
*/

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/input.h>
#include <linux/platform_device.h>
#include <linux/jiffies.h>
#include <linux/io.h>
#include <linux/uaccess.h>
#include <linux/miscdevice.h>
#include <linux/i2c.h>
#include <linux/semaphore.h>
#include <linux/delay.h>
#include <linux/slab.h>
#ifdef   CONFIG_HAS_EARLYSUSPEND
#include <linux/earlysuspend.h>
#endif
#include <linux/time.h>
#include <linux/mutex.h>
#include <mach/vreg.h>

#include <mach/ATA2538_capkey.h>

#include <linux/pmic8058-othc.h>
#include <linux/mfd/pmic8901.h>
#include <linux/mfd/pmic8058.h>
#include <linux/regulator/pmic8058-regulator.h>
#include <linux/regulator/pmic8901-regulator.h>
#include <linux/regulator/consumer.h>
#include <linux/regulator/machine.h>
#include <linux/gpio.h>
#include <linux/gpio/gpio_def.h>
#include <linux/hrtimer.h>
#include <mach/hw_id.h>

#define CAPKEY_RETRY_COUNT    5
#define ADDR_DIM_START 0x3B
#define ADDR_DIMMING_EN 0x3C
#define ADDR_DIM_2_CONTORL 0x33
#define ADDR_DIM_3_CONTORL 0x34

#define DEFAULT_BRIGHTNESS 0x3f
#define MAX_BRIGHTNESS 0x3f
#define MIN_BRIGHTNESS 0x01

//Debug_LEVEL
static int DLL=5;
module_param_named( 
	DLL, DLL,
	int, S_IRUGO | S_IWUSR | S_IWGRP
)

#define INFO_LEVEL  1
#define ERR_LEVEL   2
#define MY_INFO_PRINTK(level, fmt, args...) if(level <= DLL) printk( fmt, ##args);
#define PRINT_IN MY_INFO_PRINTK(4,"+++++%s++++ %d\n",__func__,__LINE__);
#define PRINT_OUT MY_INFO_PRINTK(4,"----%s---- %d\n",__func__,__LINE__);

#define CAPKEY_NUM 3
#define CAPKEY_ERR_CHECK_DELAY_MS 3000
#define CAPKEY_ERR_CHECK_MAX_PERMITTED_ERR  0
#define CAPKEY_ERR_CHECK_MAX_PERMITTED_DIFF 2

struct capkey_t {
	struct i2c_client        *client_4_i2c;    
	struct input_dev         *capkey_input;	
	struct input_dev         *keyarray_input;    
	int                      irq; //ISR number    
	int                      gpio_num; //GPIO number   
/*Orange EVT2 CR XXXX Jack W Lu 2011-09-03 Add for L1B vote, Power Consumption issue {*/
	int (*pm8901_l1b_init)(int on);
	int (*pm8901_l1b_vote_set)(int on);
/*Orange EVT2 CR XXXX Jack W Lu 2011-09-03 Add for L1B vote, Power Consumption issue }*/
	int                      gpio_rst; //GPIO reset    
	int                      open_count; //input device open count
	int                      capkey_suspended; //touchpad suspended    
	int                      misc_open_count; //misc device open count    
	struct delayed_work      capkey_work;     
	struct workqueue_struct  *capkey_wqueue;    
	uint32_t                 info_block_checksum;    
	uint32_t                 T6_config_checksum;    
	struct  mutex            mutex;	
	struct early_suspend     capkey_early_suspend; //CONFIG HAS EARLYSUSPEND	
	uint16_t                 atmel_x_max,atmel_y_max;	
	int                      fvs_mode_flag;  //verify press keypad is correct or not for FVS API	
	uint8_t                  i2c_addr;
	uint32_t                 VddId;	
	int                      PowerOn;	
	uint32_t                 capkey_powercut; //check if 3.3V turn on/off flag	
	uint8_t                  brightness; 
	struct hrtimer           debounce_timer;
	int                      debounce_time_ms;
	int                      keyPressed;
	int                      enableLog;
	struct delayed_work      err_check_work;     
	int                      err_count[CAPKEY_NUM];
	int                      enableErrCheck;
	int                      err_check_delay_ms;
};

static const struct i2c_device_id i2cata_capkey_idtable[] = {
	{ CAPKEY_DRIVER_NAME, 0 },
	{ }
};

static int __devinit capkey_probe(struct i2c_client *client, const struct i2c_device_id *id);

MODULE_DEVICE_TABLE(i2c, i2cata_capkey_idtable);

static struct i2c_driver ata_capkey_driver = {
	.driver	 = {
		.name   = CAPKEY_DRIVER_NAME,
		.owner	= THIS_MODULE,
	},
	.probe	  = capkey_probe,
	.id_table = i2cata_capkey_idtable,
};

//for EVT2/3

#ifdef CONFIG_MACH_EVT2

static uint8_t* init_data_alpha;
static uint8_t* init_data_burst;

/*5inchRegister_test9_2_7.txt*/
static uint8_t init_data_alpha_dvt[] = {
	0x0c, // PA0_ALPHA0 addr:0x00 
	0x0c, // PA0_ALPHA1 addr:0x01
	0x0c, // PA0_ALPHA2 addr:0x02
	0x06, // PA0_ALPHA3 addr:0x03(Back)
	0x08, // PA0_ALPHA4 addr:0x04(home)
	0x07, // PA0_ALPHA5 addr:0x05(menu)
	0x0c, // PA0_ALPHA6 addr:0x06
	0x0c  // PA0_ALPHA7 addr:0x07
};
 
static uint8_t init_data_burst_dvt[] = {
	0x7f, //00 ADDR_REFERENCE_DELAY addr: 0x08
	0x00, //01 ADDR_BETA addr: 0x09
	0x80, //02 ADDR_AIC_WAIT addr: 0x0A
	0x70, //03 ADDR_STRENGTH_THRESHOLD0 addr: 0x0B
	0x70, //04 ADDR_STRENGTH_THRESHOLD1 addr: 0x0C
	0x70, //05 ADDR_STRENGTH_THRESHOLD2 addr: 0x0D
	0x64, //06 ADDR_STRENGTH_THRESHOLD3 addr: 0x0E
	0x64, //07 ADDR_STRENGTH_THRESHOLD4 addr: 0x0F
	0x64, //08 ADDR_STRENGTH_THRESHOLD5 addr: 0x10
	0x70, //09 ADDR_STRENGTH_THRESHOLD6 addr: 0x11
	0x70, //10 ADDR_STRENGTH_THRESHOLD7 addr: 0x12
	0x02, //11 ADDR_FEATURE_SELECTOR addr: 0x13
	0x7d, //12 ADDR_INTEGRATION_TIME addr: 0x14
	0x1c, //13 ADDR_IDLE_Time addr: 0x15
	0x20, //14 ADDR_CONTROL_1 addr: 0x16
	0x80, //15 ADDR_CONTROL_2 addr: 0x17
	0x00, //16 ADDR_PA_DATA addr: 0x18
	0x0f, //17 ADDR_GPIO_DATA addr: 0x19
	0x00, //18 ADDR_PA_DIR addr: 0x1A
	0x00, //19 ADDR_GPIO_DIR addr: 0x1B
	0xc7, //20 ADDR_PA_CONFIGURATION addr: 0x1C
	0x0f, //21 ADDR_GPIO_CONFIGURATION addr: 0x1D
	0x80, //0x30, //22 ADDR_CAL_INTERVAL addr: 0x1E
	0x7e, //0xFE, //23 ADDR_INT_MASK addr: 0x1F
	0x00, //24 ADDR_INT_CLEAR addr: 0x20
	0x00, //25 ADDR_PA_EINT_EN addr: 0x21
	0x00, //26 ADDR_GPIO_EINT_EN addr: 0x22
	0x05, //27 ADDR_FILTER_PERIOD addr: 0x23
	0x04, //28 ADDR_FILTER_THRESHOLD addr: 0x24
	0x00, //29 ADDR_CONTROL_3 addr: 0x25
	0x7e, //30 ADDR_EDGE_EN addr: 0x26
	0x0a, //31 ADDR_BOUNCE_PERIOD addr: 0x27?
	0xff, //0xFF //31 ADDR_BOUNCE_PERIOD addr: 0x28?
	0x55, //33 ADDR_R_SEL_0_3 addr: 0x29
	0x55, //34 ADDR_R_SEL_4_7 addr: 0x2A
	0x02, //35 ADDR_R_SEL_REF addr: 0x2B
	0x00, //36 ADDR_BETA_DISABLE addr: 0x2C
	0x00, //37 ADDR_DIM_PERIOD_1_0 addr: 0x2D
	0x00, //38 ADDR_DIM_PERIOD_3_2 addr: 0x2E
	0x00, //39 ADDR_DIM_PERIOD_5_4 addr: 0x2F
	0x00, //40 ADDR_DIM_PERIOD_7_6 addr: 0x30
	0x00, //41 ADDR_DIM_0_CONTORL addr: 0x31
	0x00, //42 ADDR_DIM_1_CONTORL addr: 0x32
	0x00, //43 ADDR_DIM_2_CONTORL addr: 0x33
	0x00, //44 ADDR_DIM_3_CONTORL addr: 0x34
	0x00, //45 ADDR_DIM_4_CONTORL addr: 0x35
	0x00, //46 ADDR_DIM_5_CONTORL addr: 0x36
	0x00, //47 ADDR_DIM_6_CONTORL addr: 0x37
	0x00, //48 ADDR_DIM_7_CONTORL addr: 0x38
	0x00, //49 ADDR_DIM_MODE_3_2_1_0 addr: 0x39
	0x00, //50 ADDR_DIM_MODE_7_6_5_4 addr: 0x3A
	0x00, //51 ADDR_DIM_START addr: 0x3B
	0x00 //52 ADDR_DIMMING_EN addr: 0x3C
};
/*5inchRegister_test9_2_7.txt*/
static uint8_t init_data_alpha_evt[] = {
	0x0c, // PA0_ALPHA0 addr:0x00 
	0x0c, // PA0_ALPHA1 addr:0x01
	0x0c, // PA0_ALPHA2 addr:0x02
	0x07, // PA0_ALPHA3 addr:0x03(Back)
	0x0a, // PA0_ALPHA4 addr:0x04(home)
	0x08, // PA0_ALPHA5 addr:0x05(menu)
	0x0c, // PA0_ALPHA6 addr:0x06
	0x0c  // PA0_ALPHA7 addr:0x07
};
 
static uint8_t init_data_burst_evt[] = {
	0x7f, //00 ADDR_REFERENCE_DELAY addr: 0x08
	0x00, //01 ADDR_BETA addr: 0x09
	0x80, //02 ADDR_AIC_WAIT addr: 0x0A
	0x70, //03 ADDR_STRENGTH_THRESHOLD0 addr: 0x0B
	0x70, //04 ADDR_STRENGTH_THRESHOLD1 addr: 0x0C
	0x70, //05 ADDR_STRENGTH_THRESHOLD2 addr: 0x0D
	0x64, //06 ADDR_STRENGTH_THRESHOLD3 addr: 0x0E
	0x64, //07 ADDR_STRENGTH_THRESHOLD4 addr: 0x0F
	0x64, //08 ADDR_STRENGTH_THRESHOLD5 addr: 0x10
	0x70, //09 ADDR_STRENGTH_THRESHOLD6 addr: 0x11
	0x70, //10 ADDR_STRENGTH_THRESHOLD7 addr: 0x12
	0x02, //11 ADDR_FEATURE_SELECTOR addr: 0x13
	0x7d, //12 ADDR_INTEGRATION_TIME addr: 0x14
	0x1c, //13 ADDR_IDLE_Time addr: 0x15
	0x20, //14 ADDR_CONTROL_1 addr: 0x16
	0x80, //15 ADDR_CONTROL_2 addr: 0x17
	0x00, //16 ADDR_PA_DATA addr: 0x18
	0x0f, //17 ADDR_GPIO_DATA addr: 0x19
	0x00, //18 ADDR_PA_DIR addr: 0x1A
	0x00, //19 ADDR_GPIO_DIR addr: 0x1B
	0xc7, //20 ADDR_PA_CONFIGURATION addr: 0x1C
	0x0f, //21 ADDR_GPIO_CONFIGURATION addr: 0x1D
	0x80, //0x30, //22 ADDR_CAL_INTERVAL addr: 0x1E
	0x7e, //0xFE, //23 ADDR_INT_MASK addr: 0x1F
	0x00, //24 ADDR_INT_CLEAR addr: 0x20
	0x00, //25 ADDR_PA_EINT_EN addr: 0x21
	0x00, //26 ADDR_GPIO_EINT_EN addr: 0x22
	0x05, //27 ADDR_FILTER_PERIOD addr: 0x23
	0x04, //28 ADDR_FILTER_THRESHOLD addr: 0x24
	0x00, //29 ADDR_CONTROL_3 addr: 0x25
	0x7e, //30 ADDR_EDGE_EN addr: 0x26
	0x0a, //31 ADDR_BOUNCE_PERIOD addr: 0x27?
	0xff, //0xFF //31 ADDR_BOUNCE_PERIOD addr: 0x28?
	0x55, //33 ADDR_R_SEL_0_3 addr: 0x29
	0x55, //34 ADDR_R_SEL_4_7 addr: 0x2A
	0x01, //35 ADDR_R_SEL_REF addr: 0x2B
	0x00, //36 ADDR_BETA_DISABLE addr: 0x2C
	0x00, //37 ADDR_DIM_PERIOD_1_0 addr: 0x2D
	0x00, //38 ADDR_DIM_PERIOD_3_2 addr: 0x2E
	0x00, //39 ADDR_DIM_PERIOD_5_4 addr: 0x2F
	0x00, //40 ADDR_DIM_PERIOD_7_6 addr: 0x30
	0x00, //41 ADDR_DIM_0_CONTORL addr: 0x31
	0x00, //42 ADDR_DIM_1_CONTORL addr: 0x32
	0x00, //43 ADDR_DIM_2_CONTORL addr: 0x33
	0x00, //44 ADDR_DIM_3_CONTORL addr: 0x34
	0x00, //45 ADDR_DIM_4_CONTORL addr: 0x35
	0x00, //46 ADDR_DIM_5_CONTORL addr: 0x36
	0x00, //47 ADDR_DIM_6_CONTORL addr: 0x37
	0x00, //48 ADDR_DIM_7_CONTORL addr: 0x38
	0x00, //49 ADDR_DIM_MODE_3_2_1_0 addr: 0x39
	0x00, //50 ADDR_DIM_MODE_7_6_5_4 addr: 0x3A
	0x00, //51 ADDR_DIM_START addr: 0x3B
	0x00 //52 ADDR_DIMMING_EN addr: 0x3C
};

#elif defined (CONFIG_MACH_EVT1)
static uint8_t init_data_alpha[] = {
	0x12, // PA0_ALPHA0 addr:0x00 
	0x12, // PA0_ALPHA1 addr:0x01
	0x12, // PA0_ALPHA2 addr:0x02
	0x4, // PA0_ALPHA3 addr:0x03
	0x6, // PA0_ALPHA4 addr:0x04
	0x4, // PA0_ALPHA5 addr:0x05
	0x12, // PA0_ALPHA6 addr:0x06
	0x12  // PA0_ALPHA7 addr:0x07
};

static uint8_t init_data_burst[] = {
	0x6f, //00 ADDR_REFERENCE_DELAY addr: 0x08
	0x04, //01 ADDR_BETA addr: 0x09
	0x27, //02 ADDR_AIC_WAIT addr: 0x0A
	0x64, //03 ADDR_STRENGTH_THRESHOLD0 addr: 0x0B
	0x64, //04 ADDR_STRENGTH_THRESHOLD1 addr: 0x0C
	0x64, //05 ADDR_STRENGTH_THRESHOLD2 addr: 0x0D
	0x64, //06 ADDR_STRENGTH_THRESHOLD3 addr: 0x0E
	0x64, //07 ADDR_STRENGTH_THRESHOLD4 addr: 0x0F
	0x64, //08 ADDR_STRENGTH_THRESHOLD5 addr: 0x10
	0x64, //09 ADDR_STRENGTH_THRESHOLD6 addr: 0x11
	0x64, //10 ADDR_STRENGTH_THRESHOLD7 addr: 0x12
	0x04, //11 ADDR_FEATURE_SELECTOR addr: 0x13
	0xff, //12 ADDR_INTEGRATION_TIME addr: 0x14
	0x1c, //13 ADDR_IDLE_Time addr: 0x15
	0x80, //14 ADDR_CONTROL_1 addr: 0x16
	0x80, //15 ADDR_CONTROL_2 addr: 0x17
	0x00, //16 ADDR_PA_DATA addr: 0x18
	0x0f, //17 ADDR_GPIO_DATA addr: 0x19
	0x00, //18 ADDR_PA_DIR addr: 0x1A
	0x00, //19 ADDR_GPIO_DIR addr: 0x1B
	0xc7, //20 ADDR_PA_CONFIGURATION addr: 0x1C
	0x0f, //21 ADDR_GPIO_CONFIGURATION addr: 0x1D
	0x60, //0x30, //22 ADDR_CAL_INTERVAL addr: 0x1E
	0x7e, //0xFE, //23 ADDR_INT_MASK addr: 0x1F
	0x00, //24 ADDR_INT_CLEAR addr: 0x20
	0x00, //25 ADDR_PA_EINT_EN addr: 0x21
	0x00, //26 ADDR_GPIO_EINT_EN addr: 0x22
	0x00, //27 ADDR_FILTER_PERIOD addr: 0x23
	0x01, //28 ADDR_FILTER_THRESHOLD addr: 0x24
	0x00, //29 ADDR_CONTROL_3 addr: 0x25
	0x7e, //30 ADDR_EDGE_EN addr: 0x26
	0x0a, //31 ADDR_BOUNCE_PERIOD addr: 0x27	
	0xff, //0xFF //31 ADDR_BOUNCE_PERIOD addr: 0x28	
	0x00, //33 ADDR_R_SEL_0_3 addr: 0x29
	0x00, //34 ADDR_R_SEL_4_7 addr: 0x2A
	0x03, //35 ADDR_R_SEL_REF addr: 0x2B
	0x00, //36 ADDR_BETA_DISABLE addr: 0x2C
	0x00, //37 ADDR_DIM_PERIOD_1_0 addr: 0x2D
	0x11, //38 ADDR_DIM_PERIOD_3_2 addr: 0x2E
	0x00, //39 ADDR_DIM_PERIOD_5_4 addr: 0x2F
	0x00, //40 ADDR_DIM_PERIOD_7_6 addr: 0x30
	0x00, //41 ADDR_DIM_0_CONTORL addr: 0x31
	0x00, //42 ADDR_DIM_1_CONTORL addr: 0x32
	DEFAULT_BRIGHTNESS, //43 ADDR_DIM_2_CONTORL addr: 0x33
	DEFAULT_BRIGHTNESS, //44 ADDR_DIM_3_CONTORL addr: 0x34
	0x00, //45 ADDR_DIM_4_CONTORL addr: 0x35
	0x00, //46 ADDR_DIM_5_CONTORL addr: 0x36
	0x00, //47 ADDR_DIM_6_CONTORL addr: 0x37
	0x00, //48 ADDR_DIM_7_CONTORL addr: 0x38
	0xf0, //49 ADDR_DIM_MODE_3_2_1_0 addr: 0x39
	0x00, //50 ADDR_DIM_MODE_7_6_5_4 addr: 0x3A
	0x00, //51 ADDR_DIM_START addr: 0x3B
	0x0c //52 ADDR_DIMMING_EN addr: 0x3C
};
#endif

static struct capkey_t         *g_ck;

int  capkey_LED_power_switch(int on);
static int capkey_detect_ATA2538(struct capkey_t *g_ck);
static int capkey_config_gpio(struct capkey_t *g_ck);
static int capkey_config_ATA2538(struct capkey_t *g_ck);

static int capkey_write_i2c( struct i2c_client *client,
               uint8_t           regBuf,
               uint8_t           *dataBuf,
               uint8_t           dataLen )
{
	int     result;
	uint8_t *buf = NULL;

	struct  i2c_msg msgs[] = { 
		[0] = {
			.addr   = g_ck->i2c_addr,
			.flags  = 0,
			.buf    = (void *)buf,
			.len    = 0
		}
	};

	buf = kzalloc( dataLen+sizeof(regBuf), GFP_KERNEL );
	if( NULL == buf )
	{
		printk("[Star], ATA2538 capkey_write_i2c alloc memory fail \n");
		return -EFAULT;
	}

	buf[0] = (uint8_t)(regBuf & 0xFF);
	
	memcpy( &buf[1], dataBuf, dataLen );
	
	msgs[0].buf = buf;
	msgs[0].len = dataLen+sizeof(regBuf);
	
	result = i2c_transfer( client->adapter, msgs, ARRAY_SIZE(msgs));
	
	if( result != ARRAY_SIZE(msgs) )
	{
		//MY_INFO_PRINTK( 2,"ERROR_LEVELG""touchpad_write_i2c: write 0x%x 0x%x %d bytes return failure, %d\n", result, buf[0], buf[1], dataLen );
		printk("[Star], ATA2538 capkey_write_i2c i2c_transfer fail \n");
		kfree( buf );
		return result;
	}
	kfree(buf);
	
	return 0;

}

static int capkey_read_i2c( struct i2c_client *client,
              uint8_t           regBuf,
              uint8_t           *dataBuf,
              uint8_t           dataLen )
{
	int     result;    
	struct  i2c_msg msgs[] = {         
		[0] = {            
			.addr   = g_ck->i2c_addr,            
			.flags  = 0,                  
			.buf    = (void *)&regBuf,            
			.len    = sizeof(regBuf)        
		},        
		[1] = {                                 
			.addr   = g_ck->i2c_addr,            
			.flags  = I2C_M_RD,            
			.buf    = (void *)dataBuf,            
			.len    = dataLen        
		}    
	};    
	
	result = i2c_transfer( client->adapter, msgs, ARRAY_SIZE(msgs) );  
	
	if( result != ARRAY_SIZE(msgs) )    
	{        
		//MY_INFO_PRINTK( 2,"ERROR_LEVELG""read %Xh %d bytes return failure, %d\n", result, regBuf, dataLen );                
		return result;    
	}	    
	return 0;

}

static enum hrtimer_restart capkey_debounce_timer(struct hrtimer *timer)
{
//	unsigned long flags;

	if(g_ck->enableLog)
		printk("[capkey_debounce_timer],  keyPress, key is 0x%x.\n",g_ck->keyPressed);

//	spin_lock_irqsave(&cblpwrkey->lock, flags);
	input_report_key(g_ck->capkey_input, g_ck->keyPressed, 1);
	input_sync(g_ck->capkey_input);
//	spin_unlock_irqrestore(&cblpwrkey->lock, flags);

	return HRTIMER_NORESTART;
}

static void capkey_err_check_WorkHandler( struct work_struct *work )
{
	int  result = 0;
	uint8_t value[9];
	uint8_t data = 0x7F;
	uint8_t addr;
	int i, j = 0;
	
	if(g_ck->enableLog)
		printk("capkey_err_check_WorkHandler in\n");
		
	if(1)
	{
		mutex_lock(&g_ck->mutex);
		
		addr = ADD_PA0_ALPHA+3;
		result = capkey_read_i2c( g_ck->client_4_i2c, addr, &value[0], 3 );
		if (result)
		{
			MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_ALPHA!\n" );
			result = -EFAULT;
			mutex_unlock(&g_ck->mutex);
			return;
		}
				
		//read capkey IMPEDANCE
		result = capkey_read_i2c(g_ck->client_4_i2c, PA3_IMPEDANCE, &value[3], 3);
		if(result)
		{
			MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to read reg IMPEDANCE 0x%x and value failed 0x%x,\n", PA3_IMPEDANCE,value[0] );
			
			result = -EFAULT;
			mutex_unlock(&g_ck->mutex);
			return;
		}
		
		//read capkey REFERENCE IMPEDANCE
		result = capkey_read_i2c(g_ck->client_4_i2c, PA3_REFERENCE_IMPEDANCE, &value[6], 3);
		if(result)
		{
			MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to read reg REFERENCE IMPEDANCE 0x%x and value failed 0x%x,\n", PA3_REFERENCE_IMPEDANCE,value[0] );
			
			result = -EFAULT;
			mutex_unlock(&g_ck->mutex);
			return;
		}
		
		for ( i = 3 ; i < 9 ; i++ )
		{
			if ( i < 6)
			{
				value[i] = data - value[i];
				if(g_ck->enableLog)
					printk("read IMPEDANCE = %d\n",value[i] );
			}
			else
			{
				value[i] = data - value[i];
				if(g_ck->enableLog)
					printk("read Cal IMPEDANCE = %d\n",value[i] );
			}
		}
		
		for(i =0; i < CAPKEY_NUM; i++)
		{
			if( ( (value[i+6] - value[i+3]) > (value[i] + CAPKEY_ERR_CHECK_MAX_PERMITTED_DIFF) ) 
				|| ( (value[i+3] - value[i+6]) > (value[i] + CAPKEY_ERR_CHECK_MAX_PERMITTED_DIFF) ) )
			{
				g_ck->err_count[i] ++;
			}
			else
			{
				if(0 < g_ck->err_count[i])
					g_ck->err_count[i] --;
			}
			
			j |= (g_ck->err_count[i] > CAPKEY_ERR_CHECK_MAX_PERMITTED_ERR);
		}
		
		if(j)
		{
			for(i =0; i < CAPKEY_NUM; i++)
				g_ck->err_count[i] = 0;
	
			result = capkey_config_gpio(g_ck);		
			if (result)
			{
				printk("[Star], ATA2538 re capkey_config_gpio3 set GPIO fail \n");	
			}			
			// detect ata2538	
			result = capkey_detect_ATA2538(g_ck);			
			// config capkey
			result = capkey_config_ATA2538(g_ck);			
			//turn on LED light
			capkey_LED_power_switch(1);
			
			printk("\n!!!reset Capkey in err_check_timer !!! \n");
		}
		mutex_unlock(&g_ck->mutex);
	}
	
	if(g_ck->enableErrCheck)
	{
		if(!g_ck->capkey_suspended)
			queue_delayed_work(g_ck->capkey_wqueue, &g_ck->err_check_work, round_jiffies_relative(msecs_to_jiffies(g_ck->err_check_delay_ms)) );  
		if(g_ck->enableLog)
			printk("queue_delayed_work(g_ck->capkey_wqueue, &g_ck->err_check_work1 \n");
	}
	
	return;
}



static int capkey_config_ATA2538(struct capkey_t *g_ck)
{

	int i;	
	int result;    
	uint8_t value = 0xFF;	
	uint8_t data[ALPHA_SIZE];    
	uint8_t warm_reset_data = 0x01;  	    
	
	result = capkey_write_i2c(g_ck->client_4_i2c,ADDR_REG_CHECK,&value,1);  
	
	if( result )    
	{             
		printk("[Star], ATA2538 capkey_config_ATA2538 unable to write reg_check 0X%Xh = 0x%X  \n", ADDR_REG_CHECK, value);     
		return result;    
	}    

//init register PA0~PA7 Aplha    
for ( i = 0; i < ALPHA_SIZE ; i++ )    
{		
	data[0] = init_data_alpha[i];	
	
	result = capkey_write_i2c(g_ck->client_4_i2c,i,data,1);    	
	if ( result )    	
	{    		
		//MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to write reg_check 0X%Xh = 0x%x\n",i,data[0] );   
		printk("[Star], ATA2538 capkey_config_ATA2538 unable to write reg_check 0X%Xh = 0x%X  \n", i,data[0]);
		return result;	    	
	}		
	//MY_INFO_PRINTK( 4, "INFO_LEVEL:" "read 0x0%d = 0x%X\n",i, data[0] );    
}	    

//init other registers burst    
	for ( i = ALPHA_SIZE; i < TOTAL_REG_SIZE; i++ )    
	{	
		data[0]	= init_data_burst[i-ALPHA_SIZE];	
		
		if(i != ADDR_REG_CHECK)		
		{    		
			result = capkey_write_i2c(g_ck->client_4_i2c,i,data,1);    		
			if ( result )    		
			{    			
				//MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to write reg init_data_burst 0x%Xh = 0x%x\n",i,data[0] );        		        		
				return result;    		
			}	        
		}    	
	}        

	//setup warm reset    
	msleep(1);    
	
	result = capkey_write_i2c(g_ck->client_4_i2c,ADDR_WARM_RESET,&warm_reset_data,1);    
	if( result )    
	{        
		//MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to write reg warm reset 0xFFh, return %d\n", result );    
		printk("[Star], ATA2538 warm reset fail \n");
		return result;    
	}   
	msleep(10);    
	
	return result;

}


static int capkey_detect_ATA2538(struct capkey_t *g_ck)
{
	int result = 0;	
	
	uint8_t value[ALPHA_SIZE];    
	
	result = capkey_read_i2c(g_ck->client_4_i2c, ADD_PA0_ALPHA, &value[0], ALPHA_SIZE);	
	
	if( result && value[0] != INIT_ALPHA_VALUE )	
	{		
		//MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to read reg 0x00h and value failed 0x%x, return %d\n", value[0],result );		
		printk("[Star], unable to read reg 0x00h and value failed 0x%x, return %d\n", value[0],result);
		result = -EFAULT;		
		/*Leo Qin ?????*/
		//return result;	
	}		
	
	return 0;

}

static int capkey_test_ATA2538(struct capkey_t *g_ck)
{
	int result = 0;	
	
	uint8_t value[ALPHA_SIZE];    
	
	result = capkey_read_i2c(g_ck->client_4_i2c, ADD_PA0_ALPHA, &value[0], ALPHA_SIZE);	
	
	if( result || value[0] != init_data_alpha[0] )	
	{		
		printk(" unable to read reg 0x00h and return 0x%x, return %d\n", value[0],result);
		return -1;		
	}		
	
	return 0;

}


static int capkey_poweron_device(int OnOff)
{
	static struct regulator *vreg_ata;
	//static struct regulator *vreg_ata_ls;
	int     rc = 0;
	
	/*Leo Qin: adopt Orange L1B pm function*/
	if(g_ck->pm8901_l1b_init != NULL)
		return g_ck->pm8901_l1b_init(OnOff);
	else
		return -1;

	if (OnOff) 
	{
		//vreg_ata = regulator_get(NULL, "8901_l3");
		vreg_ata = regulator_get(NULL, "8901_l1"); // Orange from L3 to L1
		if (IS_ERR(vreg_ata)) 
		{
			pr_err("%s: unable to get vreg_ata\n", __func__);
			printk("[Star], ATA2538 regulator_get fail \n");
			return -1;
		}
		rc = regulator_set_voltage(vreg_ata, 3300000, 3300000);
		if (rc) 
		{
			pr_err("%s: regulator_set_voltage() = %d\n",
			__func__, rc);
			printk("[Star], ATA2538 regulator_set_voltage fail \n");
			goto exit_power_switch;
		}
		if (regulator_enable(vreg_ata)) 
		{
			pr_err("%s: Unable to enable the regulator:"
				" vreg_ata\n", __func__);
			printk("[Star], ATA2538 regulator_enable fail \n");
			return -1;
		}

	} 
	else
	{
		if (regulator_disable(vreg_ata))
		pr_err("%s: Unable to enable the regulator:"" vreg_ata\n", __func__);
		regulator_put(vreg_ata);
	}

exit_power_switch:

	return rc;
}

static int capkey_setup_gpio(void)
{
	int rc=0;
	int i=0;
	
	struct pm8058_gpio_cfg {
	int 			   gpio;
	struct pm8058_gpio cfg;
	};
	
	struct pm8058_gpio_cfg gpio_cfgs[] = {	
		{ /* Touch RST */
			26, // PMIC_GPIO27
			{
				.direction	= PM_GPIO_DIR_OUT,
				.output_value	= 1,
				.output_buffer	= PM_GPIO_OUT_BUF_CMOS,
				.pull		= PM_GPIO_PULL_DN,
				.out_strength	= PM_GPIO_STRENGTH_HIGH,
				.function	= PM_GPIO_FUNC_NORMAL,
				.vin_sel	= PM_GPIO_VIN_L6,
				.inv_int_pol	= 0,
			}
		},
	
		{ /* Touch INT */
			32, // PMIC_GPIO33
			{
				.direction	= PM_GPIO_DIR_IN,
				.pull		= PM_GPIO_PULL_DN,
				.function	= PM_GPIO_FUNC_NORMAL,
				.vin_sel	=PM_GPIO_VIN_L6,
				.inv_int_pol	= 0,
			}
		}
	};

	rc = gpio_request( PM8058_GPIO_PM_TO_SYS(PM_GPIO_33), "ATA2538_capkey_irq" );
	rc = gpio_request( PM8058_GPIO_PM_TO_SYS(PM_GPIO_27), "ATA2538_capkey_rst" );

	for (i = 0; i < ARRAY_SIZE(gpio_cfgs); ++i) 
	{
		rc = pm8058_gpio_config(gpio_cfgs[i].gpio,&gpio_cfgs[i].cfg);
		if (rc < 0) {
			printk("[Star], capkey_setup_gpio \n");
		}
	}

	return rc;

}

static int capkey_config_gpio(struct capkey_t *g_ck)
{
	int rc=0;
	
	gpio_set_value_cansleep(g_ck->gpio_rst, 0);
	msleep(1);
	gpio_set_value_cansleep(g_ck->gpio_rst, 1);
	
	gpio_tlmm_config(GPIO_CFG(43, 1, GPIO_CFG_OUTPUT, GPIO_CFG_PULL_UP, GPIO_CFG_10MA), GPIO_CFG_ENABLE);// TOUCH_I2C_Data
	gpio_tlmm_config(GPIO_CFG(44, 1, GPIO_CFG_OUTPUT, GPIO_CFG_PULL_UP, GPIO_CFG_10MA), GPIO_CFG_ENABLE);// TOUCH_I2C_Clk
	
	msleep(100); 
	
	return rc;

}

static void capkey_irqWorkHandler( struct work_struct *work )
{	
	uint8_t value;
	//uint32_t pinValue;

	int keyCount = 0;
	uint8_t keyValues = 0;
		
	struct sched_param s = { .sched_priority = 1 };
	
	if(!rt_task(current))
	{
		if(sched_setscheduler_nocheck(current, SCHED_FIFO, &s)!=0)
		{
			MY_INFO_PRINTK( 1, "TEST_INFO_LEVELG" "fail to set rt pri...\n" );
		}
		else
		{
			MY_INFO_PRINTK( 1, "TEST_INFO_LEVELG" "set rt pri...\n" );
		}
	}
	
	mutex_lock(&g_ck->mutex);
	do
	{
		capkey_read_i2c(g_ck->client_4_i2c, PA_TOUCH_BYTE, &value, 1);

/*Leo Qin: temporary modification, put it in config data later.*/		
		if(g_ck->enableLog)
			printk("[capkey_irqWorkHandler], value is 0x%x, keyPressed is 0x%x.\n",value,g_ck->keyPressed);
		
		if(value & (0x08 | 0x10 | 0x20))
		{
#ifdef CONFIG_MACH_EVT2
			if(value & 0x08)
			{
				g_ck->keyPressed = KEY_BACK;
			}
			else if(value & 0x10)
			{
				g_ck->keyPressed = KEY_HOME;
			}
#elif defined (CONFIG_MACH_EVT1)
			if(value & 0x08)
			{
				g_ck->keyPressed = KEY_HOME;
			}
			else if(value & 0x10)
			{
				g_ck->keyPressed = KEY_BACK;
			}
#endif
			else if(value & 0x20)
			{
				g_ck->keyPressed = KEY_MENU;
			}
			
			keyCount ++;
			keyValues |= value;
		}
			
	}while( gpio_get_value_cansleep(g_ck->gpio_num) == 1 );
	
	if(1 == keyCount)
	{
	
		if(g_ck->enableLog)
			printk("[capkey_irqWorkHandler],  g_ck->keyPressed, key is 0x%x.\n",g_ck->keyPressed);
//		input_report_key(g_ck->capkey_input, g_ck->keyPressed, 1);
//		input_sync(g_ck->capkey_input);

		hrtimer_cancel(&g_ck->debounce_timer);
		if(g_ck->enableLog)
			printk("[cancel_timer]\n");
		hrtimer_start(&g_ck->debounce_timer,
				ktime_set(g_ck->debounce_time_ms / 1000,
				(g_ck->debounce_time_ms % 1000) * 1000000),
				HRTIMER_MODE_REL);
		if(g_ck->enableLog)
			printk("[start_timer]\n");
	}
	else
	{
		if(g_ck->keyPressed)
		{
			if(g_ck->enableLog)
				printk("[capkey_irqWorkHandler],  keyRelease1, key is 0x%x.\n",g_ck->keyPressed);
			hrtimer_cancel(&g_ck->debounce_timer);
			if(g_ck->enableLog)
				printk("[cancel_timer]\n");
			input_report_key(g_ck->capkey_input, g_ck->keyPressed, 0);
			input_sync(g_ck->capkey_input);
		}
		g_ck->keyPressed = 0;
	}
				
	//enalbe interrupts;
	enable_irq(g_ck->irq ); 
	if(g_ck->enableLog)
		printk("[enable_irq]\n");                                                                                                                                                                  
	mutex_unlock(&g_ck->mutex);
	
	return;	
}	

static irqreturn_t capkey_irqHandler(int irq, void *dev_id)
{    

	disable_irq_nosync(irq); 
	if(g_ck->enableLog)
		printk("[disable_irq_nosync]\n");                                                                                                                                                                  
	queue_delayed_work(g_ck->capkey_wqueue, &g_ck->capkey_work, 0);    
	
	return IRQ_HANDLED;
}

int  capkey_LED_power_switch(int on)
{     	
	int result = 0;
	uint8_t value;
	
	if (on) // turn on capkey LED light
	{
		value = 0x00;
	}
	else //turn off capkey LED light
	{
		value = 0x0c;
	} 

	result = capkey_write_i2c(g_ck->client_4_i2c,0x19/*ADDR_GPIO_DATA*/,&value,1);
		
	return result;    
}


#define RESTORE_LOCK_INT		{enable_irq(g_ck->irq);	mutex_unlock(&g_ck->mutex);}

static long ck_misc_ioctl( struct file *fp,
                 unsigned int cmd,
                 unsigned long arg )
{	
	
	int  result = 0;
	uint8_t value[9];
	uint8_t data = 0x7F;
	uint8_t addr;
	int i;
	struct capkey_alpha_t alpha;
	
	uint8_t *pData = NULL;
	uint    length = 0;
	
	switch(cmd)
	{
		case ATA_CAPKEY_IOCTL_GET_SENSOR_VALUE:
			mutex_lock(&g_ck->mutex);
			//read capkey strength
			result = capkey_read_i2c(g_ck->client_4_i2c, PA3_STRENGTH , &value[0], 3);
			if(result)
			{
				MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to read reg STRENGTH 0x%x and value failed 0x%x,\n", PA3_STRENGTH,value[0] );
				
				result = -EFAULT;
				mutex_unlock(&g_ck->mutex);
				return result;
			}
	
			//read capkey IMPEDANCE
			result = capkey_read_i2c(g_ck->client_4_i2c, PA3_IMPEDANCE, &value[3], 3);
			if(result)
			{
				MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to read reg IMPEDANCE 0x%x and value failed 0x%x,\n", PA3_IMPEDANCE,value[0] );
				
				result = -EFAULT;
				mutex_unlock(&g_ck->mutex);
				return result;
			}
			
			//read capkey REFERENCE IMPEDANCE
			result = capkey_read_i2c(g_ck->client_4_i2c, PA3_REFERENCE_IMPEDANCE, &value[6], 3);
			if(result)
			{
				MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to read reg REFERENCE IMPEDANCE 0x%x and value failed 0x%x,\n", PA3_REFERENCE_IMPEDANCE,value[0] );
				
				result = -EFAULT;
				mutex_unlock(&g_ck->mutex);
				return result;
			}
			mutex_unlock(&g_ck->mutex);
			
			for ( i = 3 ; i < 9 ; i++ )
			{
				if ( i < 6)
				{
					value[i] = data - value[i];
				}
				else
				{
					value[i] = data - value[i];
				}
			}
			
			result = copy_to_user( (void *)arg,&value[0],9 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy GET_SENSOR_VALUE to user failed!\n" );
				result = -EFAULT;
				return result;
			}
		break;
		case ATA_CAPKEY_IOCTL_SET_ALPHA:
			addr = ADD_PA0_ALPHA+3;
			pData = (void *)&alpha;
			length = sizeof(alpha);
			if( copy_from_user( (void *)pData,(void *)arg,length) )
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy SET_ALPHA from user failed!\n" );
				result = -EFAULT;
				return result;
			}
			else
			{
				value[0] = alpha.PA3_value;
				value[1] = alpha.PA4_value;
				value[2] = alpha.PA5_value;
				value[3] = alpha.reference_delay;
				mutex_lock(&g_ck->mutex);
				result = capkey_write_i2c( g_ck->client_4_i2c, addr, &value[0], 3 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_ALPHA!\n" );
					result = -EFAULT;
					mutex_unlock(&g_ck->mutex);
					return result;
				}
				addr = ADD_PA0_ALPHA+8;
				result = capkey_write_i2c( g_ck->client_4_i2c, addr, &value[3], 1 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_ALPHA!\n" );
					result = -EFAULT;
					mutex_unlock(&g_ck->mutex);
					return result;
				}
				mutex_unlock(&g_ck->mutex);
			}
		break;
		case ATA_CAPKEY_IOCTL_GET_ALPHA:
			addr = ADD_PA0_ALPHA+3;
			mutex_lock(&g_ck->mutex);
			result = capkey_read_i2c( g_ck->client_4_i2c, addr, &value[0], 3 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_ALPHA!\n" );
				result = -EFAULT;
				mutex_unlock(&g_ck->mutex);
				return result;
			}
			addr = ADD_PA0_ALPHA+8;
			result = capkey_read_i2c( g_ck->client_4_i2c, addr, &value[3], 1 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_ALPHA!\n" );
				result = -EFAULT;
				mutex_unlock(&g_ck->mutex);
				return result;
			}
			mutex_unlock(&g_ck->mutex);
			result = copy_to_user( (void *)arg,&value[0],4 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy GET_ALPHA to user failed!\n" );
				result = -EFAULT;
				return result;
			}
		break;
/*Qisda, alan.p.xu, 2012.2.9, calibration capkey{*/
		case ATA_CAPKEY_IOCTL_CONFIG:
		{
			int i;	
			int result;    
			uint8_t value = 0xFF;	    
			uint8_t warm_reset_data = 0x01; 
			struct capkey_config capkey_regvalue; 
  
			if(copy_from_user((void *)(&capkey_regvalue), (void *)arg, TOTAL_REG_SIZE))
			{ 
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy from user failed!\n" );
				result = -EFAULT;
				return result;
			}	 
     	
			mutex_lock(&g_ck->mutex);
			disable_irq_nosync(g_ck->irq);
	
			result = capkey_write_i2c(g_ck->client_4_i2c,ADDR_REG_CHECK,&value,1);  
			if( result )    
			{             
				printk("ioctl capkey config reg_check fail\n"); 
				RESTORE_LOCK_INT
				return result;    
			}    
  
			for ( i = 0; i < ALPHA_SIZE ; i++ )    
			{		
				value = capkey_regvalue.value[i];	
				init_data_alpha[i] = capkey_regvalue.value[i];
				result = capkey_write_i2c(g_ck->client_4_i2c, i, &value, 1);    	
				if ( result )    	
				{    		 
					printk("ioctl capkey config %d register fail\n",i);
					RESTORE_LOCK_INT
					return result;	    	
				}	 
			}	    
   
			for ( i = ALPHA_SIZE; i < TOTAL_REG_SIZE; i++ )    
			{	
				value	= capkey_regvalue.value[i];	
				init_data_burst[i-ALPHA_SIZE] = capkey_regvalue.value[i];
				if(i != ADDR_REG_CHECK)		
				{    		
					result = capkey_write_i2c(g_ck->client_4_i2c, i, &value, 1);    		
					if ( result )    		
					{    			
						printk("ioctl capkey config %d register fail\n",i);
						RESTORE_LOCK_INT		        		
						return result;    		
					}	        
				}    	
			}        
  
			msleep(1);    
	
			result = capkey_write_i2c(g_ck->client_4_i2c,ADDR_WARM_RESET,&warm_reset_data,1);    
			if( result )    
			{            
				printk("ioctl capkey warm reset fail \n");
				RESTORE_LOCK_INT
				return result;    
			}   
			msleep(10); 
  
			RESTORE_LOCK_INT
		}
		break;
		case ATA_CAPKEY_IOCTL_GET_CONFIG:
		{ 
			struct capkey_config capkey_regvalue;
			mutex_lock(&g_ck->mutex);
			for(i = 0; i < TOTAL_REG_SIZE; i++)
			{
				result = capkey_read_i2c(g_ck->client_4_i2c,i,&capkey_regvalue.value[i],1);
				if(result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "ioctl read capkey config failed!\n" );
					mutex_unlock(&g_ck->mutex); 
					return result;
				}
			}
			mutex_unlock(&g_ck->mutex);
			result = copy_to_user( (void *)arg,capkey_regvalue.value,TOTAL_REG_SIZE );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy regvalue to user failed!\n" );
				result = -EFAULT;
				return result;
			}
		}
		break;
		case ATA_CAPKEY_IOCTL_CALIBRATION_SENSOR_VALUE:
		{
			uint8_t cal;
			uint8_t data;
			uint8_t warm_reset_data = 0x01;
	    
			if(copy_from_user((void *)(&cal), (void *)arg, 1))
			{ 
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy from user failed!\n" );
				result = -EFAULT;
				return result;
			}
			mutex_lock(&g_ck->mutex);
			disable_irq_nosync(g_ck->irq);
			if(cal == 0)
			{
				data = 0x60;
				init_data_burst[0] = 0x60;
				result = capkey_write_i2c(g_ck->client_4_i2c, 0x08, &data, 1);
				if( result )    
				{             
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "ioctl calibration capkey failed!\n" );
					RESTORE_LOCK_INT
					return result;    
				} 
			}
			else{
				data = 0x01;
				init_data_burst[35] = 0x01;
				result = capkey_write_i2c(g_ck->client_4_i2c, 0x2b, &data, 1);
				if( result )    
				{             
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "ioctl calibration capkey failed!\n" );
					RESTORE_LOCK_INT
					return result;    
				} 
			}
		  
			msleep(1); 
			result = capkey_write_i2c(g_ck->client_4_i2c,ADDR_WARM_RESET,&warm_reset_data,1);    
			if( result )    
			{           
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "ioctl calibration capkey warm reset failed!\n" );
				RESTORE_LOCK_INT
				return result;    
			}   
			msleep(10);   
		  
			RESTORE_LOCK_INT
		}
		break; 
/*Qisda, alan.p.xu, 2012.2.9, calibration capkey}*/
	}
	
	return result;		
}

static char echostr[ECHOSTR_SIZE] = {0};
unsigned int enableKickdogLog = 0;
unsigned int enableBlockLog = 0;

static ssize_t ck_misc_write( struct file *fp,const char __user *buffer,size_t count,loff_t *ppos )
{
	int  result = 0;

	memset(echostr,0,ECHOSTR_SIZE);
	
	if ( count > ECHOSTR_SIZE )
	{
		MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "ts_misc_write: invalid count %d\n", count );
		return -EINVAL;
	}
	
	if ( copy_from_user(echostr,buffer,count) )
	{
		MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "copy Echo String from user failed: %s\n",echostr);
		return -EINVAL;
	}
	mutex_lock(&g_ck->mutex);

	echostr[count-1]='\0';
	MY_INFO_PRINTK( 4, "INFO_LEVEL:" "User Input Echo String : %s\n",echostr);

	if ( strcmp(echostr,"on" ) == 0 )
	{
		MY_INFO_PRINTK( 4, "INFO_LEVEL:" "User Input Echo String : %s\n",echostr);
		
		if(g_ck->capkey_suspended)
		{
			/*Leo Qin: adopt Orange L1B pm function*/
			if(g_ck->pm8901_l1b_vote_set != NULL)
				g_ck->pm8901_l1b_vote_set(1);	
			result = capkey_config_gpio(g_ck);		
			if (result)
			{
				printk("[Star], ATA2538 re capkey_config_gpio2 set GPIO fail \n");	
			}			
			// detect ata2538	
			result = capkey_detect_ATA2538(g_ck);			
			// config capkey
			result = capkey_config_ATA2538(g_ck);
		}
		capkey_LED_power_switch(1);
	}
	if ( strcmp(echostr,"useron" ) == 0 )
	{
		MY_INFO_PRINTK( 4, "INFO_LEVEL:" "User Input Echo String : %s\n",echostr);
		
		capkey_LED_power_switch(1);
	}
	else if ( strcmp(echostr,"off" ) == 0 )
	{
		MY_INFO_PRINTK( 4, "INFO_LEVEL:" "User Input Echo String : %s\n",echostr);
		capkey_LED_power_switch(0);
	}

	//check if enter deep sleep mode
	if (g_ck->capkey_suspended == 0)
	{
		if ( strcmp(echostr,"enter_test" ) == 0 )
		{
			MY_INFO_PRINTK( 4, "INFO_LEVEL:" "User Input Echo String : %s\n",echostr);
			g_ck->fvs_mode_flag = 1; //enter fvs mode
		}
		else if ( strcmp(echostr,"exit_test" ) == 0 )
		{
			MY_INFO_PRINTK( 4, "INFO_LEVEL:" "User Input Echo String : %s\n",echostr);
			g_ck->fvs_mode_flag = 0; //exit fvs mode
		}
/*Leo Qin: remove dimming control*/
#if 0
		else if ( strcmp(echostr,"brightness+" ) == 0 )
		{
			int result;   
			uint8_t value; 
			
			if(g_ck->brightness < MAX_BRIGHTNESS)
				g_ck->brightness ++;

			MY_INFO_PRINTK( 4, "INFO_LEVEL:" "User Input Echo String : %s, brightness : 0x%x \n",echostr,g_ck->brightness);
			value = g_ck->brightness;
	
			result = capkey_write_i2c(g_ck->client_4_i2c,ADDR_DIM_2_CONTORL,&value,1);
			result |= capkey_write_i2c(g_ck->client_4_i2c,ADDR_DIM_3_CONTORL,&value,1);
			if( result )
			{
				MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "setting brightness+ failed, result is 0x%X\n",result );
			}
			capkey_LED_power_switch(0);
			capkey_LED_power_switch(1);
		}
		else if ( strcmp(echostr,"brightness-" ) == 0 )
		{
			int result;   
			uint8_t value; 
			
			if(g_ck->brightness > MIN_BRIGHTNESS)
				g_ck->brightness --;

			MY_INFO_PRINTK( 4, "INFO_LEVEL:" "User Input Echo String : %s, brightness : 0x%x \n",echostr,g_ck->brightness);
			value = g_ck->brightness;
	
			result = capkey_write_i2c(g_ck->client_4_i2c,ADDR_DIM_2_CONTORL,&value,1);
			result |= capkey_write_i2c(g_ck->client_4_i2c,ADDR_DIM_3_CONTORL,&value,1);
			if( result )
			{
				MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "setting brightness- failed, result is 0x%X\n",result );
			}
			capkey_LED_power_switch(0);
			capkey_LED_power_switch(1);
		}
#endif
		/*Leo Qin: Observed that enableLog will make it easy that capkey become out-of-effect!!!*/
		else if ( strcmp(echostr,"enableLog" ) == 0 )
		{
			g_ck->enableLog = 1;
		}
		else if ( strcmp(echostr,"disableLog" ) == 0 )
		{
			g_ck->enableLog = 0;
		}	
		else if ( strcmp(echostr,"enableErrCheck" ) == 0 )
		{
			g_ck->enableErrCheck = 1;
			queue_delayed_work(g_ck->capkey_wqueue, &g_ck->err_check_work, round_jiffies_relative(msecs_to_jiffies(g_ck->err_check_delay_ms)));  	
			if(g_ck->enableLog)
				printk("queue_delayed_work(g_ck->capkey_wqueue, &g_ck->err_check_work \n");		
		}
		else if ( strcmp(echostr,"disableErrCheck" ) == 0 )
		{
			g_ck->enableErrCheck = 0;
		}	
		else if ( strcmp(echostr,"enableKickdogLog" ) == 0 )
		{
			enableKickdogLog = 1;
		}
		else if ( strcmp(echostr,"disableKickdogLog" ) == 0 )
		{
			enableKickdogLog = 0;
		}	
		else if ( strcmp(echostr,"enableBlockLog" ) == 0 )
		{
			enableBlockLog = 1;
		}
		else if ( strcmp(echostr,"disableBlockLog" ) == 0 )
		{
			enableBlockLog = 0;
		}	
		else
		{
			MY_INFO_PRINTK( 4, "INFO_LEVEL:" "User Input Echo String : %s, not supported.\n",echostr);		
		}
	}
	else
	{
		MY_INFO_PRINTK(4, "INFO_LEVEL:" "capkey in deep sleep mode and can't power switch LED light\n");
	}
	
	mutex_unlock(&g_ck->mutex);
	
	return count;    
}

static ssize_t ck_misc_read(struct file *filp, char __user *inbuf,
		size_t count, loff_t *offset)
{

	void __user *buf = (void __user *)inbuf;
	char tmp = 0;
	
	printk("%s, count=%d, echostr is %s.\n", __FUNCTION__, count,echostr);

	if ( strcmp(echostr,"chipID" ) == 0 ){
		if(!capkey_test_ATA2538(g_ck))
			tmp = 0xa5;
		else
			tmp = 0;
	}
	
	printk("%s, before copy_to_user, id is 0x%x.\n", __FUNCTION__ ,tmp);

	if (copy_to_user(buf, &tmp, sizeof(tmp))) {
		printk("%s : failed to copy to user space\n", __func__);

		return -EFAULT;
	}
	return sizeof(tmp);

}

static int capkey_open(struct input_dev *dev)
{
	int rc = 0;
	
	mutex_lock(&g_ck->mutex);
	if( g_ck->open_count == 0 )
	{
		g_ck->open_count++; //record opencount
		//MY_INFO_PRINTK( 4, "INFO_LEVEL:" "open count : %d\n",g_ck->open_count );      
	}	
	else
	{	
		printk("capkey open fail\n");//alan add
    rc = -EFAULT;
	}
	mutex_unlock(&g_ck->mutex);
	
	return rc;
}

static void capkey_close(struct input_dev *dev)
{
	mutex_lock(&g_ck->mutex);
	if( g_ck->open_count )
	{
		g_ck->open_count--;
		//MY_INFO_PRINTK( 4, "INFO_LEVEL:" "input device still opened %d times\n",g_ck->open_count );        
	}
	mutex_unlock(&g_ck->mutex);
}

static int ck_misc_release(struct inode *inode, struct file *fp)
{
	int result = 0;
	
	mutex_lock(&g_ck->mutex);
	if( g_ck->misc_open_count )
	{
		g_ck->misc_open_count--;      
	}
	mutex_unlock(&g_ck->mutex);
	
	return result;
}

static int ck_misc_open(struct inode *inode, struct file *fp)
{
	int result = 0;
	
	mutex_lock(&g_ck->mutex);
	if( g_ck->misc_open_count ==0 )
	{
		g_ck->misc_open_count++;
		//MY_INFO_PRINTK( 4, "INFO_LEVELG" "misc open count : %d\n",g_ck->misc_open_count );          
	}	
	else
	{ 
		result = -EFAULT;
		MY_INFO_PRINTK( 2, "ERROR_LEVELG" "failed to open misc count : %d\n",g_ck->misc_open_count );//alan add  
	}
	mutex_unlock(&g_ck->mutex);
	
	return result;
}

static struct file_operations ck_misc_fops = {
	.owner 	= THIS_MODULE,
	.open 	= ck_misc_open,
	.release = ck_misc_release,
	.write = ck_misc_write,
	.read = ck_misc_read,
	.unlocked_ioctl = ck_misc_ioctl,
};

static struct miscdevice ck_misc_device = {
	.minor 	= MISC_DYNAMIC_MINOR,
	.name 	= "ata_misc_capkey",
	.fops 	= &ck_misc_fops,
};

// CONFIG_HAS_EARLYSUSPEND
static void capkey_suspend(struct early_suspend *h)
{
	int result = 0;
	struct capkey_t *g_ck = container_of(h,struct capkey_t,capkey_early_suspend);
	uint8_t value;	
	
	mutex_lock(&g_ck->mutex);
	if( g_ck->capkey_suspended )
	{
		mutex_unlock(&g_ck->mutex);
		
		return;
	}
	
	g_ck->capkey_suspended = 1;
	if(g_ck->capkey_powercut != 1)
	{
		//turn off LED light
		capkey_LED_power_switch(0);
		//disable interrupts;
		disable_irq_nosync(g_ck->irq);  
		if(g_ck->enableLog)
			printk("[disable_irq_nosync]\n");       
		
		result = cancel_work_sync(&g_ck->capkey_work.work);
		if (result) //  if work was pending disable-count is now 2
		{
			enable_irq(g_ck->irq);	//enable interrupts
			printk("[enable_irq]\n");                   
		}
		
		//Enter Sleep mode
		value = 0x01;
		result = capkey_write_i2c(g_ck->client_4_i2c,Enter_SLEEP,&value,1);
		if( result )
		{
			MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to read enter sleep 0X%Xh = 0x%X\n",Enter_SLEEP, result );
		
		return;
		}
	}
	/*Leo Qin: adopt Orange L1B pm function*/
	if(g_ck->pm8901_l1b_vote_set != NULL)
		g_ck->pm8901_l1b_vote_set(0);
	
	MY_INFO_PRINTK( 1, "INFO_LEVEL:" "capkey_suspend: X\n" );
	mutex_unlock(&g_ck->mutex);
	
	return;

}

// CONFIG_HAS_RESUME
static void capkey_resume(struct early_suspend *h)
{
	int result;
	struct capkey_t *g_ck = container_of( h,struct capkey_t,capkey_early_suspend);
	
	mutex_lock(&g_ck->mutex);
	if( 0 == g_ck->capkey_suspended )
	{
		mutex_unlock(&g_ck->mutex);
		return;
	}
	
	if(g_ck->capkey_powercut != 1)
	{
		/*Leo Qin: adopt Orange L1B pm function*/
		if(g_ck->pm8901_l1b_vote_set != NULL)
			g_ck->pm8901_l1b_vote_set(1);

#if 1
		//WAKEUP SLEEP
		{
			uint8_t value;
			value = 0x01;
			result = capkey_write_i2c(g_ck->client_4_i2c,WAKEUP_SLEEP,&value,1);
		}
	
		// config capkey
		result = capkey_config_ATA2538(g_ck);
		if( result )
		{
			printk("[ERROR], ATA2538 re capkey_config_ATA2538 fail \n");
		}

#endif
		
		//turn on LED light
		//capkey_LED_power_switch(1);
		
		//enable interrupt
		enable_irq(g_ck->irq);
		if(g_ck->enableLog)
			printk("[enable_irq]\n");
	}
	g_ck->capkey_suspended = 0;

	if(g_ck->enableErrCheck)
	{
		queue_delayed_work(g_ck->capkey_wqueue, &g_ck->err_check_work, round_jiffies_relative(msecs_to_jiffies(3*g_ck->err_check_delay_ms)));  	
		if(g_ck->enableLog)
			printk("queue_delayed_work(g_ck->capkey_wqueue, &g_ck->err_check_work \n");		
	}
		
	//MY_INFO_PRINTK( 1, "INFO_LEVEL:" "capkey_resume: X\n" );
	mutex_unlock(&g_ck->mutex);
	
	return;
}

static int capkey_register_input( struct input_dev **input,
                          struct platform_device *pdev )
{
	int rc = 0;
	struct input_dev *input_dev;
	int i;
	
	i = 0;
	
	input_dev = input_allocate_device();
	if ( !input_dev ) {
		rc = -ENOMEM;
		return rc;
	}
	input_dev->name = CAPKEY_DRIVER_NAME;
	input_dev->phys = "ATA2538_capkey/input0";
	input_dev->id.bustype = BUS_I2C;
	input_dev->id.vendor = 0x0001;
	input_dev->id.product = 0x0002;
	input_dev->id.version = 0x0100;
	input_dev->open = capkey_open;
	input_dev->close = capkey_close;
	//input_dev->event = touchpad_event;
	
	input_dev->evbit[0] = BIT_MASK(EV_KEY);
	
	set_bit(KEY_MENU, input_dev->keybit);
	set_bit(KEY_HOME, input_dev->keybit);
	set_bit(KEY_BACK, input_dev->keybit);
	
	//for FVS mode API
	set_bit(KEY_F2, input_dev->keybit);
	set_bit(KEY_F5, input_dev->keybit);
	set_bit(KEY_F6, input_dev->keybit);
	rc = input_register_device( input_dev );
	
	if ( rc )
	{
		printk("[Star], ATA2538 capkey_register_input register input fail \n");
		input_free_device( input_dev );
		}else {
		*input = input_dev;
	}
	
	return rc;
}

extern unsigned int get_mfg_mode(void);
static int __devinit capkey_probe(struct i2c_client *client, const struct i2c_device_id *id)
{
	int    result = 0;		
	struct   ata2538_capkey_platform_data_t *pdata;
	
	g_ck = kzalloc( sizeof(struct capkey_t), GFP_KERNEL );
	if( !g_ck )
	{
		result = -ENOMEM;
		return result;
	}
	
	hrtimer_init(&g_ck->debounce_timer, CLOCK_MONOTONIC, HRTIMER_MODE_REL);
	g_ck->debounce_timer.function = capkey_debounce_timer;
	g_ck->debounce_time_ms = 30;
	g_ck->enableLog = 0;
	g_ck->enableErrCheck = 0;
	printk("[init_timer]\n");

	pdata = client->dev.platform_data;
	
	g_ck->gpio_num = pdata->gpioirq;
	g_ck->gpio_rst = pdata->gpiorst;
	/*Leo Qin: adopt Orange L1B pm function*/
	g_ck->pm8901_l1b_init = pdata->pm8901_l1b_init;
	g_ck->pm8901_l1b_vote_set = pdata->pm8901_l1b_vote_set;
	g_ck->irq = gpio_to_irq(g_ck->gpio_num);
	g_ck->client_4_i2c = client;
	g_ck->i2c_addr = 0x68;
	g_ck->brightness = DEFAULT_BRIGHTNESS;
	
	mutex_init(&g_ck->mutex);
	
	//setup power on device
	result = capkey_poweron_device(1);
	if(result)
	{
		MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "capkey_probe: failed to power on device\n" );
		printk("[Star], ATA2538 capkey_poweron_device fail \n");
		kfree(g_ck);
		return result;
	}
	if(g_ck->pm8901_l1b_vote_set != NULL)
		g_ck->pm8901_l1b_vote_set(1);
	// setup gpio
	result = capkey_setup_gpio();
	if( result )
	{
		printk("[Star], ATA2538 capkey_setup_gpio fail \n");
		kfree(g_ck);
		return result;
	}
	
	// config gpio 
	result = capkey_config_gpio(g_ck);
	
	if (result)
	{
		printk("[Star], ATA2538 capkey_config_gpio set GPIO fail \n");	
	}
	
	// detect ata2538	
	result = capkey_detect_ATA2538(g_ck);
	
	// config capkey
	result = capkey_config_ATA2538(g_ck);
	if( result )
	{
		printk("[Star], ATA2538 capkey_config_ATA2538 fail \n");
		kfree(g_ck);
		return result;
	}
	
	// detect ata2538	
	result = capkey_detect_ATA2538(g_ck);
	
	//turn on capeky LED light
	capkey_LED_power_switch(1);
	
	//turn off capeky LED light
	if(1 != get_mfg_mode())
		capkey_LED_power_switch(0);
	
	// register input device
	result = capkey_register_input( &g_ck->capkey_input, NULL );
	if( result )
	{
		//MY_INFO_PRINTK( 2, "ERROR_LEVELG" "capkey_probe: failed to register input\n" );
		kfree(g_ck);
		return result;
	} 
	
	//retister ck_misc_device
	
	result = misc_register( &ck_misc_device );
	if( result )
	{
		//MY_INFO_PRINTK( 2,"ERROR_LEVELG" "failed register misc driver\n" );
		printk("[Star], ATA2538 misc_register fail \n");
		result = -EFAULT;
		kfree(g_ck);
		return result;       
	}
	
	//workqueue handler
	INIT_DELAYED_WORK( &g_ck->capkey_work, capkey_irqWorkHandler );
	INIT_DELAYED_WORK( &g_ck->err_check_work, capkey_err_check_WorkHandler );
	g_ck->capkey_wqueue = create_singlethread_workqueue("ATA2538_Capkey_Wqueue"); //craete a workqueue with a single worker process
	if (!g_ck->capkey_wqueue)
	{
		//MY_INFO_PRINTK( 2, "ERROR_LEVELG" "capkey_probe: failed to create singlethread workqueue\n" );
		printk("[Star], ATA2538 capkey_wqueue fail \n");
		result = -ESRCH; 
		
		gpio_free( g_ck->gpio_num );
		kfree(g_ck); 
		return result;
	}
	
	g_ck->err_check_delay_ms = CAPKEY_ERR_CHECK_DELAY_MS;
	g_ck->enableErrCheck = 1;
	
	if(g_ck->enableErrCheck)
	{
		queue_delayed_work(g_ck->capkey_wqueue, &g_ck->err_check_work, g_ck->err_check_delay_ms);  	
		if(g_ck->enableLog)
			printk("queue_delayed_work(g_ck->capkey_wqueue, &g_ck->err_check_work \n");		
	}
	
	//request_irq
	result = request_any_context_irq( g_ck->irq, capkey_irqHandler, IRQF_TRIGGER_RISING,"ATA2538_Capkey_IRQ", g_ck );                      
	
	if ( result<0 )
	{
/*Orange Jack W Lu 2011-12-20 fix the L1B voltage error {*/
		if(g_ck->pm8901_l1b_vote_set != NULL)
			g_ck->pm8901_l1b_vote_set(0);
/*Orange Jack W Lu 2011-12-20 fix the L1B voltage error }*/

		capkey_poweron_device(0); // power off device
		result = -EFAULT;
		input_unregister_device( g_ck->capkey_input );
		input_free_device( g_ck->capkey_input );
		destroy_workqueue( g_ck->capkey_wqueue );
		
		gpio_free( g_ck->gpio_num );
		kfree(g_ck);
		
		return result;
	}
	g_ck->capkey_early_suspend.level = 150; //EARLY_SUSPEND_LEVEL_DISABLE_FB;
	g_ck->capkey_early_suspend.suspend = capkey_suspend;
	g_ck->capkey_early_suspend.resume = capkey_resume;
	register_early_suspend(&g_ck->capkey_early_suspend);
	
	return result;
}

static int __init capkey_init(void)
{
	int rc = 0;
	
	/*Leo Qin: get registers according hw version*/
#ifdef CONFIG_MACH_EVT2
	{
		kernel_hw_info hw_info_kernel;
		int hw_type;
		hw_type = get_hw_info_in_kernel(&hw_info_kernel);		
		printk("capkey_init: hardware type=%d\n",hw_info_kernel.board_version);	
	
		init_data_alpha = init_data_alpha_dvt;
		init_data_burst = init_data_burst_dvt;
		
		if( (hw_info_kernel.board_version == BOARD_EVT2)
			||(hw_info_kernel.board_version == BOARD_EVT3) )
		{
			init_data_alpha = init_data_alpha_evt;
			init_data_burst = init_data_burst_evt;
		}
	}
#endif

	ata_capkey_driver.driver.name = CAPKEY_DRIVER_NAME;
	rc = i2c_add_driver( &ata_capkey_driver ); 
	
	return rc;
}
module_init(capkey_init);

static void __exit capkey_exit(void)
{
	/*
	PRINT_IN
	platform_driver_unregister(&ata_capkey_driver);
	PRINT_OUT
	*/
}
module_exit(capkey_exit);

MODULE_DESCRIPTION("ATA2538 capkey driver");
MODULE_LICENSE("GPL v2");
MODULE_AUTHOR("Emily Jiang");
MODULE_ALIAS("platform:ata2538_capkey");
