/* drivers/input/touchscreen/atmel_mXT224_touch.c 
 *
 * Copyright (c) 2008 QUALCOMM Incorporated.
 * Copyright (c) 2008 QUALCOMM USA, INC.
 *
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

// 20101103
// Leo Guo
// Porting this file from Turcan

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/input.h>
#include <linux/platform_device.h>
#include <linux/jiffies.h>
#include <linux/io.h>
#include <linux/uaccess.h>
#include <linux/miscdevice.h>
#include <linux/i2c.h>
#include <linux/semaphore.h>
#include <linux/delay.h>
#include <linux/slab.h>
#ifdef   CONFIG_HAS_EARLYSUSPEND
#include <linux/earlysuspend.h>
#endif
#include <linux/time.h>
#include <linux/mutex.h>
#include <mach/vreg.h>
#include <mach/atmel_mXT224_touch.h>
#include "atmel_touch_obj.h"
#include "atmel_touch_TPK_obj.h" //the config file will be used in EVT3 for TPK panel
#include "atmel_touch_obj_evt1_V20.h"
#include "atmel_firmware_20.h"

#include <linux/pmic8058-othc.h>
#include <linux/mfd/pmic8901.h>
#include <linux/mfd/pmic8058.h>
#include <linux/regulator/pmic8058-regulator.h>
#include <linux/regulator/pmic8901-regulator.h>
#include <linux/regulator/consumer.h>
#include <linux/regulator/machine.h>
#include <linux/gpio.h>
#include <linux/gpio/gpio_def.h>

//#define SPEED_DISABLETOUCH_WHEN_PSENSORACTIVE 1

#ifdef SPEED_DISABLETOUCH_WHEN_PSENSORACTIVE
// 20100527 psensor status indication for key reporting.
 atomic_t psensor_approached;
#endif
static int DEBUG_LEVEL=0;
module_param_named( 
	DEBUG_LEVEL, DEBUG_LEVEL,
 	int, S_IRUGO | S_IWUSR | S_IWGRP
)

#define INFO_LEVEL  1
#define ERR_LEVEL   2
#define TEST_INFO_LEVEL 0
#define MY_INFO_PRINTK(level, fmt, args...) if(level <= DEBUG_LEVEL) printk( fmt, ##args);

#define printk(fmt, args...)

struct touchpad_t {
    struct i2c_client        *client_4_i2c;
    struct input_dev         *input;
    struct input_dev         *keyarray_input;
    int                      irq; //ISR number
    int                      gpio_num; //GPIO number
    int                      gpio_rst; //GPIO reset
    int                      open_count; //input device open count
    int						 touch_suspended; //touchpad suspended
    int                      misc_open_count; //misc device open count
    struct delayed_work      touchpad_work; 
    struct workqueue_struct  *touchpad_wqueue;
    uint32_t                 info_block_checksum;
    uint32_t                 T6_config_checksum;
    struct  id_info_t        id_info; //ID infomation
    struct  obj_t            *init_obj_element[MAX_OBJ_ELEMENT_SIZE];
    struct  tp_multi_t       *multi;
    struct  touch_point_status_t msg[ATMEL_REPORT_POINTS];  
    struct  mutex            mutex;
    struct early_suspend     touch_early_suspend; //CONFIG HAS EARLYSUSPEND
    uint16_t                 atmel_x_max,atmel_y_max;
    int                      fvs_mode_flag;  //verify press keypad is correct or not for FVS API
    uint8_t                  i2c_addr;
};

static struct touchpad_t         *g_tp;
static int __devinit touchpad_probe(struct i2c_client *client,  const struct i2c_device_id *);
static int calculate_infoblock_crc(struct touchpad_t *g_tp); // Calculates the infoblock CRC.
#ifdef CONFIG_TOUCHSCREEN_SOFTKEY
static int keyarray_register_input( struct input_dev **input,struct i2c_client *client );
#endif
static void tp_resume(struct early_suspend *h);
static void tp_suspend(struct early_suspend *h);

static int touchpad_write_i2c( struct i2c_client *client,
							   uint16_t			regBuf,
                               uint8_t          *dataBuf,
                               uint8_t          dataLen )
{
    int     result;
    uint8_t *buf = NULL;
    
    struct  i2c_msg msgs[] = { 
        [0] = {
            .addr   = g_tp->i2c_addr,
            .flags  = 0,
            .buf    = (void *)buf,
            .len    = 0
        }
    };
    
    
    buf = kzalloc( dataLen+sizeof(regBuf), GFP_KERNEL );
    if( NULL == buf )
    {
        MY_INFO_PRINTK( 2,"ERROR_LEVELG""touchpad_write_i2c: alloc memory failed\n" );
        return -EFAULT;
    }
    
    buf[0] = (uint8_t)(regBuf & 0xFF);
    buf[1] = (uint8_t)(regBuf >> 8);
    memcpy( &buf[2], dataBuf, dataLen );
    msgs[0].buf = buf;
    msgs[0].len = dataLen+sizeof(regBuf);

    result = i2c_transfer( client->adapter, msgs, 1 );
    if( result != ARRAY_SIZE(msgs) )
    {
        MY_INFO_PRINTK( 2,"ERROR_LEVELG""touchpad_write_i2c: write 0x%x 0x%x %d bytes return failure, %d\n", result, buf[0], buf[1], dataLen );
        kfree( buf );
        return result;
    }
    kfree(buf);
    
    return 0;
}

static int touchpad_read_i2c( struct i2c_client *client,
                            uint16_t           regBuf,
                            uint8_t           *dataBuf,
                            uint8_t           dataLen )
{
    int     result;
    struct  i2c_msg msgs[] = { 
        [0] = {
            .addr   = g_tp->i2c_addr,
            .flags  = 0,      
            .buf    = (void *)&regBuf,
            .len    = sizeof(regBuf)
        },
        [1] = {                     
            .addr   = g_tp->i2c_addr,
            .flags  = I2C_M_RD,
            .buf    = (void *)dataBuf,
            .len    = dataLen
        }
    };
    
	
    result = i2c_transfer( client->adapter, msgs, ARRAY_SIZE(msgs) );
    if( result != ARRAY_SIZE(msgs) )
    {
        MY_INFO_PRINTK( 2,"ERROR_LEVELG""read %Xh %d bytes return failure, %d\n", result, regBuf, dataLen );
        return result;
    }
	
    return 0;
}

static int tp_read_T5_via_i2c( struct i2c_client *client,
                            uint8_t           *dataBuf,
                            uint8_t           dataLen )
{
	int result;
	uint16_t addr = maxTouchCfg_T5_obj.obj_addr;
	uint8_t size = maxTouchCfg_T5_obj.size;
	
	
	if(addr == 0 || size == 0)
	{
		MY_INFO_PRINTK( 2,"ERROR_LEVELG""maxTouchCfg_T5_obj is NOT initialized\n");
		result = -ENOMEM;
		
		return result;		
	}
	if(client == NULL || dataBuf == NULL || dataLen != size)
	{
		MY_INFO_PRINTK( 2,"ERROR_LEVELG""no mem for reading message via i2c\n");
		result = -ENOMEM;
		
		return result;
	}
	result = touchpad_read_i2c(client,addr,dataBuf,dataLen);
	if(result)
	{
		MY_INFO_PRINTK( 2,"ERROR_LEVELG""%s failed, result=%d\n", __func__,result);
	}
	
	return result;
}

// CRC calculation routine
static uint32_t CRC_24(uint32_t crc, uint8_t byte1, uint8_t byte2)
{
	static const uint32_t crcpoly = 0x80001B;
   	uint32_t result;
   	uint16_t data_word;
   
   	
   	data_word = (uint16_t) ((uint16_t) (byte2 << 8u) | byte1);
   	//MY_INFO_PRINTK( 1,"INFO_LEVEL:""read dara word: 0x%x\n", data_word );
   	result = ((crc << 1u) ^ (uint32_t) data_word);
   
   	if (result & 0x1000000)
  	{
		result ^= crcpoly;
   	}
   	
   	return(result);
}

//config crc
static int calculate_config_crc(struct touchpad_t *g_tp)
{
	int result = 0;
   	uint32_t crc = 0;
   	uint16_t crc_area_size = 0;
   	uint16_t remainder;
   	uint8_t  *value = NULL; 
	uint8_t  i,j,index;
   
   	
   	for ( i = 0 ; i < g_tp->id_info.num_obj_element ; i++ )
	{
	    	if( g_tp->init_obj_element[i]->config_crc == 1 )
	    	{
	    		crc_area_size += ( g_tp->init_obj_element[i]->size );   			
	    		MY_INFO_PRINTK( 4, "INFO_LEVELG" "g_tp->init_obj_element[i]->size = %x\n",g_tp->init_obj_element[i]->size );
	   			MY_INFO_PRINTK( 4, "INFO_LEVELG" "crc_area_size = %x\n",crc_area_size );
	    	}
	}
    	
	value = kmalloc( crc_area_size, GFP_KERNEL );
   	if( NULL == value ) 
   	{
		result = -ENOMEM;
        
		kfree(value);
        	return result;
   	}
        
        index = 0;
   	for ( i = 0 ; i < g_tp->id_info.num_obj_element ; i++ )
    	{
	    	if( g_tp->init_obj_element[i]->config_crc == 1 )
	    	{
	    		memcpy(&value[index],g_tp->init_obj_element[i]->value_array,g_tp->init_obj_element[i]->size);
	    		index += g_tp->init_obj_element[i]->size;
	    	}
	}     
        
	for ( j = 0 ; j < crc_area_size ; j++ )
	{
		MY_INFO_PRINTK( 4,"TEST_INFO_LEVEL:""j: %d:\n",j );
        	MY_INFO_PRINTK( 4,"TEST_INFO_LEVEL:""value_array: 0x%x:\n",value[j] );
	}
	j = 0;
    	remainder = crc_area_size%2;
    	if ( remainder==0 ) //crc area size is even
    	{  	
   		while ( j < (crc_area_size-1) )
   		{
   			crc = CRC_24( crc, ( value[j]),(value[j+1]) );
      			j += 2;
      		}
    	}	  
    	else //crc area size is odd
    	{ 	
   		while ( j < (crc_area_size-1) )
   		{
   			crc = CRC_24( crc, ( value[j]),(value[j+1]) );
   			MY_INFO_PRINTK( 4,"TEST_INFO_LEVEL:""calculate config CRC: 0x%x:\n", crc );
      			j += 2;      			
      		}
      		crc = CRC_24(crc, ( value[j]), 0);
        	MY_INFO_PRINTK( 4,"TEST_INFO_LEVEL:""calculate config CRC: 0x%x:\n", crc );      		        
    	}
   	     
   	/* Return only 24 bit CRC. */
   	crc = (crc & 0x00FFFFFF);
   	MY_INFO_PRINTK( 4,"TEST_INFO_LEVEL:""calculate config CRC: 0x%x:\n", crc );
    	MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "g_tp->T6_config_checksum : 0x%x\n",g_tp->T6_config_checksum );
        
   	if ( crc != g_tp->T6_config_checksum )
   	{
   		MY_INFO_PRINTK( 2,"ERROR_LEVEL:""failed to calculate config crc: 0x%x:\n", crc );
   		result = -EFAULT;
		kfree(value);
        	return result;
   	}
   	
	kfree(value);
	return result;
}

/* \brief Calculates the CRC sum for the info block & object table area,
 *  and checks it matches the stored CRC.
 */
static int calculate_infoblock_crc(struct touchpad_t *g_tp)
{
	int result = 0;
   	int INFO_BLOCK_SIZE = ( NUM_OF_ID_INFO_BLOCK+OBJECT_TABLE_ELEMENT_SIZE*g_tp->id_info.num_obj_element )+INFO_BLOCK_CHECKSUM_SIZE;
   	uint32_t crc = 0;
   	uint16_t crc_area_size,regbuf;
   	uint8_t  *value = NULL; 
    	uint8_t  i;
   	int	j = 0;
   
   	
   	value = kmalloc( INFO_BLOCK_SIZE, GFP_KERNEL );
   	if( NULL == value ) 
   	{
        result = -ENOMEM;
        
        return result;
   	}
     
   	/* 7 bytes of version data, 6 * NUM_OF_OBJECTS bytes of object table. */
   	crc_area_size = NUM_OF_ID_INFO_BLOCK + OBJECT_TABLE_ELEMENT_SIZE*g_tp->id_info.num_obj_element;   
   
   	//read info block checksum
   	result = touchpad_read_i2c( g_tp->client_4_i2c,crc_area_size, &value[0], INFO_BLOCK_CHECKSUM_SIZE);
   	for ( regbuf = crc_area_size; regbuf < crc_area_size+INFO_BLOCK_CHECKSUM_SIZE; regbuf++ )
   	{
    		MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "read 0x%xh = 0x%x\n",regbuf, value[j] );
    		j++;
   	}
   	g_tp->info_block_checksum = value[0] | value[1]<< 8 | value[2]<<16;
   	MY_INFO_PRINTK( 4, "INFO_LEVEL:" "info block checksum : 0x%x\n",g_tp->info_block_checksum );
   
   	result = touchpad_read_i2c( g_tp->client_4_i2c,ADD_ID_INFO_BLOCK, &value[0], crc_area_size);
  	MY_INFO_PRINTK( 4,"TEST_INFO_LEVEL:""read info block checksum: 0x%x\n", value[0] );
   	if (result)
   	{
      		MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to read reg 0x%x and value failed 0x%x, return %d\n",crc_area_size,value[0],result );
      		kfree(value);
      		return result;
   	}
  
   	i = 0;
   	while (i < (crc_area_size - 1))
   	{
      		crc = CRC_24( crc, (value[i]),(value[i+1]) );
      		i += 2;
   	}
   
   	crc = CRC_24(crc, (value[i]), 0);
   	MY_INFO_PRINTK( 4,"TEST_INFO_LEVEL:""read info block checksum: 0x%x:\n", crc );
      
   	/* Return only 24 bit CRC. */
   	crc = (crc & 0x00FFFFFF);
   	MY_INFO_PRINTK( 4,"INFO_LEVEL:""read info block CRC: 0x%x:\n", crc );
   
   	if ( crc != g_tp->info_block_checksum )
   	{   	
   		MY_INFO_PRINTK( 2,"ERROR_LEVEL:""failed to calculate infoblock crc: 0x%x:\n", crc );
   		kfree(value);
        	return result;
   	}
   	
   	return result;
}

static void tp_save_multi_coord(void)
{
	struct atmel_multipoints_t    *buf = g_tp->multi->buf;
    	uint8_t index_r = g_tp->multi->index_r;
    	uint8_t index_w = g_tp->multi->index_w;
        int i; 
    	
    	for( i = 0;i<ATMEL_REPORT_POINTS;i++)
	{
		buf[index_w].points[i].x = g_tp->msg[i].coord.x;
		buf[index_w].points[i].y = g_tp->msg[i].coord.y;
		if(g_tp->msg[i].state == RELEASE)
		{
			buf[index_w].points[i].x = 0;
			buf[index_w].points[i].y = 0;
		}
		//MY_INFO_PRINTK( 1,"INFO_LEVEL:" "x_coord = %x\n",buf[index_w].points[i].x );
		//MY_INFO_PRINTK( 1,"INFO_LEVEL:" "y_coord = %x\n",buf[index_w].points[i].y );
	}

	index_w++;
    	index_w %= ATMEL_MULTITOUCH_BUF_LEN;
    	if( index_r == index_w )
    	{
        	index_r++;
        	index_r %= ATMEL_MULTITOUCH_BUF_LEN;
    	}
    	g_tp->multi->index_r = index_r;
    	g_tp->multi->index_w = index_w;
    	wake_up_interruptible( &g_tp->multi->wait );
    	return;
}

static void save_multi_touch_struct(  uint16_t x_coord,uint16_t y_coord,uint8_t touch_status, uint8_t report_id )
{

	g_tp->msg[report_id - maxTouchCfg_T9_obj.reportid_ub].coord.x = (uint)x_coord;
	g_tp->msg[report_id - maxTouchCfg_T9_obj.reportid_ub].coord.y = (uint)y_coord;
	if (( touch_status & TOUCH_PRESS_RELEASE_MASK) == TOUCH_PRESS_RELEASE_MASK ) //both press and relese touch 
    	{
		g_tp->msg[report_id - maxTouchCfg_T9_obj.reportid_ub].state = RELEASE;
	}
	else if	( ( touch_status & TOUCH_RELEASE_MASK) == TOUCH_RELEASE_MASK  ) //release one touch
	{
		g_tp->msg[report_id - maxTouchCfg_T9_obj.reportid_ub].state = RELEASE;
	}
	else if( (touch_status & TOUCH_PRESS_MASK) == TOUCH_PRESS_MASK ) //press one touch
    	{ 	
		g_tp->msg[report_id - maxTouchCfg_T9_obj.reportid_ub].state = PRESS;
	}
	else if ( (touch_status & TOUCH_MOVE_MASK) == TOUCH_MOVE_MASK ) //move one touch
    	{
		g_tp->msg[report_id - maxTouchCfg_T9_obj.reportid_ub].state = MOVE;
	}
	else if ( (touch_status & TOUCH_DETECT_MASK ) != 0x0 )
	{
		//g_tp->msg[report_id - maxTouchCfg_T9_obj.reportid_ub].state = RELEASE;
	}
	else
    	{
    		MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "error touch_state = %x\n",touch_status );
    	}			
	return;
}	

static void tp_report_coord_via_mt_protocol(void)
{
	int i;
	
	for(i=0;i<ATMEL_REPORT_POINTS;i++)
	{
		if(g_tp->msg[i].state == RELEASE)
		{
			input_report_abs(g_tp->input, ABS_MT_TOUCH_MAJOR, 0); 
			input_report_abs(g_tp->input, ABS_MT_WIDTH_MAJOR, 0);
			input_report_abs(g_tp->input, ABS_MT_POSITION_X, 0); 
			input_report_abs(g_tp->input, ABS_MT_POSITION_Y, 0);	
			MY_INFO_PRINTK( 1,"INFO_LEVEL:" "u:" );
		}
		else
		{
			input_report_abs(g_tp->input, ABS_MT_TOUCH_MAJOR, 10); 
			input_report_abs(g_tp->input, ABS_MT_WIDTH_MAJOR, 10);
			input_report_abs(g_tp->input, ABS_MT_POSITION_X, g_tp->msg[i].coord.x); 
			input_report_abs(g_tp->input, ABS_MT_POSITION_Y, g_tp->msg[i].coord.y);	
			MY_INFO_PRINTK( 1,"INFO_LEVEL:" "d:");
			MY_INFO_PRINTK( 1,"INFO_LEVEL:" "mt_protocol report x,y coordinate:(%d,%d)\n",g_tp->msg[i].coord.x,g_tp->msg[i].coord.y ); 
		}
		input_mt_sync(g_tp->input); 
	}
	input_sync(g_tp->input);
	//printk(" end\n");
	
}
#if 0
static void tp_report_single_coord( uint16_t x_coord,uint16_t y_coord,uint8_t touch_status )
{
	
	if (( touch_status & TOUCH_PRESS_RELEASE_MASK) == TOUCH_PRESS_RELEASE_MASK ) //both press and relese touch 
	{
		input_report_abs(g_tp->input, ABS_X, x_coord);
		input_report_abs(g_tp->input, ABS_Y, y_coord);
		MY_INFO_PRINTK( 1,"INFO_LEVEL:""report x,y coordinate:(%d,%d)\n", (int)x_coord,(int)y_coord);
		input_report_key(g_tp->input, BTN_TOUCH, 1);
		MY_INFO_PRINTK( 1,"INFO_LEVEL:"" press one touch\n");
		input_sync(g_tp->input);       		
		input_report_abs(g_tp->input, ABS_X, x_coord);
		input_report_abs(g_tp->input, ABS_Y, y_coord);
		MY_INFO_PRINTK( 1,"INFO_LEVEL:""report x,y coordinate:(%d,%d)\n", (int)x_coord,(int)y_coord);
		input_report_key(g_tp->input, BTN_TOUCH, 0);
		MY_INFO_PRINTK( 1,"INFO_LEVEL:"" release one touch\n");
		input_sync(g_tp->input);
	}
	else if ( ( touch_status & TOUCH_RELEASE_MASK) == TOUCH_RELEASE_MASK  ) //release one touch
	{
		input_report_abs(g_tp->input, ABS_X, x_coord);
		input_report_abs(g_tp->input, ABS_Y, y_coord);
		MY_INFO_PRINTK( 1,"INFO_LEVEL:""report x,y coordinate:(%d,%d)\n", (int)x_coord,(int)y_coord);
		input_report_key(g_tp->input, BTN_TOUCH, 0);
		MY_INFO_PRINTK( 1,"INFO_LEVEL:"" release one touch\n");
		input_sync(g_tp->input);
	}
	else if( (touch_status & TOUCH_PRESS_MASK) == TOUCH_PRESS_MASK ) //press one touch
	{
		input_report_abs(g_tp->input, ABS_X, x_coord);
		input_report_abs(g_tp->input, ABS_Y, y_coord);
		MY_INFO_PRINTK( 1,"INFO_LEVEL:""report x,y coordinate:(%d,%d)\n", (int)x_coord,(int)y_coord);
		input_report_key(g_tp->input, BTN_TOUCH, 1);
		MY_INFO_PRINTK( 1,"INFO_LEVEL:"" press one touch\n");
		input_sync(g_tp->input);
	}
	else if ( (touch_status & TOUCH_MOVE_MASK) == TOUCH_MOVE_MASK ) //move one touch
	{
		input_report_abs(g_tp->input, ABS_X, x_coord);
		input_report_abs(g_tp->input, ABS_Y, y_coord);
		MY_INFO_PRINTK( 1,"INFO_LEVEL:""report x,y coordinate:(%d,%d)\n", (int)x_coord,(int)y_coord);
		input_report_key(g_tp->input, BTN_TOUCH, 1);
		MY_INFO_PRINTK( 1,"INFO_LEVEL:"" move one touch\n");
		input_sync(g_tp->input);    	
	}
	else if ( (touch_status & TOUCH_DETECT_MASK ) != 0x0 )
	{
     	
	}
	else
	{
		MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "error touch_state = %x\n",touch_status );
	}
	
	return;
}
#endif
static void touchpad_report_coord( uint16_t x_coord,uint16_t y_coord,uint8_t touch_status, uint8_t report_id )
{                 
                
	save_multi_touch_struct( x_coord,y_coord,touch_status,report_id );
	tp_report_coord_via_mt_protocol();
	if( g_tp->misc_open_count )
    	{
       	 	//save_multi_touch_struct( x_coord,y_coord,touch_status,report_id );
        	tp_save_multi_coord();
    	}
    	if ( report_id == maxTouchCfg_T9_obj.reportid_ub )
    	{
      		//tp_report_single_coord( x_coord,y_coord,touch_status );
    	}
    return;   
}

//ptr func T15_msg_handler
int T15_msg_handler ( uint8_t *value  )
{	
	
	printk( "TEST_INFO_LEVEL:"" multiscreen touch T15 report id is  : %d\n",value[0] );
	//printk( " Keyarray T15 value[0] : %d value[1] : %d value[2] : %d \n",value[0],value[1],value[2] );

#if 0
	if ((system_rev <= TOUCAN_EVT1_Band148) || system_rev == HWID_UNKNOWN)
    	{

		if ( g_tp->fvs_mode_flag == 1 ) //enter fvs mode
		{
			if(value[2] & 0x01)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F2 is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_F2, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F2 is released\n");
				input_report_key(g_tp->keyarray_input, KEY_F2, 0);
			}
			if(value[2] & 0x02)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F5 is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_F5, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F5 is released\n");
				input_report_key(g_tp->keyarray_input, KEY_F5, 0);
			}
			if(value[2] & 0x04)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F6 is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_F6, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F6 is released\n");
				input_report_key(g_tp->keyarray_input, KEY_F6, 0);
			}
		}
		else //exit fvs mode
		{
			if(value[2] & 0x01)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" HOME_BACK is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_BACK, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_BACK is released\n");
				input_report_key(g_tp->keyarray_input, KEY_BACK, 0);
			}
			if(value[2] & 0x02)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_HOME is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_HOME, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_HOME is released\n");
				input_report_key(g_tp->keyarray_input, KEY_HOME, 0);
			}
			if(value[2] & 0x04)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_MENU is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_MENU, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_MENU is released\n");
				input_report_key(g_tp->keyarray_input, KEY_MENU, 0);
			}
		}
	}
	else
#endif
	{
		if ( g_tp->fvs_mode_flag == 1 ) //enter fvs mode
		{
			if(value[2] & 0x01)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F2 is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_F2, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F2 is released\n");
				input_report_key(g_tp->keyarray_input, KEY_F2, 0);
			}
			if(value[2] & 0x02)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F6 is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_F6, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F6 is released\n");
				input_report_key(g_tp->keyarray_input, KEY_F6, 0);
			}
			if(value[2] & 0x04)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F5 is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_F5, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_F5 is released\n");
				input_report_key(g_tp->keyarray_input, KEY_F5, 0);
			}
		}
		else //exit fvs mode
		{
			if(value[2] & 0x01)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" HOME_BACK is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_BACK, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_BACK is released\n");
				input_report_key(g_tp->keyarray_input, KEY_BACK, 0);
			}
			if(value[2] & 0x02)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_MENU is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_MENU, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_MENU is released\n");
				input_report_key(g_tp->keyarray_input, KEY_MENU, 0);
			}
			if(value[2] & 0x04)
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_HOME is pressed\n");
				input_report_key(g_tp->keyarray_input, KEY_HOME, 1);
			}
			else
			{
				MY_INFO_PRINTK( 1,"TEST_INFO_LEVEL:"" KEY_HOME is released\n");
				input_report_key(g_tp->keyarray_input, KEY_HOME, 0);
			}
		}
	}	
    
    return 0;
}

//ptr func T6_msg_handler
int T6_msg_handler ( uint8_t *value )
{
	
	//printk( "INFO_LEVEL:" " command T6 report id is  : %d\n",value[0] );
	//printk( "INFO_LEVEL:" " command T6 status  : %d\n",value[1] );
	//printk( "ERROR_LEVEL:" " It isn't normal to read T6 message \n " );
    
    return 0;
}
#ifdef CONFIG_TOUCHSCREEN_SOFTKEY
//ptr func T9_msg_handler
static void report_soft_key(uint16_t x,uint16_t y,uint8_t status)
{
	int key_status;
	unsigned int key_code;
	printk("report_soft_key status is %d\n",status);
	if(((status& TOUCH_PRESS_RELEASE_MASK) == TOUCH_PRESS_RELEASE_MASK)||((status& TOUCH_RELEASE_MASK) == TOUCH_RELEASE_MASK))
		key_status=0;
	else if((status& TOUCH_PRESS_MASK) == TOUCH_PRESS_MASK)
		key_status=1;
	else
	{
	        
	}
	if(x>320)
		return;
	if(x>=200)
		key_code=KEY_HOME;
	else if(x>=100)
		key_code=KEY_MENU;
	else
		key_code=KEY_BACK;
	
	printk("key_code is %d,key_status is %d\n",key_code,key_status);
	input_report_key(g_tp->keyarray_input, key_code, key_status);

}
#endif
int T9_msg_handler ( uint8_t *value  )
{
	//uint8_t i;
	uint16_t x_coord,y_coord,temp;
	
#ifdef TOUCH_DEBUG
	printk( "TEST_INFO_LEVEL:"" multiscreen touch T9 report id is  : %d\n",value[0] );
#endif
    //calculate xBy coordinate
	x_coord = value[2] << 2 | (value[4] & 0xc0) >> 6;
	y_coord = value[3] << 2 | (value[4] & 0x0c) >> 2;
#if 0
	printk( "TEST_INFO_LEVEL:"" x coordinate  : %d\n",(int)x_coord );
	printk( "TEST_INFO_LEVEL:"" y coordinate  : %d\n",(int)y_coord );
#endif
	x_coord = 1024-( ( x_coord - ATMEL_X_ORIGIN ) * ATMEL_TOUCAN_PANEL_X ) / ( g_tp->atmel_x_max - ATMEL_X_ORIGIN );
	y_coord = 1024-( ( y_coord - ATMEL_Y_ORIGIN ) * ATMEL_TOUCAN_PANEL_Y ) / ( g_tp->atmel_y_max - ATMEL_Y_ORIGIN );
	temp=x_coord;
	x_coord=y_coord;
	y_coord=temp;
	
	//printk( "TEST_INFO_LEVEL:"" x coordinate  : %d\n",(int)x_coord );
	//printk( "TEST_INFO_LEVEL:"" y coordinate  : %d\n",(int)y_coord );
#ifdef CONFIG_TOUCHSCREEN_SOFTKEY
	
	if(y_coord<941)
	{
#if 0
		printk( "TEST_INFO_LEVEL:"" x coordinate  : %d\n",(int)x_coord );
		printk( "TEST_INFO_LEVEL:"" y coordinate  : %d\n",(int)y_coord );
#endif
		touchpad_report_coord( x_coord,y_coord,value[1], value[0] );
	}
	else
		report_soft_key(x_coord,y_coord,value[1]);
	
#else
	touchpad_report_coord( x_coord,y_coord,value[1], value[0] );
#endif
	return 0;
}

static ssize_t tp_misc_read( struct file *fp,
                             char __user *buffer,
                             size_t count,
                             loff_t *ppos )
{
	ssize_t  rc = 0;
	int      ret = 0;
    	uint32_t reserved_num;
    	uint32_t copied_num;
    	uint32_t available_num;
    	int i;
    	
	
	if( count < sizeof(struct atmel_multipoints_t) )
    	{
        	MY_INFO_PRINTK( 2, "ERROR_LEVELG" "invalid count %d\n",count );
        	return -EINVAL;
    	}

	mutex_lock(&g_tp->mutex);
    	if( g_tp->multi->index_r == g_tp->multi->index_w )
    	{
	        mutex_unlock(&g_tp->mutex);
	        ret = wait_event_interruptible( g_tp->multi->wait, (g_tp->multi->index_r != g_tp->multi->index_w) );
	        if( ret )
	        {
	            MY_INFO_PRINTK( 2, "ERROR_LEVELG" "signaled\n" );
	            return ret;
	        }
	        mutex_lock(&g_tp->mutex);
    	}
	// copy data available inside buffer
	reserved_num = count/sizeof(struct atmel_multipoints_t);
    	available_num = (g_tp->multi->index_w > g_tp->multi->index_r)?
					(g_tp->multi->index_w - g_tp->multi->index_r):
                    (ATMEL_MULTITOUCH_BUF_LEN + g_tp->multi->index_w - g_tp->multi->index_r);
	for ( i = 0 ; i < ATMEL_REPORT_POINTS; i++ )
    	{
        	MY_INFO_PRINTK( 4,"INFO_LEVEL:" "x_coord = %x\n",g_tp->multi->buf[g_tp->multi->index_r].points[i].x );
		MY_INFO_PRINTK( 4,"INFO_LEVEL:" "y_coord = %x\n",g_tp->multi->buf[g_tp->multi->index_r].points[i].y );
	}
	
	if( reserved_num < available_num )
		copied_num = reserved_num;
    	else
        	copied_num = available_num;

    	ret = rc = 0;
    	if( g_tp->multi->index_r + copied_num > ATMEL_MULTITOUCH_BUF_LEN )
    	{
        	uint32_t copied_bytes;
        	copied_bytes = (ATMEL_MULTITOUCH_BUF_LEN - g_tp->multi->index_r) * sizeof(struct atmel_multipoints_t);
        	ret = copy_to_user ( buffer,
                            &g_tp->multi->buf[g_tp->multi->index_r],
                            copied_bytes ); 
        	for ( i = 0 ; i < ATMEL_REPORT_POINTS; i++ )
        	{
            		MY_INFO_PRINTK( 4,"INFO_LEVEL:" "x_coord = %x\n",g_tp->multi->buf[g_tp->multi->index_r].points[i].x );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "y_coord = %x\n",g_tp->multi->buf[g_tp->multi->index_r].points[i].y );
		}
			
        	if( ret )
        	{
			MY_INFO_PRINTK( 2, "ERROR_LEVELG" "failed copy %u bytes to user, ret=%d\n",
           		            copied_bytes,ret );
			rc = -EFAULT;
			goto exit_misc_read;
        	}
        	copied_num -= (ATMEL_MULTITOUCH_BUF_LEN - g_tp->multi->index_r);
        	g_tp->multi->index_r = 0;
        	buffer += copied_bytes;
        	rc += copied_bytes; 
    	}

	if( copied_num > 0 )
    	{
        	uint32_t copied_bytes;
        	copied_bytes = copied_num * sizeof(struct atmel_multipoints_t);
        	ret = copy_to_user ( buffer,
                            &g_tp->multi->buf[g_tp->multi->index_r],
                            copied_bytes );
        	for ( i = 0 ; i < ATMEL_REPORT_POINTS; i++ )
       		{
            		MY_INFO_PRINTK( 4,"INFO_LEVEL:" "x_coord = %x\n",g_tp->multi->buf[g_tp->multi->index_r].points[i].x );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "y_coord = %x\n",g_tp->multi->buf[g_tp->multi->index_r].points[i].y );
		}		
        	if( ret )
        	{
            		MY_INFO_PRINTK( 2, "ERROR_LEVELG" "tp_misc_read:failed copy %u bytes to user, ret=%d\n",
           		            copied_bytes, ret );
			rc = -EFAULT;
           		goto exit_misc_read;
        	}
        	g_tp->multi->index_r += copied_num;
        	rc += copied_bytes;            
    	}
exit_misc_read:
    	if( rc < 0 )
    	{
	        MY_INFO_PRINTK( 2, "ERROR_LEVELG" "reserved_num=%d, available_num=%d, copied_num=%d\n",
	        reserved_num, available_num, copied_num);
	        MY_INFO_PRINTK( 2, "ERROR_LEVELG" "index_r=%d, index_w=%d\n",g_tp->multi->index_r,g_tp->multi->index_w);
    	}
    	g_tp->multi->index_r %= ATMEL_MULTITOUCH_BUF_LEN;
	mutex_unlock(&g_tp->mutex);
	
	return rc;	 	
}

static void touchpad_irqWorkHandler( struct work_struct *work )
{
    	struct i2c_client           *client = g_tp->client_4_i2c;
    	uint8_t value[maxTouchCfg_T5_obj.size];
    	uint8_t i;
       struct   atmel_touchscreen_platform_data_t *pdata;
	pdata = client->dev.platform_data;
    	//struct sched_param s = { .sched_priority = 1 };
    	//printk("touchpad_irqWorkHandler^^^^^^^^^^^^^^^^^^^^^^^^\n");

#if 0
		
    	if(!rt_task(current))
    	{
 		if(sched_setscheduler_nocheck(current, SCHED_FIFO, &s)!=0)
		{
			//printk(  "TEST_INFO_LEVELG" "fail to set rt pri...\n" );
		}
		else
		{
			//printk( "TEST_INFO_LEVELG" "set rt pri...\n" );
		}
    	}
#endif
	mutex_lock(&g_tp->mutex);
    	do
	{
	    	tp_read_T5_via_i2c( client , &value[0], maxTouchCfg_T5_obj.size );    		
	    	//printk( "TEST_INFO_LEVELG" "read T5 via i2c 0x%x = %d\n",maxTouchCfg_T5_obj.obj_addr,value[0] );
		printk("%x,%x,%x,%x\n",value[0],value[1],value[2],value[3]);
	    	//printk( "TEST_INFO_LEVELG" "T5 obj size = %d\n",maxTouchCfg_T5_obj.size );
			//printk( "TILG" "rid=%x msg=%x\n",value[0],value[1] );
#if 1
	    	for ( i = 0 ; i < g_tp->id_info.num_obj_element ; i++ )
	    	{
			if (value[0] >= g_tp->init_obj_element[i]->reportid_ub && value[0] <=  g_tp->init_obj_element[i]->reportid_lb)
			{       	 			
				if(g_tp->init_obj_element[i]->msg_handler)
				{
					g_tp->init_obj_element[i]->msg_handler(value);
				}	
				break;
			}
		}
#endif
    	}while((pdata->get_irq_status() )== 0);

   	enable_irq( g_tp->irq ); 
	mutex_unlock(&g_tp->mutex);
	
    return;
}
#if 0
static int leo_test(void)
{
	struct i2c_client           *client = g_tp->client_4_i2c;
	uint8_t value[maxTouchCfg_T5_obj.size];
	int i=0;
	struct   atmel_touchscreen_platform_data_t *pdata;
	pdata = client->dev.platform_data;
	do
	{
		tp_read_T5_via_i2c( client , &value[0], maxTouchCfg_T5_obj.size );    	

		printk(  "read T5 via i2c 0x%x = %d\n",maxTouchCfg_T5_obj.obj_addr,value[0] );

#if 1
		for ( i = 0 ; i < g_tp->id_info.num_obj_element ; i++ )
    	  	{
			if (value[0] >= g_tp->init_obj_element[i]->reportid_ub && value[0] <=  g_tp->init_obj_element[i]->reportid_lb)
			{       	 			
				if(g_tp->init_obj_element[i]->msg_handler)
				{
					g_tp->init_obj_element[i]->msg_handler(value);
				}	
				break;
			}
    	  	}
#endif

    	}while((pdata->get_irq_status() )== 0);

	enable_irq( g_tp->irq ); 
	return 0;
}
#endif

static irqreturn_t touchpad_irqHandler(int irq, void *dev_id)
{
    //struct touchpad_t *g_tp = dev_id; 
    disable_irq_nosync(irq);                                                                                                                                                                  
    queue_delayed_work(g_tp->touchpad_wqueue, &g_tp->touchpad_work, 0);
    //leo_test();
    return IRQ_HANDLED;
}

static uint16_t get_ref_value(int x,int y,uint8_t data_buffer[][SIZE_OF_REF_MODE_PAGE])
{
	int page_idx,element_idx;
	
	page_idx = (x*y_channel+y)*2 / (SIZE_OF_REF_MODE_PAGE-2);
	element_idx = ((x*y_channel+y)*2 % (SIZE_OF_REF_MODE_PAGE-2))+2;
	if(page_idx >= NUM_OF_REF_MODE_PAGE || element_idx-1 >= SIZE_OF_REF_MODE_PAGE)
	{
		MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "page_idx[%d] or elemenet_idx[%d] is not correct\n",page_idx,element_idx );
		return 0;
	}
	else
	{
		return (uint16_t)(data_buffer[page_idx][element_idx] | data_buffer[page_idx][element_idx+1] << 8);
	}
}

//read T37 References Mode
static int read_T37(struct touchpad_t *g_tp,uint8_t data_buffer[][SIZE_OF_REF_MODE_PAGE],uint8_t command)
{
	struct i2c_client *client = g_tp->client_4_i2c;
	int 		result = 0;
	uint8_t 	try_ctr;
	uint8_t 	value;
	uint16_t	addr_T6;
	uint16_t 	addr_T37;
	int i;
	
	
	/* references mode */
	value = command; //diagnostic command to get reference values
	addr_T6 = maxTouchCfg_T6_obj.obj_addr+5;
	result = touchpad_write_i2c( client, addr_T6, &value, 1 );
	if (result)
	{
		MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write References Mode!\n" );
        	result = -EFAULT;
		return result;
	}

	for(i=0;i<NUM_OF_REF_MODE_PAGE;i++)
	{
		memset( data_buffer[i], 0xFF, SIZE_OF_REF_MODE_PAGE );
	}
	
	for(i=0;i<NUM_OF_REF_MODE_PAGE;i++)
	{
		/* wait for diagnostic object to update */
		addr_T37 = maxTouchCfg_T37_obj.obj_addr;
		try_ctr = 0;
		while(!((data_buffer[i][0] == command) && (data_buffer[i][1] == i)))
		{
			/* wait for data to be valid */
			if(try_ctr > 100)
			{
				/* Failed! */
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read T37!\n" );
				result = -EFAULT;
				return result;
			}
			msleep(5);
			try_ctr++; //timeout counter
			result = touchpad_read_i2c( client, addr_T37, &data_buffer[i][0], 2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read T37!\n" );
				result = -EFAULT;
				return result;
			}
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "Mode = 0x%x\n",data_buffer[i][0] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "Page = 0x%x\n",data_buffer[i][1] );
		}
		
		result = touchpad_read_i2c( client, addr_T37, &data_buffer[i][0], SIZE_OF_REF_MODE_PAGE);
		if (result)
		{
			MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read T37!\n" );
			result = -EFAULT;
			return result;
		}
				
		if(i != NUM_OF_REF_MODE_PAGE -1)
		{
			/* send page up command so we can detect when data updates next time */
			value = 0x01;
			result = touchpad_write_i2c( client, addr_T6, &value, 1 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write page up\n" );
				result = -EFAULT;
				return result;
			}
		}
	}
	
	
	return result;
}








#if 0
static int touchpad_setup_gpio( int gpio_num, int gpio_rst )
{
    	int rc;
    	int i;
	
	struct pm8058_gpio_cfg {
		int                gpio;
		struct pm8058_gpio cfg;
	};

	struct pm8058_gpio_cfg gpio_cfgs[] = {
	{ /* Touch INT */
		24,
		{
			.direction	= PM_GPIO_DIR_IN,
			.pull		= PM_GPIO_PULL_UP_1P5,
			.function	= PM_GPIO_FUNC_NORMAL,
			.vin_sel	=2,
			.inv_int_pol	= 0,
		}
	}
	};
    
    //setup gpio_num
    //printk( "touchpad_setup_gpio: setup gpio %d\n", gpio_num );

	
	for (i = 0; i < ARRAY_SIZE(gpio_cfgs); ++i) {
		rc = pm8058_gpio_config(gpio_cfgs[i].gpio,
				&gpio_cfgs[i].cfg);
		if (rc < 0) {
			pr_err("%s pmic gpio config failed\n",
				__func__);
			return rc;
		}
	}
	return rc;
}


static int touchpad_config_gpio( int gpio_num, int gpio_rst )
{
	int rc=0;
#if 0
	rc = gpio_clear_detect_status( gpio_num );
    	if ( rc )
    	{
        	MY_INFO_PRINTK( 2,"ERROR_LEVEL:""touchpad_config_gpio_num: clear detect status failed (rc=%d)\n", rc);
        
        	return rc;
    	}       
#endif
    //set its value to 0 , hw reset

        
    	gpio_tlmm_config(GPIO_CFG(43, 1, GPIO_CFG_OUTPUT, GPIO_CFG_PULL_UP, GPIO_CFG_10MA), GPIO_CFG_ENABLE);
    	gpio_tlmm_config(GPIO_CFG(44, 1, GPIO_CFG_OUTPUT, GPIO_CFG_PULL_UP, GPIO_CFG_10MA), GPIO_CFG_ENABLE);	
    	msleep(540);  
    	return rc;
}
#endif
//fill in format of each object table element
static int fillin_object_table(struct obj_t *obj, uint16_t addr,uint8_t *value )
{		
	
	obj->obj_addr = value[1] | value[2] << 8;
	obj->size = value[3] + 1;
	obj->instance = value[4] + 1;
	obj->num_reportid = value[5];
	MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "read 0x%x = 0x%x\n", addr,obj->obj_addr );
	MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "read 0x%x = 0x%d\n",addr,obj->size );
	MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "read 0x%x = 0x%d\n",addr,obj->instance );
	MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "read 0x%x = 0x%d\n",addr,obj->num_reportid );       
	
	return 0;
}

//fill in each object table value
static int fillin_init_obj_table( uint8_t match_type_id,struct obj_t *ptr_obj_struct,uint8_t *obj_value,unsigned char *value_ub,uint16_t obj_addr,uint8_t array_size,int *index )
{
	int j;
	uint8_t read_type_id = obj_value[0];
	uint8_t num_of_reportid = obj_value[5];
	uint8_t num_of_instance = obj_value[4]+1;
	
	
	#if 0
	MY_INFO_PRINTK( 4, "INFO_LEVEL:" "match_type_id 0x%x : \n",match_type_id );
	MY_INFO_PRINTK( 4, "INFO_LEVEL:" "ptr_obj_struct %p : \n",ptr_obj_struct );
	MY_INFO_PRINTK( 4, "INFO_LEVEL:" "obj_value %p : \n",obj_value );
	MY_INFO_PRINTK( 4, "INFO_LEVEL:" "value_ub %p : \n",value_ub );
	MY_INFO_PRINTK( 4, "INFO_LEVEL:" "obj_addr 0x%x : \n",obj_addr );
	MY_INFO_PRINTK( 4, "INFO_LEVEL:" "array_size 0x%x : \n",array_size );
	MY_INFO_PRINTK( 4, "INFO_LEVEL:" "index  %p : \n",index  );
	#endif	
	
	if ( read_type_id == match_type_id )
    	{      		
    		for ( j = 0; j< OBJECT_TABLE_ELEMENT_SIZE; j++ ) //print object table
		{
    			MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "read 0x%xh = 0x%x\n",obj_addr, obj_value[j] );
    		}
    	fillin_object_table( ptr_obj_struct,obj_addr,obj_value );
    	//calculate object table's lowerbond report id
    	ptr_obj_struct->reportid_ub = *value_ub;
    	ptr_obj_struct->reportid_lb = *value_ub+(num_of_reportid*num_of_instance)-1;
    	*value_ub += (num_of_reportid*num_of_instance);
    	MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "T38_obj_reportid_ub  %d\n",ptr_obj_struct->reportid_ub );
	MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "T38_obj_reportid_lb %d\n",ptr_obj_struct->reportid_lb );	   		
    		
    	if ( (uint8_t)array_size == 0 || ptr_obj_struct->size == (uint8_t)array_size ) //check if read object value is equal object table size
    	{
       		g_tp->init_obj_element[*index] = ptr_obj_struct;
            	*index += 1;
       	}
       	else
       	{
       		MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "i2c read object value isn't equal actual object table size\n" );
    		
    		return -EFAULT;
       	}
    }
    
    return 0;
}
#if 0
static int touchpad_enter_bootload(struct touchpad_t *g_tp)
{
	int result;
	struct i2c_client *client = g_tp->client_4_i2c;
	uint8_t value;
    //enter boot load
    	value = 0xA5;
    	result = touchpad_write_i2c(client,0xfc,&value ,WRITE_T6_SIZE);
    	printk( "TEST_INFO_LEVELG" "software reset 0x%x = 0x%x\n",maxTouchCfg_T6_obj.obj_addr,value );
    	if( result )
    	{
    		printk( "ERROR_LEVEL:" "unable to software reset T6 object 0x%x = 0x%x\n",maxTouchCfg_T6_obj.obj_addr,value );
    	
    		return result;
    	}    	
    //msleep(64);
	msleep(100);
       	return result;


}
#endif
static int touchpad_config_mXT224(struct touchpad_t *g_tp)
{
	int result;
	struct i2c_client *client = g_tp->client_4_i2c;
	uint8_t value;
	int i;
	uint16_t regbuf;

    
    	value = T6_BACKUPNV_VALUE;
    	for ( i = 0 ; i < g_tp->id_info.num_obj_element ; i++ )
    	{
	    	if( g_tp->init_obj_element[i]->value_array != NULL )
	    	{
			result = touchpad_write_i2c(client,g_tp->init_obj_element[i]->obj_addr,g_tp->init_obj_element[i]->value_array,g_tp->init_obj_element[i]->size);
			//printk( "TEST_INFO_LEVELG" "write reg_check 0x%x = 0x%x\n",g_tp->init_obj_element[i]->obj_addr,g_tp->init_obj_element[i]->value_array[0] );
	    		if( result )
	    		{
	    	  	 	printk( "ERROR_LEVEL:" "unable to read reg_check 0x%x = 0x%x\n",g_tp->init_obj_element[i]->obj_addr, g_tp->init_obj_element[i]->value_array[0] );
	    	   		
	    	   		return result;
	    		}
	    	}
    	}
    
    //backup CMD
    	regbuf = maxTouchCfg_T6_obj.obj_addr+1;
    	result = touchpad_write_i2c(client,regbuf,&value,WRITE_T6_SIZE);
    	printk( "TEST_INFO_LEVELG" "software backup 0x%x = 0x%x\n",regbuf,value );
	if( result )
	{
		printk( "ERROR_LEVEL:" "unable to write T6 backup byte 0x%x = 0x%x\n",regbuf,value );
	    	
	    	return result;
	}

    //software reset
    	value = T6_RESET_VALUE;
    	result = touchpad_write_i2c(client,maxTouchCfg_T6_obj.obj_addr,&value ,WRITE_T6_SIZE);
    	printk( "TEST_INFO_LEVELG" "software reset 0x%x = 0x%x\n",maxTouchCfg_T6_obj.obj_addr,value );
    	if( result )
    	{
    		printk( "ERROR_LEVEL:" "unable to software reset T6 object 0x%x = 0x%x\n",maxTouchCfg_T6_obj.obj_addr,value );
    	
    		return result;
    	}    	
    //msleep(64);
	msleep(100);
        	
	return result;
}

#if 0
//print right config obj
int print_mXT224_config(struct touchpad_t *g_tp)
{
	
	struct i2c_client *client = g_tp->client_4_i2c;
	int i,j;
	int result;
	uint8_t value;
	
	for ( i = 0 ; i < g_tp->id_info.num_obj_element ; i++ )
    	{
    		if( g_tp->init_obj_element[i]->value_array != NULL )
    		{
			for (j = 0 ; j < g_tp->init_obj_element[i]->size; j++ )
			{
				result = touchpad_read_i2c(client,g_tp->init_obj_element[i]->obj_addr+j,&value,1);
				printk("read reg_check 0x%x = 0x%x\n",g_tp->init_obj_element[i]->obj_addr+j,value );
				MY_INFO_PRINTK( 4, "INFO_LEVEL:" "read reg_check 0x%x = 0x%x\n",g_tp->init_obj_element[i]->obj_addr+j,value );
				if( result )
				{
					MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to read reg_check 0x%x = 0x%x\n",g_tp->init_obj_element[i]->obj_addr+j,value );
					
					return result;
				}
			}	
    		}
    	}
	return result;
}
#endif
#if 0
//the config file will be used in EVT3 for CANDO panel
static int copy_cando_config_to_obj_h(struct touchpad_t *g_tp)
{
	int result = 0;

    
    	memcpy(&maxTouchCfg_T38,&maxTouchCfg_T38_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T38 ));
	memcpy(&maxTouchCfg_T7,&maxTouchCfg_T7_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T7 ));
    	memcpy(&maxTouchCfg_T8,&maxTouchCfg_T8_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T8 ));
	memcpy(&maxTouchCfg_T9,&maxTouchCfg_T9_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T9 ));
	memcpy(&maxTouchCfg_T15,&maxTouchCfg_T15_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T15 ));
	memcpy(&maxTouchCfg_T18,&maxTouchCfg_T18_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T18 ));
    	memcpy(&maxTouchCfg_T19,&maxTouchCfg_T19_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T19 ));
	memcpy(&maxTouchCfg_T20,&maxTouchCfg_T20_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T20 ));
	memcpy(&maxTouchCfg_T22,&maxTouchCfg_T22_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T22 ));
	memcpy(&maxTouchCfg_T23,&maxTouchCfg_T23_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T23 ));
	memcpy(&maxTouchCfg_T24,&maxTouchCfg_T24_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T24 ));
	memcpy(&maxTouchCfg_T25,&maxTouchCfg_T25_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T25 )); 
	memcpy(&maxTouchCfg_T27,&maxTouchCfg_T27_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T27 ));
	memcpy(&maxTouchCfg_T28,&maxTouchCfg_T28_cando,(uint8_t)ARRAY_SIZE( maxTouchCfg_T28 ));
	
    	return result;
}
#endif
//the config file will be used in EVT3 for TPK panel

static int copy_tpk_config_to_obj_h(struct touchpad_t *g_tp)
{
	int result = 0;

   


    	memcpy(&maxTouchCfg_T38,&maxTouchCfg_T38_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T38_tpk_V20 ));
	memcpy(&maxTouchCfg_T7,&maxTouchCfg_T7_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T7_tpk_V20 ));
    	memcpy(&maxTouchCfg_T8,&maxTouchCfg_T8_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T8_tpk_V20 ));
	memcpy(&maxTouchCfg_T9,&maxTouchCfg_T9_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T9_tpk_V20 ));
	memcpy(&maxTouchCfg_T15,&maxTouchCfg_T15_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T15_tpk_V20 ));
	memcpy(&maxTouchCfg_T18,&maxTouchCfg_T18_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T18_tpk_V20 ));
    	memcpy(&maxTouchCfg_T19,&maxTouchCfg_T19_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T19_tpk_V20 ));
	memcpy(&maxTouchCfg_T20,&maxTouchCfg_T20_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T20_tpk_V20 ));
	memcpy(&maxTouchCfg_T22,&maxTouchCfg_T22_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T22_tpk_V20 ));
	memcpy(&maxTouchCfg_T23,&maxTouchCfg_T23_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T23_tpk_V20 ));
	memcpy(&maxTouchCfg_T24,&maxTouchCfg_T24_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T24_tpk_V20 ));
	memcpy(&maxTouchCfg_T25,&maxTouchCfg_T25_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T25_tpk_V20 )); 
	memcpy(&maxTouchCfg_T28,&maxTouchCfg_T28_tpk_V20,(uint8_t)ARRAY_SIZE( maxTouchCfg_T28_tpk_V20 ));


	
    	return result;
}



//checi if touch 2nd source
static int check_module_vendor(struct touchpad_t *g_tp)
{
	int result;
	uint8_t value;
	
	
	/* if the i2c addr is 0x4A,it's a tpk panel */
	g_tp->i2c_addr = 0x4A;
	result = touchpad_read_i2c( g_tp->client_4_i2c, ADD_ID_INFO_BLOCK, &value,1 );
	printk("check_module_vendor result1 is %d\n",result);
	if(result == 0) 
	{
		printk( "I2C addr is 0X%x !!!\n",g_tp->i2c_addr );
		printk( "It's a tpk panel !!!\n" );
		//check HW ID
		MY_INFO_PRINTK( 1, "INFO_LEVELG" "HW ID is used in EVT3 !!!\n" );
		//copy tpk obj config to right config obj
		copy_tpk_config_to_obj_h(g_tp);
		return 0;
		
	}	
	else 
	{
		/* if the i2c addr is 0x4B,it's a cando panel */
		g_tp->i2c_addr = 0x4B;
		result = touchpad_read_i2c( g_tp->client_4_i2c, ADD_ID_INFO_BLOCK, &value,1 );
		printk("check_module_vendor result2 is %d\n",result);
		if (result == 0)
		{
			printk( "I2C addr is 0X%x !!!\n",g_tp->i2c_addr );
			printk( "It's a cando panel !!!\n" );
			//copy tpk obj config to right config obj
			//copy_cando_config_to_obj_h(g_tp);
			return 0;
		}
		else
		{
			MY_INFO_PRINTK( 2, "ERROR_LEVELG" "Neither tpk panel nor cando panel is !!!\n" );
			return result;
		}
	}
	
    	return 0;
}

#define READ_MEM_OK                 1u
#define READ_MEM_FAILED             2u
#define WRITE_MEM_OK                1u
#define WRITE_MEM_FAILED            2u
#define QT_WAITING_BOOTLOAD_COMMAND 0xC0
#define QT_WAITING_FRAME_DATA       0x80
#define QT_FRAME_CRC_CHECK          0x02
#define QT_FRAME_CRC_PASS           0x04
#define QT_FRAME_CRC_FAIL           0x03
#define QT_APP_CRC_FAIL 			0x40

uint8_t boot_read_mem(uint16_t start, uint8_t size, uint8_t *mem)
{
    int     result;
    struct  i2c_msg msgs[] = { 
        [0] = {                     
            .addr   = 0x24,
            .flags  = I2C_M_RD,
            .buf    = (void *)mem,
            .len    = size
        }
    };
    

    result = i2c_transfer( g_tp->client_4_i2c->adapter, msgs, ARRAY_SIZE(msgs) );
    if( result != ARRAY_SIZE(msgs) )
    {
        MY_INFO_PRINTK( 2,"ERROR_LEVEL:""%s fail\n", __func__);
        return READ_MEM_FAILED;
    }

    return READ_MEM_OK;
}

int boot_qt602240_i2c_write(u16 reg, u8 *read_val, unsigned int len)
{
	struct i2c_msg wmsg;
	//unsigned char wbuf[3];
	unsigned char data[300];
	int ret,i;

	if(len+2 > 300)
	{
		printk("[TSP][ERROR] %s() data length error\n", __FUNCTION__);
		return -ENODEV;
	}

	wmsg.addr = 0x24;
	wmsg.flags = 0;
	wmsg.len = len;
	wmsg.buf = data;


	for (i = 0; i < len; i++)
	{
		data[i] = *(read_val+i);
	}

	//	printk("%s, %s\n",__func__,wbuf);
	ret = i2c_transfer(g_tp->client_4_i2c->adapter, &wmsg, 1);
	return ret;
}

static uint8_t boot_write_mem(uint16_t start, uint16_t size, uint8_t *mem)
{
	int ret;

	ret = boot_qt602240_i2c_write(start,mem,size);
	if(ret < 0){
		printk("boot write mem fail: %d \n",ret);
		return(WRITE_MEM_FAILED);
	}
	else
		return(WRITE_MEM_OK);
}

static uint8_t write_mem(uint16_t start, uint8_t size, uint8_t *mem)
{
	int ret;

	ret = touchpad_write_i2c(g_tp->client_4_i2c,start,mem,size);
	if(ret) 
		return(WRITE_MEM_FAILED);
	else
		return(WRITE_MEM_OK);
}

static uint8_t boot_unlock(void)
{

	int ret;
	unsigned char data[2];

	//   read_buf = (char *)kmalloc(size, GFP_KERNEL | GFP_ATOMIC);
	data[0] = 0xDC;
	data[1] = 0xAA;
	
	ret = boot_write_mem(0,2,(uint8_t*)data);
	if(ret == WRITE_MEM_FAILED) {
		printk("%s : i2c write failed\n",__func__);
		return(WRITE_MEM_FAILED);
	} 

	return(WRITE_MEM_OK);

}

//check if touch IC is in bootloader mode
static int is_bl_mode(void)
{
	struct i2c_client *client = g_tp->client_4_i2c;
	uint8_t boot_status;
	
	g_tp->i2c_addr = 0x24;
	if(touchpad_read_i2c( client, 0, &boot_status,1 ) == 0)
	{
		//printk("boot_status is 0x%x\n",boot_status);
		printk("touch ic is in bl mode\n");
		g_tp->i2c_addr = 0x4A;
		return 1;
	}
	else
	{
		printk("touch ic is NOT in bl mode\n");
		g_tp->i2c_addr = 0x4A;
		return 0;
	}
}

uint8_t QT_Boot(void)
{
		unsigned char boot_status;
		unsigned char boot_ver;
		unsigned char retry_cnt;
		//unsigned long f_size;
		unsigned long int character_position;
		unsigned int frame_size;
		unsigned int next_frame;
		unsigned int crc_error_count;
		//unsigned char *rd_msg;
		unsigned int size1,size2;
		unsigned int j,read_status_flag;
		uint8_t data = 0xA5;
		unsigned int last_frame = 0;
		uint8_t reset_result = 0;
	
		unsigned char  *firmware_data ;
	
		firmware_data = QT602240_firmware;
	
		crc_error_count = 0;
		character_position = 0;
		next_frame = 0;
	
		reset_result = write_mem(0xFB, 1, &data);
	
	
		if(reset_result != WRITE_MEM_OK)
		{
			for(retry_cnt =0; retry_cnt < 3; retry_cnt++)
			{
				msleep(100);
				reset_result = write_mem(0xFB, 1, &data);
				if(reset_result == WRITE_MEM_OK)
				{
					break;
				}
			}
	
		}
		if (reset_result == WRITE_MEM_OK)
			printk("Boot reset OK\r\n");

		msleep(100);
	
		for(retry_cnt = 0; retry_cnt < 30; retry_cnt++)
		{
			
			if( (boot_read_mem(0,1,&boot_status) == READ_MEM_OK) && (boot_status & 0xC0) == 0xC0) 
			{
				boot_ver = boot_status & 0x3F;
				crc_error_count = 0;
				character_position = 0;
				next_frame = 0;

				while(1)
				{ 
					for(j = 0; j<5; j++)
					{
						msleep(60);
						if(/*is_chg_low() &&*/ boot_read_mem(0,1,&boot_status) == READ_MEM_OK)
						{
							read_status_flag = 1;
							break;
						}
						else
						{
							printk("reading boot status\n");
							read_status_flag = 0;
						}
					}
					
					if(read_status_flag==1)	
		//			if(boot_read_mem(0,1,&boot_status) == READ_MEM_OK)
					{
						retry_cnt  = 0;
						printk("TSP boot status is %x		stage 2 \n", boot_status);
						if((boot_status & QT_WAITING_BOOTLOAD_COMMAND) == QT_WAITING_BOOTLOAD_COMMAND)
						{
							if(boot_unlock() == WRITE_MEM_OK)
							{
								msleep(10);
			
								printk("Unlock OK\n");
			
							}
							else
							{
								printk("Unlock fail\n");
							}
						}
						else if((boot_status & 0xC0) == QT_WAITING_FRAME_DATA)
						{
								/* Add 2 to frame size, as the CRC bytes are not included */
								size1 =  *(firmware_data+character_position);
								size2 =  *(firmware_data+character_position+1)+2;
								frame_size = (size1<<8) + size2;
				
								printk("Frame size:%d\n", frame_size);
								printk("Firmware pos:%ld\n", character_position);
								/* Exit if frame data size is zero */
								if( 0 == frame_size )
								{
									//if(QT_i2c_address == I2C_BOOT_ADDR_0)
									//{
									//	QT_i2c_address = I2C_APPL_ADDR_0;
									//}
									printk("0 == frame_size\n");
									return 1;
								}
								printk("len[0]=%x len[1]=%x\n",*(firmware_data +character_position),*(firmware_data +character_position+1));
								next_frame = 1;
								boot_write_mem(0,frame_size, (firmware_data +character_position));
								msleep(10);
								printk(".");
								if(frame_size+character_position >= sizeof(QT602240_firmware))
								{
									printk("frame_size+character_position=%ld sizeof(QT602240_firmware)=%d\n",frame_size+character_position,sizeof(QT602240_firmware));
									last_frame = 1;
								}
						}
						else if(boot_status == QT_FRAME_CRC_CHECK)
						{
							printk("CRC Check\n");
						}
						else if(boot_status == QT_FRAME_CRC_PASS)
						{
							if( next_frame == 1)
							{
								printk("CRC Ok\n");
								character_position += frame_size;
								next_frame = 0;
							}
							else {
								printk("next_frame != 1\n");
							}
							if(last_frame) 
							{
								msleep(500);
								printk("quit QT_BOOT\n");
								return 0;
							}
						}
						else if(boot_status  == QT_FRAME_CRC_FAIL)
						{
							printk("CRC Fail\n");
							crc_error_count++;
						}
						if(crc_error_count > 10)
						{
							return QT_FRAME_CRC_FAIL;
						}
			
					}
					else
					{
						return (0);
					}
				}
			}
			else
			{
				printk("[TSP] read_boot_state() or (boot_status & 0xC0) == 0xC0) is fail!!!\n");
			}
		}
		
		printk("QT_Boot end \n");
		return (0);
}

static int touchpad_detect_mXT224(struct touchpad_t *g_tp)
{
	int result;
    	uint8_t value[NUM_OF_ID_INFO_BLOCK];
    	uint16_t obj_addr;
#ifdef TOUCH_DEBUG
    	int i = 0;
#endif
    	int t = 0;
    	uint8_t reportid_ub = 1;
    	
	//check if touch panel is tpk or cando
    	result = check_module_vendor(g_tp);
    	//touchpad_enter_bootload(g_tp);

    	if(is_bl_mode())
	{
		QT_Boot();
	}

	
    //read ID info block
    	result = touchpad_read_i2c( g_tp->client_4_i2c, ADD_ID_INFO_BLOCK, &value[0],NUM_OF_ID_INFO_BLOCK );
    //printk("valus is %x,%x,%x\n",value[0],value[2],value[3]);
    	if( result || !(value[0] == 0x80 && (value[2] == 0x20 ||value[2] == 0x16 || value[2] == 0xF6) && (value[3] == 0xAA || value[3] == 0xAB) ) )
    	{
        	printk(  "ERROR_LEVEL:" "unable to read reg 0xh and value failed 0x%x, return %d\n",value[0],result );
        	return result;
    	}
    //fill in id info
    	g_tp->id_info.family_id = value[0];
    	g_tp->id_info.variant_id = value[1];
    	g_tp->id_info.version = value[2];
    	g_tp->id_info.build = value[3];
    	g_tp->id_info.matrix_x_size = value[4];
    	g_tp->id_info.matrix_y_size = value[5];
    	g_tp->id_info.num_obj_element = value[6];
    //print ID info block
#ifdef TOUCH_DEBUG
    	for ( regbuf = ADD_ID_INFO_BLOCK; regbuf< NUM_OF_ID_INFO_BLOCK; regbuf++ )
    	{
    		printk( "TEST_INFO_LEVEL:" "read 0x%xh = 0x%x\n",regbuf, value[regbuf] );
    		i++;
    	}
   
    	printk(  "TEST_INFO_LEVEL:" "read num_obj_element = %d\n",g_tp->id_info.num_obj_element );
#endif
    //read object table element
    	for ( obj_addr = OBJECT_TABLE_ELEMENT_1 ; obj_addr < OBJECT_TABLE_ELEMENT_1+OBJECT_TABLE_ELEMENT_SIZE*g_tp->id_info.num_obj_element ; obj_addr += OBJECT_TABLE_ELEMENT_SIZE )
    	{
	    	result = touchpad_read_i2c( g_tp->client_4_i2c, obj_addr, &value[0], OBJECT_TABLE_ELEMENT_SIZE );
	    	MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "read 0x%x = 0x%x\n",obj_addr, value[0] );
	    	if( result )
	    	{
	        	MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to read reg 0x%x and value failed 0x%x, return %d\n",obj_addr, value[0],result );
	        	
	        	return result;
	    	}
		//return result;
	        MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "GEN_MESSAGEPROCESOR_T5 0x%x\n",GEN_MESSAGEPROCESOR_T5 );
	        MY_INFO_PRINTK( 4, "TEST_INFO_LEVEL:" "GEN_COMMANDPROCESSOR_T6 0x%x\n",GEN_COMMANDPROCESSOR_T6 ); 
	    	if ( t < MAX_OBJ_ELEMENT_SIZE )	
	    	{	
	        	//init reg T5
	        	fillin_init_obj_table( GEN_MESSAGEPROCESOR_T5, &maxTouchCfg_T5_obj, value, &reportid_ub,
	        	                       	obj_addr, 0, &t );
	        	//init reg T6
	        	fillin_init_obj_table( GEN_COMMANDPROCESSOR_T6, &maxTouchCfg_T6_obj, value, &reportid_ub,
	        	                        obj_addr, 0, &t );
	        	//init reg T38
	        	fillin_init_obj_table( SPT_USERDATA_T38, &maxTouchCfg_T38_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T38 ), &t );        
	        	//init reg T7
	        	fillin_init_obj_table( GEN_POWERCONFIG_T7, &maxTouchCfg_T7_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T7 ), &t );
	        	//init reg T8
	        	fillin_init_obj_table( GEN_ACQUISITIONCONFIG_T8, &maxTouchCfg_T8_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T8 ), &t );
	        	//init reg T9
	        	fillin_init_obj_table( TOUCH_MULTITOUCHSCREEN_T9, &maxTouchCfg_T9_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T9 ), &t );
	        	//init reg T15
	        	fillin_init_obj_table( TOUCH_KEYARRAY_T15, &maxTouchCfg_T15_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T15 ), &t );
	        	//init reg T18
	        	fillin_init_obj_table( SPT_COMMSCONFIG_T18, &maxTouchCfg_T18_obj, value,  &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T18 ), &t );
	        	//init reg T19
	        	fillin_init_obj_table( SPT_GPIOPWM_T19, &maxTouchCfg_T19_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T19 ), &t );
	        	//init reg T20
	        	fillin_init_obj_table( PROCI_GRIPFACESUPPRESSION_T20, &maxTouchCfg_T20_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T20 ), &t );
	        	//init reg T22
	        	fillin_init_obj_table( PROCG_NOISESUPPRESSION_T22, &maxTouchCfg_T22_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T22 ), &t );
	        	//init reg T23
	        	fillin_init_obj_table( TOUCH_PROXIMITY_T23, &maxTouchCfg_T23_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T23 ), &t );
	        	//init reg T24
	        	fillin_init_obj_table( PROCI_ONETOUCHGESTUREPROCESSOR_T24, &maxTouchCfg_T24_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T24 ), &t );
	        	//init reg T25
	        	fillin_init_obj_table( SPT_SELFTEST_T25, &maxTouchCfg_T25_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T25 ), &t );
	        	//init reg T27
	        	fillin_init_obj_table( PROCI_TWOTOUCHGESTUREPROCESSOR_T27, &maxTouchCfg_T27_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T27 ), &t );
	        	//init reg T28
	        	fillin_init_obj_table( SPT_CTECONFIG_T28, &maxTouchCfg_T28_obj, value, &reportid_ub,
	        		                    obj_addr, (uint8_t)ARRAY_SIZE( maxTouchCfg_T28 ), &t );
	        	//init reg T37
	        	fillin_init_obj_table( DEBUG_DIAGNOSTIC_T37, &maxTouchCfg_T37_obj, value, &reportid_ub,
	        	                        obj_addr, 0, &t );	
			fillin_init_obj_table( SPT_MESSAGECOUNT_T44, &maxTouchCfg_T44_obj, value, &reportid_ub,
	        	                        obj_addr, 0, &t );	
	        } 
	        else
	        {
				printk( "ERROR_LEVEL:" "touchpad_detect_mXT224: failed to fille in  obj table , it's overflow\n" );
	        }
	}
	
    	return 0;
}

static int power_on_flow_another_way(struct touchpad_t *g_tp)
{
	int result;
	int obj_size = (int)( maxTouchCfg_T5_obj.size );
	uint8_t value[obj_size];
	uint16_t regbuf;
	int i;
	int j = 0;
	
	
	printk(  "power_on_flow_another_way:" "read obj size :%d\n", obj_size );
	
	result = touchpad_config_mXT224(g_tp); //load all config parameters
	if( result )
       	{
        	printk( "ERROR_LEVEL:" "touchpad_probe: failed to config mXT224 (result=%d)\n",result );
        
        	return result;
       	}
		
	//get gpio : check CHG pin is low
    	result = gpio_get_value_cansleep(g_tp->gpio_num);
    	if( result )
    	{
        	printk(  "ERROR_LEVEL:" " the CHG pin is not low.)\n" );
		printk( "ERROR_LEVEL:" "touchpad_probe: failed to get gpio_num value %d (result=%d)\n",g_tp->gpio_num,result );
        
        	return result;
    	}
    	
    	for (;;)
	{
		touchpad_read_i2c( g_tp->client_4_i2c, maxTouchCfg_T5_obj.obj_addr, &value[0],obj_size ); //read message table
    		i = 0;
    	//print message and command obj table
    		for ( regbuf = maxTouchCfg_T5_obj.obj_addr; regbuf < maxTouchCfg_T5_obj.obj_addr+maxTouchCfg_T5_obj.size; regbuf++ )
    		{
    			printk(  "INFO_LEVEL:" "read message & cmd obj 0x%xh = 0x%x\n",regbuf, value[i] );
    			i++;
    		}
    	//check if report id is 1
    		if( value[0] >= maxTouchCfg_T6_obj.reportid_ub && value[0] <= maxTouchCfg_T6_obj.reportid_lb )
    		{
	    		//check if CFGERR bit is 0
	    		if( (value[1] & CFGERR_MASK) != 0x0 )
	    		{
	    			printk( "ERROR_LEVEL:" "failed to  CFGERR bit : 0x%x  \n", value[1] );
	    			
	    			return -EFAULT;
	        	}
	        	else
	        	{
	        		printk(  "INFO_LEVEL:" "check CFGERR  0x%x\n", value[1] );
	    			g_tp->T6_config_checksum = value[2] | value[3]<< 8 | value[4]<<16;
	    			printk( "INFO_LEVEL:" "T6 config checksum : 0x%x\n",g_tp->T6_config_checksum );
	    			result = calculate_config_crc(g_tp);
	    			if ( result )
	    			{
	    				printk( "ERROR_LEVEL:" "failed to calculate config crc : %d\n", result );
	    				
	    				return -EFAULT;
	    			}
	    			break;
	        	}
    		}
    		else
    		{
	    		if ( j > 10 )
	    		{
	    			printk( "ERROR_LEVEL:" "failed to read T6 message\n" );
	    			
	    			return -EFAULT;
	    		}
	    		j++;	
    		}	
	}
    	
    	return 0;
}

//read message and check CFGERR bit 1:yes ,0 : no
static int power_on_flow_one_way(struct touchpad_t *g_tp)
{
	int result;
	int obj_size = (int)( maxTouchCfg_T5_obj.size );
	uint8_t value[obj_size];
	//uint16_t regbuf;
	//int i;
	int j = 0;
	
	
	printk( "power_on_flow_one_way:" "read obj size :%d,obj_addr is %d\n", obj_size,maxTouchCfg_T5_obj.obj_addr );
	for (;;)
	{
		touchpad_read_i2c( g_tp->client_4_i2c, maxTouchCfg_T5_obj.obj_addr, &value[0],obj_size ); //read message table
    	      // i = 0;
    	
		//print message and command obj table
#ifdef TOUCH_DEBUG
    	for ( regbuf = maxTouchCfg_T5_obj.obj_addr; regbuf < maxTouchCfg_T5_obj.obj_addr+maxTouchCfg_T5_obj.size; regbuf++ )
    	{
    		printk( "INFO_LEVEL:" "read message & cmd obj 0x%xh = 0x%x\n",regbuf, value[i] );
    		i++;
    	}
    	//check if report id is 1
    	printk("value[0] =%d,reportid_ub=%d,reportid_lb=%d\n",value[0],maxTouchCfg_T6_obj.reportid_ub,maxTouchCfg_T6_obj.reportid_lb);
#endif
    	if( value[0] >= maxTouchCfg_T6_obj.reportid_ub && value[0] <= maxTouchCfg_T6_obj.reportid_lb )
    	{
    		//check if CFGERR bit is 0
    		if( (value[1] & CFGERR_MASK) != 0x0 )
    		{
    			printk( "ERROR_LEVEL:" "failed to  CFGERR bit : 0x%x  \n", value[1] );
        		result = power_on_flow_another_way(g_tp);
        		if ( result )
    			{
    				printk( "ERROR_LEVEL:""failed to power on flow another way : 0x%x  \n", result );
    				
    				return result;
    			}	
    			return result;
        	}
        	else
        	{
        		printk( "INFO_LEVEL:" "check CFGERR  0x%x\n", value[1] );
    			g_tp->T6_config_checksum = value[2] | value[3]<< 8 | value[4]<<16;
    			printk( "INFO_LEVEL:" "T6 config checksum : 0x%x\n",g_tp->T6_config_checksum );				
    			result = calculate_config_crc(g_tp);
    			if ( result )
    			{
    				printk( "ERROR_LEVEL:" "failed to calculate config crc : 0x%x\n", result );
    				result = power_on_flow_another_way(g_tp);
    				    if ( result )
    				    {
    				    	printk( "ERROR_LEVEL:" "failed to power on flow another way : 0x%x\n", result );
    				    	return result;
    				    }
    				    return result;
    			}
    			break;
        	}
    	}
    	else
    	{
    		if ( j > 10 )
    		{
    			printk( "ERROR_LEVEL:" "failed to read T6 message\n" );
    			
    			return -EFAULT;
    		}
    		j++;
    	}
	}
    	
    	return 0;
}

static long tp_misc_ioctl( struct file *fp,
                           unsigned int cmd,
                           unsigned long arg )
{	
	struct i2c_client *client = g_tp->client_4_i2c;
	struct   atmel_touchscreen_platform_data_t *pdata;
	
    	struct atmel_sensitivity_t sensitivity;
	struct atmel_power_mode_t power_mode;
	struct atmel_linerity_t linerity;
	struct atmel_merge_t merge;
	struct atmel_noise_suppression_t noise_suppression;
	struct atmel_references_mode_t references_mode;
	struct atmel_deltas_mode_t deltas_mode;
	struct atmel_gain_t gain;
	struct atmel_cte_mode_t cte_mode;
	
	
	int  result = 0;
	uint8_t value[8];
	uint8_t debug_info[2];
	uint8_t value_T37[130];
	uint8_t value_cte[18];
	uint8_t value_backup[4];
	uint8_t value_T6_reset;
    	uint16_t addr = 0;
	uint16_t addr_key = 0;
	uint16_t addr_T37 = 0;
	uint16_t addr_cte = 0;
	uint16_t addr_cmd = 0;
	uint16_t addr_diagnostic = 0;
	uint16_t addr_T6 = 0;
    	uint8_t *pData = NULL;
    	uint    length = 0;
	
	
	MY_INFO_PRINTK( 1,"INFO_LEVEL:" "cmd number=%d\n", _IOC_NR(cmd) );
	switch(cmd)
    	{

		case  ATMEL_TOUCH_IOCTL_FOR_DEBUG:
			pdata = client->dev.platform_data;
			debug_info[0]=pdata->get_irq_status();
			tp_read_T5_via_i2c( client , &value[0], maxTouchCfg_T5_obj.size );   
			printk("report id is %d,value is %x\n",value[0],value[1]);
			debug_info[1]=value[1];
			result = copy_to_user( (void *)arg,&debug_info[0],2 );
		break;
				
    		case ATMEL_TOUCH_IOCTL_GET_INFO:
			addr = ADD_ID_INFO_BLOCK;
            		result = touchpad_read_i2c( client, addr, &value[0], 3 );
			if (result)
			{
				printk( "ERROR_LEVEL:" "failed to read GET_VERSION!\n" );
                		result = -EFAULT;
				return result;
			}
			result = copy_to_user( (void *)arg,&value[0],3 );
			if (result)
			{
				printk( "ERROR_LEVEL:" "copy GET_VERSION to user failed!\n" );
                		result = -EFAULT;
				return result;
			}
			printk( "INFO_LEVEL:" "value[0]: %x\n",value[0] );
            break;
		case ATMEL_TOUCH_IOCTL_SET_SENSITIVITY:
	            	addr = maxTouchCfg_T9_obj.obj_addr+7;
			addr_key = maxTouchCfg_T15_obj.obj_addr+7;
	            	pData = (void *)&sensitivity;
	            	length = sizeof(sensitivity);
	            	if( copy_from_user( (void *)pData,
	                                (void *)arg,
	                                length) )
	            	{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy SET_SENSITIVITY from user failed!\n" );
	                	result = -EFAULT;
				return result;
	            	}
			else
			{
	              		value[0] = sensitivity.touch_threshold;
				value[1] = sensitivity.key_threshold;
				result = touchpad_write_i2c( client, addr, &value[0], 1 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_TOUCH_SENSITIVITY!\n" );
					result = -EFAULT;
					return result;
				}
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_TOUCH_SENSITIVITY: %x\n", value[0]);
				result = touchpad_write_i2c( client, addr_key, &value[1], 1 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_KEY_SENSITIVITY!\n" );
					result = -EFAULT;
					return result;
				}
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_KEY_SENSITIVITY: %x\n", value[1]);
	            	}
            	break;
		case ATMEL_TOUCH_IOCTL_GET_SENSITIVITY:
			addr = maxTouchCfg_T9_obj.obj_addr+7;
			addr_key = maxTouchCfg_T15_obj.obj_addr+7;
            		pData = (void *)&sensitivity;
            		length = sizeof(sensitivity);
            		result = touchpad_read_i2c( client, addr, &value[0], 1 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_TOUCH_SENSITIVITY!\n" );
                		result = -EFAULT;
				return result;
			}
			result = touchpad_read_i2c( client, addr_key, &value[1], 1 ); //key sensitivity
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_KEY_SENSITIVITY!\n" );
                		result = -EFAULT;
				return result;
			}
			result = copy_to_user( (void *)arg,&value[0],2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy GET_TOUCH_SENSITIVITY to user failed!\n" );
                		result = -EFAULT;
				return result;
			}
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "GET_TOUCH_SENSITIVITY: %x\n",value[0] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "GET_KEY_SENSITIVITY: %x\n",value[1] );
            	break;
		case ATMEL_TOUCH_IOCTL_SET_POWER_MODE:
            		addr = maxTouchCfg_T7_obj.obj_addr;
            		pData = (void *)&power_mode;
            		length = sizeof(power_mode);
            		if( copy_from_user( (void *)pData,
                                (void *)arg,
                                length) )
            		{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy power_mode from user failed!\n" );
                		result = -EFAULT;
				return result;
                		break;
            		}
            		else
			{
				value[0] = power_mode.idleacqint;
				value[1] = power_mode.actvacqint;
				value[2] = power_mode.actv2idleto;
				result = touchpad_write_i2c( client, addr, &value[0], 3 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_POWER_MODE!\n" );
					result = -EFAULT;
					return result;
				}
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_POWER_MODE: idleacqint %x\n", value[0]);
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_POWER_MODE: actvacqint %x\n", value[1]);
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_POWER_MODE: actv2idleto %x\n", value[2]);
			}
            	break;
        	case ATMEL_TOUCH_IOCTL_GET_POWER_MODE:
            		addr = maxTouchCfg_T7_obj.obj_addr;
            		pData = (void *)&power_mode;
            		length = sizeof(power_mode);
            		result = touchpad_read_i2c( client, addr, &value[0], 3 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_POWER_MODE!\n" );
                		result = -EFAULT;
				return result;
			}
			result = copy_to_user( (void *)arg,&value[0],3 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy GET_POWER_MODE to user failed!\n" );
                		result = -EFAULT;
				return result;
			}
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[1]: %x\n",value[0] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[2]: %x\n",value[1] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[3]: %x\n",value[2] );
            	break;
		case ATMEL_TOUCH_IOCTL_SET_LINERITY:
            		addr = maxTouchCfg_T9_obj.obj_addr+11;
            		pData = (void *)&linerity;
            		length = sizeof(linerity);
            		if( copy_from_user( (void *)pData,
                                (void *)arg,
                                length) )
            		{
                		MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy linerity from user failed!\n" );
                		result = -EFAULT;
				return result;
            		}
			else
			{
                		value[0] = linerity.movhysti;
				value[1] = linerity.movhystn;
				result = touchpad_write_i2c( client, addr, &value[0], 2 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_LINERITY!\n" );
					result = -EFAULT;
					return result;
				}
            		}
            	break;
        	case ATMEL_TOUCH_IOCTL_GET_LINERITY:
            		addr = maxTouchCfg_T9_obj.obj_addr+11;
            		pData = (void *)&linerity;
            		length = sizeof(linerity);
            		result = touchpad_read_i2c( client, addr, &value[0], 2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_LINERITY!\n" );
                		result = -EFAULT;
				return result;
			}
			result = copy_to_user( (void *)arg,&value[0],2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy GET_LINERITY to user failed!\n" );
                		result = -EFAULT;
				return result;
			}
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[4]: %x\n",value[0] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[5]: %x\n",value[1] );
            	break;
		case ATMEL_TOUCH_IOCTL_SET_MERGE:
            		addr = maxTouchCfg_T9_obj.obj_addr+15;
            		pData = (void *)&merge;
            		length = sizeof(merge);
            		if( copy_from_user( (void *)pData,
                                (void *)arg,
                                length) )
            		{
                		MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy merge from user failed!\n" );
                		result = -EFAULT;
				return result;
            		}
			else
			{
              			value[0] = merge.mrghyst;
				value[1] = merge.mrgthr;
				result = touchpad_write_i2c( client, addr, &value[0], 2 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_MERGE!\n" );
					result = -EFAULT;
					return result;
				}
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_MERGE: mrghyst %x\n", value[0]);
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_MERGE: mrgthr %x\n", value[1]);
            		}
            	break;
        	case ATMEL_TOUCH_IOCTL_GET_MERGE:
            		addr = maxTouchCfg_T9_obj.obj_addr+15;
            		pData = (void *)&merge;
            		length = sizeof(merge);
            		result = touchpad_read_i2c( client, addr, &value[0], 2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_MERGE!\n" );
                		result = -EFAULT;
				return result;
			}
			result = copy_to_user( (void *)arg,&value[0],2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy GET_MERGE to user failed!\n" );
                		result = -EFAULT;
				return result;
			}
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[6]: %x\n",value[0] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[7]: %x\n",value[1] );
            	break;
		case ATMEL_TOUCH_IOCTL_SET_NOISE_SUPPRESSION:
            		addr = maxTouchCfg_T22_obj.obj_addr;
            		pData = (void *)&noise_suppression;
            		length = sizeof(noise_suppression);
            		if( copy_from_user( (void *)pData,
                                (void *)arg,
                                length) )
            		{
                		MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy noise_suppression from user failed!\n" );
                		result = -EFAULT;
				return result;
            		}
			else
			{
                		value[0] = noise_suppression.ctrl;
				result = touchpad_write_i2c( client, addr, &value[0], 1 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_NOISE_SUPPRESSION!\n" );
					result = -EFAULT;
					return result;
				}
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_NOISE_SUPPRESSION: ctrl %x\n", value[0]);
				
				value[1]  = noise_suppression.noisethr;
				addr = maxTouchCfg_T22_obj.obj_addr+8;
				result = touchpad_write_i2c( client, addr, &value[1], 1 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_NOISE_SUPPRESSION!\n" );
					result = -EFAULT;
					return result;
				}
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_NOISE_SUPPRESSION: noisethr %x\n", value[1]);
				value[2] = noise_suppression.freqhopscale;
				value[3] = noise_suppression.freq_0;
				value[4] = noise_suppression.freq_1;
				value[5] = noise_suppression.freq_2;
				value[6] = noise_suppression.freq_3;
				value[7] = noise_suppression.freq_4;
				addr = maxTouchCfg_T22_obj.obj_addr+10;
				result = touchpad_write_i2c( client, addr, &value[2], 6 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_NOISE_SUPPRESSION!\n" );
					result = -EFAULT;
					return result;
				}
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_NOISE_SUPPRESSION: freqhopscale %x\n", value[2]);
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_NOISE_SUPPRESSION: freq_0 %x\n", value[3]);
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_NOISE_SUPPRESSION: freq_1 %x\n", value[4]);
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_NOISE_SUPPRESSION: freq_2 %x\n", value[5]);
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_NOISE_SUPPRESSION: freq_3 %x\n", value[6]);
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_NOISE_SUPPRESSION: freq_4 %x\n", value[7]);
            		}
            	break;
        	case ATMEL_TOUCH_IOCTL_GET_NOISE_SUPPRESSION:
            		addr = maxTouchCfg_T22_obj.obj_addr;
            		pData = (void *)&noise_suppression;
            		length = sizeof(noise_suppression);
            		result = touchpad_read_i2c( client, addr, &value[0], 1 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_NOISE_SUPPRESSION!\n" );
                		result = -EFAULT;
				return result;
			}
			addr = maxTouchCfg_T22_obj.obj_addr+8;
            		result = touchpad_read_i2c( client, addr, &value[1], 1 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_NOISE_SUPPRESSION!\n" );
                		result = -EFAULT;
				return result;
			}
			addr = maxTouchCfg_T22_obj.obj_addr+10;
            		result = touchpad_read_i2c( client, addr, &value[2], 6 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_NOISE_SUPPRESSION!\n" );
                		result = -EFAULT;
				return result;
			}
			result = copy_to_user( (void *)arg,&value[0],8 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy GET_NOISE_SUPPRESSION to user failed!\n" );
                		result = -EFAULT;
				return result;
			}
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[8]: %x\n",value[0] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[9]: %x\n",value[1] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[10]: %x\n",value[2] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[11]: %x\n",value[3] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[12]: %x\n",value[4] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[13]: %x\n",value[5] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[14]: %x\n",value[6] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "value[15]: %x\n",value[7] );
            	break;	
		case ATMEL_TOUCH_IOCTL_SET_POWER_SWITCH:
        	{
			struct atmel_power_switch_t power;	
            		if( copy_from_user( (void *)&power,
                                (void *)arg,
                                sizeof(power) ) )
            		{
                		MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy POWER_SWITCH from user failed!\n");
                		result = -EFAULT;
				return result;
            		}
            		if( power.on )
                		tp_resume(&g_tp->touch_early_suspend);
            		else
                		tp_suspend(&g_tp->touch_early_suspend);
            	break;
        	}
		case ATMEL_TOUCH_IOCTL_GET_REFERENCES_MODE:
		{
			int i,j,k,h;
			
			addr_T37 = maxTouchCfg_T37_obj.obj_addr;
            		pData = (void *)&references_mode;
            		length = sizeof(references_mode);
			k = 0; h = 0;	
			addr = maxTouchCfg_T6_obj.obj_addr+5;
        		mutex_lock(&g_tp->mutex);
            		for ( i = 0; i < 4; i++ )
			{	
				if ( i == 0 )
				{
					value[0] = 0x11;
					result = touchpad_write_i2c( client, addr, &value[0], 1 );
					if (result)
					{
						MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_REFERENCES_MODE!\n" );
						result = -EFAULT;
						mutex_unlock(&g_tp->mutex);
						return result;
				    	}
					MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_REFERENCES_MODE: references data G %d\n", (int)value[0]);
					msleep(100);
				}
				else
				{
					value[0] = 0x1;
					result = touchpad_write_i2c( client, addr, &value[0], 1 );
					if (result)
					{
						MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_REFERENCES_MODE!\n" );
						result = -EFAULT;
						mutex_unlock(&g_tp->mutex);
						return result;
				    	}
					MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_REFERENCES_MODE: references value : %d\n", (int)value[0]);
					msleep(100);
				}
				result = touchpad_read_i2c( client, addr_T37, &value_T37[0], 130 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_REFERENCES_MODE!\n" );
					result = -EFAULT;
					mutex_unlock(&g_tp->mutex);
					return result;
				}
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "reserve : %d\n",(int)value_T37[0] );
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "page : %d\n",(int)value_T37[1] );
				for ( j = 2 ; j < 129 ; j+=2 )
				{
					if ( h >= y_channel )
					{
						h = 0;
						k++;
						if ( k >= x_channel )
						{
							break;
						}
					}
					references_mode.data[k][h] = value_T37[j] | value_T37[j+1] << 8;
					MY_INFO_PRINTK( 4,"INFO_LEVEL:" "( x%d , y%d ) : %d\n",k,h,(int)references_mode.data[k][h] );
					h++;
				}
			}
			mutex_unlock(&g_tp->mutex);
			result = copy_to_user( (void *)arg,pData, length );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy ATMEL_TOUCH_IOCTL_GET_REFERENCES_MODE to user failed!\n" );
				result = -EFAULT;
				return result;
			}
            	break;
		}
		case ATMEL_TOUCH_IOCTL_GET_DELTAS_MODE:
		{
			int  i,j;
			//int16_t delta_value;
			uint8_t data_buffer[NUM_OF_REF_MODE_PAGE][SIZE_OF_REF_MODE_PAGE];
			
            		pData = (void *)&deltas_mode;
            		length = sizeof(deltas_mode);
			
        		mutex_lock(&g_tp->mutex);
            		read_T37(g_tp,data_buffer,0x10);
			mutex_unlock(&g_tp->mutex);
			
			for(i=0;i<x_channel;i++)
			{
				for(j=0;j<y_channel;j++)
				{
					deltas_mode.deltas[i][j] = (int16_t)get_ref_value(i,j,data_buffer);
					MY_INFO_PRINTK( 4,"INFO_LEVEL:""x[%d]y[%d] = %d\n",i,j,deltas_mode.deltas[i][j]);
				}
			}
			
			result = copy_to_user( (void *)arg,pData, length );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy ATMEL_TOUCH_IOCTL_GET_DELTAS_MODE to user failed!\n" );
				result = -EFAULT;
				return result;
			}
            	break;
		}
		case ATMEL_TOUCH_IOCTL_SET_GAIN:
            		addr = maxTouchCfg_T9_obj.obj_addr+6;
			addr_key = maxTouchCfg_T15_obj.obj_addr+6;
            		pData = (void *)&gain;
            		length = sizeof(gain);
            		if( copy_from_user( (void *)pData,
                                (void *)arg,
                                length) )
            		{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy SET_GAIN from user failed!\n" );
                		result = -EFAULT;
				return result;
            		}
			else
			{
                		value[0] = gain.touch_blen;
				value[1] = gain.key_blen;
				result = touchpad_write_i2c( client, addr, &value[0], 1 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_TOUCH_GAIN!\n" );
					result = -EFAULT;
					return result;
				}
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_TOUCH_GAIN: %x\n", value[0]);
				result = touchpad_write_i2c( client, addr_key, &value[1], 1 );
				if (result)
				{
					MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write SET_KEY_GAIN!\n" );
					result = -EFAULT;
					return result;
				}
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "SET_KEY_GAIN: %x\n", value[1]);
            		}
            	break;
		case ATMEL_TOUCH_IOCTL_GET_GAIN:
			addr = maxTouchCfg_T9_obj.obj_addr+6;
			addr_key = maxTouchCfg_T15_obj.obj_addr+6;
            		pData = (void *)&gain;
            		length = sizeof(gain);
            		result = touchpad_read_i2c( client, addr, &value[0], 1 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_TOUCH_GAIN!\n" );
                		result = -EFAULT;
				return result;
			}
			result = touchpad_read_i2c( client, addr_key, &value[1], 1 ); //key gain
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_KEY_GAIN!\n" );
                		result = -EFAULT;
				return result;
			}
			result = copy_to_user( (void *)arg,&value[0],2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy GET_TOUCH_GAIN to user failed!\n" );
                		result = -EFAULT;
				return result;
			}
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "GET_TOUCH_GAIN: %x\n",value[0] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "GET_KEY_GAIN: %x\n",value[1] );
            	break;
		case ATMEL_TOUCH_IOCTL_GET_CTE_MODE:
		{
			int i;
			addr_T37 = maxTouchCfg_T37_obj.obj_addr;
            		addr = maxTouchCfg_T7_obj.obj_addr;
			addr_cte = maxTouchCfg_T28_obj.obj_addr+3;
			addr_cmd = maxTouchCfg_T28_obj.obj_addr+1;
			addr_diagnostic = maxTouchCfg_T6_obj.obj_addr+5;
			addr_T6 = maxTouchCfg_T6_obj.obj_addr+1;
            		pData = (void *)&cte_mode;
            		length = sizeof(cte_mode);
        	
			mutex_lock(&g_tp->mutex);
			//backup T7 & T28 register value
			result = touchpad_read_i2c( client, addr, &value_backup[0], 2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read T7!\n" );
				result = -EFAULT;
				mutex_unlock(&g_tp->mutex);
				return result;
			}
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "GET_CTE_MODE read T7 idleacqint: %x\n", value_backup[0]);
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "GET_CTE_MODE readT7 actvacqint: %x\n", value_backup[1]);
			result = touchpad_read_i2c( client, addr_cte, &value_backup[2], 2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read T28!\n" );
				result = -EFAULT;
				mutex_unlock(&g_tp->mutex);
				return result;
			}
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "GET_CTE_MODE read T28 idlegcafdepth: %x\n", value_backup[2]);
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "GET_CTE_MODE read T28 actvgcafdepth: %x\n", value_backup[3]);
			//set T7BT28 & T6 configuration obj parameters
			value[0] = 0xA;
			value[1] = 0xA;
			value[2] = 0x8;
			value[3] = 0x8;
			value[4] = 0xA5;
			value[5] = 0x31;
			result = touchpad_write_i2c( client, addr, &value[0], 2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write T7!\n" );
				result = -EFAULT;
				mutex_unlock(&g_tp->mutex);
				return result;
			}
			result = touchpad_write_i2c( client, addr_cte, &value[2], 2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write T28!\n" );
				result = -EFAULT;
				mutex_unlock(&g_tp->mutex);
				return result;
			}
			//send the low level gain calibration command to device
			result = touchpad_write_i2c( client, addr_cmd, &value[4], 1 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write T28 CMD!\n" );
				result = -EFAULT;
				mutex_unlock(&g_tp->mutex);
				return result;
			}
			msleep(100);
			//send the diagnostic command to the device
			result = touchpad_write_i2c( client, addr_diagnostic, &value[5], 1 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write T6!\n" );
				result = -EFAULT;
				mutex_unlock(&g_tp->mutex);
				return result;
			}
			msleep(100);
			result = touchpad_read_i2c( client, addr_T37, &value_cte[0], 18 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to read GET_CTE_MODE!\n" );
				result = -EFAULT;
				mutex_unlock(&g_tp->mutex);
				return result;
			}
			for ( i = 2 ; i < 18 ; i++ )
			{
				cte_mode.cte_data[i-2] = value_cte[i];
			}
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "Current Mode : 0x%x\n",value_cte[0] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "Page NO. : 0x%x\n",value_cte[1] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "number of Y line : %d\n",(int)cte_mode.cte_data[0] );
			MY_INFO_PRINTK( 4,"INFO_LEVEL:" "Reserved : %d\n",(int)cte_mode.cte_data[1] );
			for(i=2;i<16;i++)
			{
				MY_INFO_PRINTK( 4,"INFO_LEVEL:" "Y%d : Gain %d\n",i-2,(int)cte_mode.cte_data[i] );
			}
			msleep(100);
			result = copy_to_user( (void *)arg,pData, length );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy ATMEL_TOUCH_IOCTL_GET_CTE_MODE to user failed!\n" );
				result = -EFAULT;
				mutex_unlock(&g_tp->mutex);
				return result;
			}
			//restore T7 & T28
			result = touchpad_write_i2c( client, addr, &value_backup[0], 2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write T7!\n" );
				result = -EFAULT;
				mutex_unlock(&g_tp->mutex);
				return result;
			}
			result = touchpad_write_i2c( client, addr_cte, &value_backup[2], 2 );
			if (result)
			{
				MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "failed to write T28!\n" );
				result = -EFAULT;
				mutex_unlock(&g_tp->mutex);
				return result;
			}
			//software reset
			value_T6_reset = T6_RESET_VALUE;
			result = touchpad_write_i2c(client,maxTouchCfg_T6_obj.obj_addr,&value_T6_reset ,WRITE_T6_SIZE);
			MY_INFO_PRINTK( 4, "TEST_INFO_LEVELG" "software reset 0x%x = 0x%x\n",maxTouchCfg_T6_obj.obj_addr,value_T6_reset );
			if( result )
			{
				MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "unable to write software reset T6 object 0x%x = 0x%x\n",maxTouchCfg_T6_obj.obj_addr,value_T6_reset );
				result = -EFAULT;
				mutex_unlock(&g_tp->mutex);
				return result;
			}
			msleep(100);
			//reset mt points coordinates
			for (i = 0 ; i < ATMEL_REPORT_POINTS ; i++ )
			{
				g_tp->msg[i].coord.x = 0;
				g_tp->msg[i].coord.y = 0;
				g_tp->msg[i].state = RELEASE;
			}
			mutex_unlock(&g_tp->mutex);
            	break;
		}
		case ATMEL_TOUCH_IOCTL_SET_KEYARRAY_FVS_MODE:
		{
			struct atmel_fvs_mode_t fvs_mode;	
            		if( copy_from_user( (void *)&fvs_mode,
                                (void *)arg,
                                sizeof(fvs_mode) ) )
            		{
                		MY_INFO_PRINTK( 2,"ERROR_LEVEL:" "copy FVS MODE from user failed!\n");
                		result = -EFAULT;
				return result;
            		}
            		if( fvs_mode.enter )
                		g_tp->fvs_mode_flag = 1; //enter fvs mode
            		else
               			g_tp->fvs_mode_flag = 0; //exit fvs mode
            	break;
        	}
	} //end of switch
	
    	return result;
}

static int tp_misc_release(struct inode *inode, struct file *fp)
{
    int result = 0;
    
    
    mutex_lock(&g_tp->mutex);
    if( g_tp->misc_open_count )
    {
        g_tp->misc_open_count--;      
    }
    mutex_unlock(&g_tp->mutex);
    return result;
}

static int tp_misc_open(struct inode *inode, struct file *fp)
{
    int result = 0;
    
    
    mutex_lock(&g_tp->mutex);
	//g_tp->misc_open_count = 0;
    if( g_tp->misc_open_count <= 1 ) //g_tp->misc_open_count == 0
    {
        g_tp->misc_open_count++;
        MY_INFO_PRINTK( 4, "INFO_LEVELG" "misc open count : %d\n",g_tp->misc_open_count );          
    }	
    else
    { 
 	result = -EFAULT;
 	MY_INFO_PRINTK( 2, "ERROR_LEVELG" "failed to open misc count : %d\n",g_tp->misc_open_count );  
    }
    mutex_unlock(&g_tp->mutex);
    
    return result;
}

static struct file_operations tp_misc_fops = {
	.owner 	= THIS_MODULE,
	.open 	= tp_misc_open,
	.release = tp_misc_release,
	.read = tp_misc_read,
    	.unlocked_ioctl = tp_misc_ioctl,
};

static struct miscdevice tp_misc_device = {
	.minor 	= MISC_DYNAMIC_MINOR,
	.name 	= "atmel_misc_touch",
	//.name 	= "auo_misc_touch",
	.fops 	= &tp_misc_fops,
};

// CONFIG_HAS_EARLYSUSPEND
static void tp_suspend(struct early_suspend *h)
{
    	int ret = 0;
    	struct touchpad_t *tp = container_of( h,struct touchpad_t,touch_early_suspend);
    	struct i2c_client *client = tp->client_4_i2c;
	struct   atmel_touchscreen_platform_data_t *pdata;
    	int obj_size = 2;
	uint8_t value[maxTouchCfg_T7_obj.size];
	uint16_t regbuf;
	int i;
	
	
    	printk(  "tp_suspend : E\n" );
	pdata = client->dev.platform_data;

    	mutex_lock(&g_tp->mutex);
    	if( g_tp->touch_suspended )
    	{
      		mutex_unlock(&g_tp->mutex);	
      		return;
    	}
    	disable_irq_nosync( tp->irq );
	//if(pdata->power_onoff)
	  //pdata->power_onoff(0);
    	g_tp->touch_suspended = 1;
	mutex_unlock(&g_tp->mutex);
	//return;


    
	//print write to reg T7 obj
	i = 0;
	touchpad_read_i2c( client, maxTouchCfg_T7_obj.obj_addr, &value[0], maxTouchCfg_T7_obj.size );
	for ( regbuf = maxTouchCfg_T7_obj.obj_addr; regbuf < maxTouchCfg_T7_obj.obj_addr+maxTouchCfg_T7_obj.size; regbuf++ )
    	{
		MY_INFO_PRINTK( 4, "INFO_LEVEL:" "write T7 obj 0x%xh = 0x%x\n",regbuf, value[i] );
    		i++;
    	}
   
	//write to power obj,it's a deep sleep mode
	value[0]= 0x0;
	value[1] = 0x0;
	ret = touchpad_write_i2c( client, maxTouchCfg_T7_obj.obj_addr, &value[0], obj_size );
	if (ret)
	{
		MY_INFO_PRINTK( 2, "ERROR_LEVELG" "cannot enter real sleep mode\n" );
	}
	
	//print write to reg T7 obj
	i = 0;
	touchpad_read_i2c( client, maxTouchCfg_T7_obj.obj_addr, &value[0], maxTouchCfg_T7_obj.size );
	for ( regbuf = maxTouchCfg_T7_obj.obj_addr; regbuf < maxTouchCfg_T7_obj.obj_addr+maxTouchCfg_T7_obj.size; regbuf++ )
    	{
		MY_INFO_PRINTK( 4, "INFO_LEVEL:" "write T7 obj 0x%xh = 0x%x\n",regbuf, value[i] );
    		i++;
    	}
	
    	MY_INFO_PRINTK( 1, "INFO_LEVEL:" "tp_suspend: X\n" );
    	mutex_unlock(&g_tp->mutex);
    
	return;
}

// CONFIG_HAS_RESUME
static void tp_resume(struct early_suspend *h)
{
    	int result = 0;
    	struct touchpad_t *tp = container_of( h,struct touchpad_t,touch_early_suspend);
	struct i2c_client *client = tp->client_4_i2c;
	int obj_size = (int)( maxTouchCfg_T5_obj.size );
	struct   atmel_touchscreen_platform_data_t *pdata;
	uint8_t value[obj_size];
	int i;
	
    
    	printk(  "tp_resume: E\n" );

       pdata = client->dev.platform_data;
    	mutex_lock(&g_tp->mutex);
    	if( 0 == g_tp->touch_suspended )
	{
		mutex_unlock(&g_tp->mutex);
		
		return;
	}
	//reset mt points coordinates after wakeup
	for (i = 0 ; i < ATMEL_REPORT_POINTS ; i++ )
	{
		g_tp->msg[i].coord.x = 0;
		g_tp->msg[i].coord.y = 0;
		g_tp->msg[i].state = RELEASE;
	}
#if 1
	//write to power obj,it's a normal mode
    	value[0]= maxTouchCfg_T7_obj.value_array[0];
    	value[1] = maxTouchCfg_T7_obj.value_array[1];
    	MY_INFO_PRINTK( 4, "INFO_LEVEL:" "read T7 IDLEACQINT : 0x%x\n", value[0] );
    	MY_INFO_PRINTK( 4, "INFO_LEVEL:" "read T7 ACTVACQINT : 0x%x\n", value[1] );

    	result = touchpad_write_i2c( tp->client_4_i2c, maxTouchCfg_T7_obj.obj_addr, &value[0], 2 );
    	if (result)
    	{
      		MY_INFO_PRINTK( 2, "ERROR_LEVELG" "cannot enter normal mode\n" );
    	}

		//write a calibrate cmd in T6 object
    	value[0] = 0x01;
    	result = touchpad_write_i2c( tp->client_4_i2c, maxTouchCfg_T6_obj.obj_addr+2, &value[0], WRITE_T6_SIZE );
    	if (result)
    	{
      		MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "cannot write a calibrate filed in T6 object!!!\n" );
    	}

#else
      if(pdata->power_onoff)
	  pdata->power_onoff(1);
	  
      result = power_on_flow_one_way(g_tp);
#endif
	//enable interrupt	
    	enable_irq( tp->irq );
    	g_tp->touch_suspended = 0;
    	MY_INFO_PRINTK( 1, "INFO_LEVEL:" "tp_resume: X\n" );
    	mutex_unlock(&g_tp->mutex);
	
	return;
}

static const struct i2c_device_id i2cAtmelTouch_idtable[] = {
       { ATMEL_TOUCHSCREEN_DRIVER_NAME, 0 },
       { }
};

MODULE_DEVICE_TABLE(i2c, i2cAtmelTouch_idtable);

static struct i2c_driver i2c_touchpad_driver = {
	.driver = {
			.owner = THIS_MODULE,
			.name  = ATMEL_TOUCHSCREEN_DRIVER_NAME,
		  },
	.probe	 = touchpad_probe,
	//.remove	 = capkey_remove,

/*#ifndef CONFIG_HAS_EARLYSUSPEND
    .suspend = capkey_suspend,
    .resume  = capkey_resume,
#endif*/
	.id_table = i2cAtmelTouch_idtable,
};
#ifdef CONFIG_TOUCHSCREEN_SOFTKEY
static int touchpad_keyarray_event(struct input_dev *dev, unsigned int type,
             unsigned int code, int value)
{
	return 0;
}

static int touchpad_keyarray_open(struct input_dev *dev)
{
	int rc = 0;
    
    
#if 0
    mutex_lock(&g_tp->mutex);
    if( g_tp->keyarray_open_count == 0 )
    {
        g_tp->keyarray_open_count++; //record opencount
        MY_INFO_PRINTK( 2, "ERROR_LEVEL:" "keyarray open count : %d\n",g_tp->keyarray_open_count );      
    }	
    else
    {	
	rc = -EFAULT;
    }
    mutex_unlock(&g_tp->mutex);
#endif
    
    return rc;
}

static void touchpad_keyarray_close(struct input_dev *dev)
{
	
#if 0
    mutex_lock(&g_tp->mutex);
    if( g_tp->keyarray_open_count )
    {
        g_tp->keyarray_open_count--;
        MY_INFO_PRINTK( 4, "INFO_LEVEL:" " keyarray still opened %d times\n",g_tp->keyarray_open_count );        
    }
    mutex_unlock(&g_tp->mutex);
#endif
    
}

static int keyarray_register_input( struct input_dev **input,
                              struct i2c_client *client )
{
  int rc = 0;
  struct input_dev *input_dev;
  
  
  input_dev = input_allocate_device();
  if ( !input_dev )
  {
    rc = -ENOMEM;
    return rc;
  }

  input_dev->name = ATMEL_TOUCHSCREEN_KEYARRAY_DRIVER_NAME;
  input_dev->phys = "atmel_touchscreen_keyarray/event0";
  input_dev->id.bustype = BUS_I2C;
  input_dev->id.vendor = 0x0001;
  input_dev->id.product = 0x0002;
  input_dev->id.version = 0x0100;
  input_dev->dev.parent = &client->dev;

  input_dev->open = touchpad_keyarray_open;
  input_dev->close = touchpad_keyarray_close;
  input_dev->event = touchpad_keyarray_event;

  input_dev->evbit[0] = BIT_MASK(EV_KEY);
  
  set_bit(KEY_MENU, input_dev->keybit);
  set_bit(KEY_HOME, input_dev->keybit);
  set_bit(KEY_BACK, input_dev->keybit);
  //for FVS mode API
  set_bit(KEY_F2, input_dev->keybit);
  set_bit(KEY_F5, input_dev->keybit);
  set_bit(KEY_F6, input_dev->keybit);

  rc = input_register_device( input_dev );
  if ( rc )
  {
    MY_INFO_PRINTK( 2,"ERROR_LEVELG""failed to register keyarray input device\\n");
    input_free_device( input_dev );
  }
  else
  {
    *input = input_dev;
  }
  
  return rc;
}
#endif
static int touchpad_open(struct input_dev *dev)
{
    int rc = 0;
    
    
    mutex_lock(&g_tp->mutex);
    if( g_tp->open_count == 0 )
    {
        g_tp->open_count++; //record opencount
        MY_INFO_PRINTK( 4, "INFO_LEVEL:" "open count : %d\n",g_tp->open_count );      
    }	
    else
    {	
 	rc = -EFAULT;
    }
    mutex_unlock(&g_tp->mutex);
    
    return rc;
}

static void touchpad_close(struct input_dev *dev)
{
    
    mutex_lock(&g_tp->mutex);
    if( g_tp->open_count )
    {
        g_tp->open_count--;
        MY_INFO_PRINTK( 4, "INFO_LEVEL:" "input device still opened %d times\n",g_tp->open_count );        
    }
    mutex_unlock(&g_tp->mutex);
    
}

static int touchpad_register_input( struct input_dev **input,
                                    struct atmel_touchscreen_platform_data_t *pdata,
                                    struct i2c_client *client )
{
    int rc = 0;
    struct input_dev *input_dev;
    int i;
    
    
    i = 0;
    input_dev = input_allocate_device();
    if ( !input_dev ) {
        rc = -ENOMEM;
        return rc;
    }
    input_dev->name = ATMEL_TOUCHSCREEN_DRIVER_NAME;
    input_dev->phys = "atmel_touchscreen/input0";
    input_dev->id.bustype = BUS_I2C;
    input_dev->id.vendor = 0x0001;
    input_dev->id.product = 0x0002;
    input_dev->id.version = 0x0100;
    input_dev->dev.parent = &client->dev;
    input_dev->open = touchpad_open;
    input_dev->close = touchpad_close;
    //input_dev->event = touchpad_event;
    
    input_dev->evbit[0] = BIT_MASK(EV_KEY) | BIT_MASK(EV_ABS);
    input_dev->absbit[0] = BIT(ABS_X) | BIT(ABS_Y);
    #if 0
    // Menghan Cheng, 20090204, Report the second point to input class
    input_dev->absbit[BIT_WORD(ABS_HAT0X)] |= BIT(ABS_HAT0X) | BIT(ABS_HAT0Y);
    input_dev->keybit[BIT_WORD(BTN_BASE2)] |= BIT_MASK(BTN_BASE2);
    #endif
    
    //input_dev->absbit[BIT_WORD(ABS_MISC)] |= BIT_MASK(ABS_MISC);
    input_dev->keybit[BIT_WORD(BTN_TOUCH)] |= BIT_MASK(BTN_TOUCH);
    
    g_tp->atmel_x_max = maxTouchCfg_T9_obj.value_array[18] | maxTouchCfg_T9_obj.value_array[19] << 8;
    g_tp->atmel_y_max = maxTouchCfg_T9_obj.value_array[20] | maxTouchCfg_T9_obj.value_array[21] << 8;
    if(g_tp->atmel_y_max == 0) 
        g_tp->atmel_y_max = ATMEL_Y_MAX;
    if(g_tp->atmel_x_max == 0) 
        g_tp->atmel_x_max = ATMEL_X_MAX;
	//atmel_x_max = maxTouchCfg_T9_obj.value_array[18] | maxTouchCfg_T9_obj.value_array[19] << 8;
    //atmel_y_max = maxToug_tp->atmel_y_maxchCfg_T9_obj.value_array[20] | maxTouchCfg_T9_obj.value_array[21] << 8;
    MY_INFO_PRINTK( 4, "INFO_LEVEL:" " atmel_x_max : %d\n",(int)g_tp->atmel_x_max );
    MY_INFO_PRINTK( 4, "INFO_LEVEL:" " atmel_y_max : %d\n",(int)g_tp->atmel_y_max );
    input_set_abs_params(input_dev, ABS_X, 0, ATMEL_TOUCAN_PANEL_X, 0, 0);
#ifdef CONFIG_TOUCHSCREEN_SOFTKEY
    input_set_abs_params(input_dev, ABS_Y, 0, 941, 0, 0);
    input_set_abs_params(input_dev, ABS_MT_POSITION_Y, 0, 941, 0, 0); 
#else
    input_set_abs_params(input_dev, ABS_Y, 0, 1024, 0, 0);
    input_set_abs_params(input_dev, ABS_MT_POSITION_Y, 0, 1024, 0, 0); 
#endif
    input_set_abs_params(input_dev, ABS_MT_POSITION_X, 0, ATMEL_TOUCAN_PANEL_X, 0, 0); 

    input_set_abs_params(input_dev, ABS_MT_TOUCH_MAJOR,  0, ATMEL_TOUCAN_PANEL_X, 0, 0); 
    input_set_abs_params(input_dev, ABS_MT_WIDTH_MAJOR,  0, ATMEL_TOUCAN_PANEL_X, 0, 0); 

    rc = input_register_device( input_dev );

    if ( rc )
    {
        MY_INFO_PRINTK( 2,"ERROR_LEVELG""failed to register input device\\n");
        input_free_device( input_dev );
    }else {
        *input = input_dev;
    }
    
    return rc;
}

static int __devinit touchpad_probe(struct i2c_client *client, const struct i2c_device_id *id )
{
    int      result = 0;
    struct   atmel_touchscreen_platform_data_t *pdata;
    int i;
    //uint8_t value[maxTouchCfg_T5_obj.size];

    	

    g_tp = kzalloc( sizeof(struct touchpad_t), GFP_KERNEL );
    if( !g_tp )
    {
      result = -ENOMEM;
      return result;
    }
    g_tp->multi = kzalloc( sizeof(struct tp_multi_t), GFP_KERNEL );
    if( !g_tp->multi )
    {
        result = -ENOMEM;
		
		kfree(g_tp);
        return result;
    }
        
    for (i = 0 ; i < ATMEL_REPORT_POINTS ; i++ )
    {
      g_tp->msg[i].coord.x = 0;
      g_tp->msg[i].coord.y = 0;
      g_tp->msg[i].state = RELEASE;
    }
    pdata = client->dev.platform_data;
    g_tp->gpio_num = pdata->gpioirq;

    g_tp->irq = gpio_to_irq(g_tp->gpio_num);


    g_tp->client_4_i2c = client;
    mutex_init(&g_tp->mutex);
    if(pdata->power_onoff)
    {
         result=pdata->power_onoff(1);

	    if(result)
    {
    	MY_INFO_PRINTK( 0, "ERROR_LEVEL:" "touchpad_probe: failed to power on device\n" );
	    kfree(g_tp->multi);
	    kfree(g_tp);

        return result;
    }
    }
    // setup gpio
   if(pdata->config_io)
   {
	   result = pdata->config_io();
	    if( result )
	    {
	        MY_INFO_PRINTK( 0, "ERROR_LEVEL:" "touchpad_probe: failed to setup gpio\n" );
	        kfree(g_tp->multi);
	        kfree(g_tp);	
	        return result;
	    }
   }
   if(pdata->reset)
   {
       pdata->reset();
   }
    //config gpio 
    

    //get gpio : check if CHG pin is low
    result = pdata->get_irq_status();
   
    msleep(500);
    // detect atmel mXT224 touchpad
    result = touchpad_detect_mXT224(g_tp);
    if( result )
    {
        MY_INFO_PRINTK( 0, "ERROR_LEVEL:" "touchpad_probe: failed to detect\n" );
        //touchpad_poweron_device(0); // power off device
        pdata->release_io();
        kfree(g_tp->multi);
        kfree(g_tp);
        return result;
    }
    client->driver = &i2c_touchpad_driver;
    i2c_set_clientdata( client, g_tp );
    	     
    //config table CRC correct
    result = calculate_infoblock_crc(g_tp);

    
    //read message and check if CFGERR bit correct
    result = power_on_flow_one_way(g_tp);


    //result =power_on_flow_another_way(g_tp);


    result = touchpad_register_input( &g_tp->input, pdata, client );

    input_set_drvdata(g_tp->input, g_tp);    
    
#ifdef CONFIG_TOUCHSCREEN_SOFTKEY
    // register keyarray input device
    result = keyarray_register_input( &g_tp->keyarray_input, client );

    input_set_drvdata(g_tp->keyarray_input, g_tp); 
#endif
    //workqueue handler
    INIT_DELAYED_WORK(&g_tp->touchpad_work, touchpad_irqWorkHandler );
	
    g_tp->touchpad_wqueue = create_singlethread_workqueue("ATMEL_Touchpad_Wqueue");
    if (!g_tp->touchpad_wqueue)
    {
      printk("touchpad_probe: failed to create singlethread workqueue\n" );
      pdata->power_onoff(0); // power off device
      result = -ESRCH;
      input_unregister_device( g_tp->input );
      input_free_device( g_tp->input );
      //destroy_workqueue(g_tp->touchpad_wqueue);
      
      pdata->release_io();
      kfree(g_tp->multi);
      kfree(g_tp);
    		
      return result;
    }


	
    init_waitqueue_head( &g_tp->multi->wait );
#if 0
    tp_read_T5_via_i2c( NULL , &value[0], maxTouchCfg_T5_obj.size );      
    printk(  "TEST_INFO_LEVEL:" "read T5 via i2c 0x%x = %d\n",maxTouchCfg_T5_obj.obj_addr,value[0] );
    printk(  "TEST_INFO_LEVEL:" "T5 obj size = %d\n",maxTouchCfg_T5_obj.size );
    printk(  "TIL:" "rid=%x msg=%x\n",value[0],value[1] );
    result = gpio_get_value_cansleep(g_tp->gpio_num);
    printk( "TEST_INFO_LEVEL:" "pinValue = %d\n",result );
#endif
    result = request_any_context_irq( g_tp->irq, touchpad_irqHandler, IRQF_TRIGGER_LOW,"ATMEL_Touchpad_IRQ", g_tp );                      
    if ( result<0 )
    {
      //printk("request interrupt: irq %d requested failed\n", g_tp->irq);
      printk("result is %d\n",result);
	  
      pdata->power_onoff(0); // power off device
      result = -EFAULT;
      input_unregister_device( g_tp->input );
      input_free_device( g_tp->input );
      destroy_workqueue( g_tp->touchpad_wqueue );
      pdata->release_io();
      kfree(g_tp->multi);
      kfree(g_tp);
    		
      return result;
    }
     result=enable_irq_wake(g_tp->irq); 

	//retister st_misc_device
    result = misc_register( &tp_misc_device );
    if( result )
    {
      printk( "failed register misc driver\n" );
      result = -EFAULT;
      input_unregister_device( g_tp->input );
      input_free_device( g_tp->input );
      destroy_workqueue( g_tp->touchpad_wqueue );
      pdata->power_onoff(0); // power off device
      pdata->release_io();
      kfree(g_tp->multi);
      kfree(g_tp);
      disable_irq_nosync(g_tp->irq); 	
      return result;       
    }

	// register early suspend/resume
    g_tp->touch_early_suspend.level = 150; //EARLY_SUSPEND_LEVEL_DISABLE_FB;
    g_tp->touch_early_suspend.suspend = tp_suspend;
    g_tp->touch_early_suspend.resume = tp_resume;
    register_early_suspend(&g_tp->touch_early_suspend);
	
    //do_gettimeofday(&end_time);
	//sec_elapsed = ( end_time.tv_sec - start_time.tv_sec )*1000 + ( end_time.tv_usec - start_time.tv_usec )/1000;
	//MY_INFO_PRINTK( 1,"INFO_LEVELG""%ld ms elasped\n",sec_elapsed);
    return 0;
}

static int __init touchpad_init(void)
{
  int rc = 0;
        
   	            
  MY_INFO_PRINTK( 1,"INFO_LEVELG""system_rev=0x%x\n",system_rev);
  i2c_touchpad_driver.driver.name = ATMEL_TOUCHSCREEN_DRIVER_NAME;
  rc = i2c_add_driver( &i2c_touchpad_driver );
    	
  return rc;
}
module_init(touchpad_init);

static void __exit touchpad_exit(void)
{  
#if 0
  i2c_del_driver( &i2c_touchpad_driver );
  input_unregister_device( g_tp->input );
  input_free_device( g_tp->input );
  destroy_workqueue( g_tp->touchpad_wqueue );
  touchpad_release_gpio( g_tp->gpio_num, g_tp->gpio_rst );
  kfree(g_tp);
#endif
    
}
module_exit(touchpad_exit);

MODULE_DESCRIPTION("ATMEL xMT224 touchpad driver");
MODULE_LICENSE("GPL v2");
MODULE_AUTHOR("Emily Jiang");
MODULE_ALIAS("platform:atmel_xMT224_touch");
