// 20100104
// Emily Jiang created
//
// Include file for Atmel maxTouch Confguration file

#ifndef _ATMEL_TOUCH_OBJ_H_
#define _ATMEL_TOUCH_OBJ_H_

static int T6_msg_handler ( uint8_t *value );
static int T9_msg_handler ( uint8_t *value );
static int T15_msg_handler ( uint8_t *value );
                                   
//USERDATA
uint8_t maxTouchCfg_T38[] =
{
	0x0,//0,DATA[0]
	0x0,//0,DATA[1]
	0x0,//0,DATA[2]
	0x0,//0,DATA[3]
	0x0,//0,DATA[4]
	0x0,//0,DATA[5]
	0x0,//0,DATA[6]
	0x0,//0,DATA[7]
};

//POWERCONFIG
uint8_t maxTouchCfg_T7[] =
{
	0x1E,//30,IDLEACQINT
	0xA,//10,ACTVACQINT
	0x19,//25,ACTV2IDLETO
};

//ACQUISITIONCONFIG
uint8_t maxTouchCfg_T8[] =
{
	0x8,//8,CHRGTIME
	0x0,//0,Reserved
	0x14,//20,TCHDRIFT
	0xA,//10,DRIFTST
	0x0,//0,TCHAUTOCAL
	0x0,//0,SYNC
	0x14,//20,ATCHCALST
	0x0,//0,ATCHCALSTHR
	0x12,//18,ATCHFRCCALTHR
	0xF0//-16,ATCHFRCCALRATIO
};

//TOUCH_MULTITOUCHSCREEN
uint8_t maxTouchCfg_T9[] =
{
	 0x3,//3,TRL
	 0x0,//0,XORIGIN
	 0x0,//0,YORIGIN
	 0x13,//19,XSIZE
	 0xB,//11,SIZE
	 0x0,//0, AKSCFG
	 0x0,//0,BLEN
	 0x2D,//45,TCHTHR
	 0x2,//2,TCHDI
	 0x4,//4,ORIENT
	 0x0,//0,MRGTIMEOUT
	 0x5,//5,MOVHYSTI
	 0x2,//2,MOVHYSTN
	 0x0,//0,MOVFILTER
	 0x2,//2,NUMTOUCH
	 0x5,//5,MRGHYST
	 0x5,//5,MRGTHR
	 0x5,//5,AMPHYST
	 0x0,//1024,XRANGE
	 0x0,//1024,XRANGE	 	 	
	 0x0,//1024,YRANGE
	 0x0,//1024,YRANGE
	 0x14,//20,XLOCLIP
	 0x14,//20,XHICLIP
	 0x28,//40,YLOCLIP
	 0x23,//35,YHICLIP
	 0x8A,//138,XEDGECTRL
	 0x32,//50,XEDGEDIST
	 0x94,//148,YEDGECTRL
	 0x4B,//75,YEDGEDIST
	 0x3C,//60,JUMPLIMIT
	 0x0,//0,TCHHYST
};

//KEYARRAY
uint8_t maxTouchCfg_T15[] =
{
	0x0,//0,CTRL
	0x0,//0,XORIGIN
	0x0,//0,YORIGIN
	0x0,//0,XSIZE
	0x0,//0,YSIZE
	0x0,//0,AKSCFG
	0x0,//0,BLEN
	0x0,//0,TCHTHR
	0x0,//0,TCHDI
	0x0,//0,Reserved
	0x0,//0,Reserved 
};

//COMMSCONFIG
uint8_t maxTouchCfg_T18[] =
{
	0x0,//0,CTRL
	0x0,//0,COMMAND
};

//GPIOPWM
uint8_t maxTouchCfg_T19[] =
{
	0x0,//0,CTRL
	0x0,//0,REPORTMASK
	0x0,//0,DIR
	0x0,//0,INTPULLUP
	0x0,//0,OUT
	0x0,//0,WAKE
	0x0,//0,PWM
	0x0,//0,PERIOD
	0x0,//0,DUTY[0]
	0x0,//0,DUTY[1]
	0x0,//0,DUTY[2]
	0x0,//0,DUTY[3]
	0x0,//0,TRIGGER[0]
	0x0,//0,TRIGGER[1]
	0x0,//0,TRIGGER[2]
	0x0,//0,TRIGGER[3]
};

//PROCI_GRIPFACESUPPRESSION
uint8_t maxTouchCfg_T20[] =
{
	0x7,//3,CTRL
	0x0,//0,XLOGRIP
	0x0,//0,XHIGRIP
	0x0,//0,YLOGRIP
	0x0,//0,YHIGRIP
	0x0,//0,MAXTCHS
	0x0,//0,Reserved
	0x0,//0,SZTHR1
	0x0,//0,SZTHR2
	0x0,//0,SHPTHR1
	0x0,//0,SHPTHR2
	0x0,//0,SUPEXTTO
};

//NOISESUPPRESSION
uint8_t maxTouchCfg_T22[] =
{
	0x7,//7,CTRL   
	0x0,//0,Reserved
	0x0,//0,Reserved
	0x0,//0,GCAFUL
	0x0,//0,GCAFUL
	0x0,//0,GCAFLL
	0x0,//0,GCAFLL
	0x0,//0,ACTVGCAFVALID
	0x14,//20,NOISETHR
	0x0,//0,Reserved
	0x0,//0,FREQHOPSCALE
	0x0,//0,FREQ[0]
	0x7,//7,FREQ[1]
	0x12,//18,FREQ[2]
	0xFF,//255,FREQ[3]
	0xFF,//255,FREQ[4]
	0x0,//0,IDLEGCAFVALID
};

//PROXIMITY
uint8_t maxTouchCfg_T23[] =
{
	0x0,//0,CTRL
	0x0,//0,XORIGIN
	0x0,//0,YORIGIN
	0x0,//0,XSIZE
	0x0,//0,YSIZE
	0x0,//0,Reserved
	0x0,//0,BLEN
	0x0,//0,FXDDTHR
	0x0,//0,FXDDTHR
	0x0,//0,FXDDI
	0x0,//0,AVERAGE
	0x0,//0,MVNULIRATE
	0x0,//0,MVNULIRATE
	0x0,//0,MVDTHR
	0x0,//0,MVDTHR	
};

//ONE TOUCHGESTURE PROCESSOR
uint8_t maxTouchCfg_T24[] =
{
	0x0,//0,CTRL
	0x0,//0,NUMGEST
	0x0,//0,GESTEN
	0x0,//0,GESTEN
	0x0,//0,PROCESS
	0x0,//0,TAPTO
	0x0,//0,FLICKTO
	0x0,//0,DRAGTO
	0x0,//0,SPRESSTO
	0x0,//0,LPRESSTO
	0x0,//0,REPPRESSTO
	0x0,//0,FLICKTHR
	0x0,//0,FLICKTHR 
	0x0,//0,DRAGTHR    
	0x0,//0,DRAGTHR  
    0x0,//0,TAPTHR
    0x0,//0,TAPTHR
    0x0,//0,THROWTHR
    0x0,//0,THROWTHR             
};

//SELFTEST
uint8_t maxTouchCfg_T25[] =            
{                                           
	0x3,//3,CTRL                     
	0x0,//0,CMD                      
	0xBC,//13500, SIGLIM[0].UPSIGLIM]_Touch
	0x34,//13500, SIGLIM[0].UPSIGLIM]_Touch
	0x4C,//7500,SIGLIM[0].LOSIGLIM_Touch
	0x1D,//7500,SIGLIM[0].LOSIGLIM_Touch
	0x0,//0,SIGLIM[1].UPSIGLIM
	0x0,//0,SIGLIM[1].UPSIGLIM
	0x0,//0,SIGLIM[1].LOSIGLIM 
	0x0,//0,SIGLIM[1].LOSIGLIM   
	0x0,//0,SIGLIM[2].UPSIGLIM_ProximitySensor      
	0x0,//0,SIGLIM[2].UPSIGLIM_ProximitySensor
	0x0,//0,SIGLIM[2].LOSIGLIM_ProximitySensor
	0x0,//0,SIGLIM[2].LOSIGLIM_ProximitySensor	  	       
};                                          

//TWO TOUCHGESTURE PROCESSOR
uint8_t maxTouchCfg_T27[] =
{
	0x0,//0,CTRL
	0x0,//0,NUMGEST
	0x0,//0,Reserved
	0x0,//0,GESTEN
	0x0,//0,ROTATETHR
	0x0,//0,ZOOMTHR
	0x0,//0,ZOOMTHR
};

//CTE Mode CONFIG
uint8_t maxTouchCfg_T28[] =
{
	0x0,//0,CTRL
	0x0,//0,CMD
	0x3,//2,MODE
	0x4,//4,IDLEGCAFDEPTH
	0x8,//8,ACTVGCAFDEPTH
	0xA,//10,VOLTAGE
};

struct obj_t maxTouchCfg_T5_obj =
{
	.size = 0,
	.obj_addr = 0,
	.value_array = NULL,
	.msg_handler = NULL,
	.config_crc = 0,//don't calculate config crc
};

struct obj_t maxTouchCfg_T6_obj =
{                                 
	.value_array = NULL,
	.msg_handler = T6_msg_handler,
	.config_crc = 0,//don't calculate config crce
};

struct obj_t maxTouchCfg_T38_obj =
{                                 	
	.value_array = maxTouchCfg_T38,
	.msg_handler = NULL,
	.config_crc = 0,//don't calculate config crc
};

struct obj_t maxTouchCfg_T7_obj =
{                                 
	.value_array = maxTouchCfg_T7,
	.msg_handler = NULL,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T8_obj =
{                                 
	.value_array = maxTouchCfg_T8,
	.msg_handler = NULL,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T9_obj =
{                                 
	.value_array = maxTouchCfg_T9,
	.msg_handler = T9_msg_handler,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T15_obj =
{                                 
	.value_array = maxTouchCfg_T15,
	.msg_handler = T15_msg_handler,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T18_obj =
{                                 
	.value_array = maxTouchCfg_T18,
	.msg_handler = NULL,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T19_obj =
{                                 
	.value_array = maxTouchCfg_T19,
	.msg_handler = NULL,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T20_obj =
{                                 
	.value_array = maxTouchCfg_T20,
	.msg_handler = NULL,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T22_obj =
{                                 
	.value_array = maxTouchCfg_T22,
	.msg_handler = NULL,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T23_obj =
{                                 
	.value_array = maxTouchCfg_T23,
	.msg_handler = NULL,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T24_obj =
{                                 
	.value_array = maxTouchCfg_T24,
	.msg_handler = NULL,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T25_obj =
{                                 
	.value_array = maxTouchCfg_T25,
	.msg_handler = NULL,
	.config_crc = 1,//calculate config crc
	
};

struct obj_t maxTouchCfg_T27_obj =
{                                 
	.value_array = maxTouchCfg_T27,
	.msg_handler = NULL,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T28_obj =
{                                 
	.value_array = maxTouchCfg_T28,
	.msg_handler = NULL,
	.config_crc = 1,//calculate config crc
};

struct obj_t maxTouchCfg_T37_obj =
{                                 
	.value_array = NULL,
	.msg_handler = NULL,
	.config_crc = 0,//don't calculate config crc
};
struct obj_t maxTouchCfg_T44_obj =
{                                 
	.value_array = NULL,
	.msg_handler = NULL,
	.config_crc = 0,//don't calculate config crc
};

#endif
