#include <linux/delay.h>
#include <linux/types.h>
#include <linux/i2c.h>
#include <linux/uaccess.h>
#include <linux/miscdevice.h>
#include <linux/slab.h>
#include <mach/gpio.h>
#include <media/msm_camera.h>
#include <mach/camera.h>
#include "camera_debug.h"

static int msm_cam_gpio_tbl[] = {
	CLK_CAMIF_MCLK,		
	CAMIF_I2C_DATA,		
	CAMIF_I2C_CLK,		
};

enum msm_cam_stat
{
	MSM_CAM_OFF,
	MSM_CAM_ON,
};

static int
debug_config_gpio_table (enum msm_cam_stat stat)
{
	int rc = 0, i = 0;
	if (stat == MSM_CAM_ON)
	{
		for (i = 0; i < ARRAY_SIZE (msm_cam_gpio_tbl); i++)
		{
			rc = gpio_request (msm_cam_gpio_tbl[i], "CAM_GPIO");
			if (unlikely (rc < 0))
			{
				pr_err ("%s not able to get gpio\n",
					__func__);
				for (i--; i >= 0; i--)
					gpio_free (msm_cam_gpio_tbl[i]);
				break;
			}
		}

		gpio_tlmm_config (GPIO_CFG
				  (CLK_CAMIF_MCLK, 1, GPIO_CFG_OUTPUT,
				   GPIO_CFG_NO_PULL, GPIO_CFG_10MA),
				  GPIO_CFG_ENABLE);
		gpio_tlmm_config (GPIO_CFG
				  (CAMIF_I2C_DATA, 1, GPIO_CFG_OUTPUT,
				   GPIO_CFG_PULL_UP, GPIO_CFG_10MA),
				  GPIO_CFG_ENABLE);
		gpio_tlmm_config (GPIO_CFG
				  (CAMIF_I2C_CLK, 1, GPIO_CFG_OUTPUT,
				   GPIO_CFG_PULL_UP, GPIO_CFG_10MA),
				  GPIO_CFG_ENABLE);

	}
	else
	{
		for (i = 0; i < ARRAY_SIZE (msm_cam_gpio_tbl); i++)
			gpio_free (msm_cam_gpio_tbl[i]);
	}
	return rc;
}

int
debug_config_camera_on_gpios (void)
{
	int rc = 0;

	rc = debug_config_gpio_table (MSM_CAM_ON);
	if (rc < 0)
	{
		printk (KERN_ERR "%s: CAMSENSOR gpio table request"
			"failed\n", __func__);
		return rc;
	}


	rc = gpio_request (MP_CAM_RESET_N, "CAM_RESET");


	if (rc < 0)
	{
		debug_config_gpio_table (MSM_CAM_OFF);
		printk (KERN_ERR "%s: CAMSENSOR gpio %d request"
			"failed\n", __func__, MP_CAM_RESET_N);
		return rc;
	}
	gpio_direction_output (MP_CAM_RESET_N, 0);
	mdelay (20);
	gpio_set_value_cansleep (MP_CAM_RESET_N, 1);


#ifdef MP_CAM_PWDN_N
	rc = gpio_request (MP_CAM_PWDN_N, "MP_CAM_PWDN");
	if (rc < 0)
	{
		debug_config_gpio_table (MSM_CAM_OFF);
		pr_err (KERN_ERR "%s: CAMSENSOR gpio %d request"
			"failed\n", __func__, MP_CAM_PWDN_N);
		return rc;
	}
	gpio_direction_output (MP_CAM_PWDN_N, 0);
	mdelay (20);
	gpio_set_value_cansleep (MP_CAM_PWDN_N, 1);
#endif
	printk ("QisdaRay, config_camera_on_gpios  \n");


	return rc;
}

void
debug_config_camera_off_gpios (void)
{
	debug_config_gpio_table (MSM_CAM_OFF);

	gpio_set_value_cansleep (MP_CAM_RESET_N, 0);
	gpio_free (MP_CAM_RESET_N);

#ifdef MP_CAM_PWDN_N

	gpio_set_value_cansleep (MP_CAM_PWDN_N, 1);
	gpio_free (MP_CAM_PWDN_N);
#endif
}
