#ifndef __CAMERA_DEBUG_H__
#define __CAMERA_DEBUG_H__

#include <linux/gpio/gpio_def.h>


#ifdef FUN_DEBUG
# define FUN_START() printk(KERN_ERR "~ +++ %s  @ %s   {\n", __func__,strrchr(__FILE__, '/') + 1)
# define FUN_END()   printk(KERN_ERR "~ --- %s  @ %s   }\n", __func__,strrchr(__FILE__, '/') + 1)
#else
# define FUN_START() do { } while (0)
# define FUN_END() do { } while (0)
#endif


#ifdef FUN_DEBUG_COUNT
# define FUN_START_COUNT(n) \
{\
   static int Count_Start=0;\
   Count_Start++;\
   if(Count_Start == n)\
   {\
        printk(KERN_ERR "~  ##################  %s     {\n", __func__);\
        Count_Start = 0;\
   }\
}

# define FUN_END_COUNT(n) \
{\
    static int Count_End=0;\
    Count_End++;\
    if (Count_End == n)\
    {\
        printk (KERN_ERR "~  ##################  %s     }\n", __func__);\
        Count_End = 0;\
    }\
}
#else
# define FUN_START_COUNT(n) do { } while (0)
# define FUN_END_COUNT(n) do { } while (0)
#endif

#ifdef CAMERA_DBG
#undef CDBG
# define CDBG(fmt, args...) printk(KERN_ERR "~    *** %s :  " fmt,__func__,##args)
#else
#undef CDBG
# define CDBG(fmt, args...) do { } while (0)
#endif


#ifdef CAMERA_MYDBG
#undef MYCDBG
# define MYCDBG(fmt, args...) printk(KERN_ERR "~   *@*@* %s : " fmt,__func__,##args)
#else
#undef MYCDBG
# define MYCDBG(fmt, args...) do { } while (0)
#endif


#ifdef CAMERA_PR_INFO_DBG
#undef pr_info
# define pr_info(fmt, args...) printk(KERN_ERR "~   *@*@* %s : " fmt,__func__,##args)
#else
#undef pr_info
# define pr_info(fmt, args...) do { } while (0)
#endif

int debug_config_camera_on_gpios(void);
void debug_config_camera_off_gpios(void);


#endif 

