/* Copyright (c) 2010, Code Aurora Forum. All rights reserved. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */


#include "mt9m114.h"
#include "mt9m114_reg.h"


struct mt9m114_reg_tuning M114_pll_timing[] = {


    {0x098E, 0x1000, 0x0},      
    {0xC97E, 0x01, 0x1},        
    {0xC980, 0x0120, 0x0},      
    {0xC982, 0x0700, 0x0},      
    {0xC984, 0x8040, 0x0},      


    {0xC800, 0x0004, 0x0},      
    {0xC802, 0x0004, 0x0},      
    {0xC804, 0x03CB, 0x0},      
    {0xC806, 0x050B, 0x0},      
    {0xC808, 0x02DC, 0x0},      
    {0xC80A, 0x6C00, 0x0},

    {0xC80C, 0x0001, 0x0},      
    {0xC80E, 0x00DB, 0x0},      
    {0xC810, 0x05B3, 0x0},      
    {0xC812, 0x03EE, 0x0},      
    {0xC814, 0x0636, 0x0},      
    {0xC816, 0x0060, 0x0},      
    {0xC818, 0x03C3, 0x0},      


    {0xC834, 0x0003, 0x0},      


    {0xC854, 0x0000, 0x0},      
    {0xC856, 0x0000, 0x0},      
    {0xC858, 0x0500, 0x0},      
    {0xC85A, 0x03C0, 0x0},      

    {0xC85C, 0x03, 0x1},        
    {0xC868, 0x0500, 0x0},      
    {0xC86A, 0x03C0, 0x0},      

    {0xC88C, 0x1E02, 0x0},      
    {0xC88E, 0x1E02, 0x0},      


    {0xC914, 0x0000, 0x0},      
    {0xC916, 0x0000, 0x0},      
    {0xC918, 0x04FF, 0x0},      
    {0xC91A, 0x03BF, 0x0},      

    {0xC91C, 0x0000, 0x0},      
    {0xC91E, 0x0000, 0x0},      
    {0xC920, 0x00FF, 0x0},      
    {0xC922, 0x00BF, 0x0},      

    {0xE801, 0x00, 0x1},        
};

struct mt9m114_reg_tuning M114_optimization[] = {


    {0x316A, 0x8270, 0x0},      
    {0x316C, 0x8270, 0x0},      
    {0x3ED0, 0x2305, 0x0},      
    {0x3ED2, 0x77CF, 0x0},      
    {0x316E, 0x8202, 0x0},      
    {0x3180, 0x87FF, 0x0},      
    {0x30D4, 0x6080, 0x0},      
    {0xA802, 0x0008, 0x0},      


    {0x3E14, 0xFF39, 0x0},      


    {0x301A, 0x8234, 0x0},      
};

struct mt9m114_reg_tuning M114_patch0202[] = {



    {0x0982, 0x0001, 0x0},      
    {0x098A, 0x5000, 0x0},      
    {0xD000, 0x70CF, 0x0},
    {0xD002, 0xFFFF, 0x0},
    {0xD004, 0xC5D4, 0x0},
    {0xD006, 0x903A, 0x0},
    {0xD008, 0x2144, 0x0},
    {0xD00A, 0x0C00, 0x0},
    {0xD00C, 0x2186, 0x0},
    {0xD00E, 0x0FF3, 0x0},
    {0xD010, 0xB844, 0x0},
    {0xD012, 0xB948, 0x0},
    {0xD014, 0xE082, 0x0},
    {0xD016, 0x20CC, 0x0},
    {0xD018, 0x80E2, 0x0},
    {0xD01A, 0x21CC, 0x0},
    {0xD01C, 0x80A2, 0x0},
    {0xD01E, 0x21CC, 0x0},
    {0xD020, 0x80E2, 0x0},
    {0xD022, 0xF404, 0x0},
    {0xD024, 0xD801, 0x0},
    {0xD026, 0xF003, 0x0},
    {0xD028, 0xD800, 0x0},
    {0xD02A, 0x7EE0, 0x0},
    {0xD02C, 0xC0F1, 0x0},
    {0xD02E, 0x08BA, 0x0},

    {0xD030, 0x0600, 0x0},
    {0xD032, 0xC1A1, 0x0},
    {0xD034, 0x76CF, 0x0},
    {0xD036, 0xFFFF, 0x0},
    {0xD038, 0xC130, 0x0},
    {0xD03A, 0x6E04, 0x0},
    {0xD03C, 0xC040, 0x0},
    {0xD03E, 0x71CF, 0x0},
    {0xD040, 0xFFFF, 0x0},
    {0xD042, 0xC790, 0x0},
    {0xD044, 0x8103, 0x0},
    {0xD046, 0x77CF, 0x0},
    {0xD048, 0xFFFF, 0x0},
    {0xD04A, 0xC7C0, 0x0},
    {0xD04C, 0xE001, 0x0},
    {0xD04E, 0xA103, 0x0},
    {0xD050, 0xD800, 0x0},
    {0xD052, 0x0C6A, 0x0},
    {0xD054, 0x04E0, 0x0},
    {0xD056, 0xB89E, 0x0},
    {0xD058, 0x7508, 0x0},
    {0xD05A, 0x8E1C, 0x0},
    {0xD05C, 0x0809, 0x0},
    {0xD05E, 0x0191, 0x0},

    {0xD060, 0xD801, 0x0},
    {0xD062, 0xAE1D, 0x0},
    {0xD064, 0xE580, 0x0},
    {0xD066, 0x20CA, 0x0},
    {0xD068, 0x0022, 0x0},
    {0xD06A, 0x20CF, 0x0},
    {0xD06C, 0x0522, 0x0},
    {0xD06E, 0x0C5C, 0x0},
    {0xD070, 0x04E2, 0x0},
    {0xD072, 0x21CA, 0x0},
    {0xD074, 0x0062, 0x0},
    {0xD076, 0xE580, 0x0},
    {0xD078, 0xD901, 0x0},
    {0xD07A, 0x79C0, 0x0},
    {0xD07C, 0xD800, 0x0},
    {0xD07E, 0x0BE6, 0x0},
    {0xD080, 0x04E0, 0x0},
    {0xD082, 0xB89E, 0x0},
    {0xD084, 0x70CF, 0x0},
    {0xD086, 0xFFFF, 0x0},
    {0xD088, 0xC8D4, 0x0},
    {0xD08A, 0x9002, 0x0},
    {0xD08C, 0x0857, 0x0},
    {0xD08E, 0x025E, 0x0},

    {0xD090, 0xFFDC, 0x0},
    {0xD092, 0xE080, 0x0},
    {0xD094, 0x25CC, 0x0},
    {0xD096, 0x9022, 0x0},
    {0xD098, 0xF225, 0x0},
    {0xD09A, 0x1700, 0x0},
    {0xD09C, 0x108A, 0x0},
    {0xD09E, 0x73CF, 0x0},
    {0xD0A0, 0xFF00, 0x0},
    {0xD0A2, 0x3174, 0x0},
    {0xD0A4, 0x9307, 0x0},
    {0xD0A6, 0x2A04, 0x0},
    {0xD0A8, 0x103E, 0x0},
    {0xD0AA, 0x9328, 0x0},
    {0xD0AC, 0x2942, 0x0},
    {0xD0AE, 0x7140, 0x0},
    {0xD0B0, 0x2A04, 0x0},
    {0xD0B2, 0x107E, 0x0},
    {0xD0B4, 0x9349, 0x0},
    {0xD0B6, 0x2942, 0x0},
    {0xD0B8, 0x7141, 0x0},
    {0xD0BA, 0x2A04, 0x0},
    {0xD0BC, 0x10BE, 0x0},
    {0xD0BE, 0x934A, 0x0},

    {0xD0C0, 0x2942, 0x0},
    {0xD0C2, 0x714B, 0x0},
    {0xD0C4, 0x2A04, 0x0},
    {0xD0C6, 0x10BE, 0x0},
    {0xD0C8, 0x130C, 0x0},
    {0xD0CA, 0x010A, 0x0},
    {0xD0CC, 0x2942, 0x0},
    {0xD0CE, 0x7142, 0x0},
    {0xD0D0, 0x2250, 0x0},
    {0xD0D2, 0x13CA, 0x0},
    {0xD0D4, 0x1B0C, 0x0},
    {0xD0D6, 0x0284, 0x0},
    {0xD0D8, 0xB307, 0x0},
    {0xD0DA, 0xB328, 0x0},
    {0xD0DC, 0x1B12, 0x0},
    {0xD0DE, 0x02C4, 0x0},
    {0xD0E0, 0xB34A, 0x0},
    {0xD0E2, 0xED88, 0x0},
    {0xD0E4, 0x71CF, 0x0},
    {0xD0E6, 0xFF00, 0x0},
    {0xD0E8, 0x3174, 0x0},
    {0xD0EA, 0x9106, 0x0},
    {0xD0EC, 0xB88F, 0x0},
    {0xD0EE, 0xB106, 0x0},

    {0xD0F0, 0x210A, 0x0},
    {0xD0F2, 0x8340, 0x0},
    {0xD0F4, 0xC000, 0x0},
    {0xD0F6, 0x21CA, 0x0},
    {0xD0F8, 0x0062, 0x0},
    {0xD0FA, 0x20F0, 0x0},
    {0xD0FC, 0x0040, 0x0},
    {0xD0FE, 0x0B02, 0x0},
    {0xD100, 0x0320, 0x0},
    {0xD102, 0xD901, 0x0},
    {0xD104, 0x07F1, 0x0},
    {0xD106, 0x05E0, 0x0},
    {0xD108, 0xC0A1, 0x0},
    {0xD10A, 0x78E0, 0x0},
    {0xD10C, 0xC0F1, 0x0},
    {0xD10E, 0x71CF, 0x0},
    {0xD110, 0xFFFF, 0x0},
    {0xD112, 0xC7C0, 0x0},
    {0xD114, 0xD840, 0x0},
    {0xD116, 0xA900, 0x0},
    {0xD118, 0x71CF, 0x0},
    {0xD11A, 0xFFFF, 0x0},
    {0xD11C, 0xD02C, 0x0},
    {0xD11E, 0xD81E, 0x0},

    {0xD120, 0x0A5A, 0x0},
    {0xD122, 0x04E0, 0x0},
    {0xD124, 0xDA00, 0x0},
    {0xD126, 0xD800, 0x0},
    {0xD128, 0xC0D1, 0x0},
    {0xD12A, 0x7EE0, 0x0},

    {0x098E, 0x0000, 0x0},      
    {0xE000, 0x010C, 0x0},      
    {0xE002, 0x0202, 0x0},      
    {0xE004, 0x4103, 0x0},      
    {0xE006, 0x0202, 0x0},
};

struct mt9m114_reg_tuning M114_patch0302[] = {

    {0x0982, 0x0001, 0x0},      
    {0x098A, 0x512C, 0x0},      
    {0xD12C, 0x70CF, 0x0},
    {0xD12E, 0xFFFF, 0x0},
    {0xD130, 0xC5D4, 0x0},
    {0xD132, 0x903A, 0x0},
    {0xD134, 0x2144, 0x0},
    {0xD136, 0x0C00, 0x0},
    {0xD138, 0x2186, 0x0},
    {0xD13A, 0x0FF3, 0x0},
    {0xD13C, 0xB844, 0x0},
    {0xD13E, 0x262F, 0x0},
    {0xD140, 0xF008, 0x0},
    {0xD142, 0xB948, 0x0},
    {0xD144, 0x21CC, 0x0},
    {0xD146, 0x8021, 0x0},
    {0xD148, 0xD801, 0x0},
    {0xD14A, 0xF203, 0x0},
    {0xD14C, 0xD800, 0x0},
    {0xD14E, 0x7EE0, 0x0},
    {0xD150, 0xC0F1, 0x0},
    {0xD152, 0x71CF, 0x0},
    {0xD154, 0xFFFF, 0x0},
    {0xD156, 0xC610, 0x0},
    {0xD158, 0x910E, 0x0},
    {0xD15A, 0x208C, 0x0},
    {0xD15C, 0x8014, 0x0},
    {0xD15E, 0xF418, 0x0},
    {0xD160, 0x910F, 0x0},
    {0xD162, 0x208C, 0x0},
    {0xD164, 0x800F, 0x0},
    {0xD166, 0xF414, 0x0},
    {0xD168, 0x9116, 0x0},
    {0xD16A, 0x208C, 0x0},
    {0xD16C, 0x800A, 0x0},
    {0xD16E, 0xF410, 0x0},
    {0xD170, 0x9117, 0x0},
    {0xD172, 0x208C, 0x0},
    {0xD174, 0x8807, 0x0},
    {0xD176, 0xF40C, 0x0},
    {0xD178, 0x9118, 0x0},
    {0xD17A, 0x2086, 0x0},
    {0xD17C, 0x0FF3, 0x0},
    {0xD17E, 0xB848, 0x0},
    {0xD180, 0x080D, 0x0},
    {0xD182, 0x0090, 0x0},
    {0xD184, 0xFFEA, 0x0},
    {0xD186, 0xE081, 0x0},
    {0xD188, 0xD801, 0x0},
    {0xD18A, 0xF203, 0x0},
    {0xD18C, 0xD800, 0x0},
    {0xD18E, 0xC0D1, 0x0},
    {0xD190, 0x7EE0, 0x0},
    {0xD192, 0x78E0, 0x0},
    {0xD194, 0xC0F1, 0x0},
    {0xD196, 0x71CF, 0x0},
    {0xD198, 0xFFFF, 0x0},
    {0xD19A, 0xC610, 0x0},
    {0xD19C, 0x910E, 0x0},
    {0xD19E, 0x208C, 0x0},
    {0xD1A0, 0x800A, 0x0},
    {0xD1A2, 0xF418, 0x0},
    {0xD1A4, 0x910F, 0x0},
    {0xD1A6, 0x208C, 0x0},
    {0xD1A8, 0x8807, 0x0},
    {0xD1AA, 0xF414, 0x0},
    {0xD1AC, 0x9116, 0x0},
    {0xD1AE, 0x208C, 0x0},
    {0xD1B0, 0x800A, 0x0},
    {0xD1B2, 0xF410, 0x0},
    {0xD1B4, 0x9117, 0x0},
    {0xD1B6, 0x208C, 0x0},
    {0xD1B8, 0x8807, 0x0},
    {0xD1BA, 0xF40C, 0x0},
    {0xD1BC, 0x9118, 0x0},
    {0xD1BE, 0x2086, 0x0},
    {0xD1C0, 0x0FF3, 0x0},
    {0xD1C2, 0xB848, 0x0},
    {0xD1C4, 0x080D, 0x0},
    {0xD1C6, 0x0090, 0x0},
    {0xD1C8, 0xFFD9, 0x0},
    {0xD1CA, 0xE080, 0x0},
    {0xD1CC, 0xD801, 0x0},
    {0xD1CE, 0xF203, 0x0},
    {0xD1D0, 0xD800, 0x0},
    {0xD1D2, 0xF1DF, 0x0},
    {0xD1D4, 0x9040, 0x0},
    {0xD1D6, 0x71CF, 0x0},
    {0xD1D8, 0xFFFF, 0x0},
    {0xD1DA, 0xC5D4, 0x0},
    {0xD1DC, 0xB15A, 0x0},
    {0xD1DE, 0x9041, 0x0},
    {0xD1E0, 0x73CF, 0x0},
    {0xD1E2, 0xFFFF, 0x0},
    {0xD1E4, 0xC7D0, 0x0},
    {0xD1E6, 0xB140, 0x0},
    {0xD1E8, 0x9042, 0x0},
    {0xD1EA, 0xB141, 0x0},
    {0xD1EC, 0x9043, 0x0},
    {0xD1EE, 0xB142, 0x0},
    {0xD1F0, 0x9044, 0x0},
    {0xD1F2, 0xB143, 0x0},
    {0xD1F4, 0x9045, 0x0},
    {0xD1F6, 0xB147, 0x0},
    {0xD1F8, 0x9046, 0x0},
    {0xD1FA, 0xB148, 0x0},
    {0xD1FC, 0x9047, 0x0},
    {0xD1FE, 0xB14B, 0x0},
    {0xD200, 0x9048, 0x0},
    {0xD202, 0xB14C, 0x0},
    {0xD204, 0x9049, 0x0},
    {0xD206, 0x1958, 0x0},
    {0xD208, 0x0084, 0x0},
    {0xD20A, 0x904A, 0x0},
    {0xD20C, 0x195A, 0x0},
    {0xD20E, 0x0084, 0x0},
    {0xD210, 0x8856, 0x0},
    {0xD212, 0x1B36, 0x0},
    {0xD214, 0x8082, 0x0},
    {0xD216, 0x8857, 0x0},
    {0xD218, 0x1B37, 0x0},
    {0xD21A, 0x8082, 0x0},
    {0xD21C, 0x904C, 0x0},
    {0xD21E, 0x19A7, 0x0},
    {0xD220, 0x009C, 0x0},
    {0xD222, 0x881A, 0x0},
    {0xD224, 0x7FE0, 0x0},
    {0xD226, 0x1B54, 0x0},
    {0xD228, 0x8002, 0x0},
    {0xD22A, 0x78E0, 0x0},
    {0xD22C, 0x71CF, 0x0},
    {0xD22E, 0xFFFF, 0x0},
    {0xD230, 0xC350, 0x0},
    {0xD232, 0xD828, 0x0},
    {0xD234, 0xA90B, 0x0},
    {0xD236, 0x8100, 0x0},
    {0xD238, 0x01C5, 0x0},
    {0xD23A, 0x0320, 0x0},
    {0xD23C, 0xD900, 0x0},
    {0xD23E, 0x78E0, 0x0},
    {0xD240, 0x220A, 0x0},
    {0xD242, 0x1F80, 0x0},
    {0xD244, 0xFFFF, 0x0},
    {0xD246, 0xD4E0, 0x0},
    {0xD248, 0xC0F1, 0x0},
    {0xD24A, 0x0811, 0x0},
    {0xD24C, 0x0051, 0x0},
    {0xD24E, 0x2240, 0x0},
    {0xD250, 0x1200, 0x0},
    {0xD252, 0xFFE1, 0x0},
    {0xD254, 0xD801, 0x0},
    {0xD256, 0xF006, 0x0},
    {0xD258, 0x2240, 0x0},
    {0xD25A, 0x1900, 0x0},
    {0xD25C, 0xFFDE, 0x0},
    {0xD25E, 0xD802, 0x0},
    {0xD260, 0x1A05, 0x0},
    {0xD262, 0x1002, 0x0},
    {0xD264, 0xFFF2, 0x0},
    {0xD266, 0xF195, 0x0},
    {0xD268, 0xC0F1, 0x0},
    {0xD26A, 0x0E7E, 0x0},
    {0xD26C, 0x05C0, 0x0},
    {0xD26E, 0x75CF, 0x0},
    {0xD270, 0xFFFF, 0x0},
    {0xD272, 0xC84C, 0x0},
    {0xD274, 0x9502, 0x0},
    {0xD276, 0x77CF, 0x0},
    {0xD278, 0xFFFF, 0x0},
    {0xD27A, 0xC344, 0x0},
    {0xD27C, 0x2044, 0x0},
    {0xD27E, 0x008E, 0x0},
    {0xD280, 0xB8A1, 0x0},
    {0xD282, 0x0926, 0x0},
    {0xD284, 0x03E0, 0x0},
    {0xD286, 0xB502, 0x0},
    {0xD288, 0x9502, 0x0},
    {0xD28A, 0x952E, 0x0},
    {0xD28C, 0x7E05, 0x0},
    {0xD28E, 0xB5C2, 0x0},
    {0xD290, 0x70CF, 0x0},
    {0xD292, 0xFFFF, 0x0},
    {0xD294, 0xC610, 0x0},
    {0xD296, 0x099A, 0x0},
    {0xD298, 0x04A0, 0x0},
    {0xD29A, 0xB026, 0x0},
    {0xD29C, 0x0E02, 0x0},
    {0xD29E, 0x0560, 0x0},
    {0xD2A0, 0xDE00, 0x0},
    {0xD2A2, 0x0A12, 0x0},
    {0xD2A4, 0x0320, 0x0},
    {0xD2A6, 0xB7C4, 0x0},
    {0xD2A8, 0x0B36, 0x0},
    {0xD2AA, 0x03A0, 0x0},
    {0xD2AC, 0x70C9, 0x0},
    {0xD2AE, 0x9502, 0x0},
    {0xD2B0, 0x7608, 0x0},
    {0xD2B2, 0xB8A8, 0x0},
    {0xD2B4, 0xB502, 0x0},
    {0xD2B6, 0x70CF, 0x0},
    {0xD2B8, 0x0000, 0x0},
    {0xD2BA, 0x5536, 0x0},
    {0xD2BC, 0x7860, 0x0},
    {0xD2BE, 0x2686, 0x0},
    {0xD2C0, 0x1FFB, 0x0},
    {0xD2C2, 0x9502, 0x0},
    {0xD2C4, 0x78C5, 0x0},
    {0xD2C6, 0x0631, 0x0},
    {0xD2C8, 0x05E0, 0x0},
    {0xD2CA, 0xB502, 0x0},
    {0xD2CC, 0x72CF, 0x0},
    {0xD2CE, 0xFFFF, 0x0},
    {0xD2D0, 0xC5D4, 0x0},
    {0xD2D2, 0x923A, 0x0},
    {0xD2D4, 0x73CF, 0x0},
    {0xD2D6, 0xFFFF, 0x0},
    {0xD2D8, 0xC7D0, 0x0},
    {0xD2DA, 0xB020, 0x0},
    {0xD2DC, 0x9220, 0x0},
    {0xD2DE, 0xB021, 0x0},
    {0xD2E0, 0x9221, 0x0},
    {0xD2E2, 0xB022, 0x0},
    {0xD2E4, 0x9222, 0x0},
    {0xD2E6, 0xB023, 0x0},
    {0xD2E8, 0x9223, 0x0},
    {0xD2EA, 0xB024, 0x0},
    {0xD2EC, 0x9227, 0x0},
    {0xD2EE, 0xB025, 0x0},
    {0xD2F0, 0x9228, 0x0},
    {0xD2F2, 0xB026, 0x0},
    {0xD2F4, 0x922B, 0x0},
    {0xD2F6, 0xB027, 0x0},
    {0xD2F8, 0x922C, 0x0},
    {0xD2FA, 0xB028, 0x0},
    {0xD2FC, 0x1258, 0x0},
    {0xD2FE, 0x0101, 0x0},
    {0xD300, 0xB029, 0x0},
    {0xD302, 0x125A, 0x0},
    {0xD304, 0x0101, 0x0},
    {0xD306, 0xB02A, 0x0},
    {0xD308, 0x1336, 0x0},
    {0xD30A, 0x8081, 0x0},
    {0xD30C, 0xA836, 0x0},
    {0xD30E, 0x1337, 0x0},
    {0xD310, 0x8081, 0x0},
    {0xD312, 0xA837, 0x0},
    {0xD314, 0x12A7, 0x0},
    {0xD316, 0x0701, 0x0},
    {0xD318, 0xB02C, 0x0},
    {0xD31A, 0x1354, 0x0},
    {0xD31C, 0x8081, 0x0},
    {0xD31E, 0x7FE0, 0x0},
    {0xD320, 0xA83A, 0x0},
    {0xD322, 0x78E0, 0x0},
    {0xD324, 0xC0F1, 0x0},
    {0xD326, 0x0DC2, 0x0},
    {0xD328, 0x05C0, 0x0},
    {0xD32A, 0x7608, 0x0},
    {0xD32C, 0x09BB, 0x0},
    {0xD32E, 0x0010, 0x0},
    {0xD330, 0x75CF, 0x0},
    {0xD332, 0xFFFF, 0x0},
    {0xD334, 0xD4E0, 0x0},
    {0xD336, 0x8D21, 0x0},
    {0xD338, 0x8D00, 0x0},
    {0xD33A, 0x2153, 0x0},
    {0xD33C, 0x0003, 0x0},
    {0xD33E, 0xB8C0, 0x0},
    {0xD340, 0x8D45, 0x0},
    {0xD342, 0x0B23, 0x0},
    {0xD344, 0x0000, 0x0},
    {0xD346, 0xEA8F, 0x0},
    {0xD348, 0x0915, 0x0},
    {0xD34A, 0x001E, 0x0},
    {0xD34C, 0xFF81, 0x0},
    {0xD34E, 0xE808, 0x0},
    {0xD350, 0x2540, 0x0},
    {0xD352, 0x1900, 0x0},
    {0xD354, 0xFFDE, 0x0},
    {0xD356, 0x8D00, 0x0},
    {0xD358, 0xB880, 0x0},
    {0xD35A, 0xF004, 0x0},
    {0xD35C, 0x8D00, 0x0},
    {0xD35E, 0xB8A0, 0x0},
    {0xD360, 0xAD00, 0x0},
    {0xD362, 0x8D05, 0x0},
    {0xD364, 0xE081, 0x0},
    {0xD366, 0x20CC, 0x0},
    {0xD368, 0x80A2, 0x0},
    {0xD36A, 0xDF00, 0x0},
    {0xD36C, 0xF40A, 0x0},
    {0xD36E, 0x71CF, 0x0},
    {0xD370, 0xFFFF, 0x0},
    {0xD372, 0xC84C, 0x0},
    {0xD374, 0x9102, 0x0},
    {0xD376, 0x7708, 0x0},
    {0xD378, 0xB8A6, 0x0},
    {0xD37A, 0x2786, 0x0},
    {0xD37C, 0x1FFE, 0x0},
    {0xD37E, 0xB102, 0x0},
    {0xD380, 0x0B42, 0x0},
    {0xD382, 0x0180, 0x0},
    {0xD384, 0x0E3E, 0x0},
    {0xD386, 0x0180, 0x0},
    {0xD388, 0x0F4A, 0x0},
    {0xD38A, 0x0160, 0x0},
    {0xD38C, 0x70C9, 0x0},
    {0xD38E, 0x8D05, 0x0},
    {0xD390, 0xE081, 0x0},
    {0xD392, 0x20CC, 0x0},
    {0xD394, 0x80A2, 0x0},
    {0xD396, 0xF429, 0x0},
    {0xD398, 0x76CF, 0x0},
    {0xD39A, 0xFFFF, 0x0},
    {0xD39C, 0xC84C, 0x0},
    {0xD39E, 0x082D, 0x0},
    {0xD3A0, 0x0051, 0x0},
    {0xD3A2, 0x70CF, 0x0},
    {0xD3A4, 0xFFFF, 0x0},
    {0xD3A6, 0xC90C, 0x0},
    {0xD3A8, 0x8805, 0x0},
    {0xD3AA, 0x09B6, 0x0},
    {0xD3AC, 0x0360, 0x0},
    {0xD3AE, 0xD908, 0x0},
    {0xD3B0, 0x2099, 0x0},
    {0xD3B2, 0x0802, 0x0},
    {0xD3B4, 0x9634, 0x0},
    {0xD3B6, 0xB503, 0x0},
    {0xD3B8, 0x7902, 0x0},
    {0xD3BA, 0x1523, 0x0},
    {0xD3BC, 0x1080, 0x0},
    {0xD3BE, 0xB634, 0x0},
    {0xD3C0, 0xE001, 0x0},
    {0xD3C2, 0x1D23, 0x0},
    {0xD3C4, 0x1002, 0x0},
    {0xD3C6, 0xF00B, 0x0},
    {0xD3C8, 0x9634, 0x0},
    {0xD3CA, 0x9503, 0x0},
    {0xD3CC, 0x6038, 0x0},
    {0xD3CE, 0xB614, 0x0},
    {0xD3D0, 0x153F, 0x0},
    {0xD3D2, 0x1080, 0x0},
    {0xD3D4, 0xE001, 0x0},
    {0xD3D6, 0x1D3F, 0x0},
    {0xD3D8, 0x1002, 0x0},
    {0xD3DA, 0xFFA4, 0x0},
    {0xD3DC, 0x9602, 0x0},
    {0xD3DE, 0x7F05, 0x0},
    {0xD3E0, 0xD800, 0x0},
    {0xD3E2, 0xB6E2, 0x0},
    {0xD3E4, 0xAD05, 0x0},
    {0xD3E6, 0x0511, 0x0},
    {0xD3E8, 0x05E0, 0x0},
    {0xD3EA, 0xD800, 0x0},
    {0xD3EC, 0xC0F1, 0x0},
    {0xD3EE, 0x0CFE, 0x0},
    {0xD3F0, 0x05C0, 0x0},
    {0xD3F2, 0x0A96, 0x0},
    {0xD3F4, 0x05A0, 0x0},
    {0xD3F6, 0x7608, 0x0},
    {0xD3F8, 0x0C22, 0x0},
    {0xD3FA, 0x0240, 0x0},
    {0xD3FC, 0xE080, 0x0},
    {0xD3FE, 0x20CA, 0x0},
    {0xD400, 0x0F82, 0x0},
    {0xD402, 0x0000, 0x0},
    {0xD404, 0x190B, 0x0},
    {0xD406, 0x0C60, 0x0},
    {0xD408, 0x05A2, 0x0},
    {0xD40A, 0x21CA, 0x0},
    {0xD40C, 0x0022, 0x0},
    {0xD40E, 0x0C56, 0x0},
    {0xD410, 0x0240, 0x0},
    {0xD412, 0xE806, 0x0},
    {0xD414, 0x0E0E, 0x0},
    {0xD416, 0x0220, 0x0},
    {0xD418, 0x70C9, 0x0},
    {0xD41A, 0xF048, 0x0},
    {0xD41C, 0x0896, 0x0},
    {0xD41E, 0x0440, 0x0},
    {0xD420, 0x0E96, 0x0},
    {0xD422, 0x0400, 0x0},
    {0xD424, 0x0966, 0x0},
    {0xD426, 0x0380, 0x0},
    {0xD428, 0x75CF, 0x0},
    {0xD42A, 0xFFFF, 0x0},
    {0xD42C, 0xD4E0, 0x0},
    {0xD42E, 0x8D00, 0x0},
    {0xD430, 0x084D, 0x0},
    {0xD432, 0x001E, 0x0},
    {0xD434, 0xFF47, 0x0},
    {0xD436, 0x080D, 0x0},
    {0xD438, 0x0050, 0x0},
    {0xD43A, 0xFF57, 0x0},
    {0xD43C, 0x0841, 0x0},
    {0xD43E, 0x0051, 0x0},
    {0xD440, 0x8D04, 0x0},
    {0xD442, 0x9521, 0x0},
    {0xD444, 0xE064, 0x0},
    {0xD446, 0x790C, 0x0},
    {0xD448, 0x702F, 0x0},
    {0xD44A, 0x0CE2, 0x0},
    {0xD44C, 0x05E0, 0x0},
    {0xD44E, 0xD964, 0x0},
    {0xD450, 0x72CF, 0x0},
    {0xD452, 0xFFFF, 0x0},
    {0xD454, 0xC700, 0x0},
    {0xD456, 0x9235, 0x0},
    {0xD458, 0x0811, 0x0},
    {0xD45A, 0x0043, 0x0},
    {0xD45C, 0xFF3D, 0x0},
    {0xD45E, 0x080D, 0x0},
    {0xD460, 0x0051, 0x0},
    {0xD462, 0xD801, 0x0},
    {0xD464, 0xFF77, 0x0},
    {0xD466, 0xF025, 0x0},
    {0xD468, 0x9501, 0x0},
    {0xD46A, 0x9235, 0x0},
    {0xD46C, 0x0911, 0x0},
    {0xD46E, 0x0003, 0x0},
    {0xD470, 0xFF49, 0x0},
    {0xD472, 0x080D, 0x0},
    {0xD474, 0x0051, 0x0},
    {0xD476, 0xD800, 0x0},
    {0xD478, 0xFF72, 0x0},
    {0xD47A, 0xF01B, 0x0},
    {0xD47C, 0x0886, 0x0},
    {0xD47E, 0x03E0, 0x0},
    {0xD480, 0xD801, 0x0},
    {0xD482, 0x0EF6, 0x0},
    {0xD484, 0x03C0, 0x0},
    {0xD486, 0x0F52, 0x0},
    {0xD488, 0x0340, 0x0},
    {0xD48A, 0x0DBA, 0x0},
    {0xD48C, 0x0200, 0x0},
    {0xD48E, 0x0AF6, 0x0},
    {0xD490, 0x0440, 0x0},
    {0xD492, 0x0C22, 0x0},
    {0xD494, 0x0400, 0x0},
    {0xD496, 0x0D72, 0x0},
    {0xD498, 0x0440, 0x0},
    {0xD49A, 0x0DC2, 0x0},
    {0xD49C, 0x0200, 0x0},
    {0xD49E, 0x0972, 0x0},
    {0xD4A0, 0x0440, 0x0},
    {0xD4A2, 0x0D3A, 0x0},
    {0xD4A4, 0x0220, 0x0},
    {0xD4A6, 0xD820, 0x0},
    {0xD4A8, 0x0BFA, 0x0},
    {0xD4AA, 0x0260, 0x0},
    {0xD4AC, 0x70C9, 0x0},
    {0xD4AE, 0x0451, 0x0},
    {0xD4B0, 0x05C0, 0x0},
    {0xD4B2, 0x78E0, 0x0},
    {0xD4B4, 0xD900, 0x0},
    {0xD4B6, 0xF00A, 0x0},
    {0xD4B8, 0x70CF, 0x0},
    {0xD4BA, 0xFFFF, 0x0},
    {0xD4BC, 0xD520, 0x0},
    {0xD4BE, 0x7835, 0x0},
    {0xD4C0, 0x8041, 0x0},
    {0xD4C2, 0x8000, 0x0},
    {0xD4C4, 0xE102, 0x0},
    {0xD4C6, 0xA040, 0x0},
    {0xD4C8, 0x09F1, 0x0},
    {0xD4CA, 0x8114, 0x0},
    {0xD4CC, 0x71CF, 0x0},
    {0xD4CE, 0xFFFF, 0x0},
    {0xD4D0, 0xD4E0, 0x0},
    {0xD4D2, 0x70CF, 0x0},
    {0xD4D4, 0xFFFF, 0x0},
    {0xD4D6, 0xC594, 0x0},
    {0xD4D8, 0xB03A, 0x0},
    {0xD4DA, 0x7FE0, 0x0},
    {0xD4DC, 0xD800, 0x0},
    {0xD4DE, 0x0000, 0x0},
    {0xD4E0, 0x0000, 0x0},
    {0xD4E2, 0x0500, 0x0},
    {0xD4E4, 0x0500, 0x0},
    {0xD4E6, 0x0200, 0x0},
    {0xD4E8, 0x0330, 0x0},
    {0xD4EA, 0x0000, 0x0},
    {0xD4EC, 0x0000, 0x0},
    {0xD4EE, 0x03CD, 0x0},
    {0xD4F0, 0x050D, 0x0},
    {0xD4F2, 0x01C5, 0x0},
    {0xD4F4, 0x03B3, 0x0},
    {0xD4F6, 0x00E0, 0x0},
    {0xD4F8, 0x01E3, 0x0},
    {0xD4FA, 0x0280, 0x0},
    {0xD4FC, 0x01E0, 0x0},
    {0xD4FE, 0x0109, 0x0},
    {0xD500, 0x0080, 0x0},
    {0xD502, 0x0500, 0x0},
    {0xD504, 0x0000, 0x0},
    {0xD506, 0x0000, 0x0},
    {0xD508, 0x0000, 0x0},
    {0xD50A, 0x0000, 0x0},
    {0xD50C, 0x0000, 0x0},
    {0xD50E, 0x0000, 0x0},
    {0xD510, 0x0000, 0x0},
    {0xD512, 0x0000, 0x0},
    {0xD514, 0x0000, 0x0},
    {0xD516, 0x0000, 0x0},
    {0xD518, 0x0000, 0x0},
    {0xD51A, 0x0000, 0x0},
    {0xD51C, 0x0000, 0x0},
    {0xD51E, 0x0000, 0x0},
    {0xD520, 0xFFFF, 0x0},
    {0xD522, 0xC9B4, 0x0},
    {0xD524, 0xFFFF, 0x0},
    {0xD526, 0xD324, 0x0},
    {0xD528, 0xFFFF, 0x0},
    {0xD52A, 0xCA34, 0x0},
    {0xD52C, 0xFFFF, 0x0},
    {0xD52E, 0xD3EC, 0x0},
    {0x098E, 0x0000, 0x0},      
    {0xE000, 0x04B4, 0x0},      
    {0xE002, 0x0302, 0x0},      
    {0xE004, 0x4103, 0x0},      
    {0xE006, 0x0202, 0x0},
};

struct mt9m114_reg_tuning M114_APGA[] = {
    {0x098E, 0x495E, 0x0},
    {0xC95E, 0x0000, 0x0},
    {0x3640, 0x0250, 0x0},
    {0x3642, 0x98CA, 0x0},
    {0x3644, 0x52F0, 0x0},
    {0x3646, 0xA14C, 0x0},
    {0x3648, 0x6FF0, 0x0},
    {0x364A, 0x00F0, 0x0},
    {0x364C, 0x8CEA, 0x0},
    {0x364E, 0x2111, 0x0},
    {0x3650, 0x396B, 0x0},
    {0x3652, 0x17F1, 0x0},
    {0x3654, 0x01B0, 0x0},
    {0x3656, 0x628A, 0x0},
    {0x3658, 0x3430, 0x0},
    {0x365A, 0x9765, 0x0},
    {0x365C, 0x6CD0, 0x0},
    {0x365E, 0x00D0, 0x0},
    {0x3660, 0xC80A, 0x0},
    {0x3662, 0x5C50, 0x0},
    {0x3664, 0xA2AC, 0x0},
    {0x3666, 0x56B0, 0x0},
    {0x3680, 0xB36C, 0x0},
    {0x3682, 0x5CE5, 0x0},
    {0x3684, 0xBC2D, 0x0},
    {0x3686, 0x23ED, 0x0},
    {0x3688, 0xAA2D, 0x0},
    {0x368A, 0xFE6C, 0x0},
    {0x368C, 0xBB6A, 0x0},
    {0x368E, 0xC86E, 0x0},
    {0x3690, 0x3CCE, 0x0},
    {0x3692, 0x7B0B, 0x0},
    {0x3694, 0xC3EB, 0x0},
    {0x3696, 0xDF2C, 0x0},
    {0x3698, 0xF0EE, 0x0},
    {0x369A, 0x28AD, 0x0},
    {0x369C, 0x3A2D, 0x0},
    {0x369E, 0xF62B, 0x0},
    {0x36A0, 0x9FC8, 0x0},
    {0x36A2, 0xFCAE, 0x0},
    {0x36A4, 0x00ED, 0x0},
    {0x36A6, 0x8A8F, 0x0},
    {0x36C0, 0x6A10, 0x0},
    {0x36C2, 0xC5AB, 0x0},
    {0x36C4, 0x6D52, 0x0},
    {0x36C6, 0xE0EB, 0x0},
    {0x36C8, 0xC932, 0x0},
    {0x36CA, 0x16D1, 0x0},
    {0x36CC, 0x512C, 0x0},
    {0x36CE, 0x3873, 0x0},
    {0x36D0, 0x936F, 0x0},
    {0x36D2, 0xCF73, 0x0},
    {0x36D4, 0x2E90, 0x0},
    {0x36D6, 0x39AD, 0x0},
    {0x36D8, 0x5252, 0x0},
    {0x36DA, 0x83AF, 0x0},
    {0x36DC, 0xFE31, 0x0},
    {0x36DE, 0x6770, 0x0},
    {0x36E0, 0x8D0C, 0x0},
    {0x36E2, 0x6EB2, 0x0},
    {0x36E4, 0x228C, 0x0},
    {0x36E6, 0xDAB2, 0x0},
    {0x3700, 0x93EE, 0x0},
    {0x3702, 0x250D, 0x0},
    {0x3704, 0xB2CE, 0x0},
    {0x3706, 0xA72F, 0x0},
    {0x3708, 0x0C73, 0x0},
    {0x370A, 0xD08E, 0x0},
    {0x370C, 0x256D, 0x0},
    {0x370E, 0x284D, 0x0},
    {0x3710, 0xCA90, 0x0},
    {0x3712, 0x29D3, 0x0},
    {0x3714, 0xFA4D, 0x0},
    {0x3716, 0x0C6E, 0x0},
    {0x3718, 0x570E, 0x0},
    {0x371A, 0x980F, 0x0},
    {0x371C, 0x4312, 0x0},
    {0x371E, 0xB40D, 0x0},
    {0x3720, 0x284D, 0x0},
    {0x3722, 0xA7F0, 0x0},
    {0x3724, 0xD4AE, 0x0},
    {0x3726, 0x4573, 0x0},
    {0x3740, 0x3AD0, 0x0},
    {0x3742, 0x2A0F, 0x0},
    {0x3744, 0x77EF, 0x0},
    {0x3746, 0xB572, 0x0},
    {0x3748, 0xF8F5, 0x0},
    {0x374A, 0x61F1, 0x0},
    {0x374C, 0x108F, 0x0},
    {0x374E, 0xC9EF, 0x0},
    {0x3750, 0x84D3, 0x0},
    {0x3752, 0xBE36, 0x0},
    {0x3754, 0x25F1, 0x0},
    {0x3756, 0x678B, 0x0},
    {0x3758, 0x2872, 0x0},
    {0x375A, 0xAC72, 0x0},
    {0x375C, 0x9616, 0x0},
    {0x375E, 0x3370, 0x0},
    {0x3760, 0x0190, 0x0},
    {0x3762, 0x6AEE, 0x0},
    {0x3764, 0xDDD2, 0x0},
    {0x3766, 0xF5F5, 0x0},
    {0x3784, 0x0280, 0x0},
    {0x3782, 0x01EC, 0x0},
    {0x37C0, 0x9F2B, 0x0},
    {0x37C2, 0xEEEA, 0x0},
    {0x37C4, 0xCFCB, 0x0},
    {0x37C6, 0x8DAB, 0x0},
    {0x098E, 0x0000, 0x0},
    {0xC960, 0x0AF0, 0x0},
    {0xC962, 0x7780, 0x0},
    {0xC964, 0x64B4, 0x0},
    {0xC966, 0x755E, 0x0},
    {0xC968, 0x7821, 0x0},
    {0xC96A, 0x0FA0, 0x0},
    {0xC96C, 0x7FB1, 0x0},
    {0xC96E, 0x8DDE, 0x0},
    {0xC970, 0x7E87, 0x0},
    {0xC972, 0x8497, 0x0},
    {0xC974, 0x1964, 0x0},
    {0xC976, 0x7EDA, 0x0},
    {0xC978, 0x7FC8, 0x0},
    {0xC97A, 0x7E82, 0x0},
    {0xC97C, 0x7EEB, 0x0},
    {0xC95E, 0x0003, 0x0},



























};

struct mt9m114_reg_tuning M114_AWB_CCM[] = {
    {0x098E, 0x4892, 0x0},
    {0xC892, 0x0340, 0x0},
    {0xC894, 0xFD77, 0x0},
    {0xC896, 0x0048, 0x0},
    {0xC898, 0xFF68, 0x0},
    {0xC89A, 0x019B, 0x0},
    {0xC89C, 0xFFFC, 0x0},
    {0xC89E, 0xFEED, 0x0},
    {0xC8A0, 0xFDB1, 0x0},
    {0xC8A2, 0x0462, 0x0},
    {0xC8A4, 0x01BF, 0x0},
    {0xC8A6, 0xFF01, 0x0},
    {0xC8A8, 0xFFF3, 0x0},
    {0xC8AA, 0xFF75, 0x0},
    {0xC8AC, 0x0198, 0x0},
    {0xC8AE, 0xFFFD, 0x0},
    {0xC8B0, 0xFF9A, 0x0},
    {0xC8B2, 0xFEE7, 0x0},
    {0xC8B4, 0x02A8, 0x0},
    {0xC8B6, 0x01D9, 0x0},
    {0xC8B8, 0xFF26, 0x0},
    {0xC8BA, 0xFFF3, 0x0},
    {0xC8BC, 0xFFB3, 0x0},
    {0xC8BE, 0x0132, 0x0},
    {0xC8C0, 0xFFE8, 0x0},
    {0xC8C2, 0xFFDA, 0x0},
    {0xC8C4, 0xFECD, 0x0},
    {0xC8C6, 0x02C2, 0x0},
    {0xC8DA, 0x004D, 0x0},
    {0xC8DC, 0x0096, 0x0},
    {0xC8DE, 0x001D, 0x0},
    {0xC8E0, 0x004D, 0x0},
    {0xC8E2, 0x0096, 0x0},
    {0xC8E4, 0x001D, 0x0},
    {0xC8E6, 0x004D, 0x0},
    {0xC8E8, 0x0096, 0x0},
    {0xC8EA, 0x001D, 0x0},
    {0xC8F2, 0x0003, 0x0},
    {0xC8F3, 0x0002, 0x0},
    {0xC8F4, 0xD748, 0x0},
    {0xC8F6, 0x2E1D, 0x0},
    {0xC8F8, 0x43AA, 0x0},
    {0xC8FA, 0x6A43, 0x0},
    {0xC8FC, 0xA9F2, 0x0},
    {0xC8FE, 0xB566, 0x0},
    {0xC900, 0x9392, 0x0},
    {0xC902, 0x6A65, 0x0},
    {0xC904, 0x0033, 0x0},
    {0xC906, 0x003C, 0x0},
    {0xC8EC, 0x09C4, 0x0},
    {0xC8EE, 0x1964, 0x0},

    {0xC90C, 0x80, 0x1},
    {0xC90D, 0x80, 0x1},
    {0xC90E, 0x80, 0x1},
    {0xC90F, 0x80, 0x1},
    {0xC910, 0x80, 0x1},
    {0xC911, 0x70, 0x1},



    {0xC926, 0x0020, 0x0},
    {0xC928, 0x009A, 0x0},
    {0xC946, 0x0070, 0x0},
    {0xC948, 0x00F3, 0x0},
    {0xC952, 0x0020, 0x0},
    {0xC954, 0x009A, 0x0},
    {0xC92A, 0x80, 0x1},
    {0xC92B, 0x4B, 0x1},
    {0xC92C, 0x00, 0x1},
    {0xC92D, 0xFF, 0x1},
    {0xC92E, 0x3C, 0x1},
    {0xC92F, 0x07, 0x1},
    {0xC930, 0x00, 0x1},
    {0xC931, 0x64, 0x1},
    {0xC932, 0x01, 0x1},
    {0xC933, 0x10, 0x1},
    {0xC934, 0x3C, 0x1},
    {0xC935, 0x3C, 0x1},
    {0xC936, 0x3C, 0x1},
    {0xC937, 0x0F, 0x1},
    {0xC938, 0x64, 0x1},
    {0xC939, 0x64, 0x1},
    {0xC93A, 0x64, 0x1},
    {0xC93B, 0x32, 0x1},
    {0xC93C, 0x0020, 0x0},
    {0xC93E, 0x009A, 0x0},
    {0xC940, 0x00DC, 0x0},
    {0xC942, 0x38, 0x1},
    {0xC943, 0x30, 0x1},
    {0xC944, 0x50, 0x1},
    {0xC945, 0x19, 0x1},
    {0xC94A, 0x0230, 0x0},
    {0xC94C, 0x0010, 0x0},
    {0xC94E, 0x01CD, 0x0},
    {0xC950, 0x05, 0x1},
    {0xC951, 0x40, 0x1},
    {0xC87A, 0x00, 0x1},
    {0xC87B, 0x1B, 0x1},
    {0xC878, 0x0E, 0x1},
    {0xC890, 0x0080, 0x0},
    {0xC886, 0x0100, 0x0},
    {0xC87C, 0x005A, 0x0},
    {0xB42A, 0x05, 0x1},
    {0xA80A, 0x20, 0x1},
    {0xA808, 0x14, 0x1},
    {0x098E, 0x0000, 0x0},
    {0xC984, 0x8040, 0x0},
    {0x001E, 0x0575, 0x0},

    {0x098E, 0xBC1D, 0x0},
    {0xBC1D, 0x00, 0x1},
    {0xBC1E, 0x0A, 0x1},
    {0xBC1F, 0x1D, 0x1},
    {0xBC20, 0x37, 0x1},
    {0xBC21, 0x58, 0x1},
    {0xBC22, 0x71, 0x1},
    {0xBC23, 0x86, 0x1},
    {0xBC24, 0x98, 0x1},
    {0xBC25, 0xA7, 0x1},
    {0xBC26, 0xB5, 0x1},
    {0xBC27, 0xC0, 0x1},
    {0xBC28, 0xCB, 0x1},
    {0xBC29, 0xD4, 0x1},
    {0xBC2A, 0xDD, 0x1},
    {0xBC2B, 0xE4, 0x1},
    {0xBC2C, 0xEC, 0x1},
    {0xBC2D, 0xF3, 0x1},
    {0xBC2E, 0xF9, 0x1},
    {0xBC2F, 0xFF, 0x1},
    {0x0080, 0x8004, 0x0},

    {0x098E, 0xBC07, 0x0},
    {0xBC07, 0x01, 0x1},        
    {0x098E, 0xBC31, 0x0},
    {0xBC31, 0x08, 0x1},
    {0xBC0A, 0x00, 0x1},
    {0xBC0B, 0x18, 0x1},
    {0xBC0C, 0x23, 0x1},
    {0xBC0D, 0x37, 0x1},
    {0xBC0E, 0x59, 0x1},
    {0xBC0F, 0x79, 0x1},
    {0xBC10, 0x94, 0x1},
    {0xBC11, 0xA8, 0x1},
    {0xBC12, 0xB9, 0x1},
    {0xBC13, 0xC7, 0x1},
    {0xBC14, 0xD3, 0x1},
    {0xBC15, 0xDD, 0x1},
    {0xBC16, 0xE5, 0x1},
    {0xBC17, 0xEC, 0x1},
    {0xBC18, 0xF3, 0x1},
    {0xBC19, 0xF7, 0x1},
    {0xBC1A, 0xF9, 0x1},
    {0xBC1B, 0xFC, 0x1},
    {0xBC1C, 0xFF, 0x1},
    {0x0080, 0x8004, 0x0},

    {0x098E, 0x2802, 0x0},
    {0xA802, 0x08, 0x1},
    {0xC908, 0x01, 0x1},
    {0xC879, 0x01, 0x1},
    {0xC909, 0x02, 0x1},
    {0xA80A, 0x18, 0x1},
    {0xA80B, 0x18, 0x1},
    {0xAC16, 0x18, 0x1},
    {0xC878, 0x0E, 0x1},

    {0x098E, 0xC87A, 0x0}, 	
    {0xC87A, 0x50, 0x1},

    {0x2112, 0x0000, 0x0},
    {0x2114, 0x0000, 0x0},
    {0x2116, 0x0000, 0x0},
    {0x2118, 0x0000, 0x0},
    {0x211A, 0x7A9F, 0x0},
    {0x211C, 0x7A9F, 0x0},
    {0x211E, 0x3C3C, 0x0},
    {0x2120, 0x6A65, 0x0},    

    {0xCC03, 0x01, 0x1}, 	
};

struct mt9m114_reg_tuning M114_MIPI_setting[] = {

    {0xC984, 0x8041, 0x0},      
    {0xC988, 0x0F00, 0x0},      
    {0xC98A, 0x0B07, 0x0},      
    {0xC98C, 0x0D01, 0x0},      
    {0xC98E, 0x071D, 0x0},      
    {0xC990, 0x0006, 0x0},      
    {0xC992, 0x0A0C, 0x0},      
    {0x3C5A, 0x0009, 0x0},      
};

struct mt9m114_reg_tuning M114_Dual_Lane_Mipi_Receiver_Init[] = {

    {0x098E, 0x2802, 0x0},      
    {0xA802, 0x0008, 0x0},      
    {0xC908, 0x01, 0x1},        
    {0xC879, 0x01, 0x1},        
    {0xC909, 0x02, 0x1},        
    {0xA80A, 0x18, 0x1},        
    {0xA80B, 0x18, 0x1},        
    {0xAC16, 0x18, 0x1},        
    {0xC878, 0x0E, 0x1},        
};

struct mt9m114_reg mt9m114_regs = {
    .reg_pll_timing = &M114_pll_timing[0],
    .reg_pll_timing_size = ARRAY_SIZE (M114_pll_timing),
    .reg_optimization = &M114_optimization[0],
    .reg_optimization_size = ARRAY_SIZE (M114_optimization),
    .reg_patch0202 = &M114_patch0202[0],
    .reg_patch0202_size = ARRAY_SIZE (M114_patch0202),
    .reg_patch0302 = &M114_patch0302[0],
    .reg_patch0302_size = ARRAY_SIZE (M114_patch0302),
    .reg_APGA = &M114_APGA[0],
    .reg_APGA_size = ARRAY_SIZE (M114_APGA),
    .reg_AWB_CCM = &M114_AWB_CCM[0],
    .reg_AWB_CCM_size = ARRAY_SIZE (M114_AWB_CCM),
    .reg_MIPI_setting = &M114_MIPI_setting[0],
    .reg_MIPI_setting_size = ARRAY_SIZE (M114_MIPI_setting),
    .reg_Dual_Lane_Mipi_Receiver_Init = &M114_Dual_Lane_Mipi_Receiver_Init[0],
    .reg_Dual_Lane_Mipi_Receiver_Init_size =
        ARRAY_SIZE (M114_Dual_Lane_Mipi_Receiver_Init),
};




struct mt9m114_reg_tuning M114_scene_mode_off1[] = {

    {0x098E, 0xC87A, 0x0},      
    {0xC87A, 0x3D, 0x1},        

    {0x098E, 0x488E, 0x0},      
    {0xC88E, 0x1E02, 0x0},      
};

struct mt9m114_reg_tuning M114_scene_mode_off2[] = {
    {0x098E, 0x4892, 0x0},      
    {0xC892, 0x0267, 0x0},      
    {0xC8A4, 0x01BF, 0x0},      
    {0xC8B6, 0x01D9, 0x0},      
    {0xC8DA, 0x004D, 0x0},      
    {0xC894, 0xFF1A, 0x0},      
    {0xC8A6, 0xFF01, 0x0},      
    {0xC8B8, 0xFF26, 0x0},      
    {0xC8DC, 0x0096, 0x0},      
    {0xC896, 0xFFB3, 0x0},      
    {0xC8A8, 0xFFF3, 0x0},      
    {0xC8BA, 0xFFF3, 0x0},      
    {0xC8DE, 0x001D, 0x0},      
    {0xC898, 0xFF80, 0x0},      
    {0xC8AA, 0xFF75, 0x0},      
    {0xC8BC, 0xFFB3, 0x0},      
    {0xC8E0, 0x004D, 0x0},      
    {0xC89A, 0x0166, 0x0},      
    {0xC8AC, 0x0198, 0x0},      
    {0xC8BE, 0x0132, 0x0},      
    {0xC8E2, 0x0096, 0x0},      
    {0xC89C, 0x0003, 0x0},      
    {0xC8AE, 0xFFFD, 0x0},      
    {0xC8C0, 0xFFE8, 0x0},      
    {0xC8E4, 0x001D, 0x0},      
    {0xC89E, 0xFF9A, 0x0},      
    {0xC8B0, 0xFF9A, 0x0},      
    {0xC8C2, 0xFFDA, 0x0},      
    {0xC8E6, 0x004D, 0x0},      
    {0xC8A0, 0xFEB4, 0x0},      
    {0xC8B2, 0xFEE7, 0x0},      
    {0xC8C4, 0xFECD, 0x0},      
    {0xC8E8, 0x0096, 0x0},      
    {0xC8A2, 0x024D, 0x0},      
    {0xC8B4, 0x02A8, 0x0},      
    {0xC8C6, 0x02C2, 0x0},      
    {0xC8EA, 0x001D, 0x0},      
    {0x098E, 0xC942, 0x0},      
    {0xC942, 0x38, 0x1},        
    {0xC944, 0x50, 0x1},        
    {0xC945, 0x19, 0x1},        
    {0xC943, 0x30, 0x1},        
};


struct mt9m114_reg_tuning M114_scene_mode_landscape1[] = {

    {0x098E, 0xC87A, 0x0},      
    {0xC87A, 0x3D, 0x1},        

    {0x098E, 0x488E, 0x0},      
    {0xC88E, 0x1E02, 0x0},      
};

struct mt9m114_reg_tuning M114_scene_mode_landscape2[] = {
    {0x098E, 0x4892, 0x0},      
    {0xC892, 0x0267, 0x0},      
    {0xC8A4, 0x01BF, 0x0},      
    {0xC8B6, 0x027A, 0x0},      
    {0xC8DA, 0x004D, 0x0},      
    {0xC894, 0xFF1A, 0x0},      
    {0xC8A6, 0xFF01, 0x0},      
    {0xC8B8, 0xFE90, 0x0},      
    {0xC8DC, 0x0096, 0x0},      
    {0xC896, 0xFFB3, 0x0},      
    {0xC8A8, 0xFFF3, 0x0},      
    {0xC8BA, 0xFFE2, 0x0},      
    {0xC8DE, 0x001D, 0x0},      
    {0xC898, 0xFF80, 0x0},      
    {0xC8AA, 0xFF75, 0x0},      
    {0xC8BC, 0xFF74, 0x0},      
    {0xC8E0, 0x004D, 0x0},      
    {0xC89A, 0x0166, 0x0},      
    {0xC8AC, 0x0198, 0x0},      
    {0xC8BE, 0x0171, 0x0},      
    {0xC8E2, 0x0096, 0x0},      
    {0xC89C, 0x0003, 0x0},      
    {0xC8AE, 0xFFFD, 0x0},      
    {0xC8C0, 0xFFD2, 0x0},      
    {0xC8E4, 0x001D, 0x0},      
    {0xC89E, 0xFF9A, 0x0},      
    {0xC8B0, 0xFF9A, 0x0},      
    {0xC8C2, 0xFFAB, 0x0},      
    {0xC8E6, 0x004D, 0x0},      
    {0xC8A0, 0xFEB4, 0x0},      
    {0xC8B2, 0xFEE7, 0x0},      
    {0xC8C4, 0xFE13, 0x0},      
    {0xC8E8, 0x0096, 0x0},      
    {0xC8A2, 0x024D, 0x0},      
    {0xC8B4, 0x02A8, 0x0},      
    {0xC8C6, 0x03D6, 0x0},      
    {0xC8EA, 0x001D, 0x0},      
    {0x098E, 0xC942, 0x0},      
    {0xC942, 0x38, 0x1},        
    {0xC944, 0x50, 0x1},        
    {0xC945, 0x19, 0x1},        
    {0xC943, 0x30, 0x1},        
};

struct mt9m114_reg_tuning M114_scene_mode_portrain1[] = {

    {0x098E, 0xC87A, 0x0},      
    {0xC87A, 0x3D, 0x1},        

    {0x098E, 0x488E, 0x0},      
    {0xC88E, 0x1E02, 0x0},      
};

struct mt9m114_reg_tuning M114_scene_mode_portrain2[] = {
    {0x098E, 0x4892, 0x0},      
    {0xC892, 0x0267, 0x0},      
    {0xC8A4, 0x01BF, 0x0},      
    {0xC8B6, 0x0338, 0x0},      
    {0xC8DA, 0x004D, 0x0},      
    {0xC894, 0xFF1A, 0x0},      
    {0xC8A6, 0xFF01, 0x0},      
    {0xC8B8, 0xFDE0, 0x0},      
    {0xC8DC, 0x0096, 0x0},      
    {0xC896, 0xFFB3, 0x0},      
    {0xC8A8, 0xFFF3, 0x0},      
    {0xC8BA, 0xFFCE, 0x0},      
    {0xC8DE, 0x001D, 0x0},      
    {0xC898, 0xFF80, 0x0},      
    {0xC8AA, 0xFF75, 0x0},      
    {0xC8BC, 0xFFBA, 0x0},      
    {0xC8E0, 0x004D, 0x0},      
    {0xC89A, 0x0166, 0x0},      
    {0xC8AC, 0x0198, 0x0},      
    {0xC8BE, 0x012B, 0x0},      
    {0xC8E2, 0x0096, 0x0},      
    {0xC89C, 0x0003, 0x0},      
    {0xC8AE, 0xFFFD, 0x0},      
    {0xC8C0, 0xFFEB, 0x0},      
    {0xC8E4, 0x001D, 0x0},      
    {0xC89E, 0xFF9A, 0x0},      
    {0xC8B0, 0xFF9A, 0x0},      
    {0xC8C2, 0xFFAB, 0x0},      
    {0xC8E6, 0x004D, 0x0},      
    {0xC8A0, 0xFEB4, 0x0},      
    {0xC8B2, 0xFEE7, 0x0},      
    {0xC8C4, 0xFE12, 0x0},      
    {0xC8E8, 0x0096, 0x0},      
    {0xC8A2, 0x024D, 0x0},      
    {0xC8B4, 0x02A8, 0x0},      
    {0xC8C6, 0x03D6, 0x0},      
    {0xC8EA, 0x001D, 0x0},      
    {0x098E, 0xC942, 0x0},      
    {0xC942, 0x32, 0x1},        
    {0xC944, 0x23, 0x1},        
    {0xC943, 0x30, 0x1},        
    {0xC945, 0x19, 0x1},        
};

struct mt9m114_reg_tuning M114_scene_mode_snow1[] = {

    {0x098E, 0xC87A, 0x0},      
    {0xC87A, 0x63, 0x1},        

    {0x098E, 0x488E, 0x0},      
    {0xC88E, 0x1E02, 0x0},      
};

struct mt9m114_reg_tuning M114_scene_mode_snow2[] = {
    {0x098E, 0x4892, 0x0},      
    {0xC892, 0x0267, 0x0},      
    {0xC8A4, 0x01BF, 0x0},      
    {0xC8B6, 0x01D9, 0x0},      
    {0xC8DA, 0x004D, 0x0},      
    {0xC894, 0xFF1A, 0x0},      
    {0xC8A6, 0xFF01, 0x0},      
    {0xC8B8, 0xFF26, 0x0},      
    {0xC8DC, 0x0096, 0x0},      
    {0xC896, 0xFFB3, 0x0},      
    {0xC8A8, 0xFFF3, 0x0},      
    {0xC8BA, 0xFFF3, 0x0},      
    {0xC8DE, 0x001D, 0x0},      
    {0xC898, 0xFF80, 0x0},      
    {0xC8AA, 0xFF75, 0x0},      
    {0xC8BC, 0xFFB3, 0x0},      
    {0xC8E0, 0x004D, 0x0},      
    {0xC89A, 0x0166, 0x0},      
    {0xC8AC, 0x0198, 0x0},      
    {0xC8BE, 0x0132, 0x0},      
    {0xC8E2, 0x0096, 0x0},      
    {0xC89C, 0x0003, 0x0},      
    {0xC8AE, 0xFFFD, 0x0},      
    {0xC8C0, 0xFFE8, 0x0},      
    {0xC8E4, 0x001D, 0x0},      
    {0xC89E, 0xFF9A, 0x0},      
    {0xC8B0, 0xFF9A, 0x0},      
    {0xC8C2, 0xFFDA, 0x0},      
    {0xC8E6, 0x004D, 0x0},      
    {0xC8A0, 0xFEB4, 0x0},      
    {0xC8B2, 0xFEE7, 0x0},      
    {0xC8C4, 0xFECD, 0x0},      
    {0xC8E8, 0x0096, 0x0},      
    {0xC8A2, 0x024D, 0x0},      
    {0xC8B4, 0x02A8, 0x0},      
    {0xC8C6, 0x02C2, 0x0},      
    {0xC8EA, 0x001D, 0x0},      
    {0x098E, 0xC942, 0x0},      
    {0xC942, 0x38, 0x1},        
    {0xC944, 0x50, 0x1},        
    {0xC945, 0x19, 0x1},        
    {0xC943, 0x30, 0x1},        
};

struct mt9m114_reg_tuning M114_scene_mode_night1[] = {

    {0x098E, 0xC87A, 0x0},      
    {0xC87A, 0x3D, 0x1},        

    {0x098E, 0x488E, 0x0},      
    {0xC88E, 0x03C0, 0x0},      
};

struct mt9m114_reg_tuning M114_scene_mode_night2[] = {
    {0x098E, 0x4892, 0x0},      
    {0xC892, 0x0267, 0x0},      
    {0xC8A4, 0x01BF, 0x0},      
    {0xC8B6, 0x01D9, 0x0},      
    {0xC8DA, 0x004D, 0x0},      
    {0xC894, 0xFF1A, 0x0},      
    {0xC8A6, 0xFF01, 0x0},      
    {0xC8B8, 0xFF26, 0x0},      
    {0xC8DC, 0x0096, 0x0},      
    {0xC896, 0xFFB3, 0x0},      
    {0xC8A8, 0xFFF3, 0x0},      
    {0xC8BA, 0xFFF3, 0x0},      
    {0xC8DE, 0x001D, 0x0},      
    {0xC898, 0xFF80, 0x0},      
    {0xC8AA, 0xFF75, 0x0},      
    {0xC8BC, 0xFFB3, 0x0},      
    {0xC8E0, 0x004D, 0x0},      
    {0xC89A, 0x0166, 0x0},      
    {0xC8AC, 0x0198, 0x0},      
    {0xC8BE, 0x0132, 0x0},      
    {0xC8E2, 0x0096, 0x0},      
    {0xC89C, 0x0003, 0x0},      
    {0xC8AE, 0xFFFD, 0x0},      
    {0xC8C0, 0xFFE8, 0x0},      
    {0xC8E4, 0x001D, 0x0},      
    {0xC89E, 0xFF9A, 0x0},      
    {0xC8B0, 0xFF9A, 0x0},      
    {0xC8C2, 0xFFDA, 0x0},      
    {0xC8E6, 0x004D, 0x0},      
    {0xC8A0, 0xFEB4, 0x0},      
    {0xC8B2, 0xFEE7, 0x0},      
    {0xC8C4, 0xFECD, 0x0},      
    {0xC8E8, 0x0096, 0x0},      
    {0xC8A2, 0x024D, 0x0},      
    {0xC8B4, 0x02A8, 0x0},      
    {0xC8C6, 0x02C2, 0x0},      
    {0xC8EA, 0x001D, 0x0},      
    {0x098E, 0xC942, 0x0},      
    {0xC942, 0x38, 0x1},        
    {0xC944, 0x50, 0x1},        
    {0xC945, 0x19, 0x1},        
    {0xC943, 0x30, 0x1},        
};

struct mt9m114_reg_setting mt9m114_reg_settings = {
    .reg_scene_mode_off1 = &M114_scene_mode_off1[0],
    .reg_scene_mode_off1_size = ARRAY_SIZE (M114_scene_mode_off1),
    .reg_scene_mode_off2 = &M114_scene_mode_off2[0],
    .reg_scene_mode_off2_size = ARRAY_SIZE (M114_scene_mode_off2),
    .reg_scene_mode_landscape1 = &M114_scene_mode_landscape1[0],
    .reg_scene_mode_landscape1_size = ARRAY_SIZE (M114_scene_mode_landscape1),
    .reg_scene_mode_landscape2 = &M114_scene_mode_landscape2[0],
    .reg_scene_mode_landscape2_size = ARRAY_SIZE (M114_scene_mode_landscape2),
    .reg_scene_mode_portrain1 = &M114_scene_mode_portrain1[0],
    .reg_scene_mode_portrain1_size = ARRAY_SIZE (M114_scene_mode_portrain1),
    .reg_scene_mode_portrain2 = &M114_scene_mode_portrain2[0],
    .reg_scene_mode_portrain2_size = ARRAY_SIZE (M114_scene_mode_portrain2),
    .reg_scene_mode_snow1 = &M114_scene_mode_snow1[0],
    .reg_scene_mode_snow1_size = ARRAY_SIZE (M114_scene_mode_snow1),
    .reg_scene_mode_snow2 = &M114_scene_mode_snow2[0],
    .reg_scene_mode_snow2_size = ARRAY_SIZE (M114_scene_mode_snow2),
    .reg_scene_mode_night1 = &M114_scene_mode_night1[0],
    .reg_scene_mode_night1_size = ARRAY_SIZE (M114_scene_mode_night1),
    .reg_scene_mode_night2 = &M114_scene_mode_night2[0],
    .reg_scene_mode_night2_size = ARRAY_SIZE (M114_scene_mode_night2),
};

