#ifndef MT9M114_REG_H
#define MT9M114_REG_H

#include <linux/types.h>
#include <mach/board.h>

extern struct mt9m114_reg mt9m114_regs;
extern struct mt9m114_reg_setting mt9m114_reg_settings;

struct mt9m114_reg_tuning
{
	unsigned short waddr;
	unsigned short wdata;
	bool is_byte;

	struct mt9m114_reg_tuning *next;
};

struct IQ_item_mt9m114
{
	char *name;
	int size;
	struct mt9m114_reg_tuning *head;
	struct IQ_item_mt9m114 *next;

};


struct mt9m114_reg {

     struct mt9m114_reg_tuning *reg_pll_timing;
     unsigned short reg_pll_timing_size;
     struct mt9m114_reg_tuning *reg_optimization;
     unsigned short reg_optimization_size;
     struct mt9m114_reg_tuning *reg_patch0202;
     unsigned short reg_patch0202_size;
     struct mt9m114_reg_tuning *reg_patch0302;
     unsigned short reg_patch0302_size;
     struct mt9m114_reg_tuning *reg_APGA;
     unsigned short reg_APGA_size;
     struct mt9m114_reg_tuning *reg_AWB_CCM;
     unsigned short reg_AWB_CCM_size;
     struct mt9m114_reg_tuning *reg_MIPI_setting;
     unsigned short reg_MIPI_setting_size;
     struct mt9m114_reg_tuning *reg_Dual_Lane_Mipi_Receiver_Init;
     unsigned short reg_Dual_Lane_Mipi_Receiver_Init_size;

};


struct mt9m114_reg_setting {
     struct mt9m114_reg_tuning *reg_scene_mode_off1;
     unsigned short reg_scene_mode_off1_size;
     struct mt9m114_reg_tuning *reg_scene_mode_off2;
     unsigned short reg_scene_mode_off2_size;
     struct mt9m114_reg_tuning *reg_scene_mode_landscape1;
     unsigned short reg_scene_mode_landscape1_size;
     struct mt9m114_reg_tuning *reg_scene_mode_landscape2;
     unsigned short reg_scene_mode_landscape2_size;
     struct mt9m114_reg_tuning *reg_scene_mode_portrain1;
     unsigned short reg_scene_mode_portrain1_size;
     struct mt9m114_reg_tuning *reg_scene_mode_portrain2;
     unsigned short reg_scene_mode_portrain2_size;
     struct mt9m114_reg_tuning *reg_scene_mode_snow1;
     unsigned short reg_scene_mode_snow1_size;
     struct mt9m114_reg_tuning *reg_scene_mode_snow2;
     unsigned short reg_scene_mode_snow2_size;
     struct mt9m114_reg_tuning *reg_scene_mode_night1;
     unsigned short reg_scene_mode_night1_size;
     struct mt9m114_reg_tuning *reg_scene_mode_night2;
     unsigned short reg_scene_mode_night2_size;
};




#if 0
struct mt9m114_reg_settings
{
    const struct mt9m114_reg_tuning *reg_pll_timing;
    const unsigned short reg_pll_timing_size;
    const struct mt9m114_reg_tuning *reg_optimization;
    const unsigned short reg_optimization_size;
    const struct mt9m114_reg_tuning *reg_patch0202;
    const unsigned short reg_patch0202_size;
    const struct mt9m114_reg_tuning *reg_patch0302;
    const unsigned short reg_patch0302_size;
    const struct mt9m114_reg_tuning *reg_APGA;
    const unsigned short reg_APGA_size;
    const struct mt9m114_reg_tuning *reg_AWB_CCM;
    const unsigned short reg_AWB_CCM_size;
    const struct mt9m114_reg_tuning *reg_MIPI_setting;
    const unsigned short reg_MIPI_setting_size;
    const struct mt9m114_reg_tuning *reg_Dual_Lane_Mipi_Receiver_Init;
    const unsigned short reg_Dual_Lane_Mipi_Receiver_Init_size;

}
#endif
#endif
