#ifndef OV5642_H
#define OV5642_H

#include "ov5642_reg.h"



#define USE_AE_TRANS




#define USE_AF
#define OV5642_SLAVE_ADDR (0x78 >> 1)



#define FALSE			0 
#define TRUE			1






enum ov5642_test_mode_t
{
	TEST_OFF,
	TEST_1,
	TEST_2,
	TEST_3
};

enum ov5642_setting
{
	RES_PREVIEW,
	RES_CAPTURE,
	RES_1080P,
	RES_MAX
};
enum ov5642_reg_update
{
	
	REG_INIT,
	
	UPDATE_PERIODIC,
	
	UPDATE_ALL,
	
	UPDATE_INVALID
};


struct ov5642_ae_func_array
{
	long (*preview_to_snapshot) (void);
	long (*snapshot_to_preview) (int);
	long (*prepare_snapshot) (void);
};


#define OV5642_BIT_OPERATION_TAG 0xFFFE


int32_t ov5642_i2c_read (unsigned short raddr, uint8_t * rdata, int rlen);

int32_t ov5642_i2c_read_array (struct ov5642_reg * regs, uint32_t size);

int32_t ov5642_i2c_write_b_sensor (unsigned short waddr, uint8_t bdata);

int32_t ov5642_i2c_write_b_table (struct ov5642_reg *reg_conf_tbl, int num);

int32_t ov5642_i2c_burst_write (char const *data, uint32_t size);

#endif 
