#include "ov5642.h"


#define EXPOSURE_HIGH    0
#define EXPOSURE_MID     1
#define EXPOSURE_LOW     2
#define GAIN             3
#define VTS_MAXLINE_HIGH 4
#define VTS_MAXLINE_LOW  5
#define AWB              6
#define LIGHT_INDICATOR  AWB
static struct ov5642_reg ov5642_1D_transform_reg[] = {
	{0x3500, 0x00},		
	{0x3501, 0x00},
	{0x3502, 0x00},
	{0x350b, 0x00},		
	{0x350c, 0x00},
	{0x350d, 0x00},
	{0x3406, 0x00},		
};

#define AUTO_TRANSFORM   0
#define MANUAL_TRANSFORM 1
static char ov5642_1D_transform_flag = AUTO_TRANSFORM;

static long
ov5642_1D_preview_transform (int whiteBalance)
{
	long rc;

	if (whiteBalance == 1)	
		ov5642_1D_transform_reg[AWB].val = 0x00;
	else
		ov5642_1D_transform_reg[AWB].val = 0x01;

	CDBG ("ov5642_1D_preview_transform: exposure=0x%02X %02X %02X gain=0x%02X awb=0x%02X vts=0x%02X %02X\n", ov5642_1D_transform_reg[EXPOSURE_HIGH].val, ov5642_1D_transform_reg[EXPOSURE_MID].val, ov5642_1D_transform_reg[EXPOSURE_LOW].val, ov5642_1D_transform_reg[GAIN].val, ov5642_1D_transform_reg[AWB].val, ov5642_1D_transform_reg[VTS_MAXLINE_HIGH].val, ov5642_1D_transform_reg[VTS_MAXLINE_LOW].val);

	if (MANUAL_TRANSFORM == ov5642_1D_transform_flag)
	{
		unsigned long exposure = 0;

		exposure =
			(ov5642_1D_transform_reg[EXPOSURE_HIGH].
			 val << 16) | (ov5642_1D_transform_reg[EXPOSURE_MID].
				       val << 8) |
			ov5642_1D_transform_reg[EXPOSURE_LOW].val;

		
		rc = ov5642_i2c_write_b_table ((struct ov5642_reg *)
					       ov5642_1D_transform_reg,
					       AWB + 1);

		ov5642_1D_transform_flag = AUTO_TRANSFORM;
	}
	else
	{
		ov5642_1D_transform_reg[VTS_MAXLINE_HIGH].val = 0x03;
		ov5642_1D_transform_reg[VTS_MAXLINE_LOW].val = 0xf0;
		rc = ov5642_i2c_write_b_table ((struct ov5642_reg *)
					       &ov5642_1D_transform_reg
					       [VTS_MAXLINE_HIGH], 3);
	}

	return rc;
}

static long
ov5642_1D_snapshot_transform (void)
{
	long rc;
	int banding;

	struct ov5642_reg const ov5642_stop_ae_awb[] = {
		{0x3503, 0x07},
		{0x3406, 0x01},
	};

	struct ov5642_reg ov5642_transform_read[] = {
		{0x3500, 0x00},
		{0x3501, 0x00},
		{0x3502, 0x00},
		{0x350b, 0x00},
		{0x350c, 0x00},
		{0x350d, 0x00},
		{0x3c0c, 0x00},
	};

#define  CAPTURE_FRAMERATE 750	
#define  PREVIEW_FRAMERATE 2000	

	unsigned long ulLines_10ms;

	unsigned int Capture_MaxLines, Preview_Maxlines;
	unsigned long ulCapture_Exposure, ulPreviewExposure,
		ulCapture_Exposure_Gain;
	long iCapture_Gain;
	char Gain;
	unsigned long aec_pk_vts;

    printk ("OV5642 ov5642_1D_snapshot_transform  in \n");

	
	rc = ov5642_i2c_write_b_table ((struct ov5642_reg *)
				       ov5642_stop_ae_awb,
				       ARRAY_SIZE (ov5642_stop_ae_awb));
	if (rc)
		goto exit_config_exp;


	
#ifdef USE_AE_TRANS	
	rc = ov5642_i2c_read_array ((struct ov5642_reg *)
				    ov5642_transform_read,
				    ARRAY_SIZE (ov5642_transform_read));
	if (rc)
		goto exit_config_exp;
#endif
	ov5642_1D_transform_flag = MANUAL_TRANSFORM;
	

	CDBG ("ov5642_1D_snapshot_transform: exposure=0x%02X %02X %02X gain=0x%02X vts=0x%02X %02X \n", ov5642_transform_read[EXPOSURE_HIGH].val, ov5642_transform_read[EXPOSURE_MID].val, ov5642_transform_read[EXPOSURE_LOW].val, ov5642_transform_read[GAIN].val, ov5642_transform_read[VTS_MAXLINE_HIGH].val, ov5642_transform_read[VTS_MAXLINE_LOW].val);

	ov5642_transform_read[EXPOSURE_HIGH].val &= 0x0F;
	ulPreviewExposure =
		((unsigned long) (ov5642_transform_read[EXPOSURE_HIGH].
				  val)) << 12;
	ulPreviewExposure +=
		((unsigned long) ov5642_transform_read[EXPOSURE_MID].
		 val) << 4;
	ulPreviewExposure += (ov5642_transform_read[EXPOSURE_LOW].val >> 4);
	Gain = ov5642_transform_read[GAIN].val;
	
	Preview_Maxlines = 0x3f0;

	
	
#if 1
	rc = ov5642_i2c_write_b_table
		(ov5642_regs.snapshot_settings,
		 ov5642_regs.snapshot_settings_size);
	if (rc < 0)
		return rc;
#endif
#if 0
	if (rc)
		goto exit_config_exp;
#endif    

	
	
	Capture_MaxLines = 0x7d0;


	if (ov5642_transform_read[LIGHT_INDICATOR].val & 0x01)
		banding = 50;	
	else
		banding = 60;	


	if (banding == 60)	
	{
		ulLines_10ms = CAPTURE_FRAMERATE * Capture_MaxLines / 12000;
	}
	else
	{
		ulLines_10ms = CAPTURE_FRAMERATE * Capture_MaxLines / 10000;
	}

	if (0 == Preview_Maxlines || 0 == PREVIEW_FRAMERATE
	    || 0 == ulLines_10ms)
	{
		CDBG ("ov5642_1D_snapshot_transform: zero parameters\n");
		rc = -1;
		goto exit_config_exp;
	}

	
	
	
	if (ulPreviewExposure > 0x3f0)
	{
		unsigned long long temp;

		
		temp = (unsigned long long) (ulPreviewExposure * 2 *   		
					     Capture_MaxLines) /
			(unsigned long long) (4 * Preview_Maxlines);
		ulCapture_Exposure = (unsigned long) temp;
	}
	else
	{
		unsigned long long temp;
		
		temp = (unsigned long long) (ulPreviewExposure * 9 *       
					     Capture_MaxLines) /
			(unsigned long long) (16 * Preview_Maxlines);
		ulCapture_Exposure = (unsigned long) temp;
	}
	CDBG ("%s: ulCapture_Exposure=%lx, ulPreviewExposure=%lx, Capture_MaxLines=%x, Preview_Maxlines=%x\n", __func__, ulCapture_Exposure, ulPreviewExposure, Capture_MaxLines, Preview_Maxlines);


	iCapture_Gain = (Gain & 0x0f) + 16;
	if (Gain & 0x10)
	{
		iCapture_Gain = iCapture_Gain << 1;
	}
	if (Gain & 0x20)
	{
		iCapture_Gain = iCapture_Gain << 1;
	}
	if (Gain & 0x40)
	{
		iCapture_Gain = iCapture_Gain << 1;
	}
	if (Gain & 0x80)
	{
		iCapture_Gain = iCapture_Gain << 1;
	}

	ulCapture_Exposure_Gain = ulCapture_Exposure * iCapture_Gain;
	if (ulCapture_Exposure_Gain <
	    ((unsigned long) (Capture_MaxLines) * 16))
	{
		ulCapture_Exposure = ulCapture_Exposure_Gain / 16;
		if (ulCapture_Exposure > ulLines_10ms)
		{
			ulCapture_Exposure /= ulLines_10ms;
			ulCapture_Exposure *= ulLines_10ms;
		}
	}
	else
	{
		ulCapture_Exposure = Capture_MaxLines;
	}
	CDBG ("%s: ulCapture_Exposure_Gain=%lx, iCapture_Gain=%lx, ulCapture_Exposure=%lx\n", __func__, ulCapture_Exposure_Gain, iCapture_Gain, ulCapture_Exposure);

	if (ulCapture_Exposure == 0)
	{
		ulCapture_Exposure = 1;
	}
	
	iCapture_Gain = ulCapture_Exposure_Gain / ulCapture_Exposure;
	iCapture_Gain +=
		((ulCapture_Exposure_Gain % ulCapture_Exposure) * 2 /
		 ulCapture_Exposure + 1) / 2;

	ov5642_transform_read[EXPOSURE_LOW].val =
		(char) ((ulCapture_Exposure << 4) & 0xff);
	ov5642_transform_read[EXPOSURE_MID].val =
		(char) ((ulCapture_Exposure >> 4) & 0xff);
	ov5642_transform_read[EXPOSURE_HIGH].val =
		(char) ((ulCapture_Exposure >> 12) & 0xff);

	Gain = 0;
	if (iCapture_Gain > 31)
	{
		Gain |= 0x10;
		iCapture_Gain = iCapture_Gain >> 1;
	}
	if (iCapture_Gain > 31)
	{
		Gain |= 0x20;
		iCapture_Gain = iCapture_Gain >> 1;
	}
	if (iCapture_Gain > 31)
	{
		Gain |= 0x40;
		iCapture_Gain = iCapture_Gain >> 1;
	}
	if (iCapture_Gain > 31)
	{
		Gain |= 0x80;
		iCapture_Gain = iCapture_Gain >> 1;
	}

	if (iCapture_Gain > 16)
	{
		Gain |= ((iCapture_Gain - 16) & 0x0f);
	}
	if (Gain == 0x10)
	{
		Gain = 0x11;
	}

	ov5642_transform_read[GAIN].val = Gain;


	aec_pk_vts = ulPreviewExposure * 2;	
	if ((aec_pk_vts & 0xFFFF) < 0x7D0)
		aec_pk_vts = 0x7D0;
	ov5642_transform_read[VTS_MAXLINE_HIGH].val =
		(aec_pk_vts >> 8) & 0xFF;
	ov5642_transform_read[VTS_MAXLINE_LOW].val = aec_pk_vts & 0xFF;


	
	CDBG ("ov5642_1D_snapshot_transform: exposure=0x%02X %02X %02X gain=0x%02X vts=0x%02X %02X \n", ov5642_transform_read[EXPOSURE_HIGH].val, ov5642_transform_read[EXPOSURE_MID].val, ov5642_transform_read[EXPOSURE_LOW].val, ov5642_transform_read[GAIN].val, ov5642_transform_read[VTS_MAXLINE_HIGH].val, ov5642_transform_read[VTS_MAXLINE_LOW].val);

	rc = ov5642_i2c_write_b_table ((struct ov5642_reg *)
				       ov5642_transform_read,
				       ARRAY_SIZE (ov5642_transform_read) -
				       1);

      exit_config_exp:
	return rc;
}

static long
ov5642_1D_prepare_snapshot (void)
{
	long rc;
    
	struct ov5642_reg exp_gain_vts[] = {
		{0x3500, 0x00},
		{0x3501, 0x00},
		{0x3502, 0x00},
		{0x350b, 0x00},
		{0x350c, 0x00},
		{0x350d, 0x00}
	};
    
    rc = 0;
#ifdef USE_AE_TRANS
	rc = ov5642_i2c_read_array ((struct ov5642_reg *) exp_gain_vts,
				    ARRAY_SIZE (exp_gain_vts));
	if (rc)
		return rc;
#endif
	memcpy (ov5642_1D_transform_reg, exp_gain_vts, sizeof (exp_gain_vts));
	CDBG ("ov5642_1D_prepare_snapshot: exposure=0x%02X %02X %02X gain=0x%02X vts=0x%02X %02X \n", ov5642_1D_transform_reg[EXPOSURE_HIGH].val, ov5642_1D_transform_reg[EXPOSURE_MID].val, ov5642_1D_transform_reg[EXPOSURE_LOW].val, ov5642_1D_transform_reg[GAIN].val, ov5642_1D_transform_reg[VTS_MAXLINE_HIGH].val, ov5642_1D_transform_reg[VTS_MAXLINE_LOW].val);

	return rc;
}

struct ov5642_ae_func_array ov5642_1D_ae_func = {
	.preview_to_snapshot = ov5642_1D_snapshot_transform,
	.snapshot_to_preview = ov5642_1D_preview_transform,
	.prepare_snapshot = ov5642_1D_prepare_snapshot,
};
