#ifndef __VIDEO_MSM_OV5642_AF_H
#define __VIDEO_MSM_OV5642_AF_H


#include "ov5642.h"



#define OV5642_AF_CMD_MAIN       0x3024
#define OV5642_AF_CMD_TAG        0x3025
#define OV5642_AF_CMD_PARA3      0x5082
#define OV5642_AF_CMD_PARA2      0x5083
#define OV5642_AF_CMD_PARA1      0x5084
#define OV5642_AF_CMD_PARA0      0x5085
#define OV5642_AF_STA_ZONE       0x3026
#define OV5642_AF_STA_FOCUS      0x3027


#define CMD_MAIN_ENABLE_OVERLAY  0x01
#define CMD_MAIN_DISABLE_OVERLAY 0x02
#define CMD_MAIN_SINGLE_FOCUS    0x03
#define CMD_MAIN_RETURN_TO_IDLE  0x08
#define CMD_MAIN_UPDATE_ZONE     0x12
#define CMD_MAIN_READ_STEP       0x21



#define CMD_TAG_VALUE_NOT_ZERO   0xFF


#define STA_FOCUS_S_FIRMWARE     0xFF
#define STA_FOCUS_S_STARTUP      0xFA
#define STA_FOCUS_S_ERROR        0xFE
#define STA_FOCUS_S_DRVICERR     0xEE
#define STA_FOCUS_S_IDLE         0x00
#define STA_FOCUS_S_FOCUSING     0x01
#define STA_FOCUS_S_FOCUSED      0x02
#define STA_FOCUS_S_CAPTURE      0x12
#define STA_FOCUS_S_STEP         0x20

enum ov5642_af_status_t
{
	UNKNOWN_STATUS,
	DOWNLOADING_STATUS,
	IDLE_STATUS,
};

struct ov5642_reg const ov5642_af_step[] = {
	{OV5642_AF_CMD_TAG, 0x01},
	{OV5642_AF_CMD_MAIN, 0x21},
};


struct ov5642_reg const ov5642_download_af[] = {
	{OV5642_BIT_OPERATION_TAG, 0x20},
	{0x3004, 0x20},
	{0x3000, 0x20},
};

struct ov5642_reg const ov5642_reset_af[] = {
	{OV5642_BIT_OPERATION_TAG, 0x20},
	{0x3000, 0x20},
};

struct ov5642_reg const ov5642_enable_af[] = {
	{0x3024, 0x00},
	{0x3025, 0x00},
	{0x5082, 0x00},
	{0x5083, 0x00},
	{0x5084, 0x00},
	{0x5085, 0x00},
	{0x3026, 0x00},
	{0x3027, 0xFF},
	{OV5642_BIT_OPERATION_TAG, 0x20},
	{0x3000, 0x00},
};

struct ov5642_reg const ov5642_single_af[] = {
	{OV5642_AF_CMD_TAG, CMD_TAG_VALUE_NOT_ZERO},
	{OV5642_AF_CMD_MAIN, CMD_MAIN_SINGLE_FOCUS},
};

struct ov5642_reg const ov5642_disable_overlay[] = {
	{OV5642_AF_CMD_TAG, CMD_TAG_VALUE_NOT_ZERO},
	{OV5642_AF_CMD_MAIN, CMD_MAIN_DISABLE_OVERLAY},
};

char ov5642_autofocus_reg[] = {

	0x80,
	0x00,
	0x02,			
	0x00,
	0x06,
	0x02,
	0x0b,
	0x5f,
	0x78,
	0x7f,
	0xe4,
	0xf6,
	0xd8,
	0xfd,
	0x75,
	0x81,
	0x7e,
	0x02,
	0x13,
	0xb5,
	0x00,
	0x02,
	0x12,
	0xe0,
	0xe0,
	0xf5,
	0x72,
	0xa3,
	0xe0,
	0xf5,
	0x73,
	0xae,
	0x6a,
	0xe4,
	0x85,
	0x6b,
	0x55,
	0x8e,
	0x54,
	0xf5,
	0x53,
	0xf5,
	0x52,
	0xab,
	0x55,
	0xaa,
	0x54,
	0xa9,
	0x53,
	0xa8,
	0x52,
	0xaf,
	0x2c,
	0xfc,
	0xfd,
	0xfe,
	0x12,
	0x08,
	0x8e,
	0x8f,
	0x55,
	0x8e,
	0x54,
	0x8d,
	0x53,
	0x8c,
	0x52,
	0xaf,
	0x55,
	0xae,
	0x54,
	0xad,
	0x53,
	0xac,
	0x52,
	0x8f,
	0x2b,
	0x8e,
	0x2a,
	0x8d,
	0x29,
	0x8c,
	0x28,
	0xae,
	0x6c,
	0xe4,
	0x85,
	0x6d,
	0x55,
	0x8e,
	0x54,
	0xf5,
	0x53,
	0xf5,
	0x52,
	0xab,
	0x55,
	0xaa,
	0x54,
	0xa9,
	0x53,
	0xa8,
	0x52,
	0xaf,
	0x2d,
	0xfc,
	0xfd,
	0xfe,
	0x12,
	0x08,
	0x8e,
	0x8f,
	0x55,
	0x8e,
	0x54,
	0x8d,
	0x53,
	0x8c,
	0x52,
	0xe5,
	0x2b,
	0x25,
	0x55,
	0xf5,
	0x2b,
	0xe5,
	0x2a,
	0x35,
	0x54,
	0xf5,
	0x2a,
	0xe5,
	0x29,
	0x35,
	0x53,
	0xf5,
	0x29,
	0xe5,
	0x28,
	0x35,
	0x52,
	0xf5,
	0x28,
	0xae,
	0x6e,
	0xe4,
	0x85,
	0x6f,
	0x55,
	0x8e,
	0x54,
	0xf5,
	0x53,
	0xf5,
	0x52,
	0xab,
	0x55,
	0xaa,
	0x54,
	0xa9,
	0x53,
	0xa8,
	0x52,
	0xaf,
	0x2e,
	0xfc,
	0xfd,
	0xfe,
	0x12,
	0x08,
	0x8e,
	0x8f,
	0x55,
	0x8e,
	0x54,
	0x8d,
	0x53,
	0x8c,
	0x52,
	0xe5,
	0x2b,
	0x25,
	0x55,
	0xf5,
	0x2b,
	0xe5,
	0x2a,
	0x35,
	0x54,
	0xf5,
	0x2a,
	0xe5,
	0x29,
	0x35,
	0x53,
	0xf5,
	0x29,
	0xe5,
	0x28,
	0x35,
	0x52,
	0xf5,
	0x28,
	0xae,
	0x70,
	0xe4,
	0x85,
	0x71,
	0x55,
	0x8e,
	0x54,
	0xf5,
	0x53,
	0xf5,
	0x52,
	0xab,
	0x55,
	0xaa,
	0x54,
	0xa9,
	0x53,
	0xa8,
	0x52,
	0xaf,
	0x2f,
	0xfc,
	0xfd,
	0xfe,
	0x12,
	0x08,
	0x8e,
	0x8f,
	0x55,
	0x8e,
	0x54,
	0x8d,
	0x53,
	0x8c,
	0x52,
	0xe5,
	0x2b,
	0x25,
	0x55,
	0xf5,
	0x2b,
	0xe5,
	0x2a,
	0x35,
	0x54,
	0xf5,
	0x2a,
	0xe5,
	0x29,
	0x35,
	0x53,
	0xf5,
	0x29,
	0xe5,

	0x81,
	0x00,
	0x28,			
	0x35,
	0x52,
	0xf5,
	0x28,
	0xae,
	0x72,
	0xe4,
	0x85,
	0x73,
	0x55,
	0x8e,
	0x54,
	0xf5,
	0x53,
	0xf5,
	0x52,
	0xab,
	0x55,
	0xaa,
	0x54,
	0xa9,
	0x53,
	0xa8,
	0x52,
	0xaf,
	0x30,
	0xfc,
	0xfd,
	0xfe,
	0x12,
	0x08,
	0x8e,
	0x8f,
	0x55,
	0x8e,
	0x54,
	0x8d,
	0x53,
	0x8c,
	0x52,
	0xe5,
	0x2b,
	0x25,
	0x55,
	0xf5,
	0x2b,
	0xe5,
	0x2a,
	0x35,
	0x54,
	0xf5,
	0x2a,
	0xe5,
	0x29,
	0x35,
	0x53,
	0xf5,
	0x29,
	0xe5,
	0x28,
	0x35,
	0x52,
	0xf5,
	0x28,
	0x22,
	0xab,
	0x0d,
	0xaa,
	0x0c,
	0xa9,
	0x0b,
	0xa8,
	0x0a,
	0xfc,
	0xfd,
	0xfe,
	0x12,
	0x08,
	0x8e,
	0x8f,
	0x0d,
	0x8e,
	0x0c,
	0x8d,
	0x0b,
	0x8c,
	0x0a,
	0x7b,
	0x40,
	0xe4,
	0xfa,
	0xf9,
	0xf8,
	0x12,
	0x09,
	0x19,
	0x8f,
	0x0d,
	0x8e,
	0x0c,
	0x8d,
	0x0b,
	0x8c,
	0x0a,
	0x22,
	0xd2,
	0x29,
	0x90,
	0x30,
	0x1b,
	0xe5,
	0x25,
	0xf0,
	0x22,
	0x85,
	0x49,
	0x82,
	0x85,
	0x48,
	0x83,
	0xe5,
	0x7c,
	0x75,
	0xf0,
	0x02,
	0x12,
	0x09,
	0xe1,
	0xe4,
	0x93,
	0xfe,
	0x74,
	0x01,
	0x93,
	0xff,
	0x85,
	0x49,
	0x82,
	0x85,
	0x48,
	0x83,
	0xe4,
	0x93,
	0xfc,
	0x74,
	0x01,
	0x93,
	0xfd,
	0xc3,
	0xef,
	0x9d,
	0xff,
	0xee,
	0x9c,
	0x22,
	0xfe,
	0xe4,
	0xfc,
	0xfd,
	0xe5,
	0x3f,
	0x2f,
	0xf5,
	0x3f,
	0xe5,
	0x3e,
	0x3e,
	0xf5,
	0x3e,
	0xed,
	0x35,
	0x3d,
	0xf5,
	0x3d,
	0xec,
	0x35,
	0x3c,
	0xf5,
	0x3c,
	0xaf,
	0x3f,
	0xae,
	0x3e,
	0xfc,
	0xad,
	0x3d,
	0x78,
	0x08,
	0x12,
	0x09,
	0xbe,
	0x8f,
	0x3f,
	0x8e,
	0x3e,
	0x8d,
	0x3d,
	0x8c,
	0x3c,
	0x22,
	0xe5,
	0x0b,
	0x24,
	0x01,
	0xff,
	0xe4,
	0x33,
	0xfe,
	0x22,
	0xaf,
	0x2b,
	0xae,
	0x2a,
	0xad,
	0x29,
	0xac,
	0x28,
	0x78,
	0x06,
	0x12,
	0x09,
	0xab,
	0x8f,
	0x2b,
	0x8e,
	0x2a,
	0x8d,
	0x29,
	0x8c,
	0x28,
	0xd3,
	0xe5,
	0x29,
	0x94,
	0x00,
	0xe5,
	0x28,
	0x94,
	0x00,
	0x22,
	0x12,
	0x08,
	0x8e,
	0x8f,
	0x69,
	0x8e,
	0x68,
	0x8d,
	0x67,
	0x8c,
	0x66,
	0xaf,
	0x69,
	0xae,
	0x68,

	0x82,
	0x00,
	0xad,			
	0x67,
	0xac,
	0x66,
	0x22,
	0xe0,
	0x44,
	0x01,
	0xf0,
	0xe0,
	0x44,
	0x02,
	0xf0,
	0xe0,
	0x44,
	0x04,
	0xf0,
	0x22,
	0xd2,
	0x09,
	0x90,
	0x30,
	0x18,
	0xe5,
	0x21,
	0xf0,
	0x22,
	0xe4,
	0x85,
	0x11,
	0x0d,
	0x85,
	0x10,
	0x0c,
	0xf5,
	0x0b,
	0xf5,
	0x0a,
	0xab,
	0x0d,
	0xaa,
	0x0c,
	0xa9,
	0x0b,
	0xa8,
	0x0a,
	0x22,
	0x90,
	0x30,
	0x42,
	0xe0,
	0xf5,
	0x22,
	0x75,
	0x51,
	0x0a,
	0x22,
	0x85,
	0x49,
	0x82,
	0x85,
	0x48,
	0x83,
	0x22,
	0xf5,
	0x82,
	0xe4,
	0x3a,
	0xf5,
	0x83,
	0x02,
	0x09,
	0xd1,
	0x8f,
	0x0a,
	0x74,
	0x4a,
	0x2f,
	0xf8,
	0xe6,
	0x22,
	0xc2,
	0x07,
	0xc2,
	0x06,
	0xc2,
	0x02,
	0xc2,
	0x01,
	0xc2,
	0x00,
	0xc2,
	0x03,
	0xd2,
	0x04,
	0x22,
	0xe5,
	0x16,
	0x25,
	0xe0,
	0x25,
	0xe0,
	0x22,
	0x12,
	0x09,
	0x19,
	0x8f,
	0x69,
	0x8e,
	0x68,
	0x8d,
	0x67,
	0x8c,
	0x66,
	0x22,
	0xe4,
	0x85,
	0x0f,
	0x0d,
	0x85,
	0x0e,
	0x0c,
	0xf5,
	0x0b,
	0xf5,
	0x0a,
	0x22,
	0x90,
	0x10,
	0xa7,
	0xe4,
	0x93,
	0xff,
	0x90,
	0x30,
	0x0a,
	0xe0,
	0x22,
	0xc2,
	0x02,
	0xc2,
	0x01,
	0xd2,
	0x00,
	0xc2,
	0x03,
	0xc2,
	0x04,
	0x22,
	0x75,
	0xf0,
	0x02,
	0x02,
	0x09,
	0xe1,
	0xd2,
	0x02,
	0xd2,
	0x01,
	0xc2,
	0x00,
	0x22,
	0x74,
	0x4a,
	0x25,
	0x0a,
	0xf8,
	0xe6,
	0x22,
	0xd3,
	0xe5,
	0x69,
	0x94,
	0xff,
	0xe5,
	0x68,
	0x94,
	0x03,
	0x22,
	0x30,
	0x18,
	0x4d,
	0x20,
	0x19,
	0x4a,
	0x75,
	0x0a,
	0x02,
	0x12,
	0x02,
	0xa2,
	0xff,
	0xe5,
	0x4a,
	0xd3,
	0x9f,
	0x40,
	0x04,
	0x7f,
	0x00,
	0x80,
	0x02,
	0xaf,
	0x0a,
	0x12,
	0x02,
	0x49,
	0xff,
	0xe5,
	0x4b,
	0xd3,
	0x9f,
	0x40,
	0x04,
	0x7f,
	0x01,
	0x80,
	0x02,
	0xaf,
	0x0a,
	0x12,
	0x02,
	0x49,
	0xff,
	0xe5,
	0x4d,
	0xd3,
	0x9f,
	0x40,
	0x04,
	0x7f,
	0x03,
	0x80,
	0x02,
	0xaf,
	0x0a,
	0x12,
	0x02,
	0x49,
	0xff,
	0xe5,
	0x4e,
	0xd3,
	0x9f,
	0x40,
	0x04,
	0x7f,
	0x04,
	0x80,
	0x02,
	0xaf,
	0x0a,
	0x12,
	0x02,
	0x49,
	0xf5,

	0x83,
	0x00,
	0x0b,			
	0x80,
	0x06,
	0x85,
	0x79,
	0x0a,
	0x85,
	0x4f,
	0x0b,
	0x7f,
	0x01,
	0xe4,
	0xfe,
	0x12,
	0x02,
	0xa2,
	0xfd,
	0xe5,
	0x0b,
	0xc3,
	0x9d,
	0x50,
	0x04,
	0x7d,
	0x01,
	0x80,
	0x02,
	0x7d,
	0xff,
	0xac,
	0x0b,
	0xe5,
	0x4e,
	0xb5,
	0x0b,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1f,
	0xe5,
	0x4d,
	0xb5,
	0x0b,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1e,
	0xe5,
	0x4c,
	0xb5,
	0x0b,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1d,
	0xe5,
	0x4b,
	0xb5,
	0x0b,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1c,
	0xe5,
	0x4a,
	0xb5,
	0x0b,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1b,
	0xe5,
	0x30,
	0xd3,
	0x94,
	0x00,
	0x40,
	0x04,
	0xa2,
	0x1f,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1f,
	0xe5,
	0x2f,
	0xd3,
	0x94,
	0x00,
	0x40,
	0x04,
	0xa2,
	0x1e,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1e,
	0xe5,
	0x2e,
	0xd3,
	0x94,
	0x00,
	0x40,
	0x04,
	0xa2,
	0x1d,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1d,
	0xe5,
	0x2d,
	0xd3,
	0x94,
	0x00,
	0x40,
	0x04,
	0xa2,
	0x1c,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1c,
	0xe5,
	0x2c,
	0xd3,
	0x94,
	0x00,
	0x40,
	0x04,
	0xa2,
	0x1b,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1b,
	0xe5,
	0x23,
	0x54,
	0xf8,
	0x70,
	0x5b,
	0xbf,
	0x01,
	0x08,
	0xed,
	0xf4,
	0x04,
	0xfd,
	0x7f,
	0x02,
	0x80,
	0x06,
	0xbf,
	0x02,
	0x02,
	0x7f,
	0x01,
	0x0e,
	0xd3,
	0xed,
	0x64,
	0x80,
	0x94,
	0x80,
	0x40,
	0x18,
	0xec,
	0x2e,
	0xf5,
	0x0b,
	0xd3,
	0x95,
	0x7c,
	0x40,
	0x2c,
	0x7d,
	0xff,
	0xef,
	0x60,
	0x04,
	0x7b,
	0x00,
	0x80,
	0x02,
	0x7b,
	0x03,
	0xaf,
	0x03,
	0x80,
	0x18,
	0xec,
	0xc3,
	0x9e,
	0x50,
	0x13,
	0x7d,
	0x01,
	0xef,
	0x60,
	0x04,
	0x7b,
	0x00,
	0x80,
	0x02,
	0x7b,
	0x03,
	0xaf,
	0x03,
	0xec,
	0x2e,
	0xf5,
	0x0b,
	0x80,
	0x05,
	0xc3,
	0xec,
	0x9e,
	0xf5,
	0x0b,
	0xef,
	0x64,
	0x03,
	0x60,
	0x03,
	0x02,
	0x03,
	0x1f,
	0x12,
	0x02,
	0xa2,
	0xf5,
	0x0b,
	0x12,
	0x01,
	0xc9,

	0x84,
	0x00,
	0xe5,			
	0x4e,
	0xb5,
	0x07,
	0x07,
	0xe4,
	0xb5,
	0x06,
	0x03,
	0xd3,
	0x80,
	0x02,
	0xa2,
	0x1f,
	0x92,
	0x1f,
	0xe5,
	0x4d,
	0xb5,
	0x07,
	0x07,
	0xe4,
	0xb5,
	0x06,
	0x03,
	0xd3,
	0x80,
	0x02,
	0xa2,
	0x1e,
	0x92,
	0x1e,
	0x12,
	0x01,
	0xc9,
	0xe5,
	0x4c,
	0xb5,
	0x07,
	0x07,
	0xe4,
	0xb5,
	0x06,
	0x03,
	0xd3,
	0x80,
	0x02,
	0xa2,
	0x1d,
	0x92,
	0x1d,
	0xe5,
	0x4b,
	0xb5,
	0x07,
	0x07,
	0xe4,
	0xb5,
	0x06,
	0x03,
	0xd3,
	0x80,
	0x02,
	0xa2,
	0x1c,
	0x92,
	0x1c,
	0x12,
	0x01,
	0xc9,
	0xe5,
	0x4a,
	0xb5,
	0x07,
	0x07,
	0xe4,
	0xb5,
	0x06,
	0x03,
	0xd3,
	0x80,
	0x02,
	0xa2,
	0x1b,
	0x92,
	0x1b,
	0xe5,
	0x4e,
	0x12,
	0x01,
	0xcb,
	0xad,
	0x0b,
	0x7c,
	0x00,
	0xef,
	0xb5,
	0x05,
	0x07,
	0xec,
	0xb5,
	0x06,
	0x03,
	0xd3,
	0x80,
	0x02,
	0xa2,
	0x1f,
	0x92,
	0x1f,
	0xe5,
	0x4d,
	0x12,
	0x01,
	0xcb,
	0xef,
	0xb5,
	0x05,
	0x07,
	0xee,
	0xb5,
	0x04,
	0x03,
	0xd3,
	0x80,
	0x02,
	0xa2,
	0x1e,
	0x92,
	0x1e,
	0xe5,
	0x4c,
	0x12,
	0x01,
	0xcb,
	0xad,
	0x0b,
	0x7c,
	0x00,
	0xef,
	0xb5,
	0x05,
	0x07,
	0xec,
	0xb5,
	0x06,
	0x03,
	0xd3,
	0x80,
	0x02,
	0xa2,
	0x1d,
	0x92,
	0x1d,
	0xe5,
	0x4b,
	0x12,
	0x01,
	0xcb,
	0xef,
	0xb5,
	0x05,
	0x07,
	0xee,
	0xb5,
	0x04,
	0x03,
	0xd3,
	0x80,
	0x02,
	0xa2,
	0x1c,
	0x92,
	0x1c,
	0xe5,
	0x4a,
	0x12,
	0x01,
	0xcb,
	0x7c,
	0x00,
	0xef,
	0xb5,
	0x0b,
	0x07,
	0xec,
	0xb5,
	0x06,
	0x03,
	0xd3,
	0x80,
	0x02,
	0xa2,
	0x1b,
	0x92,
	0x1b,
	0xe5,
	0x30,
	0xd3,
	0x94,
	0x00,
	0x40,
	0x04,
	0xa2,
	0x1f,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1f,
	0xe5,
	0x2f,
	0xd3,
	0x94,
	0x00,
	0x40,
	0x04,
	0xa2,
	0x1e,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1e,
	0xe5,
	0x2e,
	0xd3,
	0x94,
	0x00,
	0x40,
	0x04,
	0xa2,
	0x1d,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1d,
	0xe5,
	0x2d,
	0xd3,
	0x94,
	0x00,
	0x40,
	0x04,
	0xa2,
	0x1c,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1c,
	0xe5,
	0x2c,
	0xd3,
	0x94,

	0x85,
	0x00,
	0x00,			
	0x40,
	0x04,
	0xa2,
	0x1b,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x1b,
	0x85,
	0x0a,
	0x79,
	0xe5,
	0x7d,
	0xb5,
	0x0b,
	0x03,
	0x02,
	0x15,
	0x17,
	0x85,
	0x0b,
	0x0c,
	0x12,
	0x11,
	0xd8,
	0xd2,
	0x02,
	0xc2,
	0x01,
	0xd2,
	0x00,
	0x75,
	0x31,
	0x03,
	0x22,
	0xe5,
	0x7e,
	0x24,
	0xfe,
	0x60,
	0x27,
	0x14,
	0x60,
	0x31,
	0x24,
	0xf8,
	0x60,
	0x3a,
	0x14,
	0x60,
	0x4b,
	0x14,
	0x60,
	0x59,
	0x14,
	0x60,
	0x6a,
	0x24,
	0xfd,
	0x70,
	0x03,
	0x02,
	0x05,
	0xda,
	0x24,
	0x10,
	0x60,
	0x03,
	0x02,
	0x06,
	0xd5,
	0xe4,
	0xf5,
	0x0a,
	0x12,
	0x11,
	0x10,
	0x02,
	0x06,
	0xbe,
	0x75,
	0x0a,
	0x01,
	0x12,
	0x06,
	0xd6,
	0xc2,
	0x3a,
	0xd2,
	0x39,
	0x02,
	0x06,
	0xcf,
	0x75,
	0x0a,
	0x02,
	0x12,
	0x06,
	0xd6,
	0xd2,
	0x3a,
	0xc2,
	0x39,
	0x02,
	0x06,
	0xcf,
	0x30,
	0x36,
	0x0c,
	0x20,
	0x3a,
	0x03,
	0x30,
	0x39,
	0x06,
	0xe4,
	0xf5,
	0x0a,
	0x12,
	0x12,
	0x91,
	0xd2,
	0x18,
	0xc2,
	0x19,
	0x22,
	0x30,
	0x36,
	0x09,
	0x20,
	0x3a,
	0x03,
	0x30,
	0x39,
	0x03,
	0x12,
	0x06,
	0xe7,
	0xd2,
	0x18,
	0xd2,
	0x19,
	0x22,
	0x30,
	0x36,
	0x0c,
	0x20,
	0x3a,
	0x03,
	0x30,
	0x39,
	0x06,
	0x75,
	0x0a,
	0x02,
	0x12,
	0x12,
	0x91,
	0xc2,
	0x18,
	0xd2,
	0x19,
	0x22,
	0x20,
	0x3a,
	0x06,
	0x20,
	0x39,
	0x03,
	0x02,
	0x06,
	0xd5,
	0xe5,
	0x79,
	0xd3,
	0x94,
	0x03,
	0x40,
	0x04,
	0x7f,
	0x00,
	0x80,
	0x04,
	0xe5,
	0x79,
	0x04,
	0xff,
	0x8f,
	0x79,
	0x30,
	0x18,
	0x06,
	0x30,
	0x19,
	0x03,
	0x12,
	0x06,
	0xe7,
	0x30,
	0x18,
	0x03,
	0x02,
	0x06,
	0xd5,
	0x20,
	0x19,
	0x03,
	0x02,
	0x06,
	0xd5,
	0x75,
	0x0a,
	0x02,
	0x02,
	0x12,
	0x91,
	0xe5,
	0x68,
	0xd3,
	0x94,
	0x38,
	0x40,
	0x04,
	0x7f,
	0x34,
	0x80,
	0x02,
	0xaf,
	0x68,
	0x8f,
	0x68,
	0xe5,
	0x68,
	0xc3,
	0x94,
	0x08,
	0x50,
	0x04,
	0x7f,
	0x08,
	0x80,
	0x02,
	0xaf,
	0x68,
	0x8f,
	0x68,
	0xe5,
	0x69,
	0xd3,
	0x94,
	0x2a,
	0x40,
	0x04,
	0x7f,

	0x86,
	0x00,
	0x2a,			
	0x80,
	0x02,
	0xaf,
	0x69,
	0x8f,
	0x69,
	0xe5,
	0x69,
	0xc3,
	0x94,
	0x06,
	0x50,
	0x04,
	0x7f,
	0x06,
	0x80,
	0x02,
	0xaf,
	0x69,
	0x8f,
	0x69,
	0xaf,
	0x68,
	0xef,
	0x24,
	0xf8,
	0xff,
	0xe4,
	0x34,
	0xff,
	0xfe,
	0xe4,
	0x8f,
	0x3f,
	0x8e,
	0x3e,
	0xf5,
	0x3d,
	0xf5,
	0x3c,
	0xac,
	0x3c,
	0x12,
	0x01,
	0xb9,
	0xaf,
	0x69,
	0xef,
	0x24,
	0xfa,
	0xff,
	0xe4,
	0x34,
	0xff,
	0x12,
	0x01,
	0x9c,
	0xaf,
	0x68,
	0xef,
	0x24,
	0x08,
	0xff,
	0xe4,
	0x33,
	0x12,
	0x01,
	0x9c,
	0xaf,
	0x69,
	0xef,
	0x24,
	0x06,
	0xff,
	0xe4,
	0x33,
	0xfe,
	0xe4,
	0xfc,
	0xfd,
	0xe5,
	0x3f,
	0x2f,
	0xf5,
	0x3f,
	0xe5,
	0x3e,
	0x3e,
	0xf5,
	0x3e,
	0xed,
	0x35,
	0x3d,
	0xf5,
	0x3d,
	0xec,
	0x35,
	0x3c,
	0xf5,
	0x3c,
	0xe4,
	0x25,
	0x3f,
	0xf5,
	0x37,
	0xe4,
	0x35,
	0x3e,
	0xf5,
	0x36,
	0xe4,
	0x35,
	0x3d,
	0xf5,
	0x35,
	0xe5,
	0x3c,
	0x34,
	0x08,
	0xf5,
	0x34,
	0xe4,
	0x25,
	0x3f,
	0xf5,
	0x3b,
	0xe4,
	0x35,
	0x3e,
	0xf5,
	0x3a,
	0xe5,
	0x3d,
	0x34,
	0x06,
	0xf5,
	0x39,
	0xe4,
	0x35,
	0x3c,
	0xf5,
	0x38,
	0xe5,
	0x3f,
	0x24,
	0xfa,
	0xf5,
	0x43,
	0xe5,
	0x3e,
	0x34,
	0xff,
	0xf5,
	0x42,
	0xe5,
	0x3d,
	0x34,
	0xff,
	0xf5,
	0x41,
	0xe5,
	0x3c,
	0x34,
	0xff,
	0xf5,
	0x40,
	0xe4,
	0x25,
	0x3f,
	0xf5,
	0x47,
	0xe5,
	0x3e,
	0x34,
	0xf8,
	0xf5,
	0x46,
	0xe5,
	0x3d,
	0x34,
	0xff,
	0xf5,
	0x45,
	0xe5,
	0x3c,
	0x34,
	0xff,
	0xf5,
	0x44,
	0x75,
	0x79,
	0x02,
	0x75,
	0x0a,
	0x01,
	0x12,
	0x12,
	0x91,
	0xd2,
	0x18,
	0xd2,
	0x19,
	0xc2,
	0x3a,
	0xc2,
	0x39,
	0xd2,
	0x1a,
	0xd2,
	0x36,
	0xd2,
	0x30,
	0x22,
	0x12,
	0x11,
	0x10,
	0x75,
	0x79,
	0x02,
	0xe4,
	0xf5,
	0x0a,
	0x12,
	0x12,
	0x91,
	0xd2,
	0x18,
	0xc2,
	0x19,
	0x22,
	0x75,
	0x0a,
	0x01,
	0x12,
	0x12,
	0x91,
	0x22,
	0x90,
	0x38,
	0x04,
	0xe0,
	0xfe,
	0xa3,
	0xe0,
	0xfd,
	0xed,
	0xff,
	0xee,
	0x54,
	0x0f,
	0xf5,
	0x0e,
	0x8f,
	0x0f,
	0xa3,

	0x87,
	0x00,
	0xe0,			
	0xfe,
	0xa3,
	0xe0,
	0xfd,
	0xed,
	0xff,
	0xee,
	0x54,
	0x07,
	0xf5,
	0x10,
	0x8f,
	0x11,
	0xe5,
	0x0e,
	0xc4,
	0xf8,
	0x54,
	0xf0,
	0xc8,
	0x68,
	0xf5,
	0x0e,
	0xe5,
	0x0f,
	0xc4,
	0x54,
	0x0f,
	0x48,
	0xf5,
	0x0f,
	0xe5,
	0x10,
	0xc4,
	0xf8,
	0x54,
	0xf0,
	0xc8,
	0x68,
	0xf5,
	0x10,
	0xe5,
	0x11,
	0xc4,
	0x54,
	0x0f,
	0x48,
	0xf5,
	0x11,
	0xe4,
	0xf5,
	0x17,
	0x75,
	0x16,
	0x04,
	0x12,
	0x02,
	0x60,
	0x24,
	0x34,
	0xf8,
	0xe6,
	0xf5,
	0x12,
	0x12,
	0x02,
	0x60,
	0x24,
	0x35,
	0xf8,
	0xe6,
	0xf5,
	0x14,
	0x12,
	0x02,
	0x60,
	0x24,
	0x36,
	0xf8,
	0xe6,
	0xf5,
	0x13,
	0x12,
	0x02,
	0x60,
	0x24,
	0x37,
	0xf8,
	0xe6,
	0xf5,
	0x15,
	0x12,
	0x02,
	0x73,
	0xaf,
	0x12,
	0x12,
	0x01,
	0x42,
	0x8f,
	0x12,
	0x12,
	0x02,
	0x73,
	0xaf,
	0x13,
	0x12,
	0x01,
	0x42,
	0x8f,
	0x13,
	0x12,
	0x02,
	0x1b,
	0xaf,
	0x14,
	0xfc,
	0xfd,
	0xfe,
	0x12,
	0x08,
	0x8e,
	0x12,
	0x01,
	0x61,
	0x7b,
	0x30,
	0x12,
	0x01,
	0x5a,
	0x8f,
	0x14,
	0x12,
	0x02,
	0x1b,
	0xaf,
	0x15,
	0xfc,
	0xfd,
	0xfe,
	0x12,
	0x08,
	0x8e,
	0x12,
	0x01,
	0x61,
	0xe4,
	0x7b,
	0x30,
	0x12,
	0x01,
	0x5b,
	0x8f,
	0x15,
	0xc3,
	0xe5,
	0x13,
	0x95,
	0x12,
	0xff,
	0x0f,
	0xef,
	0xc3,
	0x13,
	0xff,
	0xc3,
	0x94,
	0x04,
	0x50,
	0x27,
	0xe5,
	0x12,
	0x9f,
	0x40,
	0x06,
	0xe5,
	0x12,
	0x9f,
	0xfe,
	0x80,
	0x02,
	0x7e,
	0x00,
	0x8e,
	0x12,
	0xef,
	0xfd,
	0xe5,
	0x13,
	0x2d,
	0xfd,
	0xe4,
	0x33,
	0xfc,
	0xc3,
	0xed,
	0x95,
	0x0f,
	0xec,
	0x95,
	0x0e,
	0x50,
	0x02,
	0x80,
	0x02,
	0xad,
	0x0f,
	0x8d,
	0x13,
	0xc3,
	0xe5,
	0x15,
	0x95,
	0x14,
	0xff,
	0xc3,
	0x94,
	0x04,
	0x50,
	0x29,
	0xe5,
	0x14,
	0x9f,
	0x40,
	0x06,
	0xe5,
	0x14,
	0x9f,
	0xfe,
	0x80,
	0x02,
	0x7e,
	0x00,
	0x8e,
	0x14,
	0xef,
	0xfd,
	0xe5,
	0x15,
	0x2d,
	0xfd,
	0xe4,
	0x33,
	0xfc,
	0xc3,
	0xed,
	0x95,
	0x11,
	0xec,
	0x95,
	0x10,
	0x50,
	0x04,
	0xaf,
	0x05,

	0x88,
	0x00,
	0x80,			
	0x02,
	0xaf,
	0x11,
	0x8f,
	0x15,
	0xe5,
	0x15,
	0xd3,
	0x95,
	0x17,
	0x40,
	0x04,
	0xaf,
	0x15,
	0x80,
	0x02,
	0xaf,
	0x17,
	0x8f,
	0x17,
	0xd3,
	0xe5,
	0x16,
	0x64,
	0x80,
	0x94,
	0x80,
	0x40,
	0x04,
	0xaf,
	0x15,
	0x80,
	0x02,
	0xaf,
	0x17,
	0x8f,
	0x15,
	0xe5,
	0x16,
	0xfd,
	0x33,
	0x95,
	0xe0,
	0xfc,
	0xed,
	0xae,
	0x04,
	0x78,
	0x02,
	0xc3,
	0x33,
	0xce,
	0x33,
	0xce,
	0xd8,
	0xf9,
	0xff,
	0x24,
	0x01,
	0xfb,
	0xee,
	0x34,
	0x60,
	0x8b,
	0x82,
	0xf5,
	0x83,
	0xe5,
	0x12,
	0xf0,
	0xef,
	0x24,
	0x02,
	0xff,
	0xee,
	0x34,
	0x60,
	0x8f,
	0x82,
	0xf5,
	0x83,
	0xe5,
	0x14,
	0xf0,
	0xed,
	0xae,
	0x04,
	0x78,
	0x02,
	0xc3,
	0x33,
	0xce,
	0x33,
	0xce,
	0xd8,
	0xf9,
	0xff,
	0x24,
	0x03,
	0xfd,
	0xee,
	0x34,
	0x60,
	0x8d,
	0x82,
	0xf5,
	0x83,
	0xe5,
	0x13,
	0xf0,
	0xef,
	0x24,
	0x04,
	0xff,
	0xee,
	0x34,
	0x60,
	0x8f,
	0x82,
	0xf5,
	0x83,
	0xe5,
	0x15,
	0xf0,
	0x15,
	0x16,
	0xc3,
	0xe5,
	0x16,
	0x64,
	0x80,
	0x94,
	0x80,
	0x40,
	0x03,
	0x02,
	0x07,
	0x38,
	0xc2,
	0x30,
	0x22,
	0xe8,
	0x8f,
	0xf0,
	0xa4,
	0xcc,
	0x8b,
	0xf0,
	0xa4,
	0x2c,
	0xfc,
	0xe9,
	0x8e,
	0xf0,
	0xa4,
	0x2c,
	0xfc,
	0x8a,
	0xf0,
	0xed,
	0xa4,
	0x2c,
	0xfc,
	0xea,
	0x8e,
	0xf0,
	0xa4,
	0xcd,
	0xa8,
	0xf0,
	0x8b,
	0xf0,
	0xa4,
	0x2d,
	0xcc,
	0x38,
	0x25,
	0xf0,
	0xfd,
	0xe9,
	0x8f,
	0xf0,
	0xa4,
	0x2c,
	0xcd,
	0x35,
	0xf0,
	0xfc,
	0xeb,
	0x8e,
	0xf0,
	0xa4,
	0xfe,
	0xa9,
	0xf0,
	0xeb,
	0x8f,
	0xf0,
	0xa4,
	0xcf,
	0xc5,
	0xf0,
	0x2e,
	0xcd,
	0x39,
	0xfe,
	0xe4,
	0x3c,
	0xfc,
	0xea,
	0xa4,
	0x2d,
	0xce,
	0x35,
	0xf0,
	0xfd,
	0xe4,
	0x3c,
	0xfc,
	0x22,
	0x75,
	0xf0,
	0x08,
	0x75,
	0x82,
	0x00,
	0xef,
	0x2f,
	0xff,
	0xee,
	0x33,
	0xfe,
	0xcd,
	0x33,
	0xcd,
	0xcc,
	0x33,
	0xcc,
	0xc5,
	0x82,
	0x33,
	0xc5,
	0x82,
	0x9b,
	0xed,
	0x9a,
	0xec,
	0x99,
	0xe5,
	0x82,
	0x98,
	0x40,
	0x0c,
	0xf5,
	0x82,

	0x89,
	0x00,
	0xee,			
	0x9b,
	0xfe,
	0xed,
	0x9a,
	0xfd,
	0xec,
	0x99,
	0xfc,
	0x0f,
	0xd5,
	0xf0,
	0xd6,
	0xe4,
	0xce,
	0xfb,
	0xe4,
	0xcd,
	0xfa,
	0xe4,
	0xcc,
	0xf9,
	0xa8,
	0x82,
	0x22,
	0xb8,
	0x00,
	0xc1,
	0xb9,
	0x00,
	0x59,
	0xba,
	0x00,
	0x2d,
	0xec,
	0x8b,
	0xf0,
	0x84,
	0xcf,
	0xce,
	0xcd,
	0xfc,
	0xe5,
	0xf0,
	0xcb,
	0xf9,
	0x78,
	0x18,
	0xef,
	0x2f,
	0xff,
	0xee,
	0x33,
	0xfe,
	0xed,
	0x33,
	0xfd,
	0xec,
	0x33,
	0xfc,
	0xeb,
	0x33,
	0xfb,
	0x10,
	0xd7,
	0x03,
	0x99,
	0x40,
	0x04,
	0xeb,
	0x99,
	0xfb,
	0x0f,
	0xd8,
	0xe5,
	0xe4,
	0xf9,
	0xfa,
	0x22,
	0x78,
	0x18,
	0xef,
	0x2f,
	0xff,
	0xee,
	0x33,
	0xfe,
	0xed,
	0x33,
	0xfd,
	0xec,
	0x33,
	0xfc,
	0xc9,
	0x33,
	0xc9,
	0x10,
	0xd7,
	0x05,
	0x9b,
	0xe9,
	0x9a,
	0x40,
	0x07,
	0xec,
	0x9b,
	0xfc,
	0xe9,
	0x9a,
	0xf9,
	0x0f,
	0xd8,
	0xe0,
	0xe4,
	0xc9,
	0xfa,
	0xe4,
	0xcc,
	0xfb,
	0x22,
	0x75,
	0xf0,
	0x10,
	0xef,
	0x2f,
	0xff,
	0xee,
	0x33,
	0xfe,
	0xed,
	0x33,
	0xfd,
	0xcc,
	0x33,
	0xcc,
	0xc8,
	0x33,
	0xc8,
	0x10,
	0xd7,
	0x07,
	0x9b,
	0xec,
	0x9a,
	0xe8,
	0x99,
	0x40,
	0x0a,
	0xed,
	0x9b,
	0xfd,
	0xec,
	0x9a,
	0xfc,
	0xe8,
	0x99,
	0xf8,
	0x0f,
	0xd5,
	0xf0,
	0xda,
	0xe4,
	0xcd,
	0xfb,
	0xe4,
	0xcc,
	0xfa,
	0xe4,
	0xc8,
	0xf9,
	0x22,
	0xe8,
	0x60,
	0x0f,
	0xec,
	0xc3,
	0x13,
	0xfc,
	0xed,
	0x13,
	0xfd,
	0xee,
	0x13,
	0xfe,
	0xef,
	0x13,
	0xff,
	0xd8,
	0xf1,
	0x22,
	0xe8,
	0x60,
	0x0f,
	0xef,
	0xc3,
	0x33,
	0xff,
	0xee,
	0x33,
	0xfe,
	0xed,
	0x33,
	0xfd,
	0xec,
	0x33,
	0xfc,
	0xd8,
	0xf1,
	0x22,
	0xe4,
	0x93,
	0xfc,
	0x74,
	0x01,
	0x93,
	0xfd,
	0x74,
	0x02,
	0x93,
	0xfe,
	0x74,
	0x03,
	0x93,
	0xff,
	0x22,
	0xa4,
	0x25,
	0x82,
	0xf5,
	0x82,
	0xe5,
	0xf0,
	0x35,
	0x83,
	0xf5,
	0x83,
	0x22,
	0xd0,
	0x83,
	0xd0,
	0x82,
	0xf8,
	0xe4,
	0x93,
	0x70,
	0x12,
	0x74,
	0x01,
	0x93,
	0x70,
	0x0d,
	0xa3,
	0xa3,
	0x93,
	0xf8,
	0x74,

	0x8a,
	0x00,
	0x01,			
	0x93,
	0xf5,
	0x82,
	0x88,
	0x83,
	0xe4,
	0x73,
	0x74,
	0x02,
	0x93,
	0x68,
	0x60,
	0xef,
	0xa3,
	0xa3,
	0xa3,
	0x80,
	0xdf,
	0x75,
	0x0f,
	0x0a,
	0xa2,
	0xaf,
	0x92,
	0x32,
	0xc2,
	0xaf,
	0xc2,
	0x33,
	0x12,
	0x01,
	0x6a,
	0x12,
	0x02,
	0x12,
	0x12,
	0x01,
	0x6a,
	0x75,
	0x51,
	0x05,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0xd2,
	0x28,
	0x12,
	0x01,
	0x6c,
	0x75,
	0x51,
	0x0a,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0xc2,
	0x29,
	0x12,
	0x01,
	0x6c,
	0x75,
	0x51,
	0x05,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0xc2,
	0x28,
	0x12,
	0x01,
	0x6c,
	0x75,
	0x51,
	0x05,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0x75,
	0x10,
	0x18,
	0x12,
	0x0b,
	0x53,
	0x75,
	0x51,
	0x0a,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0xd2,
	0x28,
	0x12,
	0x01,
	0x6c,
	0x12,
	0x02,
	0x2f,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0xc2,
	0x28,
	0x12,
	0x01,
	0x6c,
	0x75,
	0x51,
	0x0a,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0x30,
	0x11,
	0x03,
	0x02,
	0x0b,
	0x0a,
	0x12,
	0x01,
	0x6a,
	0x12,
	0x02,
	0x12,
	0xe5,
	0x0d,
	0xf5,
	0x10,
	0x12,
	0x0b,
	0x53,
	0x75,
	0x51,
	0x0a,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0xd2,
	0x28,
	0x12,
	0x01,
	0x6c,
	0x12,
	0x02,
	0x2f,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0xc2,
	0x28,
	0x12,
	0x01,
	0x6c,
	0x75,
	0x51,
	0x0a,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0x30,
	0x11,
	0x04,
	0x15,
	0x0f,
	0x80,
	0x45,
	0x12,
	0x01,
	0x6a,
	0x12,
	0x02,
	0x12,
	0x85,
	0x0e,
	0x10,
	0x12,
	0x13,
	0x71,
	0xc2,
	0x09,
	0x12,
	0x02,
	0x14,
	0x75,
	0x51,
	0x0a,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0xd2,
	0x28,
	0x12,
	0x01,
	0x6c,
	0x12,
	0x02,
	0x2f,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0xc2,
	0x28,
	0x12,
	0x01,
	0x6c,
	0x75,
	0x51,
	0x0a,

	0x8b,
	0x00,
	0xaf,			
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0x30,
	0x11,
	0x06,
	0x15,
	0x0f,
	0xd2,
	0x33,
	0x80,
	0x03,
	0xe4,
	0xf5,
	0x0f,
	0x12,
	0x01,
	0x6a,
	0x12,
	0x02,
	0x12,
	0xc2,
	0x29,
	0x12,
	0x01,
	0x6c,
	0x75,
	0x51,
	0x05,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0xd2,
	0x28,
	0x12,
	0x01,
	0x6c,
	0x75,
	0x51,
	0x05,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0x12,
	0x01,
	0x6a,
	0x75,
	0x51,
	0x05,
	0xaf,
	0x51,
	0x15,
	0x51,
	0xef,
	0x70,
	0xf9,
	0xa2,
	0x32,
	0x92,
	0xaf,
	0xe5,
	0x0f,
	0xd3,
	0x94,
	0x00,
	0x40,
	0x03,
	0x02,
	0x0a,
	0x1a,
	0x22,
	0x12,
	0x13,
	0x71,
	0xc2,
	0x09,
	0x90,
	0x30,
	0x18,
	0xe5,
	0x21,
	0xf0,
	0x22,
	0xc0,
	0xe0,
	0xc0,
	0xf0,
	0xc0,
	0x83,
	0xc0,
	0x82,
	0xc0,
	0xd0,
	0x75,
	0xd0,
	0x00,
	0xc0,
	0x00,
	0xc0,
	0x01,
	0xc0,
	0x02,
	0xc0,
	0x03,
	0xc0,
	0x04,
	0xc0,
	0x05,
	0xc0,
	0x06,
	0xc0,
	0x07,
	0x90,
	0x3f,
	0x0c,
	0xe0,
	0xf5,
	0x08,
	0xe5,
	0x08,
	0x20,
	0xe3,
	0x03,
	0x02,
	0x0c,
	0x10,
	0x30,
	0x35,
	0x03,
	0x02,
	0x0c,
	0x10,
	0x90,
	0x60,
	0x16,
	0xe0,
	0xf5,
	0x6a,
	0xa3,
	0xe0,
	0xf5,
	0x6b,
	0x90,
	0x60,
	0x1e,
	0xe0,
	0xf5,
	0x6c,
	0xa3,
	0xe0,
	0xf5,
	0x6d,
	0x90,
	0x60,
	0x26,
	0xe0,
	0xf5,
	0x6e,
	0xa3,
	0xe0,
	0xf5,
	0x6f,
	0x90,
	0x60,
	0x2e,
	0xe0,
	0xf5,
	0x70,
	0xa3,
	0xe0,
	0xf5,
	0x71,
	0x90,
	0x60,
	0x36,
	0x12,
	0x00,
	0x16,
	0x12,
	0x01,
	0xd2,
	0x40,
	0x06,
	0x75,
	0x2a,
	0xff,
	0x75,
	0x2b,
	0xff,
	0x85,
	0x2a,
	0x74,
	0x85,
	0x2b,
	0x75,
	0x90,
	0x60,
	0x1a,
	0xe0,
	0xf5,
	0x6a,
	0xa3,
	0xe0,
	0xf5,
	0x6b,
	0x90,
	0x60,
	0x22,
	0xe0,
	0xf5,
	0x6c,
	0xa3,
	0xe0,
	0xf5,
	0x6d,
	0x90,
	0x60,
	0x2a,
	0xe0,
	0xf5,
	0x6e,
	0xa3,
	0xe0,
	0xf5,
	0x6f,
	0x90,
	0x60,
	0x32,
	0xe0,
	0xf5,
	0x70,
	0xa3,
	0xe0,
	0xf5,
	0x71,
	0x90,
	0x60,
	0x3a,
	0x12,
	0x00,
	0x16,
	0x12,
	0x01,
	0xd2,

	0x8c,
	0x00,
	0x40,			
	0x06,
	0x75,
	0x2a,
	0xff,
	0x75,
	0x2b,
	0xff,
	0x85,
	0x2a,
	0x76,
	0x85,
	0x2b,
	0x77,
	0xd2,
	0x3b,
	0xe5,
	0x08,
	0x30,
	0xe5,
	0x41,
	0x90,
	0x56,
	0x90,
	0xe0,
	0xf5,
	0x55,
	0xe5,
	0x7b,
	0x12,
	0x01,
	0xcb,
	0xad,
	0x55,
	0xc3,
	0xef,
	0x9d,
	0x74,
	0x80,
	0xf8,
	0x6e,
	0x98,
	0x50,
	0x02,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x27,
	0xaf,
	0x55,
	0xef,
	0x24,
	0x01,
	0xff,
	0xe4,
	0x33,
	0xfe,
	0xc3,
	0xef,
	0x95,
	0x7b,
	0x74,
	0x80,
	0xf8,
	0x6e,
	0x98,
	0x50,
	0x02,
	0x80,
	0x02,
	0xa2,
	0x27,
	0x92,
	0x27,
	0x30,
	0x27,
	0x04,
	0xaf,
	0x55,
	0x80,
	0x02,
	0xaf,
	0x7b,
	0x8f,
	0x7b,
	0xe5,
	0x08,
	0x30,
	0xe1,
	0x08,
	0x90,
	0x30,
	0x24,
	0xe0,
	0xf5,
	0x33,
	0xe4,
	0xf0,
	0x90,
	0x3f,
	0x0c,
	0xe5,
	0x08,
	0xf0,
	0xd0,
	0x07,
	0xd0,
	0x06,
	0xd0,
	0x05,
	0xd0,
	0x04,
	0xd0,
	0x03,
	0xd0,
	0x02,
	0xd0,
	0x01,
	0xd0,
	0x00,
	0xd0,
	0xd0,
	0xd0,
	0x82,
	0xd0,
	0x83,
	0xd0,
	0xf0,
	0xd0,
	0xe0,
	0x32,
	0xe5,
	0x33,
	0x70,
	0x03,
	0x02,
	0x0d,
	0x91,
	0xc2,
	0xaf,
	0xaf,
	0x33,
	0xe4,
	0xf5,
	0x33,
	0xd2,
	0xaf,
	0x90,
	0x30,
	0x25,
	0xe0,
	0xf5,
	0x7e,
	0x90,
	0x50,
	0x82,
	0xe0,
	0xf5,
	0x66,
	0xa3,
	0xe0,
	0xf5,
	0x67,
	0xa3,
	0xe0,
	0xf5,
	0x68,
	0xa3,
	0xe0,
	0xf5,
	0x69,
	0xef,
	0x12,
	0x09,
	0xed,
	0x0c,
	0xd5,
	0x03,
	0x0c,
	0xea,
	0x05,
	0x0d,
	0x14,
	0x06,
	0x0d,
	0x02,
	0x08,
	0x0d,
	0x21,
	0x10,
	0x0d,
	0x35,
	0x12,
	0x0d,
	0x3a,
	0x20,
	0x0d,
	0x48,
	0x21,
	0x0d,
	0x4d,
	0x30,
	0x0d,
	0x76,
	0x50,
	0x0d,
	0x58,
	0xd8,
	0x00,
	0x00,
	0x0d,
	0x83,
	0x20,
	0x05,
	0x03,
	0x02,
	0x0d,
	0x83,
	0x30,
	0x00,
	0x03,
	0x02,
	0x0d,
	0x83,
	0xd2,
	0x07,
	0xc2,
	0x06,
	0x12,
	0x02,
	0x8a,
	0x80,
	0x24,
	0x20,
	0x05,
	0x03,
	0x02,
	0x0d,
	0x83,
	0x30,
	0x00,
	0x03,
	0x02,
	0x0d,
	0x83,
	0xc2,
	0x07,
	0xd2,
	0x06,
	0x12,
	0x02,
	0x9b,
	0xc2,
	0x04,
	0x02,

	0x8d,
	0x00,
	0x0d,			
	0x83,
	0x12,
	0x02,
	0x51,
	0x30,
	0x05,
	0x06,
	0xe4,
	0xf5,
	0x0c,
	0x12,
	0x11,
	0xd8,
	0xc2,
	0x31,
	0xd2,
	0x34,
	0x80,
	0x6f,
	0x30,
	0x07,
	0x6c,
	0x30,
	0x06,
	0x69,
	0x12,
	0x02,
	0x8a,
	0xd2,
	0x31,
	0x80,
	0x62,
	0x20,
	0x07,
	0x03,
	0x30,
	0x06,
	0x09,
	0xe5,
	0x7e,
	0x64,
	0x0e,
	0x70,
	0x56,
	0x20,
	0x00,
	0x53,
	0x12,
	0x05,
	0x25,
	0x80,
	0x4e,
	0x12,
	0x06,
	0xee,
	0x80,
	0x49,
	0x30,
	0x05,
	0x46,
	0x20,
	0x07,
	0x43,
	0x20,
	0x06,
	0x40,
	0x12,
	0x15,
	0x4b,
	0x80,
	0x3b,
	0x12,
	0x10,
	0x3e,
	0x80,
	0x36,
	0x20,
	0x07,
	0x33,
	0x20,
	0x06,
	0x30,
	0x12,
	0x15,
	0x5a,
	0x80,
	0x2b,
	0xe5,
	0x7e,
	0x64,
	0x01,
	0x70,
	0x25,
	0xd2,
	0x35,
	0x90,
	0x50,
	0x82,
	0xe5,
	0x74,
	0xf0,
	0xa3,
	0xe5,
	0x75,
	0xf0,
	0xa3,
	0xe5,
	0x76,
	0xf0,
	0xa3,
	0xe5,
	0x77,
	0xf0,
	0xc2,
	0x35,
	0x80,
	0x0d,
	0x90,
	0x50,
	0x82,
	0x30,
	0x33,
	0x05,
	0x74,
	0x55,
	0xf0,
	0x80,
	0x02,
	0xe4,
	0xf0,
	0x20,
	0x07,
	0x06,
	0x30,
	0x06,
	0x03,
	0x30,
	0x04,
	0x05,
	0x90,
	0x30,
	0x25,
	0xe4,
	0xf0,
	0x22,
	0x30,
	0x04,
	0x03,
	0x02,
	0x0e,
	0x72,
	0xd2,
	0x04,
	0xe5,
	0x7e,
	0xb4,
	0x01,
	0x06,
	0x12,
	0x15,
	0x2b,
	0x02,
	0x0e,
	0x6b,
	0xe5,
	0x7e,
	0xb4,
	0x02,
	0x06,
	0x12,
	0x15,
	0x3c,
	0x02,
	0x0e,
	0x6b,
	0xe5,
	0x7e,
	0xb4,
	0x03,
	0x05,
	0xe4,
	0xf5,
	0x0c,
	0x80,
	0x08,
	0xe5,
	0x7e,
	0xb4,
	0x04,
	0x09,
	0x85,
	0x7c,
	0x0c,
	0x12,
	0x11,
	0xd8,
	0x02,
	0x0e,
	0x6b,
	0xe5,
	0x7e,
	0x64,
	0x0f,
	0x70,
	0x15,
	0x12,
	0x02,
	0xa9,
	0x40,
	0x06,
	0x7e,
	0x03,
	0x7f,
	0xff,
	0x80,
	0x04,
	0xae,
	0x68,
	0xaf,
	0x69,
	0x12,
	0x0e,
	0x73,
	0x02,
	0x0e,
	0x6b,
	0xe5,
	0x7e,
	0x64,
	0x10,
	0x60,
	0x03,
	0x02,
	0x0e,
	0x6b,
	0xf5,
	0x66,
	0xf5,
	0x67,
	0xf5,
	0x68,
	0xab,
	0x69,
	0xaa,
	0x68,
	0xa9,
	0x67,
	0xa8,
	0x66,
	0x12,
	0x01,
	0x73,
	0xfe,
	0xe4,
	0xfc,

	0x8e,
	0x00,
	0xfd,			
	0x12,
	0x01,
	0xf1,
	0xe4,
	0x7b,
	0xff,
	0xfa,
	0xf9,
	0xf8,
	0x12,
	0x02,
	0x67,
	0x12,
	0x02,
	0x39,
	0xe4,
	0x93,
	0xfe,
	0x74,
	0x01,
	0x93,
	0xff,
	0xe4,
	0xfc,
	0xfd,
	0xe5,
	0x69,
	0x2f,
	0xf5,
	0x69,
	0xe5,
	0x68,
	0x3e,
	0xf5,
	0x68,
	0xed,
	0x35,
	0x67,
	0xf5,
	0x67,
	0xec,
	0x35,
	0x66,
	0xf5,
	0x66,
	0x12,
	0x02,
	0xa9,
	0x40,
	0x06,
	0x7e,
	0x03,
	0x7f,
	0xff,
	0x80,
	0x04,
	0xae,
	0x68,
	0xaf,
	0x69,
	0x12,
	0x0e,
	0x73,
	0xe4,
	0xf5,
	0x67,
	0xf5,
	0x67,
	0xe5,
	0x67,
	0xd3,
	0x95,
	0x7c,
	0x50,
	0x1c,
	0x12,
	0x02,
	0x39,
	0xaf,
	0x67,
	0x75,
	0xf0,
	0x02,
	0xef,
	0x12,
	0x09,
	0xe1,
	0xc3,
	0x74,
	0x01,
	0x93,
	0x95,
	0x69,
	0xe4,
	0x93,
	0x95,
	0x68,
	0x50,
	0x04,
	0x05,
	0x67,
	0x80,
	0xdd,
	0x85,
	0x67,
	0x7d,
	0x90,
	0x30,
	0x25,
	0xe4,
	0xf0,
	0xd2,
	0x34,
	0x22,
	0x8e,
	0x68,
	0x8f,
	0x69,
	0x85,
	0x68,
	0x64,
	0x85,
	0x69,
	0x65,
	0xe5,
	0x69,
	0xc4,
	0xf8,
	0x54,
	0x0f,
	0xc8,
	0x68,
	0xf5,
	0x69,
	0xe5,
	0x68,
	0xc4,
	0x54,
	0xf0,
	0x48,
	0xf5,
	0x68,
	0x85,
	0x68,
	0x0d,
	0x85,
	0x69,
	0x0e,
	0x12,
	0x0a,
	0x13,
	0x22,
	0x12,
	0x02,
	0x7f,
	0xb5,
	0x07,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x40,
	0x03,
	0x02,
	0x0f,
	0x38,
	0x90,
	0x30,
	0x04,
	0xe0,
	0x44,
	0x20,
	0xf0,
	0xa3,
	0xe0,
	0x44,
	0x40,
	0xf0,
	0x90,
	0x50,
	0x25,
	0xe0,
	0x44,
	0x04,
	0xf0,
	0x90,
	0x50,
	0x03,
	0xe0,
	0x54,
	0xfd,
	0xf0,
	0x90,
	0x50,
	0x27,
	0xe0,
	0x44,
	0x01,
	0xf0,
	0x90,
	0x50,
	0x31,
	0xe4,
	0xf0,
	0x90,
	0x50,
	0x33,
	0xf0,
	0x90,
	0x30,
	0x1e,
	0x12,
	0x02,
	0x05,
	0x90,
	0x30,
	0x18,
	0x12,
	0x02,
	0x05,
	0x90,
	0x30,
	0x1b,
	0x12,
	0x02,
	0x05,
	0xe0,
	0xf5,
	0x25,
	0x90,
	0x30,
	0x18,
	0xe0,
	0xf5,
	0x21,
	0x90,
	0x60,
	0x00,
	0x74,
	0xf5,
	0xf0,
	0x90,
	0x3f,
	0x01,
	0xe4,
	0xf0,
	0xa3,
	0xf0,
	0x90,
	0x3f,
	0x01,
	0xe0,
	0x44,
	0x08,

	0x8f,
	0x00,
	0xf0,			
	0xe0,
	0x44,
	0x20,
	0xf0,
	0x90,
	0x3f,
	0x05,
	0x74,
	0x30,
	0xf0,
	0xa3,
	0x74,
	0x24,
	0xf0,
	0x90,
	0x3f,
	0x0b,
	0xe0,
	0x44,
	0x0f,
	0xf0,
	0x90,
	0x3f,
	0x01,
	0xe0,
	0x44,
	0x02,
	0xf0,
	0xc2,
	0x8c,
	0x75,
	0x89,
	0x03,
	0x75,
	0xa8,
	0x07,
	0x75,
	0xb8,
	0x04,
	0xe4,
	0xf5,
	0xd8,
	0xf5,
	0xe8,
	0x90,
	0x30,
	0x01,
	0xe0,
	0x44,
	0x40,
	0xf0,
	0xe0,
	0x54,
	0xbf,
	0xf0,
	0x22,
	0x30,
	0x3c,
	0x09,
	0x30,
	0x20,
	0x06,
	0xae,
	0x56,
	0xaf,
	0x57,
	0x80,
	0x04,
	0xae,
	0x6a,
	0xaf,
	0x6b,
	0x8e,
	0x56,
	0x8f,
	0x57,
	0x30,
	0x3c,
	0x09,
	0x30,
	0x21,
	0x06,
	0xae,
	0x58,
	0xaf,
	0x59,
	0x80,
	0x04,
	0xae,
	0x6c,
	0xaf,
	0x6d,
	0x8e,
	0x58,
	0x8f,
	0x59,
	0x30,
	0x3c,
	0x09,
	0x30,
	0x22,
	0x06,
	0xae,
	0x5a,
	0xaf,
	0x5b,
	0x80,
	0x04,
	0xae,
	0x6e,
	0xaf,
	0x6f,
	0x8e,
	0x5a,
	0x8f,
	0x5b,
	0x30,
	0x3c,
	0x09,
	0x30,
	0x23,
	0x06,
	0xae,
	0x5c,
	0xaf,
	0x5d,
	0x80,
	0x04,
	0xae,
	0x70,
	0xaf,
	0x71,
	0x8e,
	0x5c,
	0x8f,
	0x5d,
	0x30,
	0x3c,
	0x09,
	0x30,
	0x24,
	0x06,
	0xae,
	0x5e,
	0xaf,
	0x5f,
	0x80,
	0x04,
	0xae,
	0x72,
	0xaf,
	0x73,
	0x8e,
	0x5e,
	0x8f,
	0x5f,
	0x30,
	0x3c,
	0x09,
	0x30,
	0x25,
	0x06,
	0xae,
	0x60,
	0xaf,
	0x61,
	0x80,
	0x04,
	0xae,
	0x74,
	0xaf,
	0x75,
	0x8e,
	0x60,
	0x8f,
	0x61,
	0x30,
	0x3c,
	0x09,
	0x30,
	0x26,
	0x06,
	0xae,
	0x62,
	0xaf,
	0x63,
	0x80,
	0x04,
	0xae,
	0x76,
	0xaf,
	0x77,
	0x8e,
	0x62,
	0x8f,
	0x63,
	0x22,
	0xd3,
	0xe5,
	0x57,
	0x95,
	0x6b,
	0xe5,
	0x56,
	0x95,
	0x6a,
	0x40,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x20,
	0xd3,
	0xe5,
	0x59,
	0x95,
	0x6d,
	0xe5,
	0x58,
	0x95,
	0x6c,
	0x40,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x21,
	0xd3,
	0xe5,
	0x5b,
	0x95,
	0x6f,
	0xe5,
	0x5a,
	0x95,
	0x6e,
	0x40,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x22,
	0xd3,
	0xe5,
	0x5d,
	0x95,
	0x71,
	0xe5,
	0x5c,

	0x90,
	0x00,
	0x95,			
	0x70,
	0x40,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x23,
	0xd3,
	0xe5,
	0x5f,
	0x95,
	0x73,
	0xe5,
	0x5e,
	0x95,
	0x72,
	0x40,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x24,
	0xd3,
	0xe5,
	0x61,
	0x95,
	0x75,
	0xe5,
	0x60,
	0x95,
	0x74,
	0x40,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x25,
	0xd3,
	0xe5,
	0x63,
	0x95,
	0x77,
	0xe5,
	0x62,
	0x95,
	0x76,
	0x40,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x92,
	0x26,
	0x22,
	0xe5,
	0x7e,
	0x64,
	0x01,
	0x70,
	0x50,
	0x12,
	0x02,
	0x39,
	0xe5,
	0x7d,
	0x12,
	0x01,
	0x7b,
	0xfe,
	0xe4,
	0x8f,
	0x69,
	0x8e,
	0x68,
	0xf5,
	0x67,
	0xf5,
	0x66,
	0x12,
	0x01,
	0xfc,
	0x7b,
	0xff,
	0xfa,
	0xf9,
	0xf8,
	0x12,
	0x01,
	0xf1,
	0xc0,
	0x04,
	0xc0,
	0x05,
	0xc0,
	0x06,
	0xc0,
	0x07,
	0x12,
	0x01,
	0x73,
	0xab,
	0x07,
	0xfa,
	0xe4,
	0xf9,
	0xf8,
	0xd0,
	0x07,
	0xd0,
	0x06,
	0xd0,
	0x05,
	0xd0,
	0x04,
	0x12,
	0x02,
	0x67,
	0x85,
	0x69,
	0x66,
	0x85,
	0x7d,
	0x67,
	0x12,
	0x02,
	0x39,
	0xe5,
	0x7d,
	0x12,
	0x02,
	0x95,
	0xe4,
	0x93,
	0xf5,
	0x68,
	0x74,
	0x01,
	0x93,
	0xf5,
	0x69,
	0x90,
	0x50,
	0x82,
	0xe5,
	0x66,
	0xf0,
	0xa3,
	0xe5,
	0x67,
	0xf0,
	0xa3,
	0xe5,
	0x68,
	0xf0,
	0xa3,
	0xe5,
	0x69,
	0xf0,
	0x22,
	0x56,
	0x0c,
	0x04,
	0x00,
	0x00,
	0x00,
	0xc8,
	0x01,
	0x2c,
	0x01,
	0x5e,
	0x01,
	0x8b,
	0x01,
	0xb8,
	0x01,
	0xe5,
	0x02,
	0x12,
	0x02,
	0x3f,
	0x02,
	0x6c,
	0x02,
	0x99,
	0x02,
	0xc6,
	0x02,
	0xf3,
	0x07,
	0x20,
	0x12,
	0x28,
	0x1e,
	0x18,
	0x18,
	0x28,
	0x1e,
	0x18,
	0x12,
	0x28,
	0x1e,
	0x18,
	0x12,
	0x28,
	0x18,
	0x18,
	0x12,
	0x20,
	0x18,
	0x28,
	0x1c,
	0x30,
	0x24,
	0x10,
	0x1c,
	0x18,
	0x24,
	0x1c,
	0x14,
	0x24,
	0x1c,
	0x28,
	0x0c,
	0x30,
	0x14,
	0x10,
	0x0c,
	0x18,
	0x14,
	0x1c,
	0x20,
	0x24,
	0x28,
	0x0c,
	0x14,
	0x14,
	0x1c,
	0x1c,
	0x14,
	0x24,
	0x1c,
	0x2c,
	0x14,
	0x34,
	0x1c,
	0x1c,
	0x08,
	0x24,

	0x91,
	0x00,
	0x10,			
	0x19,
	0x19,
	0x1c,
	0x19,
	0x19,
	0x10,
	0x10,
	0x10,
	0x10,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xe5,
	0x0a,
	0x70,
	0x04,
	0x7a,
	0x10,
	0x7b,
	0xc5,
	0xe5,
	0x0a,
	0xb4,
	0x01,
	0x04,
	0x7a,
	0x10,
	0x7b,
	0xd9,
	0xe5,
	0x0a,
	0xb4,
	0x02,
	0x04,
	0x7a,
	0x10,
	0x7b,
	0xed,
	0x8b,
	0x82,
	0x8a,
	0x83,
	0x12,
	0x09,
	0xd1,
	0x8f,
	0x37,
	0x8e,
	0x36,
	0x8d,
	0x35,
	0x8c,
	0x34,
	0xe5,
	0x82,
	0x24,
	0x04,
	0xf5,
	0x82,
	0xe4,
	0x35,
	0x83,
	0xf5,
	0x83,
	0x12,
	0x09,
	0xd1,
	0x8f,
	0x3b,
	0x8e,
	0x3a,
	0x8d,
	0x39,
	0x8c,
	0x38,
	0xeb,
	0x24,
	0x08,
	0x12,
	0x02,
	0x40,
	0x12,
	0x01,
	0xc0,
	0xeb,
	0x24,
	0x0c,
	0x12,
	0x02,
	0x40,
	0x8f,
	0x43,
	0x8e,
	0x42,
	0x8d,
	0x41,
	0x8c,
	0x40,
	0xeb,
	0x24,
	0x10,
	0x12,
	0x02,
	0x40,
	0x8f,
	0x47,
	0x8e,
	0x46,
	0x8d,
	0x45,
	0x8c,
	0x44,
	0x22,
	0x30,
	0x3c,
	0x07,
	0x30,
	0x20,
	0x04,
	0xaf,
	0x4a,
	0x80,
	0x02,
	0xaf,
	0x7d,
	0x8f,
	0x4a,
	0x30,
	0x3c,
	0x07,
	0x30,
	0x21,
	0x04,
	0xaf,
	0x4b,
	0x80,
	0x02,
	0xaf,
	0x7d,
	0x8f,
	0x4b,
	0x30,
	0x3c,
	0x07,
	0x30,
	0x22,
	0x04,
	0xaf,
	0x4c,
	0x80,
	0x02,
	0xaf,
	0x7d,
	0x8f,
	0x4c,
	0x30,
	0x3c,
	0x07,
	0x30,
	0x23,
	0x04,
	0xaf,
	0x4d,
	0x80,
	0x02,
	0xaf,
	0x7d,
	0x8f,
	0x4d,
	0x30,
	0x3c,
	0x07,
	0x30,
	0x24,
	0x04,
	0xaf,
	0x4e,
	0x80,
	0x02,
	0xaf,
	0x7d,
	0x8f,
	0x4e,
	0x30,
	0x3c,
	0x07,
	0x30,
	0x25,
	0x04,
	0xaf,
	0x4f,
	0x80,
	0x02,
	0xaf,
	0x7d,
	0x8f,
	0x4f,
	0x30,
	0x3c,
	0x07,
	0x30,
	0x26,
	0x04,
	0xaf,
	0x50,
	0x80,
	0x02,
	0xaf,
	0x7d,
	0x8f,
	0x50,
	0x22,
	0xe5,
	0x0c,
	0xd3,
	0x95,
	0x7c,
	0x40,
	0x01,
	0x22,
	0x12,
	0x02,
	0x39,
	0xe5,
	0x0c,
	0x12,
	0x02,
	0x95,
	0xe4,
	0x93,
	0xfe,
	0x74,
	0x01,
	0x93,
	0xff,
	0x4e,
	0x60,
	0x21,
	0x8e,
	0x64,
	0x8f,
	0x65,
	0xef,
	0xc4,
	0xf8,
	0x54,
	0x0f,
	0xc8,
	0x68,
	0xff,
	0xee,
	0xc4,

	0x92,
	0x00,
	0x54,			
	0xf0,
	0x48,
	0xfe,
	0x43,
	0x07,
	0x0d,
	0x8e,
	0x0d,
	0x8f,
	0x0e,
	0x12,
	0x0a,
	0x13,
	0x30,
	0x33,
	0x22,
	0xc3,
	0x22,
	0x75,
	0x0d,
	0x00,
	0x75,
	0x0e,
	0x0d,
	0x12,
	0x0a,
	0x13,
	0x30,
	0x33,
	0x02,
	0xc3,
	0x22,
	0x75,
	0x0d,
	0x00,
	0x75,
	0x0e,
	0x64,
	0x12,
	0x14,
	0xcc,
	0x75,
	0x0d,
	0x80,
	0x75,
	0x0e,
	0x00,
	0x12,
	0x0a,
	0x13,
	0x85,
	0x0c,
	0x7d,
	0xd3,
	0x22,
	0xc2,
	0x34,
	0x20,
	0x05,
	0x05,
	0x75,
	0x0a,
	0xee,
	0x80,
	0x36,
	0x20,
	0x07,
	0x08,
	0x20,
	0x06,
	0x05,
	0xe4,
	0xf5,
	0x0a,
	0x80,
	0x2b,
	0x20,
	0x07,
	0x08,
	0x30,
	0x06,
	0x05,
	0x75,
	0x0a,
	0x20,
	0x80,
	0x20,
	0x30,
	0x00,
	0x05,
	0x75,
	0x0a,
	0x01,
	0x80,
	0x18,
	0xe5,
	0x20,
	0x54,
	0x07,
	0xff,
	0xbf,
	0x06,
	0x0d,
	0x30,
	0x31,
	0x04,
	0x7f,
	0x12,
	0x80,
	0x02,
	0x7f,
	0x02,
	0x8f,
	0x0a,
	0x80,
	0x03,
	0x75,
	0x0a,
	0xfe,
	0x90,
	0x30,
	0x27,
	0xe5,
	0x0a,
	0xf0,
	0xe5,
	0x23,
	0x54,
	0xf8,
	0xf5,
	0x0a,
	0xe5,
	0x79,
	0x25,
	0x0a,
	0xf5,
	0x0a,
	0x90,
	0x30,
	0x26,
	0xe5,
	0x0a,
	0xf0,
	0x22,
	0xe5,
	0x0a,
	0x70,
	0x04,
	0x7e,
	0x11,
	0x7f,
	0x01,
	0xe5,
	0x0a,
	0xb4,
	0x01,
	0x04,
	0x7e,
	0x11,
	0x7f,
	0x06,
	0xe5,
	0x0a,
	0xb4,
	0x02,
	0x04,
	0x7e,
	0x11,
	0x7f,
	0x0b,
	0x8f,
	0x82,
	0x8e,
	0x83,
	0xe4,
	0x93,
	0xf5,
	0x2c,
	0x74,
	0x01,
	0x93,
	0xf5,
	0x2d,
	0x74,
	0x02,
	0x93,
	0xf5,
	0x2e,
	0x74,
	0x03,
	0x93,
	0xf5,
	0x2f,
	0x74,
	0x04,
	0x93,
	0xf5,
	0x30,
	0xe5,
	0x0a,
	0xb4,
	0x01,
	0x07,
	0x74,
	0x2c,
	0x25,
	0x79,
	0xf8,
	0x76,
	0x40,
	0xe5,
	0x0a,
	0xb4,
	0x02,
	0x07,
	0x74,
	0x2c,
	0x25,
	0x79,
	0xf8,
	0x76,
	0x80,
	0x22,
	0xc0,
	0xe0,
	0xc0,
	0x83,
	0xc0,
	0x82,
	0xc0,
	0xd0,
	0x90,
	0x3f,
	0x0d,
	0xe0,
	0xf5,
	0x09,
	0xe5,
	0x09,
	0x30,
	0xe0,
	0x2e,
	0xe5,
	0x7a,
	0xb4,
	0x01,
	0x09,
	0x90,
	0x3a,
	0x00,
	0xe0,
	0xf5,
	0x78,
	0x44,
	0x01,

	0x93,
	0x00,
	0xf0,			
	0xe5,
	0x7a,
	0xb4,
	0x03,
	0x09,
	0x90,
	0x3a,
	0x00,
	0xe0,
	0xf5,
	0x78,
	0x54,
	0xfe,
	0xf0,
	0xe5,
	0x7a,
	0xb4,
	0x03,
	0x05,
	0x75,
	0x7a,
	0x00,
	0x80,
	0x02,
	0x05,
	0x7a,
	0x90,
	0x3f,
	0x0d,
	0x74,
	0x01,
	0xf0,
	0xd0,
	0xd0,
	0xd0,
	0x82,
	0xd0,
	0x83,
	0xd0,
	0xe0,
	0x32,
	0x90,
	0x50,
	0x27,
	0xe0,
	0x44,
	0x01,
	0xf0,
	0x90,
	0x50,
	0x34,
	0x74,
	0x80,
	0xf0,
	0xa3,
	0x74,
	0x2a,
	0xf0,
	0xa3,
	0x74,
	0x14,
	0xf0,
	0x90,
	0x50,
	0x30,
	0xe4,
	0xf0,
	0xa3,
	0x74,
	0x02,
	0xf0,
	0xa3,
	0xe4,
	0xf0,
	0xa3,
	0x74,
	0x80,
	0xf0,
	0xe4,
	0xf5,
	0x0a,
	0x12,
	0x11,
	0x10,
	0x75,
	0x79,
	0x02,
	0x75,
	0x0a,
	0x01,
	0x12,
	0x12,
	0x91,
	0xd2,
	0x18,
	0xd2,
	0x19,
	0xc2,
	0x3a,
	0xc2,
	0x39,
	0xd2,
	0x1a,
	0xd2,
	0x36,
	0xd2,
	0x30,
	0xc2,
	0x35,
	0xc2,
	0x3b,
	0x22,
	0x85,
	0x10,
	0x11,
	0x7f,
	0x08,
	0xe5,
	0x11,
	0x30,
	0xe7,
	0x04,
	0xd2,
	0x29,
	0x80,
	0x02,
	0xc2,
	0x29,
	0x12,
	0x01,
	0x6c,
	0x75,
	0x51,
	0x0a,
	0xae,
	0x51,
	0x15,
	0x51,
	0xee,
	0x70,
	0xf9,
	0xe5,
	0x11,
	0x25,
	0xe0,
	0xf5,
	0x11,
	0xd2,
	0x28,
	0x12,
	0x01,
	0x6c,
	0x75,
	0x51,
	0x0a,
	0xae,
	0x51,
	0x15,
	0x51,
	0xee,
	0x70,
	0xf9,
	0xc2,
	0x28,
	0x12,
	0x01,
	0x6c,
	0x75,
	0x51,
	0x05,
	0xae,
	0x51,
	0x15,
	0x51,
	0xee,
	0x70,
	0xf9,
	0xdf,
	0xc2,
	0x22,
	0xc2,
	0xaf,
	0x90,
	0x30,
	0x27,
	0x74,
	0xfa,
	0xf0,
	0x12,
	0x0e,
	0x99,
	0x12,
	0x14,
	0x83,
	0xe4,
	0xf5,
	0x33,
	0xd2,
	0xaf,
	0x12,
	0x0c,
	0x84,
	0x30,
	0x30,
	0x03,
	0x12,
	0x06,
	0xee,
	0x30,
	0x34,
	0x03,
	0x12,
	0x12,
	0x38,
	0x30,
	0x3b,
	0xee,
	0xc2,
	0x3b,
	0xd2,
	0x35,
	0x30,
	0x00,
	0x05,
	0x12,
	0x14,
	0x56,
	0x80,
	0x09,
	0x20,
	0x07,
	0x06,
	0x30,
	0x06,
	0x03,
	0x12,
	0x0d,
	0x92,
	0xc2,
	0x35,
	0x80,
	0xd5,
	0x12,
	0x0f,
	0xc6,
	0xd2,
	0x3c,
	0x12,
	0x0f,
	0x39,
	0xd2,
	0x3c,
	0x12,
	0x11,
	0x75,

	0x94,
	0x00,
	0xe5,			
	0x7c,
	0xd3,
	0x95,
	0x7d,
	0x40,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x50,
	0x14,
	0x20,
	0x37,
	0x0e,
	0xe5,
	0x24,
	0x54,
	0x1f,
	0xff,
	0xbf,
	0x1f,
	0x06,
	0x30,
	0x25,
	0x03,
	0x20,
	0x26,
	0x03,
	0x02,
	0x15,
	0x2b,
	0x12,
	0x02,
	0xb3,
	0x22,
	0xe5,
	0x7d,
	0x70,
	0x19,
	0x12,
	0x15,
	0x03,
	0xc2,
	0x3c,
	0x12,
	0x0f,
	0x39,
	0xc2,
	0x3c,
	0x12,
	0x11,
	0x75,
	0xc2,
	0x03,
	0x12,
	0x15,
	0x2b,
	0xd2,
	0x02,
	0xd2,
	0x01,
	0xd2,
	0x00,
	0x22,
	0x30,
	0x03,
	0x08,
	0xc2,
	0x03,
	0xc2,
	0x04,
	0x12,
	0x02,
	0x9b,
	0x22,
	0xe4,
	0xf5,
	0x0c,
	0x12,
	0x11,
	0xd8,
	0xd2,
	0x03,
	0x22,
	0xe5,
	0x20,
	0x54,
	0x07,
	0xff,
	0xbf,
	0x01,
	0x03,
	0x02,
	0x14,
	0x25,
	0xe5,
	0x20,
	0x54,
	0x07,
	0xff,
	0xbf,
	0x07,
	0x03,
	0x02,
	0x14,
	0xa9,
	0xe5,
	0x20,
	0x54,
	0x07,
	0xff,
	0xbf,
	0x03,
	0x03,
	0x02,
	0x13,
	0xf3,
	0xe5,
	0x20,
	0x54,
	0x07,
	0xff,
	0xbf,
	0x05,
	0x03,
	0x12,
	0x15,
	0x69,
	0x22,
	0x12,
	0x13,
	0x2a,
	0x12,
	0x15,
	0x77,
	0x50,
	0x04,
	0xd2,
	0x05,
	0x80,
	0x02,
	0xc2,
	0x05,
	0x12,
	0x02,
	0x51,
	0xc2,
	0x37,
	0xc2,
	0x31,
	0xd2,
	0x34,
	0x12,
	0x02,
	0x7f,
	0xb5,
	0x07,
	0x03,
	0xd3,
	0x80,
	0x01,
	0xc3,
	0x40,
	0x02,
	0xc2,
	0x05,
	0x22,
	0x12,
	0x0f,
	0xc6,
	0xd2,
	0x3c,
	0x12,
	0x0f,
	0x39,
	0xd2,
	0x3c,
	0x12,
	0x11,
	0x75,
	0x12,
	0x15,
	0x2b,
	0xe5,
	0x32,
	0xd3,
	0x95,
	0x7d,
	0x40,
	0x05,
	0xe4,
	0x95,
	0x7d,
	0x40,
	0x06,
	0xc2,
	0x02,
	0xd2,
	0x01,
	0xd2,
	0x00,
	0x22,
	0xe4,
	0xff,
	0xfe,
	0xc3,
	0xef,
	0x95,
	0x0e,
	0xee,
	0x95,
	0x0d,
	0x50,
	0x15,
	0x7d,
	0x8a,
	0x7c,
	0x02,
	0xed,
	0x1d,
	0xaa,
	0x04,
	0x70,
	0x01,
	0x1c,
	0x4a,
	0x70,
	0xf6,
	0x0f,
	0xbf,
	0x00,
	0x01,
	0x0e,
	0x80,
	0xe2,
	0x22,
	0x75,
	0x48,
	0x10,
	0x75,
	0x49,
	0xaa,
	0x90,
	0x10,
	0xa8,
	0xe4,
	0x93,
	0xf5,
	0x7c,
	0xa3,
	0xe4,
	0x93,
	0xf5,
	0x32,

	0x95,
	0x00,
	0xc2,			
	0x38,
	0x22,
	0xe4,
	0xff,
	0xef,
	0x25,
	0xe0,
	0x24,
	0x56,
	0xf8,
	0xe4,
	0xf6,
	0x08,
	0xf6,
	0x0f,
	0xbf,
	0x07,
	0xf2,
	0x53,
	0x24,
	0x80,
	0x22,
	0xc2,
	0x03,
	0xd2,
	0x04,
	0x12,
	0x02,
	0x9b,
	0xc2,
	0x3c,
	0x12,
	0x0f,
	0x39,
	0xc2,
	0x3c,
	0x12,
	0x11,
	0x75,
	0xd2,
	0x34,
	0x22,
	0xe5,
	0x7d,
	0xc3,
	0x95,
	0x7c,
	0x40,
	0x01,
	0x22,
	0xe5,
	0x7d,
	0x04,
	0xf5,
	0x0c,
	0x12,
	0x11,
	0xd8,
	0x22,
	0xe5,
	0x7d,
	0x70,
	0x02,
	0xc3,
	0x22,
	0xe5,
	0x7d,
	0x14,
	0xf5,
	0x0c,
	0x12,
	0x11,
	0xd8,
	0x22,
	0xe5,
	0x7e,
	0xb4,
	0x01,
	0x09,
	0x12,
	0x14,
	0xee,
	0xe4,
	0xf5,
	0x0c,
	0x12,
	0x11,
	0xd8,
	0x22,
	0xe5,
	0x7e,
	0x24,
	0xfe,
	0x60,
	0x06,
	0x04,
	0x70,
	0x05,
	0xd2,
	0x37,
	0x22,
	0xc2,
	0x37,
	0x22,
	0xe5,
	0x31,
	0xd3,
	0x94,
	0x00,
	0x40,
	0x03,
	0x15,
	0x31,
	0x22,
	0x12,
	0x15,
	0x17,
	0x22,
	0x12,
	0x14,
	0xee,
	0xe4,
	0xf5,
	0x0c,
	0x12,
	0x11,
	0xd8,
	0x22,			
};

#endif 
