#ifndef OV5642_REG_H
#define OV5642_REG_H

#include <linux/delay.h>
#include <linux/types.h>
#include <linux/i2c.h>
#include <linux/uaccess.h>
#include <linux/miscdevice.h>
#include <linux/slab.h>
#include <mach/gpio.h>
#include <media/msm_camera.h>
#include <mach/camera.h>

#include <mach/board.h>


#define FUN_DEBUG_COUNT
#define CAMERA_DBG
#define CAMERA_MYDBG
#define CAMERA_PR_INFO_DBG
#include "camera_debug.h"

extern struct ov5642_reg_settings ov5642_regs;

extern struct ov5642_white_balance_setting ov5642_white_balance_regs;
extern struct ov5642_color_effect_setting ov5642_color_effect_regs;
extern struct ov5642_scene_mode_setting ov5642_scene_mode_regs;

struct ov5642_reg
{
	unsigned short addr;
	uint8_t val;

	struct ov5642_reg *next;
};

struct IQ_item_ov5642
{
	char *name;
	int size;
	struct ov5642_reg *head;

	struct IQ_item_ov5642 *next;

};

struct ov5642_af_func_array
{
	long (*set_default_focus) (void);
	long (*set_auto_focus) (struct auto_focus_status *);
	void (*init_auto_focus) (void);
	long (*prepare_auto_focus) (void);
	long (*detect_auto_focus) (void);
	void (*deinit_auto_focus) (void);
};


struct ov5642_reg_settings
{
	struct ov5642_reg *default_settings;
	unsigned short default_settings_size;

	struct ov5642_reg *iq_settings;
	unsigned short iq_settings_size;

	struct ov5642_reg *preview_settings;
	unsigned short preview_settings_size;

	struct ov5642_reg *preview_settings_1080p;
	unsigned short preview_settings_1080p_size;    

	struct ov5642_reg *snapshot_settings;
	unsigned short snapshot_settings_size;

};




struct ov5642_white_balance_setting
{

	struct ov5642_reg *auto_wb;
	unsigned short auto_wb_size;

	struct ov5642_reg *daylight_wb;
	unsigned short daylight_wb_size;


	struct ov5642_reg *cloudy_wb;
	unsigned short cloudy_wb_size;

	struct ov5642_reg *fluorescent_wb;
	unsigned short fluorescent_wb_size;


	struct ov5642_reg *incandescent_wb;
	unsigned short incandescent_wb_size;

};



struct ov5642_color_effect_setting
{

	struct ov5642_reg *normal_sde;
	unsigned short normal_sde_size;

	struct ov5642_reg *mono_sde;
	unsigned short mono_sde_size;


	struct ov5642_reg *bluish_sde;
	unsigned short bluish_sde_size;

	struct ov5642_reg *sepia_sde;
	unsigned short sepia_sde_size;


	struct ov5642_reg *reddish_sde;
	unsigned short reddish_sde_size;

	struct ov5642_reg *solarize_sde;
	unsigned short solarize_sde_size;

	struct ov5642_reg *greenish_sde;
	unsigned short greenish_sde_size;

	struct ov5642_reg *negative_sde;
	unsigned short negative_sde_size;

};


struct ov5642_scene_mode_setting
{

	struct ov5642_reg *auto_sm;
	unsigned short auto_sm_size;

	struct ov5642_reg *night_sm;
	unsigned short night_sm_size;


	struct ov5642_reg *portrait_sm;
	unsigned short portrait_sm_size;

	struct ov5642_reg *landscape_sm;
	unsigned short landscape_sm_size;


	struct ov5642_reg *sport_sm;
	unsigned short sport_sm_size;

	struct ov5642_reg *snow_sm;
	unsigned short snow_sm_size;


};



#endif
