#include<linux/module.h>
#include<linux/types.h>
#include<linux/ctype.h>
#include<linux/fs.h>
#include<linux/errno.h>
#include<linux/mm.h>
#include<linux/sched.h>
#include<linux/init.h>
#include<linux/cdev.h>
#include<asm/io.h>
#include<asm/system.h>
#include<asm/uaccess.h>
#include<linux/slab.h>
#include<linux/ioctl.h>
#include<linux/kernel.h>
#include<linux/miscdevice.h>
#include "ov5642_reg.h"
#include "mt9m114_reg.h"

char *
trim (char *str)
{
	char *str_last, *str_cur;
	if (str == NULL)
		return NULL;
	for (; *str == 0x20 || *str == '\t'; ++str);
	for (str_last = str_cur = str; *str_cur != '\0'; ++str_cur)
		if (*str_cur != 0x20 && *str_cur != '\t')
			str_last = str_cur;
	*++str_last = 0;
	return str;
}

struct ov5642_reg *
ov5642_reg_list_add (struct ov5642_reg *tail, char *line)
{
	char *addr;
	char *value;
	struct ov5642_reg *new_node;

	line[7] = '\0';
	value = line + 5;
	line[4] = '\0';
	addr = line;

	new_node = kmalloc (sizeof (struct ov5642_reg), GFP_KERNEL);

	new_node->addr = simple_strtoul (trim (addr), 0, 16);
	new_node->val = simple_strtoul (trim (value), 0, 16);

	new_node->next = NULL;
	if (tail == NULL)
	{
		tail = new_node;
	}
	{
		tail->next = new_node;
		tail = new_node;
	}
	tail->next = NULL;
	return tail;

}

#if 1
struct mt9m114_reg_tuning *
mt9m114_reg_list_add (struct mt9m114_reg_tuning *tail, char *line)
{
	char *addr;
	char *value;
	struct mt9m114_reg_tuning *new_node;

	line[9] = '\0';
	value = line + 5;
	line[4] = '\0';
	addr = line;

	new_node = kmalloc (sizeof (struct mt9m114_reg_tuning), GFP_KERNEL);

	value = trim (value);

	if (value[0] == '@')
	{
		value = value + 1;
		new_node->is_byte = 1;
	}
	else
	{
		new_node->is_byte = 0;
	}

	new_node->waddr = simple_strtoul (trim (addr), 0, 16);
	new_node->wdata = simple_strtoul (trim (value), 0, 16);

	new_node->next = NULL;
	if (tail == NULL)
	{
		tail = new_node;
	}
	{
		tail->next = new_node;
		tail = new_node;
	}
	tail->next = NULL;
	return tail;

}

#endif
void
ov5642_reg_list_print (struct ov5642_reg *head)
{

	struct ov5642_reg *next_node;
	next_node = head;
	for (; next_node != NULL; next_node = next_node->next)
	{
		printk ("%X %X\n", next_node->addr, next_node->val);

	}
	printk ("\n");

}

#if 1
void
mt9m114_reg_list_print (struct mt9m114_reg_tuning *head)
{

	struct mt9m114_reg_tuning *next_node;
	next_node = head;

	for (; next_node != NULL; next_node = next_node->next)
	{

		printk ("%X %X %d\n", next_node->waddr, next_node->wdata,next_node->is_byte);

	}

}

#endif


int
my_getline (char *line, int *offset, char *setting_file)
{

	int istart = *offset;
	int iend = *offset;
	char c = *(setting_file + iend);

	if (strlen (setting_file + iend) < 5)
	{
		return -1;
	}

	while (c != '\n')
	{
		iend++;
		c = *(setting_file + iend);
	}

	c = *(setting_file + iend - 1);

	if (c == '\r')
	{
		*(setting_file + iend - 1) = '\0';
		*(setting_file + iend) = '\0';
	}
	else
	{
		*(setting_file + iend) = '\0';
	}

	strcpy (line, setting_file + istart);
	*offset = iend + 1;

	return *offset - istart;

}

int
parse_tuning_file_ov5642 (char *setting_file)
{

	char line[300];
	int offset = 0;
	ssize_t read = 0;

	int end;

	struct IQ_item_ov5642 *iq_head = NULL;
	struct IQ_item_ov5642 *iq_tail = NULL;
	struct IQ_item_ov5642 *iq_node = NULL;
	struct IQ_item_ov5642 *search = NULL;

	struct ov5642_reg *tail = NULL;


	printk ("+++ %s\n\n", __func__);

	memset (line, 0, sizeof (line));

	do
	{
		read = my_getline (line, &offset, setting_file);
		if (line[0] == '#' && read > 4)
		{

			iq_node =
				kmalloc (sizeof (struct IQ_item_ov5642),
					 GFP_KERNEL);

			end = strlen (line);

			line[end] = '\0';


			iq_node->name =
				kmalloc (strlen (line) + 1, GFP_KERNEL);
			strncpy (iq_node->name, line + 1, strlen (line));

			if (iq_head == NULL)
			{
				iq_head = iq_node;
				iq_tail = iq_node;
			}
			else
			{
				iq_tail->next = iq_node;
				iq_tail = iq_node;
			}

			iq_node->next = NULL;

			iq_node->size = 0;
			tail = NULL;
			iq_node->head = NULL;
		}
		else if (isxdigit (line[0]) && read > 4)
		{

			tail = ov5642_reg_list_add (tail, line);

			if (iq_node->size == 0)
			{
				iq_node->head = tail;
			}

			iq_node->size++;
		}

		else
		{


		}


	}while (strlen (setting_file + offset) > 5);

	search = iq_head;
	while (search != NULL)
	{
		if (strcasecmp (trim (search->name), "ov5642_default") == 0)
		{
		       printk("ov5642_default ok\n");
			ov5642_regs.default_settings = search->head;
			ov5642_regs.default_settings_size = search->size;
		}
		else if (strcasecmp (trim (search->name), "ov5642_iq") == 0)
		{
		       printk("ov5642_iq ok\n");
			ov5642_regs.iq_settings = search->head;
			ov5642_regs.iq_settings_size = search->size;
		}
    
		else if (strcasecmp (trim (search->name), "ov5642_preview") ==
			 0)
		{
		       printk("ov5642_preview ok\n");
			ov5642_regs.preview_settings = search->head;
			ov5642_regs.preview_settings_size = search->size;

		}
		else if (strcasecmp (trim (search->name), "ov5642_snapshot")
			 == 0)
		{
		       printk("ov5642_snapshot ok\n");
			ov5642_regs.snapshot_settings = search->head;
			ov5642_regs.snapshot_settings_size = search->size;

		}
        
		else if (strcasecmp (trim (search->name), "ov5642_preview_1080p") ==
			 0)
		{
		       printk("ov5642_preview_1080p ok\n");
			ov5642_regs.preview_settings_1080p = search->head;
			ov5642_regs.preview_settings_1080p_size = search->size;

		}        
                
  		else if (strcasecmp (trim (search->name), "auto_wb")
			 == 0)
		{
		       printk("auto_wb ok\n");
			ov5642_white_balance_regs.auto_wb= search->head;
			ov5642_white_balance_regs.auto_wb_size = search->size;

		}
          	else if (strcasecmp (trim (search->name), "daylight_wb")
			 == 0)
		{
		       printk("daylight_wb ok\n");
			ov5642_white_balance_regs.daylight_wb = search->head;
			ov5642_white_balance_regs.daylight_wb_size = search->size;

		}

              else if (strcasecmp (trim (search->name), "cloudy_wb")
			 == 0)
		{
		       printk("cloudy_wb ok\n");
			ov5642_white_balance_regs.cloudy_wb = search->head;
			ov5642_white_balance_regs.cloudy_wb_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "fluorescent_wb")
			 == 0)
		{
		       printk("fluorescent_wb ok\n");
			ov5642_white_balance_regs.fluorescent_wb = search->head;
			ov5642_white_balance_regs.fluorescent_wb_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "incandescent_wb")
			 == 0)
		{
		       printk("incandescent_wb ok\n");
			ov5642_white_balance_regs.incandescent_wb = search->head;
			ov5642_white_balance_regs.incandescent_wb_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "normal_sde")
			 == 0)
		{
		       printk("normal_sde ok\n");
			ov5642_color_effect_regs.normal_sde = search->head;
			ov5642_color_effect_regs.normal_sde_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "mono_sde")
			 == 0)
		{
		       printk("mono_sde ok\n");
			ov5642_color_effect_regs.mono_sde = search->head;
			ov5642_color_effect_regs.mono_sde_size = search->size;

		}
             else if (strcasecmp (trim (search->name), "bluish_sde")
			 == 0)
		{
		       printk("bluish_sde ok\n");
			ov5642_color_effect_regs.bluish_sde = search->head;
			ov5642_color_effect_regs.bluish_sde_size = search->size;

		}
             else if (strcasecmp (trim (search->name), "sepia_sde")
			 == 0)
		{
		       printk("sepia_sde ok\n");
			ov5642_color_effect_regs.sepia_sde = search->head;
			ov5642_color_effect_regs.sepia_sde_size = search->size;

		}
             else if (strcasecmp (trim (search->name), "reddish_sde")
			 == 0)
		{
		       printk("reddish_sde ok\n");
			ov5642_color_effect_regs.reddish_sde = search->head;
			ov5642_color_effect_regs.reddish_sde_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "solarize_sde")
			 == 0)
		{
		       printk("solarize_sde ok\n");
			ov5642_color_effect_regs.solarize_sde = search->head;
			ov5642_color_effect_regs.solarize_sde_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "greenish_sde")
			 == 0)
		{
		       printk("greenish_sde ok\n");
			ov5642_color_effect_regs.greenish_sde = search->head;
			ov5642_color_effect_regs.greenish_sde_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "negative_sde")
			 == 0)
		{
		       printk("negative_sde ok\n");
			ov5642_color_effect_regs.negative_sde = search->head;
			ov5642_color_effect_regs.negative_sde_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "auto_sm")
			 == 0)
		{
		       printk("auto_sm ok\n");
			ov5642_scene_mode_regs.auto_sm = search->head;
			ov5642_scene_mode_regs.auto_sm_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "night_sm")
			 == 0)
		{
		       printk("night_sm ok\n");
			ov5642_scene_mode_regs.night_sm = search->head;
			ov5642_scene_mode_regs.night_sm_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "portrait_sm")
			 == 0)
		{
		       printk("portrait_sm ok\n");
			ov5642_scene_mode_regs.portrait_sm = search->head;
			ov5642_scene_mode_regs.portrait_sm_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "landscape_sm")
			 == 0)
		{
		       printk("landscape_sm ok\n");
			ov5642_scene_mode_regs.landscape_sm = search->head;
			ov5642_scene_mode_regs.landscape_sm_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "sport_sm")
			 == 0)
		{
		       printk("sport_sm ok\n");
			ov5642_scene_mode_regs.sport_sm = search->head;
			ov5642_scene_mode_regs.sport_sm_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "snow_sm")
			 == 0)
		{
		       printk("snow_sm ok\n");
			ov5642_scene_mode_regs.snow_sm = search->head;
			ov5642_scene_mode_regs.snow_sm_size = search->size;

		}

#if 0
			printk ("Are you sure : %s : %d ?\n",
				trim (search->name), search->size);
			ov5642_reg_list_print (search->head);

#endif
		search = search->next;
	}

	printk ("--- %s\n", __func__);
	return 0;

}

#if 1
int
parse_tuning_file_mt9m114 (char *setting_file)
{

	char line[300];
	int offset = 0;
	ssize_t read = 0;

	int end;

	struct IQ_item_mt9m114 *iq_head = NULL;
	struct IQ_item_mt9m114 *iq_tail = NULL;
	struct IQ_item_mt9m114 *iq_node = NULL;
	struct IQ_item_mt9m114 *search = NULL;

	struct mt9m114_reg_tuning *tail = NULL;


	printk ("+++ %s\n\n", __func__);

	memset (line, 0, sizeof (line));

	do
	{
		read = my_getline (line, &offset, setting_file);
		if (line[0] == '#' && read > 4)
		{
			iq_node =
				kmalloc (sizeof (struct IQ_item_mt9m114),
					 GFP_KERNEL);

			end = strlen (line);

			line[end] = '\0';


			iq_node->name =
				kmalloc (strlen (line) + 1, GFP_KERNEL);
			strncpy (iq_node->name, line + 1, strlen (line));

			if (iq_head == NULL)
			{
				iq_head = iq_node;
				iq_tail = iq_node;
			}
			else
			{
				iq_tail->next = iq_node;
				iq_tail = iq_node;
			}

			iq_node->next = NULL;

			iq_node->size = 0;
			tail = NULL;
			iq_node->head = NULL;

		}
		else if (isxdigit (line[0]) && read > 4)
		{

			tail = mt9m114_reg_list_add (tail, line);

			if (iq_node->size == 0)
			{
				iq_node->head = tail;
			}

			iq_node->size++;
		}

		else
		{
                 printk ("%s\n", iq_node->name);
                 
		}

	}while (strlen (setting_file + offset) > 5);

	search = iq_head;
	while (search != NULL)
	{
		if (strcasecmp (trim (search->name), "M114_pll_timing") == 0)
		{
		       printk("find M114_pll_timing size is %d\n",search->size);
			mt9m114_regs.reg_pll_timing = search->head;
			mt9m114_regs.reg_pll_timing_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "M114_optimization") == 0)
		{
		       printk("find M114_optimization\n");
			mt9m114_regs.reg_optimization = search->head;
			mt9m114_regs.reg_optimization_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_patch0202") == 0)
		{
		       printk("find M114_patch0202\n");
			mt9m114_regs.reg_patch0202 = search->head;
			mt9m114_regs.reg_patch0202_size = search->size;

		}
              else if (strcasecmp (trim (search->name), "M114_patch0302") == 0)
		{
		       printk("find M114_patch0302\n");
			mt9m114_regs.reg_patch0302 = search->head;
			mt9m114_regs.reg_patch0302_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_APGA") == 0)
		{
		       printk("find M114_APGA\n");
			mt9m114_regs.reg_APGA = search->head;
			mt9m114_regs.reg_APGA_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_AWB_CCM") == 0)
		{
		       printk("find M114_AWB_CCM\n");
			mt9m114_regs.reg_AWB_CCM = search->head;
			mt9m114_regs.reg_AWB_CCM_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_MIPI_setting") == 0)
		{
		       printk("find M114_MIPI_setting\n");
			mt9m114_regs.reg_MIPI_setting = search->head;
			mt9m114_regs.reg_MIPI_setting_size = search->size;


		}
              else if (strcasecmp (trim (search->name), "M114_Dual_Lane_Mipi_Receiver_Init") == 0)
		{
		       printk("find M114_Dual_Lane_Mipi_Receiver_Init\n");
			mt9m114_regs.reg_Dual_Lane_Mipi_Receiver_Init = search->head;
			mt9m114_regs.reg_Dual_Lane_Mipi_Receiver_Init_size = search->size;
		}
              
              else if (strcasecmp (trim (search->name), "M114_scene_mode_off1") == 0)
		{
		       printk("find M114_scene_mode_off1\n");
			mt9m114_reg_settings.reg_scene_mode_off1 = search->head;
			mt9m114_reg_settings.reg_scene_mode_off1_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_scene_mode_off2") == 0)
		{
		       printk("find M114_scene_mode_off2\n");
			mt9m114_reg_settings.reg_scene_mode_off2 = search->head;
			mt9m114_reg_settings.reg_scene_mode_off2_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_scene_mode_landscape1") == 0)
		{
		       printk("find M114_scene_mode_landscape1\n");
			mt9m114_reg_settings.reg_scene_mode_landscape1 = search->head;
			mt9m114_reg_settings.reg_scene_mode_landscape1_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_scene_mode_landscape2") == 0)
		{
		       printk("find M114_scene_mode_landscape2\n");
			mt9m114_reg_settings.reg_scene_mode_landscape2 = search->head;
			mt9m114_reg_settings.reg_scene_mode_landscape2_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_scene_mode_portrain1") == 0)
		{
		       printk("find M114_scene_mode_portrain1\n");
			mt9m114_reg_settings.reg_scene_mode_portrain1 = search->head;
			mt9m114_reg_settings.reg_scene_mode_portrain1_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_scene_mode_portrain2") == 0)
		{
		       printk("find M114_scene_mode_portrain2\n");
			mt9m114_reg_settings.reg_scene_mode_portrain2 = search->head;
			mt9m114_reg_settings.reg_scene_mode_portrain2_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_scene_mode_snow1") == 0)
		{
		       printk("find M114_scene_mode_snow1\n");
			mt9m114_reg_settings.reg_scene_mode_snow1 = search->head;
			mt9m114_reg_settings.reg_scene_mode_snow1_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_scene_mode_snow2") == 0)
		{
		       printk("find M114_scene_mode_snow2\n");
			mt9m114_reg_settings.reg_scene_mode_snow2 = search->head;
			mt9m114_reg_settings.reg_scene_mode_snow2_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_scene_mode_night1") == 0)
		{
		       printk("find M114_scene_mode_night1\n");
			mt9m114_reg_settings.reg_scene_mode_night1 = search->head;
			mt9m114_reg_settings.reg_scene_mode_night1_size = search->size;
		}
              else if (strcasecmp (trim (search->name), "M114_scene_mode_night2") == 0)
		{
		       printk("find M114_scene_mode_night2\n");
			mt9m114_reg_settings.reg_scene_mode_night2 = search->head;
			mt9m114_reg_settings.reg_scene_mode_night2_size = search->size;
		}


		search = search->next;
	}

	printk ("--- %s\n", __func__);
	return 0;

}

#endif
