
/***********************************************************
 *
 * bma2x0.c
 *
************************************************************/



/* ------------------ */
/* - Include Files. - */
/* ------------------ */

#ifdef __KERNEL__
#include <linux/module.h>
#endif

#include "mpu.h"
#include "mlos.h"
#include "mlsl.h"

/* --------------------- */
/* -    Variables.     - */
/* --------------------- */
/* full scale setting - register and mask */

#define ACCEL_BOSCH_CTRL_REG       (0x0f)  /* BMA2x0 : full scale setting register */
#define ACCEL_BOSCH_CTRL_MASK      (0x0f)  /* BMA2x0 : full scale setting mask */
#define ACCEL_BOSCH_BW_REG       (0x10)  /* BMA2x0 : BW setting register */
#define ACCEL_BOSCH_BW_MASK      (0x1f)     /* BMA2x0 : BW setting mask */

/*********************************************
    Accelerometer Initialization Functions
**********************************************/

static int bma2x0_suspend(void *mlsl_handle,
			  struct ext_slave_descr *slave,
			  struct ext_slave_platform_data *pdata)
{
	int result;
	result = MLSLSerialWriteSingle(mlsl_handle, pdata->address, 0x14, 0xb6); /* BMA2x0 : Software reset */
	MLOSSleep(3); /* 3 ms powerup time maximum */
	ERROR_CHECK(result);
	return result;
}

static int bma2x0_resume(void *mlsl_handle,
			 struct ext_slave_descr *slave,
			 struct ext_slave_platform_data *pdata)
{
	int result;
	unsigned char reg = 0;

	/* Soft reset */
	result = MLSLSerialWriteSingle(mlsl_handle, pdata->address, 0x14, 0xb6);		  /* BMA2x0 : Software reset */
	ERROR_CHECK(result);
	MLOSSleep(10);

	result = MLSLSerialRead(mlsl_handle, pdata->address, ACCEL_BOSCH_CTRL_REG, 1, &reg);
	ERROR_CHECK(result);

	/* BMA2x0 : Full Scale */
	reg &= ~ACCEL_BOSCH_CTRL_MASK;
	reg |= 0x00;

	if (slave->range.mantissa == 2) {
		reg |= 0x03;
	} else if (slave->range.mantissa == 4) {
		reg |= 0x05;
	} else if (slave->range.mantissa == 8) {
		reg |= 0x08;
	}

	result = MLSLSerialWriteSingle(mlsl_handle, pdata->address, ACCEL_BOSCH_CTRL_REG, reg);
	ERROR_CHECK(result);

	result = MLSLSerialRead(mlsl_handle, pdata->address, ACCEL_BOSCH_BW_REG, 1, &reg);
	ERROR_CHECK(result);

	reg &= ~ACCEL_BOSCH_BW_MASK;
	reg |= 0x00;

	/* BMA2x0: Bandwidth */
	reg |= 0x0a;

	result = MLSLSerialWriteSingle(mlsl_handle, pdata->address, ACCEL_BOSCH_BW_REG, reg);
	ERROR_CHECK(result);

	return result;

}



static int bma2x0_read(void *mlsl_handle,
				struct ext_slave_descr *slave,
				struct ext_slave_platform_data *pdata,
				unsigned char *data)
{
    return ML_ERROR_FEATURE_NOT_IMPLEMENTED;
}

static int bma2x0_read_chipid(void *mlsl_handle,
                       struct ext_slave_descr *slave, 
                       struct ext_slave_platform_data *pdata,
                       unsigned char * chip_id)
{
    int result;
    
    result = MLSLSerialRead(mlsl_handle, pdata->address, 0x00, 1, chip_id);
    ERROR_CHECK(result);
	
	return ML_SUCCESS;
}
static struct ext_slave_descr bma2x0_descr = {
	/*.init             = */ NULL,
	/*.exit             = */ NULL,
	/*.suspend          = */ bma2x0_suspend,
	/*.resume           = */ bma2x0_resume,
	/*.read             = */ bma2x0_read,
	/*.config           = */ NULL,
	/*.name             = */ "bma2x0",
	/*.type             = */ EXT_SLAVE_TYPE_ACCELEROMETER,
	/*.id               = */ ACCEL_ID_BMA2X0,
	/*.reg              = */ 0x02,
	/*.len              = */ 6,
	/*.endian           = */ EXT_SLAVE_LITTLE_ENDIAN,
	/*.range            = */ {2, 0},
  	/*.read_chipid		= */bma2x0_read_chipid		
};

struct ext_slave_descr *bma2x0_get_slave_descr(void)
{
    return &bma2x0_descr;
}

EXPORT_SYMBOL(bma2x0_get_slave_descr);

#ifdef __KERNEL__
MODULE_AUTHOR("Invensense");
MODULE_DESCRIPTION("User space IRQ handler for MPU3xxx devices");
MODULE_LICENSE("GPL");
MODULE_ALIAS("bma");
#endif

/**
 *  @}
**/
