#include <asm/io.h>
#include <linux/fs.h>
#include <asm/ioctl.h>
#include <linux/module.h>
#include <linux/miscdevice.h>
#include <asm/uaccess.h>
#include <linux/platform_device.h>
#include <mach/msm_iomap-8x60.h>
#include <mach/msm_iomap.h>

#define QFPROM_IOR_OEM_CONFIG_ROW0_LSB	_IOR('A' , 1, unsigned)
#define QFPROM_IOR_OEM_CONFIG_ROW0_MSB	_IOR('B' , 2, unsigned)
#define QFPROM_IOR_OEM_SEC_BOOT_ROW0_LSB	_IOR('C' , 3, unsigned)
#define QFPROM_IOR_OEM_SEC_BOOT_ROW0_MSB	_IOR('D' , 4, unsigned)

#define QFPROM_RAW_OEM_CONFIG_ROW0_LSB_ADDR	(MSM_QFPROM_BASE + 0x220)
#define QFRPOM_RAW_OEM_SEC_BOOT_ROW0_LSB_ADDR	(MSM_QFPROM_BASE + 0x310)

static int qfprom_misc_open(struct inode *inode, struct file *fp)
{
	printk("%s\n", __func__);
  	return 0;
}

static int qfprom_misc_release(struct inode *inode, struct file *fp)
{
	printk("%s\n", __func__);
    return 0;
}

static int qfprom_misc_ioctl(struct inode *inode, struct file *fp, unsigned int cmd, unsigned long arg)
{
	int rc = 0;
	unsigned value = 0x5555;
	unsigned __iomem *address = NULL;
	
	
 	switch(cmd) {
 		case QFPROM_IOR_OEM_CONFIG_ROW0_LSB:
 			address = QFPROM_RAW_OEM_CONFIG_ROW0_LSB_ADDR;
 			break;
 		case QFPROM_IOR_OEM_SEC_BOOT_ROW0_LSB:
 			address = QFRPOM_RAW_OEM_SEC_BOOT_ROW0_LSB_ADDR;
 			break;
 		default:
 			break;
 	}

	if (address == NULL) {
		rc = -EFAULT;
		goto exit;
	}

	value = readl(address);

	if (copy_to_user((void __user*)arg, &value, sizeof(value))) {
 		pr_err("%s: copy_to_user error!\n", __func__);
 		rc = -EFAULT;
 	}
 	
exit:	 	
 	return rc;
}


static struct file_operations qfprom_misc_fops = {
	.owner    = THIS_MODULE,
	.open     = qfprom_misc_open,
	.release  = qfprom_misc_release,
	.ioctl    = qfprom_misc_ioctl,
};

static struct miscdevice qfprom_misc_device = {
	.minor  = MISC_DYNAMIC_MINOR,
	.name   = "qfprom",
	.fops   = &qfprom_misc_fops,
};


static int __init qfprom_init(void)
{
	misc_register(&qfprom_misc_device);
	return 0;
}
module_init(qfprom_init);


static int __exit qfprom_exit(struct platform_device *pdev)
{
	misc_deregister(&qfprom_misc_device);
	return 0;
}

