














#include <linux/module.h>
#include <linux/param.h>
#include <linux/workqueue.h>
#include <linux/platform_device.h>
#include <linux/power_supply.h>
#include <linux/i2c.h>
#include <linux/slab.h>
#include <asm/unaligned.h>
#include <linux/kernel.h>
#include <linux/delay.h>

#ifdef CONFIG_BATTERY_QSD
#include <mach/qsd_battery.h>
#endif
#include <linux/bq27500_gauge.h>

#ifdef QCS_BQ27500_GAUGE_SUPPORT

const unsigned char BQ27500FW[] = 
{
0x2F,0xB5,0x04,0x00,0xE0,0x26,0x81,0x03,0x66,0xA3,0x18,0xCE,0x03,0x22,0xA0,0x06,
0xBF,0x04,0x00,0xE0,0x03,0xCF,0x03,0x66,0xA0,0x04,0x2B,0x03,0x28,0xA0,0x7F,0x6E,
0x6E,0x9F,0x94,0x07,0xA4,0xA1,0xFA,0xEC,0xFC,0x4E,0x05,0x01,0x0B,0xB8,0x10,0x68,
0x0B,0xA4,0x03,0xE8,0x00,0x20,0x03,0xE8,0x00,0x20,0x00,0x20,0x96,0x00,0xD4,0x86,
0x4A,0xC6,0xB4,0xC2,0x6E,0x2B,0x03,0x7C,0x01,0x48,0xFD,0xA3,0xF6,0x75,0x12,0x58,
0x2D,0xB7,0x2C,0x4A,0x00,0x00,0x00,0x00,0xD4,0x80,0x16,0x7A,0x00,0x00,0x16,0x7A,
0xEF,0x03,0x11,0x05,0x01,0x00,0x00,0x10,0x01,0x00,0x3C,0x00,0x50,0x3C,0x00,0x64,
0x3C,0x00,0x20,0x01,0x00,0x05,0xD8,0x00,0x01,0x02,0x05,0x78,0x00,0x00,0x00,0x00,
0x3B,0x00,0x00,0xFE,0xE8,0xFB,0xD3,0x00,0x01,0x02,0xBC,0x01,0x01,0x02,0xBC,0x01,
0x2C,0x00,0x1E,0x00,0xC8,0xC8,0x14,0x08,0x00,0x3C,0x0E,0x10,0x00,0x0A,0x46,0x05,
0x0F,0x03,0x0F,0x0A,0x03,0x20,0x00,0x64,0x46,0x50,0x28,0x0E,0xE7,0x0E,0x9C,0x01,
0x90,0x00,0x64,0x19,0x01,0x03,0x05,0x05,0x25,0x5A,0x0F,0x14,0x60,0x0D,0x48,0x28,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x43,0x80,0x04,0x01,0x29,0x05,
0xD8,0x02,0x10,0x63,0xE5,0xE5,0xE8,0xE7,0xEA,0xEA,0xEC,0xEC,0xEE,0xEE,0xF0,0xF1,
0xF1,0xEF,0xEB,0xEC,0xED,0xF0,0xF6,0xF7,0xF9,0xF9,0xFB,0xFC,0xFC,0xFF,0xFF,0xFE,
0xFB,0xF6,0xF4,0xEE,0xEB,0xF6,0xFA,0xE1,0xF7,0xDF,0x80,0x00,0xA8,0xE3,0x15,0xEF,
0x0A,0xFB,0xCF,0xC0,0xFC,0x3F,0xC5,0xFC,0x7F,0xBE,0xFB,0x8F,0xBA,0xFB,0xAF,0xB0,
0xFA,0x6F,0x9C,0xF9,0x6F,0x9C,0xFA,0xFF,0xE3,0xFF,0xEF,0xEB,0xFD,0xDF,0xD9,0xFD,
0x5F,0xD1,0xFC,0x9F,0xBE,0xFA,0xDF,0x97,0xF5,0x4E,0xEB,0xE9,0x8E,0x55,0xE4,0x9E,
0x5F,0xE6,0xCE,0x76,0xE9,0xAE,0xC7,0xEB,0xCE,0xA0,0xC5,0x90,0x00,0xFF,0x55,0x01,
0x01,0x02,0x00,0x09,0x09,0xF6,0x00,0x09,0x01,0x02,0x06,0x07,0xFF,0x1D,0x65,0x7F,
0x00,0x00,0xFE,0xEE,0x00,0x00,0x0E,0x12,0xFC,0xF3,0xFD,0xDF,0x00,0x08,0xFC,0xE7,
0x24,0x59,0x3F,0x01,0x29,0x05,0xD8,0x02,0x10,0x63,0xE5,0xE5,0xE8,0xE7,0xEA,0xEA,
0xEC,0xEC,0xEE,0xEE,0xF0,0xF1,0xF1,0xEF,0xEB,0xEC,0xED,0xF0,0xF6,0xF7,0xF9,0xF9,
0xFB,0xFC,0xFC,0xFF,0xFF,0xFE,0xFB,0xF6,0xF4,0xEE,0xEB,0xF6,0xFA,0xE1,0xF7,0xDF,
0x80,0x00,0xA8,0xE3,0x15,0xEF,0x0A,0xFB,0xCF,0xC0,0xFC,0x3F,0xC5,0xFC,0x7F,0xBE,
0xFB,0x8F,0xBA,0xFB,0xAF,0xB0,0xFA,0x6F,0x9C,0xF9,0x6F,0x9C,0xFA,0xFF,0xE3,0xFF,
0xEF,0xEB,0xFD,0xDF,0xD9,0xFD,0x5F,0xD1,0xFC,0x9F,0xBE,0xFA,0xDF,0x97,0xF5,0x4E,
0xEB,0xE9,0x8E,0x55,0xE4,0x9E,0x5F,0xE6,0xCE,0x76,0xE9,0xAE,0xC7,0xEB,0xCE,0xA0,
0xC5,0x90,0x00,0xFF,0x55,0x01,0x01,0x02,0x00,0x09,0x09,0xF6,0x00,0x09,0x01,0x02,
0x06,0x07,0xFF,0x1D,0x65,0x7F,0x00,0x00,0xFE,0xEE,0x00,0x00,0x0E,0x12,0xFC,0xF3,
0xFD,0xDF,0x00,0x08,0xFC,0xE7,0x24,0x59,0x3F,0x00,0x00,0x01,0xC2,0x00,0x32,0x00,
0xC8,0x10,0x86,0x00,0x32,0x00,0x00,0x01,0xF4,0x00,0x55,0x00,0x19,0x00,0x64,0x28,
0x63,0x5F,0x64,0x62,0x89,0x79,0x04,0x2E,0x00,0x6E,0x14,0x04,0x00,0x00,0x00,0x00,
0x14,0x0A,0xF0,0x06,0xD6,0x00,0x00,0x0A,0x05,0x00,0x32,0x01,0xC2,0x14,0x14,0x00,
0x08,0x09,0xF6,0x0D,0x48,0x00,0x3C,0x00,0x4B,0x00,0x0A,0x00,0x3C,0x3C,0x01,0x80,
0x80,0x01,0x90,0x36,0x72,0x04,0x14,0xFF,0xFF,0xFF,0xFF,0x01,0x23,0x45,0x67,0x89,
0xAB,0xCD,0xEF,0xFE,0xDC,0xBA,0x98,0x76,0x54,0x32,0x10,0x67,0x45,0x23,0x01,0xEF,
0xCD,0xAB,0x89,0x98,0xBA,0xDC,0xFE,0x10,0x32,0x54,0x76,0xC3,0xD2,0xE1,0xF0,0x01,
0xC2,0x02,0x01,0x90,0x02,0x58,0x02,0x02,0x26,0x14,0x00,0x00,0xF9,0xA4,0xA7,0xA6,
0x01,0xF4,0x00,0x64,0x01,0xB0,0xF9,0xFD,0x12,0x04,0xEC,0x5A,0x05,0x78,0x07,0x62,
0x71,0x32,0x37,0x35,0x30,0x30,0x96,0xA0,0x5A,0x78,0x32,0x00,0x00,0x00,0x00,0x05,
0x02,0x51,0x49,0x53,0x44,0x41,0x20,0x10,0x08,0x17,0x01,0x29,0x02,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x55,0x00,0xE9,0x01,0x00,0x04,0x00,0xEC,0xF8,0x00,0xFC,0x00,0x02,0x02,0x00,
0x0E,0x4F,0x6B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0x55,0x01,0x01,0x02,0x00,0x09,0x09,0xF6,0x00,0x09,0x01,0x02,0x06,0x07,0xFF,
0x1D,0x65,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFF,0x01,0x01,0x02,0x00,0x09,0x09,0xF6,0x00,0x09,0x01,0x02,0x06,0x07,0xFF,
0x1D,0x65,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFF,0x01,0x01,0x02,0x00,0x09,0x09,0xF6,0x00,0x09,0x01,0x02,0x06,0x07,0xFF,
0x1D,0x65,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x80,0x01,0x90,0x36,0x72,0x04,0x14,0xFF,0xFF,0xFF,0xFF,0x01,0x23,0x45,0x67,0x89,
0xAB,0xCD,0xEF,0xFE,0xDC,0xBA,0x98,0x76,0x54,0x32,0x10,0x67,0x45,0x23,0x01,0xEF,
0xCD,0xAB,0x89,0x98,0xBA,0xDC,0xFE,0x10,0x32,0x54,0x76,0xC3,0xD2,0xE1,0xF0,0x01,
0xC2,0x02,0x01,0x90,0x02,0x58,0x02,0x02,0x26,0x14,0x00,0x00,0xF9,0xA4,0xA7,0xA6,
0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x03,0x46,0xFF,0xFF,0xFC,0xB8,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,
};

uint8_t * yDataFlashImage;
int bq27500_fw_size;
#endif

#ifdef NO_PER_DEBUG
static int gauge_log_on  = 1;
#define MSG3(format, arg...) {if(gauge_log_on)  printk(KERN_INFO "[GAUGE]" format "\n", ## arg);}
#else
#define MSG3(format, arg...) {pr_debug("[GAUGE]" format "\n", ## arg);}
#endif

int g_bq27500_on = 0;
int g_max17043_on = 0;

extern struct i2c_client *qb_i2c;
static uint16_t gauge_i2c_addr = 0;

int gauge_read(uint8_t reg, uint8_t *buf, uint8_t len)
{
  struct i2c_msg msgs[] = {
    [0] = {
      .addr   = gauge_i2c_addr,
      .flags  = 0,
      .buf    = (void *)&reg,
      .len    = 1
    },
    [1] = {
      .addr   = gauge_i2c_addr,
      .flags  = I2C_M_RD,
      .buf    = (void *)buf,
      .len    = len
    }
  };
  if(!qb_i2c)
    return -ENODEV;
  return i2c_transfer(qb_i2c->adapter, msgs, 2);
}


int gauge_write(uint8_t reg, uint8_t* buf, uint8_t len)
{
  int32_t i;
  uint8_t buf_w[64];
  struct i2c_msg msgs[] = {
    [0] = {
      .addr   = gauge_i2c_addr,
      .flags  = 0,
      .buf    = (void *)buf_w,
      .len    = len+1
    }
  };

  if(len >= sizeof(buf_w))  
    return -ENOMEM;

  if(!qb_i2c)
  return -ENODEV;

  memset(buf_w,0,sizeof(buf_w));
  buf_w[0] = reg;
  for(i=0; i<len; i++)
    buf_w[i+1] = buf[i];
  return i2c_transfer(qb_i2c->adapter, msgs, 1);
}

#ifdef QCS_BQ27500_GAUGE_SUPPORT

int16_t bq27500_gauge_temperature(void)
{
  int ret;
  uint8_t bat_temp_06_07[2];
  int16_t   temp;

  ret = gauge_read(BQ27500_REG_TEMP, bat_temp_06_07, sizeof(bat_temp_06_07));
  if (ret!=2)
  {
    MSG3("## BQ27500_REG_TEMP error");
    return ret;
  }
  temp = bat_temp_06_07[0] + (bat_temp_06_07[1]<<8);
  temp = (temp - 2731)/10; 

  return temp;
}


int16_t bq27500_gauge_voltage(void)
{
  int ret;
  uint8_t bat_volt_08_09[2];
  int16_t volt;

  ret = gauge_read(BQ27500_REG_VOLT, bat_volt_08_09, sizeof(bat_volt_08_09));
  if (ret!=2)
  {
    MSG3("## BQ27500_REG_VOLT error");
    return ret;
  }
  volt = bat_volt_08_09[0] + (bat_volt_08_09[1]<<8);

  return volt;
}


int16_t bq27500_gauge_flags(void)
{
  int ret;
  uint8_t bat_flags_0a_0b[2];
  int16_t flags;

  ret = gauge_read(BQ27500_REG_FLAGS, bat_flags_0a_0b, sizeof(bat_flags_0a_0b));
  if (ret!=2)
  {
    MSG3("## BQ27500_REG_FLAGS error");
    return ret;
  }
  flags = bat_flags_0a_0b[0] + (bat_flags_0a_0b[1]<<8);

  return flags;
}


int16_t bq27500_gauge_current(void)
{
  int ret;
  uint8_t bat_curr_14_15[2];
  int16_t chg_current;

  ret = gauge_read(BQ27500_REG_AI, bat_curr_14_15, sizeof(bat_curr_14_15));
  if (ret!=2)
  {
    MSG3("## BQ27500_REG_AI error");
    return 0;
  }
  chg_current = bat_curr_14_15[0] + (bat_curr_14_15[1]<<8);

  return chg_current;
}


int16_t bq27500_gauge_capacity(void)
{
  int ret;
  uint8_t bat_cap_2c_2d[2];
  int16_t capacity;

  ret = gauge_read(BQ27500_REG_SOC, bat_cap_2c_2d, sizeof(bat_cap_2c_2d));
  if (ret!=2)
  {
    MSG3("## BQ27500_REG_SOC error");
    return ret;
  }
  capacity = bat_cap_2c_2d[0] + (bat_cap_2c_2d[1]<<8);

  return capacity;
}

int16_t bq27500_gauge_init_DFI(void)
{
  int ret, end_l_size = 0;
  char gauge_cmd_data[2];
  char iRow;
  char yRowData[33];
  uint8_t * p_dfi = NULL;
  int i_loop = 0;

  bq27500_fw_size = sizeof(BQ27500FW);
  yDataFlashImage = kmalloc(bq27500_fw_size,GFP_KERNEL);

  for(i_loop=0;i_loop<bq27500_fw_size;i_loop++)
    yDataFlashImage[i_loop] = BQ27500FW[i_loop];
  i_loop = 0;

  gauge_cmd_data[0]=0x00;
  gauge_cmd_data[1]=0x0F;
  ret = gauge_write(0x00,gauge_cmd_data,sizeof(gauge_cmd_data));
  if (ret!=1)
  {
    MSG3("## bq27500_write 0x00 error");
    kfree(yDataFlashImage);
    return ret;
  }


  iRow = 0x00;
  do
  {
    ret = gauge_write(0x11,&iRow,sizeof(iRow));
    if (ret!=1)
    {
      MSG3("## bq27500_write 0x11 error iRow= %d",iRow);
      kfree(yDataFlashImage);
      return ret;
    }
    iRow += 2;
  }while(iRow < ((bq27500_fw_size+31)/32));


  iRow = 0x00;
  p_dfi = yDataFlashImage;
  do
  {
    yRowData[0] = iRow++;
    i_loop = 0;
    do
    {
      if(*p_dfi)
      {
        yRowData[i_loop++] = *p_dfi++;
      }
      else
      {
        end_l_size = i_loop;
        break;
      }
    }while(i_loop<32);

  
    if(end_l_size==0)
      ret = gauge_write(0x10,yRowData,sizeof(yRowData));
    else
      ret = gauge_write(0x10,yRowData,end_l_size);
    if (ret!=1)
    {
      MSG3("## bq27500_write 0x10 error iRow= %d",iRow);
      kfree(yDataFlashImage);
      return ret;
    }
  }while(iRow<((bq27500_fw_size+31)/32));


  ret = gauge_write(0x08,yRowData,sizeof(yRowData));
  if (ret!=1)
  {
    MSG3("## bq27500_write 0x08 error");
    kfree(yDataFlashImage);
    return ret;
  }

  
  kfree(yDataFlashImage);
  return 0;
}

#endif

#ifdef QCS_MAX17043_GAUGE_SUPPORT
int16_t max17043_gauge_voltage(void)
{
  int ret;
  uint8_t bat_volt_02_03[2];
  int16_t volt;

  ret = gauge_read(MAX17043_REG_VCELL, bat_volt_02_03, sizeof(bat_volt_02_03));
  if (ret!=2)
  {
    MSG3("## max17043_gauge_voltage error");
    return ret;
  }
  volt = (bat_volt_02_03[1]<<4) + (bat_volt_02_03[0]>>4);
  volt = (volt*10)/8;
  return volt;
}
int16_t max17043_gauge_capacity(void)
{
  int ret;
  uint8_t bat_capacity_04_05[2];
  int16_t capacity;

  ret = gauge_read(MAX17043_REG_SOC, bat_capacity_04_05, sizeof(bat_capacity_04_05));
  if (ret!=2)
  {
    MSG3("## max17043_gauge_capacity error");
    return ret;
  }
  capacity = (bat_capacity_04_05[1]);

  return capacity;
}
int16_t max17043_gauge_init(void)
{
  int ret;
  char buf[2];
  buf[1] = 0x40;
  buf[0] = 0x00;
  ret = gauge_write(MAX17043_REG_MODE, buf, 2);
  if (ret!=1)
  {
    MSG3("#ERROR# max17043_gauge_init error");
  }
  return ret;
}
int16_t max17043_gauge_reset(void)
{
  int ret;
  char buf[2];
  buf[1] = 0x54;
  buf[0] = 0x00;
  ret = gauge_write(MAX17043_REG_COMMAND, buf, 2);
  if (ret!=1)
  {
    MSG3("#ERROR# max17043_gauge_reset error");
  }
  return ret;
}
#endif

int16_t qsd_gauge_init(void)
{
  uint8_t reg;
  uint8_t dev_name_len[1];
  uint8_t dev_name[7];
  uint8_t len;
  int ret, i_loop;
  int vbat;
  struct i2c_msg msgs[2];
  
#ifdef QCS_BQ27500_GAUGE_SUPPORT
  reg = 0x62;
  len = 1;

  msgs[0].addr   = 0x55;
  msgs[0].flags  = 0;
  msgs[0].buf    = (void *)&reg;
  msgs[0].len    = 1;

  msgs[1].addr   = 0x55;
  msgs[1].flags  = I2C_M_RD;
  msgs[1].buf    = (void *)dev_name_len;
  msgs[1].len    = len;

  if(!qb_i2c)
    return -ENODEV;
  for(i_loop=0;i_loop<5;i_loop++)
  {
    ret = i2c_transfer(qb_i2c->adapter, msgs, 2);
    if(ret == 2)
      break;
    else
      msleep(10);
  }
  if((ret==2)&&(dev_name_len[0] != 0)&&(dev_name_len[0] < 8))
  {

    reg = 0x63;
    len = dev_name_len[0];

    msgs[0].addr   = 0x55;
    msgs[0].flags  = 0;
    msgs[0].buf    = (void *)&reg;
    msgs[0].len    = 1;

    msgs[1].addr   = 0x55;
    msgs[1].flags  = I2C_M_RD;
    msgs[1].buf    = (void *)dev_name;
    msgs[1].len    = len;

    for(i_loop=0;i_loop<5;i_loop++)
    {
      ret = i2c_transfer(qb_i2c->adapter, msgs, 2);
      if(ret == 2)
        break;
      else
        msleep(10);
    }
    if((ret==2)&&(dev_name[0] != 0))
    {
      gauge_i2c_addr = BQ_GAUGE_ADDR;
      g_bq27500_on = 1;
      MSG3("qsd_gauge_init dev_name = %s", dev_name);
      MSG3("qsd_gauge_init auto choose gauge IC I2C ADDR = 0x%x", gauge_i2c_addr); 
      return 0;
    }
  }
#endif

#ifdef QCS_MAX17043_GAUGE_SUPPORT
  reg = MAX17043_REG_VCELL;
  len = 2;
  msgs[0].addr   = 0x36;
  msgs[0].flags  = 0;
  msgs[0].buf    = (void *)&reg;
  msgs[0].len    = 1;

  msgs[1].addr   = 0x36;
  msgs[1].flags  = I2C_M_RD;
  msgs[1].buf    = (void *)dev_name;
  msgs[1].len    = len;
  for(i_loop=0;i_loop<5;i_loop++)
  {
    ret = i2c_transfer(qb_i2c->adapter, msgs, 2);
    if(ret == 2)
      break;
    else
      msleep(10);
  }
  
  vbat = (dev_name[1]<<4) + (dev_name[0]>>4);
  vbat = (vbat * 10) /8;
  if((ret==2)&&(vbat != 0))
  {
    gauge_i2c_addr = MAX_GAUGE_ADDR;
    g_max17043_on = 1;
    MSG3("qsd_gauge_init MAX vbat = %d mV", vbat);
  }
#endif
  vbat = 0;
  dev_name_len[0] = 0;
  MSG3("qsd_gauge_init auto choose gauge IC I2C ADDR = 0x%x", gauge_i2c_addr); 
  return 0;
}
