#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/ioctl.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/errno.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/device.h>
#include <linux/miscdevice.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <linux/poll.h>

#include <mach/msm_iomap.h>

#define	MTRACE_IS_PAGE_ALIGNED(addr)	(!((addr) & (~PAGE_MASK)))

static void __iomem	*modem_logger_buffer = 0;
static unsigned long/*phys_addr_t*/ modem_logger_buffer_phy ;

void modem_logger_reinit(void)
{
	unsigned long addrPhy = MSM_F3_BUF_PHYS;
	
	if (!strncmp((char*)modem_logger_buffer, "F3LogBuffer_S",13))
	{
		printk(KERN_ERR "%s: already init-ed \n",__func__);
		return ;
	}
		
	iounmap(modem_logger_buffer);	
	
	do{
		printk(KERN_INFO  "addrPhy %x \n",(unsigned int)addrPhy);
		modem_logger_buffer = ioremap((phys_addr_t)addrPhy,MSM_F3_BUF_SIZE);
		if ( unlikely(!modem_logger_buffer)) {
			printk(KERN_ERR "%s: failed to map modem image \n",__func__);
		}
		
		if (!strncmp((char*)modem_logger_buffer, "F3LogBuffer_S",13))
		{
			modem_logger_buffer_phy = addrPhy;
			printk(KERN_INFO  "modem_logger_buffer_phy %x \n",(unsigned int)modem_logger_buffer_phy);
			return ;
		}
		
		iounmap(modem_logger_buffer);	
		addrPhy += MSM_F3_BUF_SIZE_ALIGN;
	}while((MSM_F3_BUF_PHYS_END - MSM_F3_BUF_SIZE) >= addrPhy);
}

static int modem_logger_mmap(struct file *filp, struct vm_area_struct *vma)
{
	unsigned long	addr;
	unsigned long	length = vma->vm_end - vma->vm_start;

	printk(KERN_INFO "%s, length is 0x%x\n", __func__,(unsigned int)length);

	modem_logger_reinit();
	
	if (strncmp((char*)modem_logger_buffer, "F3LogBuffer_S",13)) {
		printk(KERN_ERR "%s: No modem image available.\n", __func__);
		return -ENOMEM;
	}

	printk(KERN_INFO "%s, magic is %s\n", __func__,(char*)modem_logger_buffer);

	if (!MTRACE_IS_PAGE_ALIGNED(length)) {
		printk(KERN_ERR "%s: Invalid length.\n", __func__);
		return -EINVAL;
	}

#if 0	
	if (vma->vm_flags & VM_WRITE) {
		printk(KERN_ERR "%s: Permission denied.\n",__func__);
		return -EPERM;
	}
#endif

	vma->vm_page_prot = pgprot_noncached(vma->vm_page_prot);

	addr = (unsigned long)modem_logger_buffer_phy;
	addr &= ~(PAGE_SIZE - 1);
	addr &= 0xffffffffUL;

	printk(KERN_INFO "%s, addr is 0x%x\n", __func__,(unsigned int)addr);

	if (io_remap_pfn_range(vma, vma->vm_start, addr >> PAGE_SHIFT,
				length, vma->vm_page_prot)) {
		printk(KERN_ERR "remap_pfn_range failed in %s\n",__FILE__);
		return -EAGAIN;
	}

	return 0;
}

static int modem_logger_open(struct inode *inode, struct file *file)
{
	return 0;
}

static ssize_t modem_logger_write( struct file *fp,const char __user *buffer,size_t count,loff_t *ppos )
{
	#define ECHOSTR_SIZE 32
	char echostr[ECHOSTR_SIZE];
	
	char* strPtr;
	
	if (!modem_logger_buffer) {
		printk(KERN_ERR "%s: No modem image available.\n", __func__);
		return -ENOMEM;
	}
	
	strPtr = (char*)((unsigned long)modem_logger_buffer);

	if ( count > ECHOSTR_SIZE )
	{
		printk(KERN_ERR "invalid count %d\n in %s\n",count,__FILE__);
		return -EINVAL;
	}
	
	if ( copy_from_user(echostr,buffer,count) )
	{
		printk(KERN_ERR  "copy Echo String from user failed: %s\n",echostr);
		return -EINVAL;
	}
	echostr[count-1]='\0';
	

	if ( strcmp(echostr,"init" ) == 0 )
	{
		modem_logger_reinit();	
	}
	else if ( strcmp(echostr,"read" ) == 0 )
	{
		printk(KERN_ERR  "User Input Echo String : %s\n",echostr);
		printk(KERN_ERR  "*(char*)modem_logger_buffer is %s \n",(char*)modem_logger_buffer);
	}
	
	return count;    
}

static int modem_logger_release(struct inode *inode , struct file *file)
{
	return 0;
}

static struct file_operations modem_logger_fops = {
	.owner = THIS_MODULE,
	.mmap = modem_logger_mmap,
	.open = modem_logger_open,
	.write = modem_logger_write,
	.release = modem_logger_release,
};

static struct miscdevice modem_logger_device = {
	.minor = MISC_DYNAMIC_MINOR,
	.name = "log_modem",
	.fops = &modem_logger_fops,
	.parent = NULL,
};

static int __init modem_logger_init(void)
{
	int ret;
	

	modem_logger_buffer = ioremap(MSM_F3_BUF_PHYS,MSM_F3_BUF_SIZE);
	if ( unlikely(!modem_logger_buffer)) {
		printk(KERN_ERR "%s: failed to map modem image \n",__func__);
	}
	else {
		modem_logger_buffer_phy = MSM_F3_BUF_PHYS;
		printk(KERN_INFO "%s: map modem image, modem_logger_buffer_phy is 0x%x \n",__func__, (unsigned int)modem_logger_buffer_phy);
	}		

	ret = misc_register(&modem_logger_device);
	if( unlikely(ret)) {
		printk(KERN_ERR "%s: failed to register misc \n",__func__);
		return ret;
	}

	return 0;
}

static void __exit modem_logger_exit(void)
{
	if (modem_logger_buffer) iounmap(modem_logger_buffer);	
}

module_init(modem_logger_init);
module_exit(modem_logger_exit);
