
#include <linux/kobject.h>
#include <linux/init.h>
#include <linux/string.h>


int bl_duty_cycle = 0;
int bl_frequency = 0;


#define lcd_attr(_name) \
static struct kobj_attribute _name##_attr = {	\
	.attr	= {				\
		.name = __stringify(_name),	\
		.mode = 0644,			\
	},					\
	.show	= _name##_show,			\
	.store	= _name##_store,		\
}

static ssize_t bl_duty_cycle_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	sprintf(buf, "%d",	bl_duty_cycle);

	return strlen(buf);
}

static ssize_t bl_duty_cycle_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	return 0;
}
lcd_attr(bl_duty_cycle);

static ssize_t bl_frequency_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	sprintf(buf, "%d", bl_frequency);

	return strlen(buf);
}

static ssize_t bl_frequency_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	return 0;
}
lcd_attr(bl_frequency);


#include <linux/platform_device.h>
extern  int lcdc_panel_on(struct platform_device *pdev);
extern  int lcdc_panel_off(struct platform_device *pdev);

static char enable = '1';
static ssize_t lcd_display_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	sprintf(buf, "%c", enable);
	return strlen(buf);
}

static ssize_t lcd_display_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
#ifdef CONFIG_BOARD_IS_ORANGE
	if (*buf == '0') {
		if (enable == '1') {		
			printk("Use sysfs to let panel off!\n");
			enable = '0';
			lcdc_panel_off(NULL);
		}
	} else if (*buf == '1') {
		if (enable == '0') {
			printk("Use sysfs to let panel on!\n");
			enable = '1';
			lcdc_panel_on(NULL);
		}
	}
#endif
	return 0;
}
lcd_attr(lcd_display);



static struct attribute * g[] = {
	&bl_duty_cycle_attr.attr,
	&bl_frequency_attr.attr,
	&lcd_display_attr.attr,
	NULL,
};

static struct attribute_group attr_group = {
	.attrs = g,
};


static int   __init lcd_sysfs_init(void)
{
	struct kobject *lcd_kobj;
	lcd_kobj = kobject_create_and_add("lcd", NULL);
	if (!lcd_kobj)
		return -ENOMEM;
	
	return sysfs_create_group(lcd_kobj, &attr_group);
}

core_initcall(lcd_sysfs_init);

