




#include <linux/delay.h>
#include <linux/pwm.h>
#ifdef CONFIG_PMIC8058_PWM
#include <linux/mfd/pmic8058.h>
#include <linux/pmic8058-pwm.h>
#endif

#include "msm_fb.h"
#include "lcd_sysfs.h"

#include <linux/gpio/gpio_def.h>
#include <asm-generic/gpio.h>

#ifdef 	LVDS_PWDN	
	if (ret) {
		printk("request gpio LCM_LED_EN failed!\n");
		return ret;
	}
	
	ret = gpio_request(LVDS_PWDN, "LVDS_PWDN");
	if (ret) {
		printk("request gpio LVDS_PWDN failed!\n");
		gpio_free(LVDS_LCM_EN);
		return ret;
	}
	
	for (i=0; i<28; i++) {
		ret = gpio_request(i, "gpio-i");
		if (ret) {
			printk("request gpio %d failed!\n", i);
			gpio_free(LVDS_LCM_EN);
			gpio_free(LVDS_PWDN);
			for (j=0; j<i; j++) {
				gpio_free(j);
			}
			break;
		}
	}

	return ret;
}




#ifdef CONFIG_TOUCHSCREEN_SOFTKEY
#include "softkey_icon.h"
#endif

static  int lcdc_panel_on(struct platform_device *pdev)
{
	static unsigned int count = 0;
	struct msm_fb_data_type mfd;
	
	printk("%s() ...\n", __func__);

	pdata->led_power(ON);

	pdata->logic_power(ON);
	lcdc_transmitter_enable();
	
	lcdc_backlight_enable();

	if (count == 0) {
		mfd.bl_level = 7;
		lcdc_set_backlight(&mfd);
		count++;
	}

#ifdef CONFIG_TOUCHSCREEN_SOFTKEY
		icon_display = 1;
#endif
	return 0;
}

static int lcdc_panel_off(struct platform_device *pdev)
{
	printk("%s() ...\n", __func__);

	lcdc_backlight_disable();
	pdata->led_power(OFF);

	lcdc_transmitter_disable();
	pdata->logic_power(OFF);
	
	return 0;
}


#ifdef CONFIG_PMIC8058_PWM
static struct pwm_device *bl_pwm;
#define PWM_FREQ_HZ 		300
#define PWM_PERIOD_USEC 	(USEC_PER_SEC / PWM_FREQ_HZ)
#define PWM_LEVEL 		15
#define PWM_DUTY_LEVEL 		(PWM_PERIOD_USEC / PWM_LEVEL)
#endif

static  void lcdc_set_backlight(struct msm_fb_data_type *mfd)
{
	int bl_level;
	int ret = 0;

	pr_debug(" %s: level:%d...\n", __func__, mfd->bl_level);
	bl_level = mfd->bl_level;
	if (bl_level > PWM_LEVEL) {
		bl_level = PWM_LEVEL;
	}
	else if (bl_level < 0) {
		bl_level = 0;
	}

	bl_duty_cycle = (PWM_DUTY_LEVEL*bl_level*100)/PWM_PERIOD_USEC;
	
#ifdef  CONFIG_PMIC8058_PWM
	if (bl_pwm){
		pwm_config(bl_pwm, PWM_DUTY_LEVEL*bl_level, PWM_PERIOD_USEC);
		if (ret)
			pr_err("pwm_config() failed!\n");

		ret = pwm_enable(bl_pwm);
		if (ret)
			pr_err("pwm_enable() failed!\n");
	}
#endif
	return ;
}


static int lcdc_init(void)
{
	int ret;
	
	ret = lcdc_gpio_config();
	if (ret)
		return ret;
	
	lcdc_transmitter_disable();
	lcdc_backlight_disable();

	return ret;
}

static int  lcdc_panel_probe(struct platform_device *pdev)
{
	int ret = 0;
	
	if (pdev->id == 0) {
		pdata = pdev->dev.platform_data;
#ifdef CONFIG_PMIC8058_PWM
		bl_pwm = pwm_request(*(pdata->gpio_num), "b070ew01_backlight");

		if (bl_pwm == NULL || IS_ERR(bl_pwm)) {
			pr_err("%s pwm_request() failed!\n", __func__);
			bl_pwm = NULL;
		}

		printk("%s: bl_pwm = 0x%p LPG_chan0 = %d\n", __func__, bl_pwm, pdata->gpio_num[0]);
		bl_frequency = PWM_FREQ_HZ;
#endif
		return 0;
	}

	ret = lcdc_init();
	if (ret) 
		return ret;
	
	msm_fb_add_device(pdev);

	return ret;
}


static int __devexit lcdc_panel_remove(struct platform_device *pdev)
{
	pwm_free(bl_pwm);
	return 0;
}

static struct platform_driver this_driver = {
	.probe  = lcdc_panel_probe,
	.remove = lcdc_panel_remove,
	.driver = {
		.name   = driver_name,
	},
};


static struct msm_fb_panel_data b070ew01_panel_data = {
	.on 	= lcdc_panel_on,		
	.off 	= lcdc_panel_off,
	.set_backlight = lcdc_set_backlight,
};


static struct platform_device this_device = {
	.name   	= driver_name,
	.id	= 1,
	.dev	= {
		.platform_data = &b070ew01_panel_data,
	}
};

static int __init lcdc_panel_init(void)
{
	int ret = 0;
	struct msm_panel_info *pinfo;
	
	printk("%s() ...\n", __func__);

	ret = platform_driver_register(&this_driver);
	if (ret)
		return ret;

	pinfo  = &b070ew01_panel_data.panel_info;
	pinfo->xres = 1280;
	pinfo->yres = 800;
	pinfo->type = LCDC_PANEL;
	pinfo->pdest = DISPLAY_1;
	pinfo->wait_cycle = 0;
	pinfo->bpp = 18;			
	pinfo->fb_num = 2;
	pinfo->clk_rate = 64000000;	
	pinfo->bl_max = PWM_LEVEL;		
	pinfo->bl_min = 1;
	pinfo->lcdc.h_back_porch = 80;
	pinfo->lcdc.h_front_porch = 48;
	pinfo->lcdc.h_pulse_width = 32;
	pinfo->lcdc.v_back_porch = 15;
	pinfo->lcdc.v_front_porch = 2;
	pinfo->lcdc.v_pulse_width = 6;
	pinfo->lcdc.border_clr = 0;
	pinfo->lcdc.underflow_clr = 0xff;
	pinfo->lcdc.hsync_skew = 0;
	strcpy(pinfo->version, "LG_B070EW01_V0");
	ret = platform_device_register(&this_device);
	if (ret)
		platform_driver_unregister(&this_driver);

	return ret;
}
module_init(lcdc_panel_init);
#endif	