




#include <linux/delay.h>
#include <linux/pwm.h>
#ifdef CONFIG_PMIC8058_PWM
#include <linux/mfd/pmic8058.h>
#include <linux/pmic8058-pwm.h>
#endif

#include "msm_fb.h"

#include <linux/regulator/pmic8058-regulator.h>
#include <linux/regulator/consumer.h>

#include <linux/gpio/gpio_def.h>
#include <asm-generic/gpio.h>

#define 	LEVEL_HIGH		1
#define 	LEVEL_LOW		0

#define 	ON	1
#define 	OFF	0


static struct msm_panel_common_pdata *pdata;

static int lcdc_gpio_config(void)
{
	int ret;
	int i,j;
	
	ret = gpio_request(LVDS_LED_EN, "LVDS_LED_EN");
	if (ret) {
		printk("request gpio LVDS_LED_EN failed!\n");
		return ret;
	}
	
	ret = gpio_request(LVDS_PWDN, "LVDS_PWDN");
	if (ret) {
		printk("request gpio LVDS_PWDN failed!\n");
		gpio_free(LVDS_LED_EN);
		return ret;
	}
	
	for (i=0; i<28; i++) {
		ret = gpio_request(i, "gpio-i");
		if (ret) {
			printk("request gpio %d failed!\n", i);
			gpio_free(LVDS_LED_EN);
			gpio_free(LVDS_PWDN);
			for (j=0; j<i; j++) {
				gpio_free(j);
			}
			break;
		}
	}

	return ret;
}



#define lcdc_backlight_enable()	gpio_direction_output(LVDS_LED_EN, LEVEL_HIGH)
#define lcdc_backlight_disable()	gpio_direction_output(LVDS_LED_EN, LEVEL_LOW)
#define lcdc_transmitter_enable()	gpio_direction_output(LVDS_PWDN, LEVEL_HIGH)
#define lcdc_transmitter_disable()	gpio_direction_output(LVDS_PWDN, LEVEL_LOW)

#define TEMP_LEVEL	3
static  void lcdc_set_backlight(struct msm_fb_data_type *mfd);
static  int lcdc_panel_on(struct platform_device *pdev)
{
	struct msm_fb_data_type mfd;
	
	printk("%s() ...\n", __func__);

	pdata->led_power(ON);
	pdata->logic_power(ON);
	lcdc_transmitter_enable();
	
	lcdc_backlight_enable();
	
	mfd.bl_level = TEMP_LEVEL;
	lcdc_set_backlight(&mfd);
	
	return 0;
}

static int lcdc_panel_off(struct platform_device *pdev)
{
	printk("%s() ...\n", __func__);

	lcdc_backlight_disable();
	pdata->led_power(OFF);

	lcdc_transmitter_disable();
	pdata->logic_power(OFF);
	
	return 0;
}


#ifdef CONFIG_PMIC8058_PWM
static struct pwm_device *bl_pwm;
#define PWM_FREQ_HZ 		300
#define PWM_PERIOD_USEC 	(USEC_PER_SEC / PWM_FREQ_HZ)
#define PWM_LEVEL 		15
#define PWM_DUTY_LEVEL 		(PWM_PERIOD_USEC / PWM_LEVEL)
#endif

static  void lcdc_set_backlight(struct msm_fb_data_type *mfd)
{
	int bl_level;
	int ret = 0;

	