

#include <linux/delay.h>
#include <linux/pwm.h>

#include <mach/gpio.h>
#include "msm_fb.h"
#include <linux/pmic8058-othc.h>
#include <linux/mfd/pmic8901.h>
#include <linux/regulator/pmic8058-regulator.h>
#include <linux/regulator/pmic8901-regulator.h>
#include <linux/regulator/consumer.h>
#include <linux/regulator/machine.h>

#define DBG_MONITOR 0
#define ENABLE_ESD 0
#define ENABLE_SPI_DELAY 0
#define ENABLE_CTL_PWR 1
#define ENABLE_GPIO_RESET 1
#define ENABLE_ACL_CTL 0
#define ENABLE_ELVSS_CTL 1
#define ENABLE_ROTATE_180 0
#define BYTE_PER_TRANS 3

#if ENABLE_ESD
#define ENABLE_SPI_READ 1
#else
#define ENABLE_SPI_READ 0
#endif

#define LCDC_LOG_ENABLE 1
#define LCDC_LOG_DBG 1
#define LCDC_LOG_INFO 1
#define LCDC_LOG_WARNING 1
#define LCDC_LOG_ERR 1



#define LCDC_S6E63M0_GAMMA_TABLE_MAX 23

#define LCDC_S6E63M0_PANEL_CON_CMD 0xF8
#define LCDC_S6E63M0_PANEL_CON_PARAM1_DOTC		0x01
#define LCDC_S6E63M0_PANEL_CON_PARAM2_CLWEA	0x27
#define LCDC_S6E63M0_PANEL_CON_PARAM3_CLWEB	0x27
#define LCDC_S6E63M0_PANEL_CON_PARAM4_CLTE		0x07
#define LCDC_S6E63M0_PANEL_CON_PARAM5_SHE		0x07
#define LCDC_S6E63M0_PANEL_CON_PARAM6_FLTE		0x54
#define LCDC_S6E63M0_PANEL_CON_PARAM7_FLWE		0x9F
#define LCDC_S6E63M0_PANEL_CON_PARAM8_SCTE		0x63
#define LCDC_S6E63M0_PANEL_CON_PARAM9_SCWE		0x86
#define LCDC_S6E63M0_PANEL_CON_PARAM10_INTE	0x1A
#define LCDC_S6E63M0_PANEL_CON_PARAM11_INWE	0x33
#define LCDC_S6E63M0_PANEL_CON_PARAM12_EMPS	0x0D
#define LCDC_S6E63M0_PANEL_CON_PARAM13_E_INTE	0x00
#define LCDC_S6E63M0_PANEL_CON_PARAM14_E_INWE	0x00

#define LCDC_S6E63M0_DISPCTL_CMD 0xF2
#define LCDC_S6E63M0_DISPCTL_PARAM1_NL			0x02
#define LCDC_S6E63M0_DISPCTL_PARAM2_VBP			0x03
#define LCDC_S6E63M0_DISPCTL_PARAM3_VFP			0x1C
#define LCDC_S6E63M0_DISPCTL_PARAM4_HBP			0x10
#define LCDC_S6E63M0_DISPCTL_PARAM5_HFP			0x10

#define LCDC_S6E63M0_GTCON_CMD 0xF7
#if ENABLE_ROTATE_180
#define LCDC_S6E63M0_GTCON_PARAM1_GTCON_SS		0x03
#else
#define LCDC_S6E63M0_GTCON_PARAM1_GTCON_SS		0x00
#endif
#define LCDC_S6E63M0_GTCON_PARAM2_DM			0x00
#define LCDC_S6E63M0_GTCON_PARAM3_XPL_RIM		0x00

#define LCDC_S6E63M0_ETC_F6_CMD 0xF6
#define LCDC_S6E63M0_ETC_F6_PARAM1			0x00
#define LCDC_S6E63M0_ETC_F6_PARAM2			0x8E
#define LCDC_S6E63M0_ETC_F6_PARAM3			0x07

#define LCDC_S6E63M0_ETC_B3_CMD 0xB3
#define LCDC_S6E63M0_ETC_B3_PARAM1			0x0C

#define LCDC_S6E63M0_TEMP_SWIRE_CMD 0xB2
#define LCDC_S6E63M0_TEMP_SWIRE_PARAM1			0x0C
#define LCDC_S6E63M0_TEMP_SWIRE_PARAM2			0x0C
#define LCDC_S6E63M0_TEMP_SWIRE_PARAM3			0x08
#define LCDC_S6E63M0_TEMP_SWIRE_PARAM4			0x02

#define LCDC_S6E63M0_ELVSS_CON_CMD 0xB1
#define LCDC_S6E63M0_ELVSS_CON_PARAM1_OFF		0x0A
#define LCDC_S6E63M0_ELVSS_CON_PARAM1_ON		0x0B

#define LCDC_S6E63M0_ACL_LUT_CMD 0xC1
#define LCDC_S6E63M0_ACL_LUT_PARAM1_AKR			0x4D
#define LCDC_S6E63M0_ACL_LUT_PARAM2_AKG			0x96
#define LCDC_S6E63M0_ACL_LUT_PARAM3_AKB			0x1D
#define LCDC_S6E63M0_ACL_LUT_PARAM4_AHSP		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM5_AHSP		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM6_AHEP		0x01
#define LCDC_S6E63M0_ACL_LUT_PARAM7_AHEP		0xDF
#define LCDC_S6E63M0_ACL_LUT_PARAM8_AVSP		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM9_AVSP		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM10_AVEP		0x03
#define LCDC_S6E63M0_ACL_LUT_PARAM11_AVEP		0x1F
#define LCDC_S6E63M0_ACL_LUT_PARAM12_DY0		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM13_DY1		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM14_DY2		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM15_DY3		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM16_DY4		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM17_DY5		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM18_DY6		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM19_DY7		0x00
#define LCDC_S6E63M0_ACL_LUT_PARAM20_DY8		0x03
#define LCDC_S6E63M0_ACL_LUT_PARAM21_DY9		0x07
#define LCDC_S6E63M0_ACL_LUT_PARAM22_DY10		0x0A
#define LCDC_S6E63M0_ACL_LUT_PARAM23_DY11		0x0E
#define LCDC_S6E63M0_ACL_LUT_PARAM24_DY12		0x11
#define LCDC_S6E63M0_ACL_LUT_PARAM25_DY13		0x14
#define LCDC_S6E63M0_ACL_LUT_PARAM26_DY14		0x18
#define LCDC_S6E63M0_ACL_LUT_PARAM27_DY15		0x1B

#define LCDC_S6E63M0_ACL_CON_CMD 0xC0
#define LCDC_S6E63M0_ACL_CON_PARAM1_ON			0x01
#define LCDC_S6E63M0_ACL_CON_PARAM1_OFF			0x00

#define LCDC_S6E63M0_GAMMA_CTL_CMD 0xFA
#define LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE	0x02
#define LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_ENABLE	0x03

#define LCDC_S6E63M0_SLPIN_CMD 0x10
#define LCDC_S6E63M0_SLPOUT_CMD 0x11

#define LCDC_S6E63M0_DISPOFF_CMD 0x28
#define LCDC_S6E63M0_DISPON_CMD 0x29

#define LCDC_S6E63M0_VPW 2
#define LCDC_S6E63M0_VBP (LCDC_S6E63M0_DISPCTL_PARAM2_VBP - LCDC_S6E63M0_VPW)
#define LCDC_S6E63M0_VFP LCDC_S6E63M0_DISPCTL_PARAM3_VFP
#define LCDC_S6E63M0_HPW 2
#define LCDC_S6E63M0_HBP (LCDC_S6E63M0_DISPCTL_PARAM4_HBP - LCDC_S6E63M0_HPW)
#define LCDC_S6E63M0_HFP LCDC_S6E63M0_DISPCTL_PARAM5_HFP


#define spi_cs 35
#define spi_sclk 36
#define spi_mosi 33
#define spi_miso 34

static uint8_t panel_con_set_default_value[] = {
	LCDC_S6E63M0_PANEL_CON_PARAM1_DOTC,
	LCDC_S6E63M0_PANEL_CON_PARAM2_CLWEA,
	LCDC_S6E63M0_PANEL_CON_PARAM3_CLWEB,
	LCDC_S6E63M0_PANEL_CON_PARAM4_CLTE,
	LCDC_S6E63M0_PANEL_CON_PARAM5_SHE,
	LCDC_S6E63M0_PANEL_CON_PARAM6_FLTE,
	LCDC_S6E63M0_PANEL_CON_PARAM7_FLWE,
	LCDC_S6E63M0_PANEL_CON_PARAM8_SCTE,
	LCDC_S6E63M0_PANEL_CON_PARAM9_SCWE,
	LCDC_S6E63M0_PANEL_CON_PARAM10_INTE,
	LCDC_S6E63M0_PANEL_CON_PARAM11_INWE,
	LCDC_S6E63M0_PANEL_CON_PARAM12_EMPS,
	LCDC_S6E63M0_PANEL_CON_PARAM13_E_INTE,
	LCDC_S6E63M0_PANEL_CON_PARAM14_E_INWE
};

static uint8_t dispctl_set_default_value[] = {
	LCDC_S6E63M0_DISPCTL_PARAM1_NL,
	LCDC_S6E63M0_DISPCTL_PARAM2_VBP,
	LCDC_S6E63M0_DISPCTL_PARAM3_VFP,
	LCDC_S6E63M0_DISPCTL_PARAM4_HBP,
	LCDC_S6E63M0_DISPCTL_PARAM5_HFP
};

static uint8_t gtcon_set_default_value[] = {
	LCDC_S6E63M0_GTCON_PARAM1_GTCON_SS,
	LCDC_S6E63M0_GTCON_PARAM2_DM,
	LCDC_S6E63M0_GTCON_PARAM3_XPL_RIM
};
#if 1
static uint8_t etc_f6_set_default_value[] = {
	LCDC_S6E63M0_ETC_F6_PARAM1,
	LCDC_S6E63M0_ETC_F6_PARAM2,
	LCDC_S6E63M0_ETC_F6_PARAM3
};

static uint8_t etc_b3_set_default_value[] = {
	LCDC_S6E63M0_ETC_B3_PARAM1
};


static uint8_t temp_swire_set_default_value[] = {
	LCDC_S6E63M0_TEMP_SWIRE_PARAM1,
	LCDC_S6E63M0_TEMP_SWIRE_PARAM2,
	LCDC_S6E63M0_TEMP_SWIRE_PARAM3,
	LCDC_S6E63M0_TEMP_SWIRE_PARAM4
};

static uint8_t elvss_con_set_default_value[] = {
	LCDC_S6E63M0_ELVSS_CON_PARAM1_ON
};




static uint8_t brightness_gamma_table[LCDC_S6E63M0_GAMMA_TABLE_MAX][22] = {
		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x8B, 0x45, 0x63, 0xC9,
			0xC7, 0xBC, 0xC2, 0xC7, 0xB7, 0xD4, 0xD7,
			0xCB, 0x00, 0x63, 0x00, 0x5E, 0x00, 0x80},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x85, 0x49, 0x5C, 0xC7,
			0xC7, 0xBA, 0xC1, 0xC6, 0xB6, 0xD3, 0xD6,
			0xCA, 0x00, 0x69, 0x00, 0x64, 0x00, 0x88},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x80, 0x4F, 0x59, 0xC6,
			0xC7, 0xB9, 0xC0, 0xC5, 0xB5, 0xD0, 0xD4,
			0xC8, 0x00, 0x70, 0x00, 0x6A, 0x00, 0x90},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x7E, 0x55, 0x58, 0xC4,
			0xC5, 0xB7, 0xBF, 0xC4, 0xB3, 0xD0, 0xD4,
			0xC8, 0x00, 0x75, 0x00, 0x6F, 0x00, 0x97},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x7E, 0x5B, 0x59, 0xC4,
			0xC6, 0xB7, 0xBE, 0xC2, 0xB1, 0xCE, 0xD3,
			0xC6, 0x00, 0x7A, 0x00, 0x74, 0x00, 0x9F},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x79, 0x5B, 0x52, 0xC4,
			0xC6, 0xB7, 0xBD, 0xC2, 0xB1, 0xCE, 0xD2,
			0xC6, 0x00, 0x7E, 0x00, 0x78, 0x00, 0xA3},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x7A, 0x5D, 0x54, 0xC0,
			0xC5, 0xB5, 0xBD, 0xC2, 0xB1, 0xCC, 0xD0,
			0xC3, 0x00, 0x83, 0x00, 0x7D, 0x00, 0xAA},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x75, 0x5E, 0x4F, 0xC2,
			0xC5, 0xB5, 0xBB, 0xC1, 0xB0, 0xCC, 0xCF,
			0xC3, 0x00, 0x87, 0x00, 0x81, 0x00, 0xAF},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x79, 0x61, 0x53, 0xC1,
			0xC5, 0xB4, 0xB8, 0xBE, 0xAC, 0xC8, 0xCD,
			0xC0, 0x00, 0x90, 0x00, 0x82, 0x00, 0xB5},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x75, 0x62, 0x50, 0xBF,
			0xC3, 0xB2, 0xBA, 0xBF, 0xAE, 0xCB, 0xCF,
			0xC3, 0x00, 0x8F, 0x00, 0x88, 0x00, 0xB9},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x74, 0x65, 0x50, 0xBF,
			0xC3, 0xB2, 0xB9, 0xBE, 0xAD, 0xC9, 0xCD,
			0xC0, 0x00, 0x93, 0x00, 0x8C, 0x00, 0xBF},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x73, 0x66, 0x50, 0xBE,
			0xC2, 0xB1, 0xB9, 0xBE, 0xAC, 0xC9, 0xCD,
			0xC1, 0x00, 0x96, 0x00, 0x8F, 0x00, 0xC3},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x70, 0x64, 0x4D, 0xC0,
			0xC4, 0x63, 0xB7, 0xBC, 0xAA, 0xC8, 0xCC,
			0xC0, 0x00, 0x9A, 0x00, 0x93, 0x00, 0xC8},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x70, 0x64, 0x4D, 0xBF,
			0xC3, 0xB2, 0xB7, 0xBC, 0xAA, 0xC7, 0xCB,
			0xBF, 0x00, 0x9D, 0x00, 0x96, 0x00, 0xCC},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x72, 0x67, 0x4E, 0xBE,
			0xC2, 0xB1, 0xB6, 0xBC, 0xAA, 0xC6, 0xCA,
			0xBE, 0x00, 0xA1, 0x00, 0x99, 0x00, 0xD0},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x6E, 0x62, 0x47, 0xBD,
			0xC2, 0xB1, 0xB5, 0xBB, 0xA9, 0xC5, 0xC9,
			0xBC, 0x00, 0xA5, 0x00, 0x9D, 0x00, 0xD6},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x6D, 0x67, 0x4A, 0xBE,
			0xC2, 0xB1, 0xB4, 0xBA, 0xA8, 0xC5, 0xC9,
			0xBC, 0x00, 0xA7, 0x00, 0x9F, 0x00, 0xD9},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x6C, 0x66, 0x49, 0xBD,
			0xC1, 0xB2, 0xB4, 0xBA, 0xA8, 0xC5, 0xC9,
			0xBC, 0x00, 0xAA, 0x00, 0xA2, 0x00, 0xDD},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x6B, 0x68, 0x48, 0xBC,
			0xC0, 0xAF, 0xB3, 0xB9, 0xA7, 0xC4, 0xC8,
			0xBB, 0x00, 0xAD, 0x00, 0xA5, 0x00, 0xE1},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x6B, 0x65, 0x48, 0xBD,
			0xC2, 0xB0, 0xB3, 0xB8, 0xA7, 0xC3, 0xC8,
			0xBB, 0x00, 0xB1, 0x00, 0xA8, 0x00, 0xE5},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x6B, 0x65, 0x48, 0xBC,
			0xC0, 0xAF, 0xB2, 0xB9, 0xA6, 0xC3, 0xC7,
			0xBA, 0x00, 0xB3, 0x00, 0xAA, 0x00, 0xE9},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x6A, 0x66, 0x46, 0xBB,
			0xC0, 0xAF, 0xB2, 0xB8, 0xA6, 0xC2, 0xC6,
			0xB9, 0x00, 0xB6, 0x00, 0xAD, 0x00, 0xEC},

		{	
			LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_DISABLE,
			0x18, 0x08, 0x24, 0x68, 0x66, 0x45, 0xBA,
			0xC0, 0xAE, 0xB2, 0xB7, 0xA5, 0xC3, 0xC8,
			0xBE, 0x00, 0xB8, 0x00, 0xAE, 0x00, 0xEF},
};
#endif
struct lcdc_s6e63m0_data {
	struct msm_panel_common_pdata *pdata;
	int vga_enabled;
	struct platform_device *fbpdev;
};


static int lcdc_s6e63m0_panel_on(struct platform_device *pdev);
static int lcdc_s6e63m0_panel_off(struct platform_device *pdev);
static void lcdc_s6e63m0_panel_set_backlight(struct msm_fb_data_type *mfd);
int qisda_debug_lcd_spi_test(void);
int qisda_debug_lcd_gpio_config(void);
static int lcdc_s6e63m0_gamma_table_set(int level);
static int lcdc_s6e63m0_poweron(int on);

static int lcdc_s6e63m0_gpio_config(void)
{
    int gpio_num;
    pr_debug("qisda_debug_lcd_gpio_config\n");
    
    gpio_tlmm_config(GPIO_CFG(39, 0, GPIO_CFG_OUTPUT,  GPIO_CFG_PULL_UP, GPIO_CFG_16MA),GPIO_CFG_ENABLE);



    for(gpio_num=0 ; gpio_num<=27 ; gpio_num++)
    {
      gpio_tlmm_config(GPIO_CFG(gpio_num, 1, GPIO_CFG_OUTPUT, GPIO_CFG_PULL_DOWN, GPIO_CFG_2MA), GPIO_CFG_ENABLE);
    }	
    gpio_tlmm_config(GPIO_CFG(0, 1, GPIO_CFG_OUTPUT, GPIO_CFG_PULL_DOWN, GPIO_CFG_4MA), GPIO_CFG_ENABLE);
    gpio_tlmm_config(GPIO_CFG(1, 1, GPIO_CFG_OUTPUT, GPIO_CFG_PULL_DOWN, GPIO_CFG_4MA), GPIO_CFG_ENABLE);
    return 0;
}
static void lcdc_s6e63m0_panel_set_backlight(struct msm_fb_data_type *mfd)
{
	int bl_level;
       pr_debug("lcdc_s6e63m0_panel_set_backlight,level is %d\n", mfd->bl_level);
	bl_level = mfd->bl_level;
       if(bl_level>=LCDC_S6E63M0_GAMMA_TABLE_MAX)
	   	bl_level=LCDC_S6E63M0_GAMMA_TABLE_MAX-1;
	else if(bl_level<0)
		bl_level=0;
       lcdc_s6e63m0_gamma_table_set(bl_level);
	return;

}

static int s6e63m0_probe(struct platform_device *pdev)
{
	int rc = 0;

       lcdc_s6e63m0_gpio_config();
	pr_debug("pdev->id is %d",pdev->id);

	msm_fb_add_device(pdev);

	return rc;
}

static int __devexit s6e63m0_remove(struct platform_device *pdev)
{
	return 0;
}

static struct platform_driver this_driver = {
	.probe  = s6e63m0_probe,
	.remove = s6e63m0_remove,
	.driver = {
		.name   = "lcdc_s6e63m0_wvga",
	},
};

static struct msm_fb_panel_data s6e63m0_panel_data = {
	.on = lcdc_s6e63m0_panel_on,
	.off = lcdc_s6e63m0_panel_off,
	.set_backlight = lcdc_s6e63m0_panel_set_backlight,
};

static struct platform_device this_device = {
	.name   = "lcdc_s6e63m0_wvga",
	.id	= 1,
	.dev	= {
		.platform_data = &s6e63m0_panel_data,
	}
};
static int lcdc_s6e63m0_reset(void)
{
    pr_debug("lcdc_s6e63m0_reset\n");

    gpio_set_value(39, 0);
    mdelay(1);
    gpio_set_value(39, 1);
    msleep(10);

    return 0;
}
static int spi_gpio_write_byte(char dc,uint8_t data)
{
	int ret = 0;
	uint32 bits;
	int bnum;

	

	
	gpio_set_value(spi_sclk, 0); 
	gpio_set_value(spi_mosi, dc);
	udelay(1);	
	gpio_set_value(spi_sclk, 1); 
	udelay(1);	
	
	bnum = 8;	
	bits = 0x80;
	while (bnum) 
	{
		gpio_set_value(spi_sclk, 0); 
		if (data & bits)
			gpio_set_value(spi_mosi, 1);
		else
			gpio_set_value(spi_mosi, 0);
		udelay(1);
		gpio_set_value(spi_sclk, 1); 
		udelay(1);
		bits >>= 1;
		bnum--;
	}
	udelay(1);
	return ret;

}
static int lcdc_s6e63m0_spi_write(uint32 command,uint8_t *param_buf, int32 length)
{  
   	int i=0;

	gpio_tlmm_config(GPIO_CFG(spi_sclk, 0, GPIO_CFG_OUTPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	
	gpio_tlmm_config(GPIO_CFG(spi_mosi, 0, GPIO_CFG_OUTPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	
	gpio_tlmm_config(GPIO_CFG(spi_cs, 0, GPIO_CFG_OUTPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	


   	gpio_set_value(spi_cs, 0);	
   	spi_gpio_write_byte(0,command);
   	if(length)
   	{
     	  for(i=0;i<length;i++)
	 	spi_gpio_write_byte(1,*(param_buf+i));

   	}

   	gpio_set_value(spi_cs, 1);	
   	udelay(1);
	gpio_tlmm_config(GPIO_CFG(spi_sclk, 1, GPIO_CFG_INPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	
	gpio_tlmm_config(GPIO_CFG(spi_mosi, 1, GPIO_CFG_INPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	
	gpio_tlmm_config(GPIO_CFG(spi_cs, 1, GPIO_CFG_INPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	

  	return 0;
}
static int lcdc_s6e63m0_panel_condition_set(void)
{
    int ret = 0;

    pr_debug("[Leo Guo] %s+\n", __func__);

    ret = lcdc_s6e63m0_spi_write( LCDC_S6E63M0_PANEL_CON_CMD, panel_con_set_default_value, sizeof(panel_con_set_default_value)/sizeof(uint8_t));
    return 0;
}
static int lcdc_s6e63m0_display_condition_set(void)
{
    pr_debug("lcdc_s6e63m0_display_condition_set\n");
    lcdc_s6e63m0_spi_write(LCDC_S6E63M0_DISPCTL_CMD, dispctl_set_default_value, sizeof(dispctl_set_default_value)/sizeof(uint8_t));

    lcdc_s6e63m0_spi_write(LCDC_S6E63M0_GTCON_CMD, gtcon_set_default_value, sizeof(gtcon_set_default_value)/sizeof(uint8_t));
    return 0;
}
static int lcdc_s6e63m0_gamma_table_set(int level)
{
    int ret=0;
    uint8_t buf[1];
    pr_debug("lcdc_s6e63m0_gamma_table_set\n");
    ret = lcdc_s6e63m0_spi_write(LCDC_S6E63M0_GAMMA_CTL_CMD, brightness_gamma_table[level], sizeof(brightness_gamma_table[0])/sizeof(uint8_t));
    if (ret)
    {
      pr_debug( "[Leo Guo] %s:: LCDC_S6E63M0_GAMMA_CTL_CMD err ret=%d\n", __func__, ret);
    }

    buf[0] = LCDC_S6E63M0_GAMMA_CTL_PARAM1_UPDATE_ENABLE;
    ret = lcdc_s6e63m0_spi_write(LCDC_S6E63M0_GAMMA_CTL_CMD, buf, 1);

    return ret;

}
static int lcdc_s6e63m0_etc_condition_set(void)
{  
    int ret=0;
    pr_debug("lcdc_s6e63m0_etc_condition_set\n");
    ret = lcdc_s6e63m0_spi_write(LCDC_S6E63M0_ETC_F6_CMD, etc_f6_set_default_value, sizeof(etc_f6_set_default_value)/sizeof(uint8_t));
    if (ret)
    {
      pr_debug( "[Leo Guo] %s:: LCDC_S6E63M0_ETC_F6_CMD err ret=%d\n", __func__, ret);

    }

    ret = lcdc_s6e63m0_spi_write(LCDC_S6E63M0_ETC_B3_CMD, etc_b3_set_default_value, sizeof(etc_b3_set_default_value)/sizeof(uint8_t));
    return ret;

}
static int lcdc_s6e63m0_elvss_control_set(void)
{
    int ret=0;
    pr_debug("lcdc_s6e63m0_elvss_control_set\n");
    ret = lcdc_s6e63m0_spi_write( LCDC_S6E63M0_TEMP_SWIRE_CMD, temp_swire_set_default_value, sizeof(temp_swire_set_default_value)/sizeof(uint8_t));
    if (ret)
    {
      pr_debug( "[Leo Guo] %s:: LCDC_S6E63M0_TEMP_SWIRE_CMD err ret=%d\n", __func__, ret);
    }

    ret = lcdc_s6e63m0_spi_write( LCDC_S6E63M0_ELVSS_CON_CMD, elvss_con_set_default_value, sizeof(elvss_con_set_default_value)/sizeof(uint8_t));

    return 0;

}

static int lcdc_s6e63m0_standby_on(void)
{
	int ret = 0;

	pr_debug("lcdc_s6e63m0_standby_on\n");

	ret = lcdc_s6e63m0_spi_write( LCDC_S6E63M0_SLPIN_CMD, NULL, 0);
	if (ret)
	{
		goto lcdc_s6e63m0_standby_on_err_write;
	}

	msleep(120);

lcdc_s6e63m0_standby_on_err_write:
	return ret;
}

static int lcdc_s6e63m0_standby_off(void)
{
    pr_debug("lcdc_s6e63m0_standby_off\n");
    lcdc_s6e63m0_spi_write( LCDC_S6E63M0_SLPOUT_CMD, NULL, 0);


    msleep(120);

    return 0;

}
static int lcdc_s6e63m0_display_on(void)
{

    pr_debug("lcdc_s6e63m0_display_on\n");
    lcdc_s6e63m0_spi_write( LCDC_S6E63M0_DISPON_CMD, NULL, 0);

    return 0;

}



static int lcdc_s6e63m0_spi_read(uint32 command, uint8_t *data)
{
	int ret = 0;
	uint32 bits, dbit;
	int bnum;

	pr_debug( "[Leo Guo] %s+\n", __func__);

	gpio_tlmm_config(GPIO_CFG(spi_sclk, 0, GPIO_CFG_OUTPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	
	gpio_tlmm_config(GPIO_CFG(spi_mosi, 0, GPIO_CFG_OUTPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	
	gpio_tlmm_config(GPIO_CFG(spi_cs, 0, GPIO_CFG_OUTPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	

	gpio_set_value(spi_cs, 0);
	
	gpio_set_value(spi_sclk, 0); 
	gpio_set_value(spi_mosi, 0);
	udelay(1);	
	gpio_set_value(spi_sclk, 1); 
	udelay(1);	
	
	bnum = 8;	
	bits = 0x80;
	while (bnum) 
	{
		gpio_set_value(spi_sclk, 0); 
		if (command & bits)
			gpio_set_value(spi_mosi, 1);
		else
			gpio_set_value(spi_mosi, 0);
		udelay(1);
		gpio_set_value(spi_sclk, 1); 
		udelay(1);
		bits >>= 1;
		bnum--;
	}

	gpio_tlmm_config(GPIO_CFG(spi_mosi, 0, GPIO_CFG_INPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	
       gpio_set_value(spi_sclk, 0); 
	udelay(1);
	
	bnum = 1 * 8;	
	bits = 0;
	while (bnum) 
	{
		bits <<= 1;
		gpio_set_value(spi_sclk, 1); 
		udelay(1);
		dbit = gpio_get_value(spi_mosi);
		udelay(1);
		gpio_set_value(spi_sclk, 0); 
		bits |= dbit;
		bnum--;
	}

	*data = bits & 0xFF;

	pr_debug("[Leo Guo] gpio spi cmd=%d, data=%d\n", command, bits);

	udelay(1);
	gpio_set_value(spi_sclk, 1); 
	gpio_set_value(spi_cs, 1);	
	udelay(1);

	gpio_tlmm_config(GPIO_CFG(spi_sclk, 1, GPIO_CFG_INPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	
	gpio_tlmm_config(GPIO_CFG(spi_mosi, 1, GPIO_CFG_INPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	
	gpio_tlmm_config(GPIO_CFG(spi_cs, 1, GPIO_CFG_INPUT,  GPIO_CFG_NO_PULL, GPIO_CFG_2MA), GPIO_CFG_ENABLE);	


	return ret;

}
static int lcdc_detect_panel(void)
{
    uint8_t value;

    lcdc_s6e63m0_gpio_config();
    lcdc_s6e63m0_poweron(1);
    lcdc_s6e63m0_reset();

    lcdc_s6e63m0_spi_read( 0x0A, &value);
    if(value==0||value==0xff)
      goto power_off;
     lcdc_s6e63m0_spi_read( 0x0C, &value);
    if(value==0||value==0xff)
      goto power_off;
    pr_debug("detect lcdc panel is successful!\n");
    lcdc_s6e63m0_poweron(0);
    return 0;
    power_off:
	lcdc_s6e63m0_poweron(0);
	return 1;
   
}

int qisda_debug_lcd_gpio_config(void)
{
    int gpio_num;
    pr_debug("qisda_debug_lcd_gpio_config\n");
    
    gpio_tlmm_config(GPIO_CFG(39, 0, GPIO_CFG_OUTPUT,  GPIO_CFG_PULL_UP, GPIO_CFG_16MA),GPIO_CFG_ENABLE);



    for(gpio_num=0 ; gpio_num<=27 ; gpio_num++)
    {
      gpio_tlmm_config(GPIO_CFG(gpio_num, 1, GPIO_CFG_OUTPUT, GPIO_CFG_PULL_DOWN, GPIO_CFG_2MA), GPIO_CFG_ENABLE);
    }	
    gpio_tlmm_config(GPIO_CFG(0, 1, GPIO_CFG_OUTPUT, GPIO_CFG_PULL_DOWN, GPIO_CFG_4MA), GPIO_CFG_ENABLE);
    gpio_tlmm_config(GPIO_CFG(1, 1, GPIO_CFG_OUTPUT, GPIO_CFG_PULL_DOWN, GPIO_CFG_4MA), GPIO_CFG_ENABLE);
    return 0;
}

int qisda_debug_lcd_power_on(void)
{
      pr_debug("qisda_debug_lcd_power_on\n");
      
      return 0;
}

int qisda_debug_lcd_reset(void)
{
       printk("qisda_debug_lcd_reset\n");
	gpio_set_value(39, 0);
	mdelay(1);
	gpio_set_value(39, 1);
	msleep(10);
	return 0;
}

int qisda_debug_lcd_spi_test(void)
{
        int ret;
	 uint8_t rx_buf;
		
        ret = lcdc_s6e63m0_spi_read( 0x0A, &rx_buf);
	 printk("lcdc_s6e63m0_spi_read 0x0A is %d\n",rx_buf);

	 ret = lcdc_s6e63m0_spi_read( 0x0C, &rx_buf);
	 printk("lcdc_s6e63m0_spi_read 0x0C is %d\n",rx_buf);
        return 0;
}
int qisda_debug_lcd_init(void)
{
       int ret;
       printk("qisda_debug_lcd_init\n");
	ret = lcdc_s6e63m0_panel_condition_set();

	ret = lcdc_s6e63m0_display_condition_set();

	ret = lcdc_s6e63m0_gamma_table_set(20);

	ret = lcdc_s6e63m0_etc_condition_set();

	ret = lcdc_s6e63m0_elvss_control_set();

	ret = lcdc_s6e63m0_standby_off();

	ret = lcdc_s6e63m0_display_on();
	return 0;
}

int qisda_debug_lcd_set_backlight(void)
{

   lcdc_s6e63m0_gamma_table_set(5);
   mdelay(500);
   lcdc_s6e63m0_gamma_table_set(10);
   mdelay(500);
   lcdc_s6e63m0_gamma_table_set(15);
   mdelay(500);
   lcdc_s6e63m0_gamma_table_set(20);
   return 0;
}

static int lcdc_s6e63m0_init(void)
{
       int ret=0;
       pr_debug("qisda_debug_lcd_init\n");
	   
	lcdc_s6e63m0_panel_condition_set();

	lcdc_s6e63m0_display_condition_set();

	lcdc_s6e63m0_gamma_table_set(20);

	lcdc_s6e63m0_etc_condition_set();

	lcdc_s6e63m0_elvss_control_set();

	lcdc_s6e63m0_standby_off();

	lcdc_s6e63m0_display_on();
	return ret;
}
static int lcdc_s6e63m0_poweron(int on)
{
       static struct regulator *vreg_vdd;
	static struct regulator *vreg_vci;
	int rc;
       if (on)
	{
		vreg_vdd = regulator_get(NULL, "8058_l15");
		if (IS_ERR(vreg_vdd)) 
		{
			pr_err("%s: unable to get vreg_vdd\n", __func__);
			return 0;
		}
		rc = regulator_set_voltage(vreg_vdd, 2850000, 2850000);
		if (rc) 
		{
			pr_err("%s: regulator_set_voltage() = %d\n",
				__func__, rc);
			if (vreg_vdd)
				regulator_put(vreg_vdd);
			return 0;
		}
		if (regulator_enable(vreg_vdd)) 
		{
			pr_err("%s: Unable to enable the regulator:"
					" vreg_vdd\n", __func__);
			return 0;
		}
		vreg_vci = regulator_get(NULL, "8058_s3");
		if (IS_ERR(vreg_vci)) 
		{
			pr_err("%s: unable to get vreg_vci\n", __func__);
			return 0;
		}
		rc = regulator_set_voltage(vreg_vci, 1800000, 1800000);
		if (rc) 
		{
			pr_err("%s: regulator_set_voltage() = %d\n",
				__func__, rc);
			if (vreg_vci)
				regulator_put(vreg_vci);
			return 0;
		}
		if (regulator_enable(vreg_vci)) 
		{
			pr_err("%s: Unable to enable the regulator:"
					" vreg_vci\n", __func__);
			return 0;
		}
	}
	else
	{
           regulator_disable(vreg_vdd);
	    regulator_disable(vreg_vci);
           regulator_put(vreg_vdd);
	    regulator_put(vreg_vci);
	}
	   	
	return 0;

}

static int lcdc_s6e63m0_panel_on(struct platform_device *pdev)
{
	int ret = 0;
	pr_debug("[Leo Guo] %s+\n", __func__);
       lcdc_s6e63m0_poweron(1);
	lcdc_s6e63m0_reset();
  
	qisda_debug_lcd_spi_test();
	lcdc_s6e63m0_init();

	pr_debug("[Leo Guo] %s-\n", __func__);
	return ret;
}
static int lcdc_s6e63m0_panel_off(struct platform_device *pdev)
{
	int ret = 0;

	pr_debug("lcdc_s6e63m0_panel_off\n");

	ret = lcdc_s6e63m0_standby_on();
	if (ret)
	{
		goto lcdc_s6e63m0_panel_off_err_standby_on;
	}

	gpio_set_value(39, 1);

       lcdc_s6e63m0_poweron(0);

lcdc_s6e63m0_panel_off_err_standby_on:
	
	pr_debug("[LCDC] %s-\n", __func__);
	return ret;
}
static int __init lcdc_s6e63m0_panel_init(void)
{
	int ret;
	struct msm_panel_info *pinfo;
       pr_debug("lcdc_s6e63m0_panel_init\n");

	if(lcdc_detect_panel())
		return 0;
	ret = platform_driver_register(&this_driver);
	if (ret)
		return ret;

	pinfo = &s6e63m0_panel_data.panel_info;
	pinfo->xres = 480;
	pinfo->yres = 800;
	pinfo->type = LCDC_PANEL;
	pinfo->pdest = DISPLAY_1;
	pinfo->wait_cycle = 0;
	pinfo->bpp = 24;
	pinfo->fb_num = 2;
	pinfo->clk_rate = 43192000;
	
	pinfo->bl_max = 22;
	pinfo->bl_min = 1;

	pinfo->lcdc.h_back_porch = LCDC_S6E63M0_HBP;
	pinfo->lcdc.h_front_porch = LCDC_S6E63M0_HFP;
	pinfo->lcdc.h_pulse_width = LCDC_S6E63M0_HPW;
	pinfo->lcdc.v_back_porch = LCDC_S6E63M0_VBP;
	pinfo->lcdc.v_front_porch = LCDC_S6E63M0_VFP;
	pinfo->lcdc.v_pulse_width = LCDC_S6E63M0_VPW;
	pinfo->lcdc.border_clr = 0;     
	pinfo->lcdc.underflow_clr = 0xff;       
	pinfo->lcdc.hsync_skew = 0;

	ret = platform_device_register(&this_device);
	if (ret)
		platform_driver_unregister(&this_driver);

	return ret;
}

module_init(lcdc_s6e63m0_panel_init);
