#ifndef	__QSD_GAUGE_H__
#define	__QSD_GAUGE_H__

/*Jack W Lu 2010-11-16 android\kernel\include\linux\bq27500_gauge.h*/

#include <linux/kernel.h>

#ifdef CONFIG_GAUGE_QSD
#define QCS_BQ27500_GAUGE_SUPPORT
#define QCS_MAX17043_GAUGE_SUPPORT
#endif

#define GAUGE_DRIVER_VERSION			"1.1.0"

int gauge_read(uint8_t reg, uint8_t *buf, uint8_t len);

int gauge_write(uint8_t reg, uint8_t* buf, uint8_t len);

#ifdef QCS_BQ27500_GAUGE_SUPPORT
#define BQ_GAUGE_ADDR    (0xAA >> 1)

#define BQ27500_REG_CTRL		    0x00
#define BQ27500_REG_TEMP		    0x06
#define BQ27500_REG_VOLT		    0x08
#define BQ27500_REG_FLAGS		 0x0A
#define BQ27500_REG_AI			    0x14
#define BQ27500_REG_TTE			 0x16
#define BQ27500_REG_TTF			 0x18
#define BQ27500_REG_TTECP		 0x26
#define BQ27500_REG_SOC          0x2C


#define BQ27500_FLAG_DSG                BIT(0)
#define BQ27500_FLAG_BAT_DET         BIT(3)
#define BQ27500_FLAG_CHG                BIT(8)
#define BQ27500_FLAG_FC                  BIT(9)
#define BQ27500_FLAG_XCHG              BIT(10)
#define BQ27500_FLAG_CHG_INH         BIT(11)
#define BQ27500_FLAG_OTD                 BIT(14)
#define BQ27500_FLAG_OTC                 BIT(15)

/*
 * Return the gauge temperature in tenths of degree Celsius
 * Or < 0 if something fails.
 */
extern int16_t bq27500_gauge_temperature(void);

/*
 * Return the gauge Voltage in milivolts
 * Or < 0 if something fails.
 */
extern int16_t bq27500_gauge_voltage(void);

/*
 * Return the gauge flags
 * Or < 0 if something fails.
 */
extern int16_t bq27500_gauge_flags(void);

/*
 * Return the gauge average current
 * Note that current can be negative signed as well
 * Or 0 if something fails.
 */
extern int16_t bq27500_gauge_current(void);

/*
 * Return the gauge Relative State-of-Charge capacity
 * Or < 0 if something fails.
 */
extern int16_t bq27500_gauge_capacity(void);

extern int16_t bq27500_gauge_init_DFI(void);

#endif

#ifdef QCS_MAX17043_GAUGE_SUPPORT
#define MAX_GAUGE_ADDR    (0x6C >> 1)

#define MAX17043_REG_VCELL		                0x02
#define MAX17043_REG_SOC		                0x04
#define MAX17043_REG_MODE		                0x06
#define MAX17043_REG_VERSION	             0x08
#define MAX17043_REG_CONFIG		             0x0C
#define MAX17043_REG_COMMAND		          0xFE

#define MAX17043_CMD_QUICK_START		    0x4000
#define MAX17043_CMD_RESET		              0x5400

#define MAX17043_CONFIG_BIT_ALRT                BIT(5)
#define MAX17043_CONFIG_BIT_SLEEP                BIT(7)


extern int16_t max17043_gauge_voltage(void);
extern int16_t max17043_gauge_capacity(void);
extern int16_t max17043_gauge_init(void);
extern int16_t max17043_gauge_reset(void);
#endif

extern int16_t qsd_gauge_init(void);
#endif
