/*
 * Copyright (C) 2011 Qisda Corporation.
 */

#ifndef GPIO_DEF_LA_H
#define GPIO_DEF_LA_H

/******************************************************************/
/****************************** EVT2 ******************************/
/******************************************************************/
#if defined(CONFIG_MACH_EVT2)


/******************************************************************/
/****************************** EVT1 ******************************/
/******************************************************************/
#elif defined(CONFIG_MACH_EVT1)
/********************LCD********************/
#define LCDC_PCLK	GPIO_0
#define LCDC_HSYNC	GPIO_1
#define LCDC_VSYNC	GPIO_2
#define LCDC_EN		GPIO_3
#define LCDC_RED_7	GPIO_4
#define LCDC_RED_6	GPIO_5
#define LCDC_RED_5	GPIO_6
#define LCDC_RED_4	GPIO_7
#define LCDC_RED_3	GPIO_8
#define LCDC_RED_2	GPIO_9
#define LCDC_RED_1	GPIO_10
#define LCDC_RED_0	GPIO_11
#define LCDC_GRN_7	GPIO_12
#define LCDC_GRN_6	GPIO_13
#define LCDC_GRN_5	GPIO_14
#define LCDC_GRN_4	GPIO_15
#define LCDC_GRN_3	GPIO_16
#define LCDC_GRN_2	GPIO_17
#define LCDC_GRN_1	GPIO_18
#define LCDC_GRN_0	GPIO_19
#define LCDC_BLUE_7	GPIO_20
#define LCDC_BLUE_6	GPIO_21
#define LCDC_BLUE_5	GPIO_22
#define LCDC_BLUE_4	GPIO_23
#define LCDC_BLUE_3	GPIO_24
#define LCDC_BLUE_2	GPIO_25
#define LCDC_BLUE_1	GPIO_26
#define LCDC_BLUE_0	GPIO_27

#define LVDS_LCM_EN	GPIO_46
#define LVDS_LED_EN	GPIO_49
#define LVDS_PWDN	GPIO_68

/********************Touch Panel********************/
#define TOUCH_I2C_DATA	GPIO_43
#define TOUCH_I2C_CLK	GPIO_44
#define TOUCH_GPIOIRQ	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_25))

/********************Flash Light********************/
#define FL_EN		GPIO_31
#define LED_D_G1	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_22))
#define LED_D_G2	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_23))

/********************Camera********************/
#define CLK_CAMIF_MCLK		GPIO_32
#define CAMIF_I2C_DATA		GPIO_47
#define CAMIF_I2C_CLK		GPIO_48
#define MP_CAM_RESET_N		GPIO_100
#define MP_CAM_PWDN_N		GPIO_127
#define VGA_CAM_RESET_N		GPIO_99

/********************Accessory********************/
#define HEADSET_DET_N	GPIO_103

/********************HDMI********************/
#define HDMI_DDC_CLK	GPIO_170
#define HDMI_DDC_DATA	GPIO_171
#define HDMI_HPD	GPIO_172
#define HDMI_CEC	GPIO_169

/********************BT********************/
#define BT_TX		GPIO_53
#define BT_RX		GPIO_54
#define BT_CTS		GPIO_55
#define BT_RFR		GPIO_56
#define BT_EN		GPIO_70
#define BT_INT		GPIO_105
#define BT_RST_N	GPIO_97
#define BT_WAKEUP	GPIO_98
#define BT_PCM_DOUT	GPIO_111
#define BT_PCM_DIN	GPIO_112
#define BT_PCM_SYNC	GPIO_113
#define BT_PCM_CLK	GPIO_114

/********************WLAN********************/
#define WLAN_EN		GPIO_83
#define WLAN_IRQ	GPIO_57

/********************Power********************/
#define CORE_I2C_DATA	GPIO_64
#define CORE_I2C_CLK	GPIO_65
#define BATT_GOD_INT	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_35))
#define BOOST_5V_EN	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_10))
#define BATT_SOC_INT	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_31))
#define BATT_LOW	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_34))
#define BATT_SOC_INT_GPIO PM_GPIO_31

/********************USB********************/
#define USB20_RST_N	GPIO_72
#define USB_ID		(PM8058_GPIO_PM_TO_SYS(PM_GPIO_37))

/********************Sensors********************/
#define SENSOR_I2C_CLK		GPIO_115
#define SENSOR_I2C_DATA		GPIO_116
#define GYRO_INT		GPIO_93
#define G_SENSOR_INT		GPIO_94
#define LIGHT_INT_N		GPIO_95
#define E_COMPASS_INT		GPIO_96
#define E_COMPASS_RESET		GPIO_104
#define nAP_INT_1		GPIO_39
#define nAP_INT_2		GPIO_40
#define ALS_INT			GPIO_72

/********************Audio********************/
#define CDC_TX_MCLK		GPIO_108
#define CDC_RX_MCLK1		GPIO_109
#define CDC_TX_I2S_SD2		GPIO_110
#define CDC_RX_I2S_SCK2		GPIO_119
#define CDC_RX_I2S_WS2		GPIO_120
#define CDC_RX_I2S_SD2		GPIO_121
#define CDC_RX_MCLK2		GPIO_122
#define AUDIO_AMP_EN		GPIO_29

/********************eMMC********************/
#define SDC1_DATA0	GPIO_159
#define SDC1_DATA1	GPIO_160
#define SDC1_DATA2	GPIO_161
#define SDC1_DATA3	GPIO_162
#define SDC1_DATA4	GPIO_163
#define SDC1_DATA5	GPIO_164
#define SDC1_DATA6	GPIO_165
#define SDC1_DATA7	GPIO_166
#define SDC1_CLK	GPIO_167
#define SDC1_CMD	GPIO_168

/********************SD********************/
#define TFLASH_CD	GPIO_51

/********************PMIC********************/
#define PM8058_GPIO_INT	GPIO_88
#define PM8901_GPIO_INT	GPIO_91

/********************Vibrator********************/
#define HAP_EN			GPIO_86
#define HAP_LDO_EN		GPIO_156
#define CLOCK_BUFFER_EN		GPIO_155
#define VIB_CLK_EN		GPIO_158

/********************Charging********************/
#define CHG_FAULT	GPIO_124
#define DC_PWR_OK	GPIO_125
#define CHG_STAT	GPIO_134
#define CHG_IUSB	GPIO_135
#define CHG_USUS	GPIO_136
#define CHG_DCM		GPIO_137
#define CHG_EN		GPIO_138

/********************Others********************/
#define QTR_I2C_DATA	GPIO_59
#define QTR_I2C_CLK	GPIO_60
#define P_PS_HOLD	GPIO_92
#define UART_RX		GPIO_117
#define UART_TX		GPIO_118
#define CDC_RST_N	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_21))
#define XO_THERM_MPP	PM8058_MPP_9
#define MSM_THERM_MPP	PM8058_MPP_10
#define BOARD_ID_MPP	PM8058_MPP_8
#define SAR_DETECT	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_20))
#define TEST_POINT	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_40))

/********************PM8058 GPIO NOT Mapped********************/
#define PM_WLAN_SLEEP_CLK	PM_GPIO_38
#define PM_LVDS_BL_PWM		PM_GPIO_24
#define PM_BOOST_5V_EN		PM_GPIO_10
#define PM_TOUCH_INT		PM_GPIO_25
#define PM_LED_D_G1		PM_GPIO_22
#define PM_LED_D_G2		PM_GPIO_23
#define PM_SSBI_PMIC_FWD_CLK	PM_GPIO_39
#define PM_TEST_POINT		PM_GPIO_40

/********************IRQS********************/
#define TFLASH_CD_IRQ_NUM	(MSM_GPIO_TO_INT(TFLASH_CD))
#define GAU_INT_IRQ_NUM		(PM8058_GPIO_IRQ(PM8058_IRQ_BASE, PM_GPIO_31))
#define G_SENSOR_INT_IRQ_NUM	(MSM_GPIO_TO_INT(G_SENSOR_INT))
#define E_COMPASS_INT_IRQ_NUM	(MSM_GPIO_TO_INT(E_COMPASS_INT))
#define GYRO_INT_IRQ_NUM	(MSM_GPIO_TO_INT(GYRO_INT))
#define LIGHT_INT_N_IRQ_NUM	(MSM_GPIO_TO_INT(LIGHT_INT_N))

#endif/*#ifdef CONFIG_MACH_EVT1*/

#endif
