/*
 * Copyright (C) 2011 Qisda Corporation.
 */

#ifndef GPIO_DEF_SONG_H
#define GPIO_DEF_SONG_H

/******************************************************************/
/****************************** EVB2 ******************************/
/******************************************************************/
#if defined(CONFIG_MACH_EVB2)
/********************LCD********************/
#define LCDC_PCLK	GPIO_0
#define LCDC_HSYNC	GPIO_1
#define LCDC_VSYNC	GPIO_2
#define LCDC_EN		GPIO_3
#define LCDC_RED_7	GPIO_4
#define LCDC_RED_6	GPIO_5
#define LCDC_RED_5	GPIO_6
#define LCDC_RED_4	GPIO_7
#define LCDC_RED_3	GPIO_8
#define LCDC_RED_2	GPIO_9
#define LCDC_RED_1	GPIO_10
#define LCDC_RED_0	GPIO_11
#define LCDC_GRN_7	GPIO_12
#define LCDC_GRN_6	GPIO_13
#define LCDC_GRN_5	GPIO_14
#define LCDC_GRN_4	GPIO_15
#define LCDC_GRN_3	GPIO_16
#define LCDC_GRN_2	GPIO_17
#define LCDC_GRN_1	GPIO_18
#define LCDC_GRN_0	GPIO_19
#define LCDC_BLUE_7	GPIO_20
#define LCDC_BLUE_6	GPIO_21
#define LCDC_BLUE_5	GPIO_22
#define LCDC_BLUE_4	GPIO_23
#define LCDC_BLUE_3	GPIO_24
#define LCDC_BLUE_2	GPIO_25
#define LCDC_BLUE_1	GPIO_26
#define LCDC_BLUE_0	GPIO_27
#define LCD_TE		GPIO_28
#define LCD_RESET_N	GPIO_39

#define LVDS_LCM_EN	GPIO_46
#define LVDS_LED_EN	GPIO_49
#define LVDS_PWDN	GPIO_68

/********************Touch Panel********************/
#define TOUCH_I2C_DATA		GPIO_43
#define TOUCH_I2C_CLK		GPIO_44
#define CAP_RESET		GPIO_66
#define CAP_INT			GPIO_73
#define TOUCH_GPIORST		(PM8058_GPIO_PM_TO_SYS(PM_GPIO_27))
#define TOUCH_GPIOIRQ		(PM8058_GPIO_PM_TO_SYS(PM_GPIO_25))

/********************Flash Light********************/
#define FL_EN		GPIO_31
#define LED_D_G1	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_22))
#define LED_D_G2	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_23))

/********************Camera********************/
#define CLK_CAMIF_MCLK		GPIO_32
#define CAMIF_I2C_DATA		GPIO_47
#define CAMIF_I2C_CLK		GPIO_48
#define MP_CAM_RESET_N		GPIO_100
#define MP_CAM_PWDN_N		GPIO_105

/********************Accessory********************/
#define HEADSET_DET_N	GPIO_103

/********************HDMI********************/
#define MHL_INT		GPIO_45
#define MHL_RST		GPIO_58
#define MHL_nUSB	GPIO_62
#define HDMI_DDC_CLK	GPIO_170
#define HDMI_DDC_DATA	GPIO_171
#define HDMI_HPD	GPIO_172
#define HDMI_CEC	GPIO_169

/********************BT********************/
#define BT_TX		GPIO_53
#define BT_RX		GPIO_54
#define BT_CTS		GPIO_55
#define BT_RFR		GPIO_56
#define BT_EN		GPIO_70
#define BT_INT		GPIO_105
#define BT_RST_N	GPIO_97
#define BT_WAKEUP	GPIO_98
#define BT_PCM_DOUT	GPIO_111
#define BT_PCM_DIN	GPIO_112
#define BT_PCM_SYNC	GPIO_113
#define BT_PCM_CLK 	GPIO_114

/********************WLAN********************/
#define WLAN_EN		GPIO_82
#define WLAN_IRQ	GPIO_57

/********************GPS********************/
#define GPS_POWER_ON	GPIO_83
#define GPS_UART_RTS_N	GPIO_35
#define GPS_UART_CTS_N	GPIO_36
#define GPS_RESET_N	GPIO_155

/********************FM********************/
#define FM_I2C_DATA	GPIO_59
#define FM_I2C_CLK	GPIO_60
#define FM_I2S_WS	GPIO_101
#define FM_I2S_SCK	GPIO_102
#define FM_I2S_DI	GPIO_106
#define FM_I2S_DO	GPIO_107
#define FM_EN		GPIO_30
#define FM_IRQ		GPIO_29

/********************Power********************/
#define CORE_I2C_DATA	GPIO_64
#define CORE_I2C_CLK	GPIO_65
#define BATT_GOD_INT	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_35))
#define CHG_I_MON_MPP	PM8058_MPP_5
#define BAT_ID_MPP	PM8058_MPP_8
#define CHG_VFSW	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_17))
#define GAU_INT		(PM8058_GPIO_PM_TO_SYS(PM_GPIO_31))
#define BATT_LOW	(PM8058_GPIO_PM_TO_SYS(PM_GPIO_34))
#define BOOST_5V_EN_MPP	PM8901_MPP_1

/********************USB********************/
#define USB20_RST_N	GPIO_72
#define USB_ID		(PM8058_GPIO_PM_TO_SYS(PM_GPIO_37))
#define ID_SW		GPIO_67
#define USB20_INT	GPIO_152
#define ID_ADC_MPP	PM8058_MPP_4

/********************Sensors********************/
#define SENSOR_I2C_CLK		GPIO_115
#define SENSOR_I2C_DATA		GPIO_116
#define GYRO_INT		GPIO_93
#define G_SENSOR_INT		GPIO_94
#define LIGHT_INT_N		GPIO_95
#define E_COMPASS_INT		GPIO_96
#define E_COMPASS_RESET		GPIO_104

/********************Audio********************/
#define AUDIO_SW_USB_EN		GPIO_69
#define AUDIO_SW_AUD_EN		GPIO_71
#define CDC_TX_MCLK		GPIO_108
#define CDC_RX_MCLK1		GPIO_109
#define CDC_TX_I2S_SD2		GPIO_110
#define CDC_RX_I2S_SCK2		GPIO_119
#define CDC_RX_I2S_WS2		GPIO_120
#define CDC_RX_I2S_SD2		GPIO_121
#define CDC_RX_MCLK2		GPIO_122
#define AUDIO_AMP_EN_MPP	PM8901_MPP_3

/********************eMMC********************/
#define SDC1_DATA0	GPIO_159
#define SDC1_DATA1	GPIO_160
#define SDC1_DATA2	GPIO_161
#define SDC1_DATA3	GPIO_162
#define SDC1_DATA4	GPIO_163
#define SDC1_DATA5	GPIO_164
#define SDC1_DATA6	GPIO_165
#define SDC1_DATA7	GPIO_166
#define SDC1_CLK	GPIO_167
#define SDC1_CMD	GPIO_168

/********************SD********************/
#define GPIO_SDC_WP	GPIO_61
#define TFLASH_CD	GPIO_51

/********************PMIC********************/
#define PM8058_GPIO_INT	GPIO_88
#define PM8901_GPIO_INT	GPIO_91

/********************Consumer IR********************/
#define IR_UART_TX		GPIO_33
#define IR_UART_RX		GPIO_34

/********************Vibrator********************/
#define HAP_EN			GPIO_86
#define HAP_LDO_EN		GPIO_156
#define CLOCK_BUFFER_EN		GPIO_158

/********************EBI2********************/
#define EBI2_CS0_N	GPIO_134
#define EBI2_A6		GPIO_124
#define EBI2_A5		GPIO_125
#define EBI2_A4		GPIO_126
#define EBI2_A3		GPIO_127
#define EBI2_A2		GPIO_128
#define EBI2_A1		GPIO_129
#define EBI2_A0		GPIO_130
#define EBI2_D15	GPIO_135
#define EBI2_D14	GPIO_136
#define EBI2_D13	GPIO_137
#define EBI2_D12	GPIO_138
#define EBI2_D11	GPIO_139
#define EBI2_D10	GPIO_140
#define EBI2_D9		GPIO_141
#define EBI2_D8		GPIO_142
#define EBI2_D7		GPIO_143
#define EBI2_D6		GPIO_144
#define EBI2_D5		GPIO_145
#define EBI2_D4		GPIO_146
#define EBI2_D3		GPIO_147
#define EBI2_D2		GPIO_148
#define EBI2_D1		GPIO_149
#define EBI2_D0		GPIO_150
#define EBI2_OE_N	GPIO_151
#define EBI2_WE_N	GPIO_157
#define EBI2_INT_N	GPIO_52
#define EBI2_CS4_N	GPIO_132
#define EBI2_CS3_N	GPIO_133
#define EBI2_ADV_N	GPIO_153
#define EBI2_WAIT_N	GPIO_154

/********************Others********************/
#define PCI_WAKE_HOST_N		GPIO_40
#define PRESET_3G		GPIO_41
#define W_DISABLE_3G		GPIO_42
#define P_PS_HOLD		GPIO_92
#define UART_RX			GPIO_117
#define UART_TX			GPIO_118
#define USB_ID_SWITCH_MPP	PM8901_MPP_2
#define CDC_RST_N		(PM8058_GPIO_PM_TO_SYS(PM_GPIO_21))
#define XO_THERM_MPP		PM8058_MPP_9
#define MSM_THERM_MPP		PM8058_MPP_10
#define SAR_DETECT		(PM8058_GPIO_PM_TO_SYS(PM_GPIO_20))

/********************PM8058 GPIO NOT Mapped********************/
#define PM_WLAN_SLEEP_CLK	PM_GPIO_38
#define PM_LVDS_BL_PWM		PM_GPIO_26
#define PM_SSBI_PMIC_FWD_CLK	PM_GPIO_39
#define PM_LCD_BL_PWM		PM_GPIO_24
#define PM_TOUCH_BOOST_EN	PM_GPIO_19
#define PM_TOUCH_DETECT		PM_GPIO_18
#define PM_LED_D_G1		PM_GPIO_22
#define PM_LED_D_G2		PM_GPIO_23
#define PM_TOUCH_INT		PM_GPIO_25
#define PM_TOUCH_RESET		PM_GPIO_27

/********************IRQS********************/
#define TFLASH_CD_IRQ_NUM	(MSM_GPIO_TO_INT(TFLASH_CD))
#define G_SENSOR_INT_IRQ_NUM	(MSM_GPIO_TO_INT(G_SENSOR_INT))
#define E_COMPASS_INT_IRQ_NUM	(MSM_GPIO_TO_INT(E_COMPASS_INT))
#define GYRO_INT_IRQ_NUM	(MSM_GPIO_TO_INT(GYRO_INT))
#define LIGHT_INT_N_IRQ_NUM	(MSM_GPIO_TO_INT(LIGHT_INT_N))

/******************************************************************/
/****************************** EVB1 ******************************/
/******************************************************************/
#elif defined(CONFIG_MACH_EVB1)
/********************LCD********************/
#define LCDC_PCLK	GPIO_0
#define LCDC_HSYNC	GPIO_1
#define LCDC_VSYNC	GPIO_2
#define LCDC_EN		GPIO_3
#define LCDC_RED_7	GPIO_4
#define LCDC_RED_6	GPIO_5
#define LCDC_RED_5	GPIO_6
#define LCDC_RED_4	GPIO_7
#define LCDC_RED_3	GPIO_8
#define LCDC_RED_2	GPIO_9
#define LCDC_RED_1	GPIO_10
#define LCDC_RED_0	GPIO_11
#define LCDC_GRN_7	GPIO_12
#define LCDC_GRN_6	GPIO_13
#define LCDC_GRN_5	GPIO_14
#define LCDC_GRN_4	GPIO_15
#define LCDC_GRN_3	GPIO_16
#define LCDC_GRN_2	GPIO_17
#define LCDC_GRN_1	GPIO_18
#define LCDC_GRN_0	GPIO_19
#define LCDC_BLUE_7	GPIO_20
#define LCDC_BLUE_6	GPIO_21
#define LCDC_BLUE_5	GPIO_22
#define LCDC_BLUE_4	GPIO_23
#define LCDC_BLUE_3	GPIO_24
#define LCDC_BLUE_2	GPIO_25
#define LCDC_BLUE_1	GPIO_26
#define LCDC_BLUE_0	GPIO_27
#define LCD_TE		GPIO_28
#define LCDC_SPI_SDO	GPIO_33
#define LCDC_SPI_SDI	GPIO_34
#define LCDC_SPI_CS	GPIO_35
#define LCDC_SPI_CLK	GPIO_36
#define LCD_RESET_N	GPIO_39

#define LVDS_LCM_EN	GPIO_46
#define LVDS_LED_EN	GPIO_49
#define LVDS_PWDN	GPIO_68

/********************Touch Panel********************/
#define TP_INT		GPIO_30
#define TP_RST		GPIO_44

/********************Flash Light********************/
#define FL_EN		GPIO_31
#define FL_PWM		GPIO_50
#define FL_INH		GPIO_62

/********************Camera********************/
#define CLK_CAMIF_MCLK	GPIO_32
#define CAMIF_I2C_DATA	GPIO_47
#define CAMIF_I2C_CLK	GPIO_48
#define VGA_CAM_RESET_N	GPIO_99
#define MP_CAM_RESET_N	GPIO_100

/********************Accessory********************/
#define HEADSET_DET_N	GPIO_43

/********************HDMI********************/
#define HDMI_INT	GPIO_45
#define HDMI_DDC_CLK	GPIO_170
#define HDMI_DDC_DATA	GPIO_171
#define HDMI_HPD	GPIO_172
#define HDMI_CEC_MPP	PM8058_MPP_7

/********************BT********************/
#define BT_TX		GPIO_53
#define BT_RX		GPIO_54
#define BT_CTS		GPIO_55
#define BT_RFR		GPIO_56
#define BT_EN		GPIO_70
#define BT_INT		GPIO_83
#define BT_RST_N	GPIO_97
#define BT_WAKEUP	GPIO_98
#define BT_PCM_DOUT	GPIO_111
#define BT_PCM_DIN	GPIO_112
#define BT_PCM_SYNC	GPIO_113
#define BT_PCM_CLK	GPIO_114

/********************WLAN********************/
#define WLAN_EN		GPIO_57
#define WLAN_IRQ	GPIO_82

/********************FM********************/
#define FM_I2C_DATA	GPIO_59
#define FM_I2C_CLK	GPIO_60
#define FM_I2S_WS	GPIO_101
#define FM_I2S_SCK	GPIO_102
#define FM_I2S_DI	GPIO_106
#define FM_I2S_DO	GPIO_107
#define FM_EN		GPIO_131
#define FM_IRQ		GPIO_132

/********************Power********************/
#define DC_IN_EN	GPIO_58
#define BATT_LOW	GPIO_61
#define DC_CHG_INT	GPIO_66
#define CHG_LOAD_SW_N_EN	GPIO_67
#define FUEL_GAUGE_INT_N	GPIO_103
#define BATT_GOD_INT_MPP	PM8058_MPP_11
#define BOOST_5V_EN_MPP		PM8901_MPP_1

/********************USB********************/
#define USB20_RST_N	GPIO_72
#define USB20_INT	GPIO_85
#define USB_ID		(PM8058_GPIO_PM_TO_SYS(PM_GPIO_37))

/********************Sensors********************/
#define CAP_ATT_N		GPIO_73
#define GYRO_INT		GPIO_93
#define G_SENSOR_INT		GPIO_94
#define LIGHT_INT_N		GPIO_95
#define E_COMPASS_INT		GPIO_96
#define SENSOR_I2C_CLK		GPIO_115
#define SENSOR_I2C_DATA		GPIO_116

/********************Audio********************/
#define AUDIO_SW_USB_EN		GPIO_69
#define AUDIO_SW_AUD_EN		GPIO_71
#define CDC_TX_MCLK		GPIO_108
#define CDC_RX_MCLK1		GPIO_109
#define CDC_TX_I2S_SD2		GPIO_110
#define CDC_RX_I2S_SCK2		GPIO_119
#define CDC_RX_I2S_WS2		GPIO_120
#define CDC_RX_I2S_SD2		GPIO_121
#define CDC_RX_MCLK2		GPIO_122
#define AUDIO_AMP_EN_MPP	PM8901_MPP_3

/********************eMMC********************/
#define SDC1_DATA0	GPIO_159
#define SDC1_DATA1	GPIO_160
#define SDC1_DATA2	GPIO_161
#define SDC1_DATA3	GPIO_162
#define SDC1_DATA4	GPIO_163
#define SDC1_DATA5	GPIO_164
#define SDC1_DATA6	GPIO_165
#define SDC1_DATA7	GPIO_166
#define SDC1_CLK	GPIO_167
#define SDC1_CMD	GPIO_168

/********************I2C********************/
#define CORE_I2C_DATA	GPIO_64
#define CORE_I2C_CLK	GPIO_65

/********************PMIC********************/
#define PM8058_GPIO_INT	GPIO_88
#define PM8901_GPIO_INT	GPIO_91

/********************EBI2********************/
#define EBI2_CS0_N	GPIO_134
#define EBI2_A6		GPIO_124
#define EBI2_A5		GPIO_125
#define EBI2_A4		GPIO_126
#define EBI2_A3		GPIO_127
#define EBI2_A2		GPIO_128
#define EBI2_A1		GPIO_129
#define EBI2_A0		GPIO_130
#define EBI2_D15	GPIO_135
#define EBI2_D14	GPIO_136
#define EBI2_D13	GPIO_137
#define EBI2_D12	GPIO_138
#define EBI2_D11	GPIO_139
#define EBI2_D10	GPIO_140
#define EBI2_D9		GPIO_141
#define EBI2_D8		GPIO_142
#define EBI2_D7		GPIO_143
#define EBI2_D6		GPIO_144
#define EBI2_D5		GPIO_145
#define EBI2_D4		GPIO_146
#define EBI2_D3		GPIO_147
#define EBI2_D2		GPIO_148
#define EBI2_D1		GPIO_149
#define EBI2_D0		GPIO_150
#define EBI2_OE_N	GPIO_151
#define EBI2_WE_N	GPIO_157
#define EBI2_INT_N	GPIO_52
#define EBI2_CS4_N	GPIO_132
#define EBI2_CS3_N	GPIO_133
#define EBI2_ADV_N	GPIO_153
#define EBI2_WAIT_N	GPIO_154

/********************Others********************/
#define PCI_WAKE_HOST_N		GPIO_40
#define PRESET_3G		GPIO_41
#define W_DISABLE_3G		GPIO_42
#define P_PS_HOLD		GPIO_92
#define UART_RX			GPIO_117
#define UART_TX			GPIO_118
#define VIB2_DRV_N_MPP		PM8058_MPP_3
#define USB_ID_SWITCH_MPP	PM8901_MPP_2
#define CDC_RST_N		(PM8058_GPIO_PM_TO_SYS(PM_GPIO_21))

/********************PM8058 GPIO NOT Mapped********************/
#define PM_WLAN_SLEEP_CLK	PM_GPIO_38
#define PM_LVDS_BL_PWM		PM_GPIO_26
#define PM_TOUCH_INT		PM_GPIO_25
#define PM_TOUCH_RESET		PM_GPIO_27
#define PM_SSBI_PMIC_FWD_CLK	PM_GPIO_39
#define PM_LCD_BL_PWM		PM_GPIO_24

/********************IRQS********************/
#define G_SENSOR_INT_IRQ_NUM	(MSM_GPIO_TO_INT(G_SENSOR_INT))
#define E_COMPASS_INT_IRQ_NUM	(MSM_GPIO_TO_INT(E_COMPASS_INT))
#define GYRO_INT_IRQ_NUM	(MSM_GPIO_TO_INT(GYRO_INT))
#define LIGHT_INT_N_IRQ_NUM	(MSM_GPIO_TO_INT(LIGHT_INT_N))

#endif/*#ifdef CONFIG_MACH_EVB1*/

#endif
