/*
 *  q_isa1200.h - ISA1200 Haptic Motor driver
 *
 *  Copyright (C) 2011 Qisda Corp.
 *  Author: Adil Zhu <Adil.Zhu@Qisda.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __LINUX_Q_ISA1200_H
#define __LINUX_Q_ISA1200_H

enum q_mode_control {
	Q_POWER_DOWN_MODE = 0,
	Q_PWM_INPUT_MODE,
	Q_PWM_GEN_MODE,
	Q_WAVE_GEN_MODE
};

union q_pwm_div_freq {
	unsigned int pwm_div; /* PWM gen mode */
	unsigned int pwm_freq; /* PWM input mode */
};

struct q_isa1200_platform_data {
	const char *name;
	unsigned int pwm_ch_id; /* pwm channel id */
	unsigned int max_timeout;
	unsigned int hap_en_gpio;
	
/* Qisda, Adil Zhu 2011-03-23, For ISA1200 Driver Porting  { */
	unsigned int hap_ldo_en_gpio;
/* } Qisda, Adil Zhu 2011-03-23 */
    
	bool overdrive_high; /* high/low overdrive */
	bool overdrive_en; /* enable/disable overdrive */
	enum q_mode_control mode_ctrl; /* input/generation/wave */
	union q_pwm_div_freq pwm_fd;
    bool smart_en;
	bool is_erm;
	bool ext_clk_en;
	unsigned int chip_en;
	unsigned int duty;
	int (*power_on)(int on);
	int (*dev_setup)(bool on);
};

#endif /* __LINUX_Q_ISA1200_H */
