/* include/linux/capella_cm3602.h
 *
 * Copyright (C) 2009 Google, Inc.
 * Author: Iliyan Malchev <malchev@google.com>
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __LINUX_PROXIMITYSENSOR_H
#define __LINUX_PROXIMITYSENSOR_H

#include <linux/types.h>
#include <linux/ioctl.h>

#define PROXIMITY_SENSOR_IOCTL_MAGIC 'p'

#define PROXIMITY_SENSOR_IOCTL_ENABLE 		_IOW(PROXIMITY_SENSOR_IOCTL_MAGIC, 1, int *)
#define PROXIMITY_SENSOR_IOCTL_DISABLE 		_IOW(PROXIMITY_SENSOR_IOCTL_MAGIC, 2, int *)
#define PROXIMITY_SENSOR_IOCTL_GET_ENABLED 	_IOR(PROXIMITY_SENSOR_IOCTL_MAGIC, 3, int *)
#define PROXIMITY_SENSOR_IOCTL_GET_ADC 		_IOR(PROXIMITY_SENSOR_IOCTL_MAGIC, 4, int *)
#define PROXIMITY_SENSOR_IOCTL_GET_CHIPID  	_IOR(PROXIMITY_SENSOR_IOCTL_MAGIC, 5, int *)
#define PROXIMITY_SENSOR_IOCTL_CALIBRATE	_IO(PROXIMITY_SENSOR_IOCTL_MAGIC, 6)

#endif
