#include <linux/ioctl.h>
#include <linux/skbuff.h>
#include <linux/videodev2.h>


#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE 
#define FALSE 0
#endif


//For check tuning status max trial
#define BCOMFM_MAX_TUNING_TRIALS	100


//RX Reg
#define I2C_FM_RDS_SYSTEM      		0x00
#define I2C_FM_CTRL            		0x01
#define I2C_RDS_CTRL0	      		0x02
#define I2C_RDS_CTRL1      		    0x03
#define I2C_FM_AUDIO_PAUSE      	0x04
#define I2C_FM_AUDIO_CTRL0      	0x05
#define I2C_FM_AUDIO_CTRL1	      	0x06
#define I2C_FM_SEARCH_CTRL0      	0x07
#define I2C_FM_SEARCH_CTRL1      	0x08
#define I2C_FM_SEARCH_TUNE_MODE   	0x09
#define I2C_FM_FREQ0      		 	0x0a
#define I2C_FM_FREQ1      		 	0x0b
#define I2C_FM_AF_FREQ0      		0x0c
#define I2C_FM_AF_FREQ1      		0x0d
#define I2C_FM_CARRIER      		0x0e
#define I2C_FM_RSSI      		    0x0f
#define I2C_FM_RDS_MASK0      		0x10
#define I2C_FM_RDS_MASK1      		0x11
#define I2C_FM_RDS_FLAG0      		0x12
#define I2C_FM_RDS_FLAG1      		0x13
#define I2C_RDS_WLINE      		    0x14
#define I2C_RDS_BLKB_MATCH0      	0x16
#define I2C_RDS_BLKB_MATCH1      	0x17
#define I2C_RDS_BLKB_MASK0      	0x18
#define I2C_RDS_BLKB_MASK1      	0x19
#define I2C_RDS_PI_MATCH0      		0x1a
#define I2C_RDS_PI_MATCH1      		0x1b
#define I2C_RDS_PI_MASK0      		0x1c
#define I2C_RDS_PI_MASK1      		0x1d
#define I2C_FM_RDS_BOOT      		0x1e
#define I2C_FM_RDS_TEST      		0x1f
#define I2C_SPARE0      		    0x20
#define I2C_SPARE1      	      	0x21
#define I2C_FM_RDS_REV_ID      		0x28
#define I2C_SLAVE_CONFIGURATION   	0x29
#define I2C_FM_PCM_ROUTE      		0x4d
#define I2C_RDS_DATA      	      	0x80
#define I2C_FM_BEST_TUNE      		0x90
/*Reserved in bcm4329:
   0x1e, 0x1f, 0x2a-0x7f, 0x81-0xaa, 0xac-0xff
 */
 
#define I2C_PAGE_CONTEXT      		0xab //TX RX share

//TX Reg
#define I2C_FMTX_MUTE      			0x63
#define I2C_FMTX_CHANL_SET0         0x6b
#define I2C_FMTX_CHANL_SET1	      	0x6c
#define I2C_FMTX_CHANL_BW_SET      	0x6d
#define I2C_FMTX_REF_SET      		0x70
#define I2C_FMTX_LOCK_GET	      	0x71
#define I2C_FMTX_PA_CONTROL_SET     0x72
#define I2C_FMTX_DEV_SET     		0x74
#define I2C_FMTX_SCAN_START  		0x77
#define I2C_FMTX_SCAN_END     		0x79
#define I2C_FMTX_AUDIO_LOW_COUNT    0x7b
#define I2C_FMTX_AUDIO_HIGH_COUNT   0x7c
#define I2C_FMTX_AUDIO_THRESH_LOW   0x7d
#define I2C_FMTX_AUDIO_THRESH_HIGH  0x7e
#define I2C_FMTX_RDS_DATA_SET      	0x80
#define I2C_FMTX_MPX_LMT_SET      	0x97
#define I2C_FMTX_REF_ERR_SET      	0xa2
#define I2C_FMTX_CTRL_SET	      	0xa3
#define I2C_FMTX_PI_SET0     		0xa4
#define I2C_FMTX_PI_SET1    		0xa5
#define I2C_FMTX_TYPE_SET  			0xa6
#define I2C_FMTX_AF     			0xa8
#define I2C_FMTX_DISPLAY_SIZE    	0xa9
#define I2C_FMTX_RDS_MODE			0xaa
#define I2C_FMTX_SCROLL_RATE     	0xad
#define I2C_FMTX_TOGGLE_AB          0xaf
#define I2C_FMTX_RDS_REP_SET	    0xb0
#define I2C_FMTX_RDS_COMMIT_SET     0xb1
#define I2C_FMTX_IRQ_MASK0      	0xbb
#define II2C_FMTX_IRQ_MASK1	      	0xbc
#define I2C_FMTX_IRQ_FLAG0    		0xbf
#define I2C_FMTX_IRQ_FLAG1   		0xc0
#define I2C_FMTX_RDS_WLINE0  		0xc9
#define I2C_FMTX_RDS_WLINE1     	0xca
#define I2C_FMTX_RDS_DEV_SET    	0xd2
#define I2C_FMTX_PILOT_DEV_SET  	0xd3
#define I2C_FMTX_AUDIO_DEV_SET   	0xd4
#define I2C_FMTX_AUDIO_MEAS_COUNT  	0xd5
#define I2C_FMTX_AUDIO_STATUS		0xd7
/*Reserved in bcm4329:
   0xac-0xff
 */

#define 	RDS_WATER_LEVEL			50


enum  {
    BCOMFM_RDS_MODE,
    BCOMFM_RBDS_MODE
};

enum
{
    BCOMFM_BAND_EUUS,
    BCOMFM_BAND_JP
};


enum
{
    BCOMFM_MUTE_DISABLED,
    BCOMFM_MUTE_ENABLED
};


enum
{
    BCOMFM_SCAN_DIR_UP,
    BCOMFM_SCAN_DIR_DOWN
};


typedef struct  {
	uint16_t  rds_data_block[RDS_WATER_LEVEL];
	uint8_t   rds_block_id[RDS_WATER_LEVEL];
	uint8_t   rds_block_errors[RDS_WATER_LEVEL];
}bcom_fm_rds_parameters;


struct bcom_fm_platform_data {
	uint16_t 	gpio_fm_wakeup;
};



#define BCOMFM_HCI_MAX_DATA 3
struct bcom_fm_event_pack {
	__u8     status;
	__u8     i2caddr;
	__u8     r_w;
	__u8     data[BCOMFM_HCI_MAX_DATA];
} __attribute__ ((packed));


// TX/RX MODE FOR REG PAGE
#define BCOMFM_RX_PAGE         (0 << 0)
#define BCOMFM_TX_PAGE         (1 << 0)


// BCOMFM Power
#define BCOMFM_POWER_PWF         (1 << 0)
#define BCOMFM_POWER_PWR         (1 << 1)

// BCOMFM  I2C_FMTX_CTRL_SET
#define BCOMFM_POWER_TXON         	(1 << 0)
#define BCOMFM_POWER_TXOFF        	(0 << 0)
#define BCOMFM_FMTX_BAND_UE         (0 << 6)
#define BCOMFM_FMTX_BAND_JA         (1 << 6)
#define BCOMFM_FMTX_AUD_I2S         (0 << 2)
#define BCOMFM_FMTX_AUD_ADC         (1 << 2)
#define BCOMFM_FMTX_AUD_STR        	(0 << 1)
#define BCOMFM_FMTX_AUD_MONO        (1 << 1)
#define BCOMFM_FMTX_PREEMPH_OFF     (0 << 4)
#define BCOMFM_FMTX_PREEMPH_50      (1 << 4)
#define BCOMFM_FMTX_PREEMPH_75      (2 << 4)


//BCOM FM_CTRL 
//stereo/mono auto select
#define BCOMFM_AUTO_SELECT_STEREO_MONO		(1<<1)
#define BCOMFM_MANUAL_SELECT_STEREO_MONO	(0<<1)
#define BCOMFM_MANUAL_SET_STEREO				(1<<2)
#define BCOMFM_MANUAL_SET_MONO				(0<<2)
#define BCOMFM_STEREO_MONO_BLEND			(0<<3)
#define BCOMFM_STEREO_MONO_SWITCH			(1<<3)

//BCOM FM_AUDIO_PAUSE
//RSSI
#define BCOMFM_AUDIO_PAUSE_RSSI_21DB		(0<<0)
#define BCOMFM_AUDIO_PAUSE_RSSI_18DB		(1<<0)
#define BCOMFM_AUDIO_PAUSE_RSSI_15DB		(2<<0)
#define BCOMFM_AUDIO_PAUSE_RSSI_12DB		(3<<0)
//duration
#define BCOMFM_AUDIO_PAUSE_RSSI_20MS		(0<<4)
#define BCOMFM_AUDIO_PAUSE_RSSI_26MS		(1<<4)
#define BCOMFM_AUDIO_PAUSE_RSSI_33MS		(2<<4)
#define BCOMFM_AUDIO_PAUSE_RSSI_40MS		(3<<4)

//BCOM FM_AUDIO_CTRL0
#define BCOMFM_ENABLE_RF_MUTE		(1<<0)
#define BCOMFM_DISABLE_RF_MUTE		(0<<0)
#define BCOMFM_MANUAL_MUTE_ON		(1<<1)
#define BCOMFM_MANUAL_MUTE_OFF		(0<<1)
#define BCOMFM_DAC_OUTPUT_LEFT		(1<<2)
#define BCOMFM_DAC_OUTPUT_RIGHT		(1<<3)
#define BCOMFM_AUDIO_ROUTE_DAC		(1<<4)
#define BCOMFM_AUDIO_DISABLE_DAC	(0<<4)
#define BCOMFM_AUDIO_ROUTE_I2S		(1<<5)
#define BCOMFM_AUDIO_DISABLE_I2S	(0<<5)
#define BCOMFM_DE_EMPHASIS_75		(1<<6)


//BCOM FM_SERACH_CTRL0
#define BCOMFM_SERACH_UP				(1<<7)
//#define BCOMFM_SERACH_DOWN			(0<<7)

//BCOM FM_SEARCH_TUNE_MODE
#define BCOMFM_STOP_TUNE				(0<<0)
#define BCOMFM_PRE_SET					(1<<0)
#define BCOMFM_AUTO_SERCH				(2<<0)
#define BCOMFM_AF_JUMP					(3<<0)

//BCOM FM_RDS_FLAG
//Byte 1 0x12
#define BCOMFM_FLAG_SEARCH_TUNE_DONE	(1<<0)
#define BCOMFM_FLAG_SEARCH_FAIL			(1<<1)
#define BCOMFM_FLAG_RSSI_LOW				(1<<2)
#define BCOMFM_FLAG_CARRIER_ERROR_HIGH	(1<<3)
#define BCOMFM_FLAG_AUDIO_PAUSE_IND		(1<<4)
#define BCOMFM_FLAG_STEREO_DETECTED		(1<<5)
#define BCOMFM_FLAG_STEREO_ACTIVE		(1<<6)
//Byte 2 0x13
#define BCOMFM_FLAG_RDS_FIFO_WLINE		(1<<1)
#define BCOMFM_FLAG_RDS_B_BLOCK_MATCH	(1<<3)
#define BCOMFM_FLAG_RDS_SYNC_LOST		(1<<4)
#define BCOMFM_FLAG_RDS_PI_MATCH			(1<<5)


#define FM_HCI_WRITE_COMPELTE_EVENT_SIZE 	9

/*add private control id here */
#define BCOMFM_PRIVATE_GET_RSSI	(V4L2_CID_PRIVATE_BASE + 30)


enum bcm4329_evt_t {
	BCM4329_EVT_RADIO_READY,
	BCM4329_EVT_TUNE_SUCC,
	BCM4329_EVT_SEEK_COMPLETE,
	BCM4329_EVT_SCAN_NEXT,
	BCM4329_EVT_NEW_RAW_RDS,
	BCM4329_EVT_NEW_RT_RDS,
	BCM4329_EVT_NEW_PS_RDS,
	BCM4329_EVT_ERROR,
	BCM4329_EVT_BELOW_TH,
	BCM4329_EVT_ABOVE_TH,
	BCM4329_EVT_STEREO,
	BCM4329_EVT_MONO,
	BCM4329_EVT_RDS_AVAIL,
	BCM4329_EVT_RDS_NOT_AVAIL,
	BCM4329_EVT_NEW_SRCH_LIST,
	BCM4329_EVT_NEW_AF_LIST
};

enum bcm4329_buf_t {
	BCM4329_BUF_SRCH_LIST,
	BCM4329_BUF_EVENTS,
	BCM4329_BUF_RT_RDS,
	BCM4329_BUF_PS_RDS,
	BCM4329_BUF_RAW_RDS,
	BCM4329_BUF_AF_LIST,
	BCM4329_BUF_MAX
};

enum v4l2_cid_private_bcm4329_t {
	V4L2_CID_PRIVATE_BCM4329_SRCHMODE = (V4L2_CID_PRIVATE_BASE + 1),
	V4L2_CID_PRIVATE_BCM4329_SCANDWELL,
	V4L2_CID_PRIVATE_BCM4329_SRCHON,
	V4L2_CID_PRIVATE_BCM4329_STATE,
	V4L2_CID_PRIVATE_BCM4329_TRANSMIT_MODE,
	V4L2_CID_PRIVATE_BCM4329_RDSGROUP_MASK,
	V4L2_CID_PRIVATE_BCM4329_REGION,
	V4L2_CID_PRIVATE_BCM4329_SIGNAL_TH,
	V4L2_CID_PRIVATE_BCM4329_SRCH_PTY,
	V4L2_CID_PRIVATE_BCM4329_SRCH_PI,
	V4L2_CID_PRIVATE_BCM4329_SRCH_CNT,
	V4L2_CID_PRIVATE_BCM4329_EMPHASIS,
	V4L2_CID_PRIVATE_BCM4329_RDS_STD,
	V4L2_CID_PRIVATE_BCM4329_SPACING,
	V4L2_CID_PRIVATE_BCM4329_RDSON,
	V4L2_CID_PRIVATE_BCM4329_RDSGROUP_PROC,
	V4L2_CID_PRIVATE_BCM4329_LP_MODE,
	V4L2_CID_PRIVATE_BCM4329_ANTENNA,
	V4L2_CID_PRIVATE_BCM4329_RDSD_BUF,
	V4L2_CID_PRIVATE_BCM4329_PSALL
};


int bcm4329_receive_evt(struct hci_dev *hdev, struct sk_buff *skb);





