/*
 * tiwlan driver loader - utility to load firmware and calibration data
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Alternatively, this software may be distributed under the terms of BSD
 * license.
 *
 *
 * drrick add for test radio fm hci
 */
/*-------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <cutils/log.h>

#include <linux/videodev2.h>
#include <sys/time.h>

//extern int bcm4329_turn_on();
//extern int bcm4329_turn_off();


static int fm_test_quit_flag = 0;
static int fm_fd;

struct fm_test_cmd_s {
    const char *cmd;
    int (*handle)(int argc, char *argv[]);
};

/*
 * ----------------------------------------------------------------------------
 * Function :   print_usage
 *
 * print some help information for user input
 *
 * -----------------------------------------------------------------------------
 */
static int print_usage(void)
{
  printf("Usage: fm_test [driver_name] [options]\n"
         "commands:\n"
         "  help        = show this usage help\n"
         "  on          = Rx:1,Tx:2\n"
         "  off         = unload fm driver\n"
         "  set_freq    = set fm' channel\n"
         "  sf          = set fm' channel\n"
         "  get rssi    = get fm' rssi\n"
         "  get_freq    = get fm' channel\n"
         "  gf          = get fm' channel\n"
         "  freq_scan   = auto search\n"
         "  fs          = auto search\n"
         "  sc          = set control\n"
         "  gc          = get control\n"
         "  quit        = exit fm test\n");

  return 0;
}


/*
 * ----------------------------------------------------------------------------
 * Function :   fm_test_cmd_help
 *
 * print help information 
 * Input    :   argc parameter number
 *                : argv parameter as string format
 *
 * ReturnVal:   one of the error codes (zero is success)
 *
 *
 * -----------------------------------------------------------------------------
 */
static int fm_test_cmd_help(int argc, char *argv[])
{
  return print_usage();
}



/*
 * Class:     com_oem_engineeringmode_fmadio_fmadio
 * Method:    power_on
 * Signature: ()I
 */
static int fm_test_power_on(int argc, char *argv[])
{ 	
  	int ret;
	struct v4l2_control control;
	int err;
	
	printf("Power on --- Open") ;
    fm_fd = open("/dev/radio0", O_RDWR);
	if (fm_fd < 0) 
		{
			LOGE("power on:: cannot open device( /dev/bcomfm )\n");
   	 		printf(stderr, "fm_test_power_on open fail !!'\n");
    		return -1;
  	}
	
	 printf("Power on --- Set State");
 	 control.id = V4L2_CID_PRIVATE_BASE+4;
 	 control.value=atoi(argv[1]);
  
  	err = ioctl(fm_fd,VIDIOC_S_CTRL,&control);
  	if(err < 0)
		{
   			 printf("Power on --- Set State Fail");
  		}
		return 0;  	
}
  
/*
 * Class:     com_oem_engineeringmode_fmadio_fmadio
 * Method:    power_off
 * Signature: ()I
 */
static int fm_test_power_off(int argc, char *argv[])
{
  	int ret;
	struct v4l2_control control;
	int err;

	 control.id = V4L2_CID_PRIVATE_BASE+4;
 	 control.value=atoi(argv[1]);

	 printf("Power off --- Set State Fail");  
  	 err = ioctl(fm_fd,VIDIOC_S_CTRL,&control);
  	 if(err < 0)
		{
   			 printf("Power off --- Set State Fail");
			 return 1;
  		}
	printf("Power off --- Close");  
  	close(fm_fd);
	return 0;  	
}  

/*
 * Class:     com_oem_engineeringmode_fmadio_fmadio
 * Method:    set_channel
 * Signature: (J)I
 */
static int fm_test_set_channel(int argc, char *argv[])
{
    int freq;
    int err;    
	struct timeval tv1;
	struct timeval tv2;
    struct v4l2_frequency freq_struct;

	printf("Set Channel \n"); 
  	freq = atoi(argv[1]);  	
  	
    freq_struct.tuner = 0;
    freq_struct.type = V4L2_TUNER_RADIO;
    freq_struct.frequency = freq;
		   
    err = ioctl(fm_fd, VIDIOC_S_FREQUENCY, &freq_struct);	
    if(err < 0)
    {
      printf("set freq fail\n");
	  return -1;
    }
    
    return 0;	
}

static int fm_test_get_channel(int argc, char *argv[])
{
    int err;    
    struct v4l2_frequency freq;
    
    printf("get channel \n");  	
  	
    freq.tuner = 0;
    freq.type = V4L2_TUNER_RADIO;
        
    err = ioctl(fm_fd, VIDIOC_G_FREQUENCY, &freq);
    if(err < 0)
    {
      printf("Get freq fail\n");
	  return -1;
    }
    
    printf("freq is %d \n", freq.frequency);
    return 0;	
}

static int fm_test_freq_scan(int argc, char *argv[])
{
  int direction = atoi(argv[1]);
  struct v4l2_hw_freq_seek seek;
  struct timeval tv1;
  struct timeval tv2;
  
  seek.seek_upward = direction;
  seek.type = V4L2_TUNER_RADIO;
  printf("fm_test_freq_scan is%d \n", direction);   

  if(ioctl(fm_fd, VIDIOC_S_HW_FREQ_SEEK, &seek) < 0)
  	{
		printf("fm_test_freq_scan FAIL");
		return -1;
  	}   
	return 0;  	
}

/*
 * Class:     com_oem_engineeringmode_fmadio_fmadio
 * Method:    get_rssi
 * Signature: (J)J
 */
#define BCOMFM_PRIVATE_GET_RSSI	(V4L2_CID_PRIVATE_BASE + 30)
static long fm_test_get_rssi(int argc, char *argv[])
{
	struct v4l2_control control;
	int err;
	
	control.id = BCOMFM_PRIVATE_GET_RSSI;
	err = ioctl(fm_fd,VIDIOC_G_CTRL,&control);
	if(err < 0){
	  return -1;
	}
	printf("fm_test_get_rssi is%d \n", control.value);    
	return 0;

}


static long fm_test_set_control(int argc, char *argv[])
{

  struct v4l2_control control;
  int err;

  printf("fm_test_set_contrl,para1=%d, para2=%d \n",atoi(argv[1]),atoi(argv[2])); 
  control.id = V4L2_CID_PRIVATE_BASE+(atoi(argv[1]));
  control.value=atoi(argv[2]);

  printf("fm_test_set_contrl: cmd=%d \n", control.id); 
  printf("fm_test_set_contrl: value=%d \n", control.value); 
  
  err = ioctl(fm_fd,VIDIOC_S_CTRL,&control);
  if(err < 0){
    return -1;
  }
   
  return 0;
}

static long fm_test_get_control(int argc, char *argv[])
{

  struct v4l2_control control;
  int err;
  
  control.id = V4L2_CID_PRIVATE_BASE+(atoi(argv[1]));
  
  err = ioctl(fm_fd,VIDIOC_G_CTRL,&control);
  if(err < 0){
  	printf("fm_test_get_contrl fail"); 
    return -1;
  }
  printf("fm_test_get_contrl,id=%d, value=%d \n",control.id,control.value); 
  return 0;
}

static long fm_test_set_tuner(int argc, char *argv[])
{

  	struct v4l2_tuner tuner;	
	int err;

    printf("fm_test_set_tuner");
	tuner.index = 0;
	tuner.rangehigh= atoi(argv[1]);
	tuner.rangelow= atoi(argv[2]);
	tuner.audmode = atoi(argv[3]);
	err = ioctl(fm_fd, VIDIOC_S_TUNER, &tuner);
	if(err < 0){
		printf("fm_test_set_tuner fail");
   		return -1;
  	}
  	return 0;
}

static long fm_test_get_tuner(int argc, char *argv[])
{

  	struct v4l2_tuner tuner;	
	int err;

    printf("fm_test_get_tuner:");
	tuner.index = 0;
	err = ioctl(fm_fd, VIDIOC_S_TUNER, &tuner);
	if(err < 0){
    return -1;
  	}
	printf("tuner.audio=%d \n",tuner.audmode); 
	printf("tuner.high=%d \n",tuner.rangehigh); 
	printf("tuner.low=%d \n",tuner.rangelow);
  	return 0;
}

static long fm_test_d_qbuf(int argc, char *argv[])
{
	int err;
	struct v4l2_buffer v4l2_buf;
	enum v4l2_buf_type type = V4L2_BUF_TYPE_PRIVATE;
	unsigned long buffer[128];
	  
	memset(&v4l2_buf, 0, sizeof (v4l2_buf));
	v4l2_buf.index = atoi(argv[1]);
	v4l2_buf.type = type;
	v4l2_buf.length = 128;
	v4l2_buf.m.userptr = (unsigned long)buffer;
	err = ioctl(fm_fd,VIDIOC_DQBUF,&v4l2_buf) ;
	if(err < 0){
		   return 1;
	}
	printf("v4l2_buf.bytesused=%d \n",v4l2_buf.bytesused);
	printf("event id=%d \n",buffer[0]);
	return 0;

}



static void fm_test_set_device(int argc, char *argv[])
{
   int device;
   device=atoi(argv[1]); // Analog:0  ;I2S:1;
   int err;
   struct v4l2_audio audio;
   printf("set A or D :%d\n",device);
  // snd_set_device(device,0,0,NULL,NULL);	
   audio.index=0;
   if (device==0)
   	{
		audio.capability=0x0003;
		printf("set A ");
   }
   else
   	{
		audio.capability=0x0004;
		printf("set D ");
   }
   	
   err = ioctl(fm_fd, VIDIOC_S_AUDIO, &audio);
	  if(err < 0){
		  printf("fm_test_set_audio fail");
		  return -1;
	  }
	  return 0;

  
}

/*
 * ----------------------------------------------------------------------------
 * Function :   fm_test_cmd_quit
 *
 * exit the exe
 *
 * Input    :   argc parameter number
 *                : argv parameter as string format
 *
 * ReturnVal:   one of the error codes (zero is success)
 *
 *
 * -----------------------------------------------------------------------------
 */
static int fm_test_cmd_quit(int argc, char *argv[])
{
   fm_test_quit_flag = 1;

   printf("quit fm test command\n");

   return 0;
}

static struct fm_test_cmd_s fm_test_commands[] = {
    { "help",           fm_test_cmd_help },
    { "on",             fm_test_power_on }, 
    { "off",            fm_test_power_off }, 
    { "set_freq",       fm_test_set_channel }, 
    { "sf",             fm_test_set_channel }, 
    { "get_rssi",       fm_test_get_rssi }, 
    { "gr",             fm_test_get_rssi }, 
    { "get_freq",       fm_test_get_channel }, 
    { "gf",             fm_test_get_channel }, 
    { "freq_scan",      fm_test_freq_scan }, 
    { "fs",             fm_test_freq_scan }, 
    { "sc",             fm_test_set_control }, 
    { "gc",             fm_test_get_control },
    { "st",             fm_test_set_tuner },
    { "gt",             fm_test_get_tuner },
    { "sd",				fm_test_set_device},
    { "dq",				fm_test_d_qbuf},  
    { "quit",           fm_test_cmd_quit }, 
    { NULL, NULL }
};



/*
 * ----------------------------------------------------------------------------
 * Function :   fm_test_exc_cmd
 *
 * compare string, and run functons
 * 
 * Input    :   argc parameter number
 *          :   argv parameter as string format
 *
 * ReturnVal:   one of the error codes (zero is success)
 *
 *
 * -----------------------------------------------------------------------------
 */
static int fm_test_exc_cmd(int argc, char *argv[])
{
    struct fm_test_cmd_s *cmd;
    struct fm_test_cmd_s *match = NULL;
    int count;
    int ret = 1;

    count = 0;
    cmd = fm_test_commands;
    while (cmd->cmd) 
    {
        if (strncasecmp(cmd->cmd, argv[0], strlen(argv[0])) == 0)
        {
            match = cmd;
            if (strcasecmp(cmd->cmd, argv[0]) == 0)
            {
                /* we have an exact match */
                count = 1;
                match->handle(argc, argv);
                break;
            }
            count++;
        }
        cmd++;
    }

    if (count > 1) 
    {     
        ret = 0;
    } else if (count == 0)
    {
        printf("Unknown command '%s'\n", argv[0]);
        ret = 0;
    }

    return ret;
}



/*
 * ----------------------------------------------------------------------------
 * Function :   main
 *
 * add for test wifi scan, ping ,get mac address functions
 *
 * Input    :   argc parameter number
 *                : argv parameter as string format
 *
 * ReturnVal:   one of the error codes (zero is success)
 *
 *
 * -----------------------------------------------------------------------------
 */

int main(int argc, char *argv[])
{
#define max_args 3
    char cmdbuf[100], *cmd, *argv_line[max_args], *pos;
    int argc_line;

	//oncrpc_init();
	//oncrpc_task_start();
   //	sndcb_app_init();

    do {
        argc_line = 0;
        memset(cmdbuf, 0, 100);

        printf("> ");
        cmd = fgets(cmdbuf, sizeof(cmdbuf), stdin);

        if (cmd == NULL)
            break;

        pos = cmd;
        while (*pos != '\0') {
            if (*pos == '\n') {
                *pos = '\0';
                break;
            }
            pos++;
        }
        argc = 0;
        pos = cmd;
        for (;;) 
        {
            while (*pos == ' ')
                pos++;
            if (*pos == '\0')
                break;
            argv_line[argc_line] = pos;
            argc_line++;
            if (argc_line == max_args)
                break;
            if (*pos == '"') 
            {
                char *pos2 = strrchr(pos, '"');
                if (pos2)
                    pos = pos2 + 1;
            }
            while (*pos != '\0' && *pos != ' ')
                pos++;
            if (*pos == ' ')
                *pos++ = '\0';
        }
        if (argc_line)
            fm_test_exc_cmd(argc_line, argv_line);

    } while (!fm_test_quit_flag);

  return 0;
}

